/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.web.module;

import com.elluminate.classroom.client.messaging.MessagePublisher;
import com.elluminate.classroom.client.messaging.MessagePublisherMetadata;
import com.elluminate.classroom.client.messaging.MessageRouter;
import com.elluminate.classroom.client.messaging.MessageType;
import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.groupware.web.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

@Singleton
public class WebPublisher {
    private final String UNIQUE_NAME = "WebPublisher";
    private final String DISPLAY_NAME;
    private final Icon icon;
    public static final String START_WEB_TOUR = "start-web-tour";
    public static final String STOP_WEB_TOUR = "stop-web-tour";
    public static final String WEB_PUSH = "web-push";
    public static final String WEB_TOUR_GRANT_PERMISSION = "web-tour-grant-permission";
    public static final String WEB_TOUR_REVOKE_PERMISSION = "web-tour-revoke-permission";
    private final MessagePublisher publisher;
    private final MessagePublisherMetadata metadata;
    private final I18n i18n;
    private final MessageRouter router;
    private String modName;
    private String modDisplayName;
    private Map<String, MessageType> msgTypes = new HashMap<String, MessageType>();

    @Inject
    public WebPublisher(MessagePublisher pub, MessagePublisherMetadata meta, MessageRouter rtr, I18n localization, ModulePublisherInfo mod) {
        this.publisher = pub;
        this.metadata = meta;
        this.router = rtr;
        this.i18n = localization;
        this.DISPLAY_NAME = this.i18n.getString((PropertiesEnum)StringsProperties.WEBPUBLISHER_DISPLAYNAME);
        this.icon = mod.getModuleIcon();
        this.modName = mod.getNameOfModule();
        this.modDisplayName = mod.getDisplayNameOfModule();
        this.initializePublisher();
    }

    public void sendStartWebTourMessage(String url) {
        if (url == null) {
            return;
        }
        String message = this.i18n.getString((PropertiesEnum)StringsProperties.WEBPUBLISHER_STARTWEBTOURMESSAGE, new Object[]{url});
        this.publisher.sendTextMessage(message, this.msgTypes.get(START_WEB_TOUR));
    }

    public void sendStopWebTourMessage() {
    }

    public void sendLaunchWebsiteMessage(String url) {
        if (url == null) {
            return;
        }
        String message = this.i18n.getString((PropertiesEnum)StringsProperties.WEBPUBLISHER_LAUNCHWEBSITEMESSAGE, new Object[]{url});
        this.publisher.sendTextMessage(message, this.msgTypes.get(WEB_PUSH));
    }

    public void sendEnabledStatusChangeMessage(boolean enabled) {
        MessageType type;
        String message;
        if (enabled) {
            message = this.i18n.getString((PropertiesEnum)StringsProperties.WEBPUBLISHER_WEBTOUR_ENABLEDMESSAGE);
            type = this.msgTypes.get(WEB_TOUR_GRANT_PERMISSION);
        } else {
            message = this.i18n.getString((PropertiesEnum)StringsProperties.WEBPUBLISHER_WEBTOUR_DISABLEDMESSAGE);
            type = this.msgTypes.get(WEB_TOUR_REVOKE_PERMISSION);
        }
        this.publisher.sendTextMessage(message, type, false);
    }

    private void initializePublisher() {
        this.initMessageTypes();
        this.setMetadata();
        this.publisher.setPublisherMetadata(this.metadata);
        this.router.registerPublisher(this.publisher);
    }

    private void setMetadata() {
        this.metadata.setPublisherDisplayName(this.DISPLAY_NAME);
        this.metadata.setPublisherUniqueName("WebPublisher");
        this.metadata.setPublisherIcon(this.icon);
        this.metadata.setModuleName(this.modName);
        this.metadata.setModuleDisplayName(this.modDisplayName);
        this.metadata.setPublisherSupportedMessageTypes(new ArrayList<MessageType>(this.msgTypes.values()));
    }

    private void initMessageTypes() {
        this.msgTypes.put(START_WEB_TOUR, new MessageType(START_WEB_TOUR, this.i18n.getString((PropertiesEnum)StringsProperties.WEBPUBLISHER_TYPE_STARTWEBTOUR), 5));
        this.msgTypes.put(WEB_PUSH, new MessageType(WEB_PUSH, this.i18n.getString((PropertiesEnum)StringsProperties.WEBPUBLISHER_TYPE_STARTWEBPUSH), 5));
        this.msgTypes.put(WEB_TOUR_GRANT_PERMISSION, new MessageType(WEB_TOUR_GRANT_PERMISSION, this.i18n.getString((PropertiesEnum)StringsProperties.WEBPUBLISHER_TYPE_ENABLED), 5));
        this.msgTypes.put(WEB_TOUR_REVOKE_PERMISSION, new MessageType(WEB_TOUR_REVOKE_PERMISSION, this.i18n.getString((PropertiesEnum)StringsProperties.WEBPUBLISHER_TYPE_DISABLED), 5));
    }
}

