/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.profile.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAPI;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.imps.ParticipantSelectionListener;
import com.elluminate.groupware.imps.ParticipantSelectorAPI;
import com.elluminate.groupware.imps.PreferencesDialogAPI;
import com.elluminate.groupware.imps.ProfileDataAPI;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.groupware.profile.Profile;
import com.elluminate.groupware.profile.ProfileItem;
import com.elluminate.groupware.profile.ProfileItemFactory;
import com.elluminate.groupware.profile.ProfileItemID;
import com.elluminate.groupware.profile.ProfileProtocol;
import com.elluminate.groupware.profile.module.ModuleProfileItemFactory;
import com.elluminate.groupware.profile.module.MyProfilePrefsPanel;
import com.elluminate.groupware.profile.module.ProfileEditor;
import com.elluminate.groupware.profile.module.ProfileLibrary;
import com.elluminate.groupware.profile.module.SetViewableProfilesCmd;
import com.elluminate.groupware.profile.module.StringsProperties;
import com.elluminate.gui.Mnemonic;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.JinxChannelException;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.ParticipantEvent;
import com.elluminate.jinx.ParticipantListener;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.platform.Platform;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.browser.BrowserUtil;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

@Singleton
public class ProfileModule
extends AbstractClientModule
implements ModulePublisherInfo,
ChannelListener,
ChannelDataListener,
ParticipantListener,
ParticipantSelectionListener,
PreferencesPanelOwner,
PropertyChangeListener {
    private static final String MODULE_NAME = "Profile";
    private static final String PROFILE_NAME = "My Profile.xml";
    private static final String OLD_PROFILE_NAME = ".vclass.profile";
    private final String DIST_VAL_NONE = "none";
    private final String DIST_VAL_MOD = "moderators";
    private final String DIST_VAL_ALL = "all";
    private final String prefix = this.getClass().getName();
    private Icon defaultIcon = UIManager.getIcon("Participant.defaultParticipantIcon");
    private Image defaultImage = null;
    private ActionFeature sendWorkEmailFeature;
    private ActionFeature sendHomeEmailFeature;
    private ActionFeature viewFeature = null;
    private EnumeratedFeature<String> showFeature = null;
    private ComponentFeature prefsFeature;
    private FeatureBroker broker;
    private Logger logger;
    private DialogParentProvider parentProv;
    private static I18n i18n = I18n.create(ProfileModule.class);
    private ClientList clients;
    private Profile myProfile;
    private ProfileLibrary lib = null;
    private ClientProvider clientProvider;
    private Imps imps;
    private ProfileEditor editor = null;
    private File profilePath = null;
    private URL profileURL = null;
    private Channel channel = null;
    private ProfileItemFactory factory = new ModuleProfileItemFactory();
    private ParticipantSelectorAPI selector = null;
    private Provider<MyProfilePrefsPanel> profilePrefsProvider;
    private CRSession session;
    private ConferencingEngine confEngine;
    private Provider<SetViewableProfilesCmd> setViewableProfilesCmd;
    private ActionFeature editProfileFeature;
    private boolean isChair;

    @Inject
    public ProfileModule() {
        this.defaultImage = this.defaultIcon != null ? ((ImageIcon)this.defaultIcon).getImage() : new BufferedImage(1, 1, 2);
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initPrefsPanelProvider(Provider<MyProfilePrefsPanel> prefsProv) {
        this.profilePrefsProvider = prefsProv;
    }

    @Inject
    public void initModuleApp(DialogParentProvider parentProv) {
        this.parentProv = parentProv;
    }

    @Inject
    public void initVersionManager(ComponentRegistrar cr) {
        cr.registerComponent((Object)this);
        Profile.setProfileItemFactory((ProfileItemFactory)this.factory);
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public void initLogger(Logger logger) {
        this.logger = logger;
    }

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    public void initSession(CRSession session) {
        this.session = session;
    }

    @Inject
    public void initConferencingEngine(ConferencingEngine ce) {
        this.confEngine = ce;
    }

    @Inject
    public void initSetViewableProfilesCmd(Provider<SetViewableProfilesCmd> cp) {
        this.setViewableProfilesCmd = cp;
    }

    private void createShowFeature() {
        String DIST_TXT_NONE = i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_DISTNONE);
        String DIST_TXT_MOD = i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_DISTMOD, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Moderators")});
        String DIST_TXT_ALL = i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_DISTALL);
        Object[] DIST_VAL_ARRAY = new String[]{"none", "moderators", "all"};
        this.showFeature = this.broker.createEnumeratedFeature((Object)this, "/profile/show", String.class, true, (Object)"none", DIST_VAL_ARRAY, i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_DISTMENU), i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_DISTMENU));
        this.showFeature.setValueText((Object)"none", DIST_TXT_NONE);
        this.showFeature.setValueText((Object)"moderators", DIST_TXT_MOD);
        this.showFeature.setValueText((Object)"all", DIST_TXT_ALL);
        if (ProfileProtocol.DEBUG.show()) {
            this.logger.message((Object)this, "createShowFeature", "showFeature settings:\n  none - " + DIST_TXT_NONE + "\n  " + "moderators" + " - " + DIST_TXT_MOD + "\n  " + "all" + " - " + DIST_TXT_ALL + "\n");
        }
        this.showFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent event) {
                byte value;
                if (ProfileProtocol.DEBUG.show()) {
                    ProfileModule.this.logger.message((Object)this, "metaDataChanged", "id = '" + event.getID() + "'  new Show value = '" + event.getNewValue() + "'");
                }
                if (!ChairProtocol.getChair((ClientList)ProfileModule.this.clients).isMe()) {
                    return;
                }
                String str = (String)event.getNewValue();
                if (str.equals("none")) {
                    value = 0;
                } else if (str.equals("moderators")) {
                    value = 1;
                } else if (str.equals("all")) {
                    value = 3;
                } else {
                    ProfileModule.this.logger.message("profile: unrecognized new distribution value '" + str + "'");
                    return;
                }
                ProfileModule.this.session.setAnnotationValue(ProfileModule.this.clientProvider.get().getAddress(), "ProfileModDisplay", (Object)str);
                if (value != ProfileModule.this.clients.getProperty("profile.distribution", value)) {
                    ProfileModule.this.clients.setProperty("profile.distribution", value);
                }
            }
        });
    }

    private void handleViewClicks() {
        if (ProfileProtocol.DEBUG.show()) {
            this.logger.message((Object)this, "handleViewClicks", "View feature clicked");
        }
        if (this.editor == null) {
            this.editor = new ProfileEditor(this.parentProv.getDialogParent());
            this.editor.pack();
            this.editor.setLocationRelativeTo(this.parentProv.getDialogParent());
        }
        List selected = this.selector.getSelectedParticipants();
        if (this.lib != null && selected != null && selected.size() == 1) {
            short addr = ((CRParticipant)selected.get(0)).getID();
            this.lib.getProfileImage(addr, ProfileItemID.PHOTO.getName());
            Profile p = this.lib.getProfile(addr);
            if (p != null) {
                this.editor.show(p);
            }
        }
    }

    private void handleSendEmailClicks(boolean isWork) {
        List selected = this.selector.getSelectedParticipants();
        if (selected == null || selected.size() != 1) {
            return;
        }
        if (ProfileProtocol.DEBUG.show()) {
            this.logger.message((Object)this, "handleSendEmailClicks", "Send Email feature clicked: work? " + isWork);
        }
        ProfileItemID id = isWork ? ProfileItemID.WORK_EMAIL : ProfileItemID.HOME_EMAIL;
        short addr = ((CRParticipant)selected.get(0)).getID();
        if (this.lib == null || !this.lib.hasProfileInfo(addr, id.getName())) {
            return;
        }
        String url = "mailto:" + this.lib.getProfileText(addr, id.getName());
        try {
            BrowserUtil.gotoURL((String)url);
        }
        catch (IOException iox) {
            this.logger.exception((Object)this, "actionPerformed", (Throwable)iox, true);
        }
    }

    private boolean createFeatures() {
        if (this.viewFeature != null) {
            return false;
        }
        this.createShowFeature();
        this.sendWorkEmailFeature = this.broker.createActionFeature((Object)this, "/profile/sendWorkEmail", i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_SENDWORK), i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_SENDWORK));
        this.sendWorkEmailFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ProfileModule.this.handleSendEmailClicks(true);
            }
        });
        this.sendHomeEmailFeature = this.broker.createActionFeature((Object)this, "/profile/sendHomeEmail", i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_SENDHOME), i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_SENDHOME));
        this.sendHomeEmailFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ProfileModule.this.handleSendEmailClicks(false);
            }
        });
        this.viewFeature = this.broker.createActionFeature((Object)this, "/profile/view", i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_VIEW), i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_VIEW));
        this.viewFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ProfileModule.this.handleViewClicks();
            }
        });
        this.prefsFeature = this.broker.createComponentFeature((Object)this, "/profile/prefs", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return (Component)ProfileModule.this.profilePrefsProvider.get();
            }
        }, i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_DISTMENU), i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_DISTMENU));
        this.prefsFeature.setEnabled(false);
        this.editProfileFeature = this.broker.createActionFeature((Object)this, "/profile/editProfile", i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_EDITPROFILE), null);
        this.editProfileFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                PreferencesDialogAPI preferencesDialogAPI;
                if (ProfileModule.this.imps != null && (preferencesDialogAPI = (PreferencesDialogAPI)ProfileModule.this.imps.findBest(PreferencesDialogAPI.class)) != null) {
                    preferencesDialogAPI.showFeaturePreferencesPanelByPath(ProfileModule.this.prefsFeature.getPath());
                }
            }
        });
        this.sendWorkEmailFeature.setEnabled(false);
        this.sendHomeEmailFeature.setEnabled(false);
        this.viewFeature.setEnabled(false);
        this.showFeature.setEnabled(false);
        return true;
    }

    public void destroyFeatures() {
        this.broker.removeFeature((Feature)this.prefsFeature);
        this.broker.removeFeature(this.showFeature);
        this.broker.removeFeature((Feature)this.viewFeature);
        this.broker.removeFeature((Feature)this.sendHomeEmailFeature);
        this.broker.removeFeature((Feature)this.sendWorkEmailFeature);
        this.prefsFeature = null;
        this.showFeature = null;
        this.viewFeature = null;
        this.sendHomeEmailFeature = null;
        this.sendWorkEmailFeature = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("chair")) {
            if (ProfileProtocol.DEBUG.show()) {
                this.logger.message((Object)this, "propertyChange", "chair changed <---");
            }
            this.chairChanged(e);
        } else if (prop.equals("profile.distribution")) {
            if (ProfileProtocol.DEBUG.show()) {
                this.logger.message((Object)this, "propertyChange", "PROPERTY (distribution changed) <---");
            }
            this.distributionChanged(e);
        } else if (prop.equals("Label.Moderators")) {
            if (ProfileProtocol.DEBUG.show()) {
                this.logger.message((Object)this, "propertyChange", "label changed <---");
            }
            this.labelChanged(e);
        }
    }

    public String getNameOfModule() {
        return MODULE_NAME;
    }

    public String getDisplayNameOfModule() {
        return i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_TITLE);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getTitle() {
        return Mnemonic.getText((String)i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_TITLE));
    }

    public Icon getIcon() {
        return i18n.getIcon("Profile.icon");
    }

    public Icon getModuleIcon() {
        return i18n.getIcon("Profile.icon");
    }

    public Class<?>[] getCommandClasses() {
        return new Class[]{SetViewableProfilesCmd.class};
    }

    public void configure(Client client) {
        try {
            this.channel = client.acquireChannel("profile", (byte)4, (ChannelListener)this, (ChannelDataListener)this);
        }
        catch (JinxChannelException cx) {
            this.logger.exception((Object)this, "configure", (Throwable)cx, true);
            return;
        }
        this.channel.setProtocol((JinxProtocol)new ProfileProtocol());
        this.channel.addParticipantListener((ParticipantListener)this);
        try {
            this.lib = new ProfileLibrary();
        }
        catch (Throwable t) {
            this.lib = null;
            this.logger.error((Object)this, "configure", "Failed to initialize profile image server.\n" + Debug.getStackTrace((Throwable)t));
        }
        if (this.lib != null) {
            this.lib.setChannel(this.channel);
            this.imps.provideAPI(ProfileDataAPI.class, (ImpsAPI)this.lib);
        }
    }

    public void start() {
        this.confEngine.registerCommand(this.setViewableProfilesCmd);
    }

    public void attach() {
        this.clients = this.clientProvider.get().getClientList();
        this.configure(this.clientProvider.get());
        try {
            if (this.profileURL != null) {
                this.myProfile = new Profile(this.profileURL);
            } else {
                this.profilePath = new File(Platform.getPreferencesDir(), Platform.cleanFilename((String)PROFILE_NAME, (boolean)true));
                File f = this.profilePath;
                if (!f.exists()) {
                    f = new File(System.getProperty("user.home"), OLD_PROFILE_NAME);
                }
                this.myProfile = new Profile(f);
            }
        }
        catch (Exception iox) {
            this.myProfile = new Profile();
        }
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("profile.distribution", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Label.Moderators", (PropertyChangeListener)this);
        this.session.registerAnnotation("ProfilePictureAnnotation", (Object)this.defaultImage);
        this.session.registerAnnotation("ProfileHTMLAnnotation", null);
        this.session.registerAnnotation("ProfileModDisplay", null);
        this.session.registerAnnotation("ProfileMinimumHeight", null);
    }

    public void setupUI() {
        if (this.createFeatures()) {
            this.broker.addFeature((Feature)this.sendWorkEmailFeature);
            this.broker.addFeature((Feature)this.sendHomeEmailFeature);
            this.broker.addFeature((Feature)this.viewFeature);
            this.broker.addFeature(this.showFeature);
            this.broker.addFeature((Feature)this.prefsFeature);
        }
        this.selector = (ParticipantSelectorAPI)this.imps.findBest(ParticipantSelectorAPI.class);
        if (this.selector != null) {
            this.selector.addSelectionListener((ParticipantSelectionListener)this);
        }
    }

    public void cleanupUI() {
        this.destroyFeatures();
    }

    public void detach() {
        this.clients.removePropertyChangeListener("Label.Moderators", (PropertyChangeListener)this);
        this.clients.removePropertyChangeListener("profile.distribution", (PropertyChangeListener)this);
        this.clients.removePropertyChangeListener("chair", (PropertyChangeListener)this);
        this.unconfigure(this.clientProvider.get());
    }

    public void stop() {
    }

    public boolean isConfigured() {
        return this.lib != null;
    }

    public void unconfigure(Client client) {
        if (this.lib != null) {
            this.imps.revokeAPI(ProfileDataAPI.class, (ImpsAPI)this.lib);
            this.lib.shutdown();
            this.lib = null;
        }
        if (this.channel != null) {
            this.channel.removeParticipantListener((ParticipantListener)this);
            if (client != null) {
                client.releaseChannel(this.channel);
            }
            this.channel = null;
        }
    }

    public boolean checkArgument(String arg, Iterator<String> argIter) {
        if (arg.equals(i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_PROFILEARG))) {
            if (this.profileURL != null) {
                throw new IllegalArgumentException(i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_MULTIPLEURLS, new Object[]{arg}));
            }
            if (argIter.hasNext()) {
                String url = argIter.next();
                try {
                    this.profileURL = new URL(url);
                }
                catch (MalformedURLException mux) {
                    throw new IllegalArgumentException(i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_BADURL, new Object[]{url}));
                }
                return true;
            }
            throw new IllegalArgumentException(i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_MISSINGURL));
        }
        return false;
    }

    boolean isProfileStoredRemotely() {
        return this.profileURL != null;
    }

    Profile getMyProfile() {
        return this.myProfile;
    }

    void saveMyProfile() throws IOException {
        Image profileImage;
        if (ProfileProtocol.DEBUG.show()) {
            this.logger.message((Object)this, "saveMyProfile", "sending and saving updated profile");
        }
        this.sendProfile();
        if (this.profileURL == null) {
            this.myProfile.save(this.profilePath);
        }
        if (this.lib != null && this.channel != null && this.channel.isUp()) {
            if (this.myProfile.isEmpty()) {
                this.lib.deleteProfile(this.clientProvider.get().getAddress());
            } else {
                this.lib.addProfile(this.clientProvider.get().getAddress(), this.myProfile);
            }
        }
        if ((profileImage = this.myProfile.getImage(ProfileItemID.PHOTO)) == null) {
            profileImage = this.defaultImage;
        }
        this.session.setAnnotationValue(this.clientProvider.get().getAddress(), "ProfilePictureAnnotation", (Object)profileImage);
    }

    private void sendProfile() {
        if (this.channel == null) {
            return;
        }
        if (!this.channel.isUp()) {
            return;
        }
        if (ProfileProtocol.DEBUG.show()) {
            this.logger.message((Object)this, "sendProfile", "sending our profile (our name is '" + this.myProfile.getString(ProfileItemID.FULL_NAME, "") + "')");
        }
        ChannelDataEvent cde = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)1);
        try {
            DataOutputStream ostr = cde.write();
            ostr.writeShort(this.clientProvider.get().getAddress());
            this.myProfile.send(ostr);
            ostr.close();
            this.channel.onChannelData(cde);
        }
        catch (IOException iox) {
            this.logger.exception((Object)this, "sendProfile", (Throwable)iox, true);
        }
    }

    public void channelStateChanged(ChannelEvent e) {
        switch (e.getState()) {
            case 1: {
                if (ProfileProtocol.DEBUG.show()) {
                    this.logger.message((Object)this, "channelStateChanged", "ChannelEvent.UP");
                }
                if (this.lib == null || this.myProfile.isEmpty()) break;
                this.lib.addProfile(this.clientProvider.get().getAddress(), this.myProfile);
                String dist = (String)this.showFeature.getValue();
                boolean isProfileEnabled = "all".equals(dist) || "moderators".equals(dist) && this.isChair;
                Image img = this.myProfile.getImage(ProfileItemID.PHOTO);
                if (img == null || !isProfileEnabled) {
                    img = this.defaultImage;
                }
                this.session.setAnnotationValue(this.clients.getMyAddress(), "ProfilePictureAnnotation", (Object)img);
                this.session.setAnnotationValue(this.clients.getMyAddress(), "ProfileModDisplay", (Object)dist);
                this.sendProfile();
                break;
            }
            case 2: {
                if (ProfileProtocol.DEBUG.show()) {
                    this.logger.message((Object)this, "channelStateChanged", "ChannelEvent.DOWN");
                }
                if (this.lib == null || this.clientProvider.get() == null) break;
                this.lib.deleteProfile(this.clientProvider.get().getAddress());
            }
        }
    }

    public void onChannelData(ChannelDataEvent e) {
        if (e.getSourceAddress() != 0) {
            this.logger.error((Object)this, "onChannelData", "Invalid profile message source: " + e.getSourceAddress());
            return;
        }
        if (this.lib == null) {
            return;
        }
        switch (e.getCommand()) {
            case 1: {
                try {
                    Image img;
                    DataInputStream istr = e.read();
                    short addr = istr.readShort();
                    Profile p = new Profile(istr);
                    istr.close();
                    if (addr != this.clientProvider.get().getAddress()) {
                        this.lib.addProfile(addr, p);
                    }
                    if ((img = this.lib.getProfileImage(addr, ProfileItemID.PHOTO.getName(), 0L)) == null) {
                        img = this.defaultImage;
                    }
                    this.session.setAnnotationValue(addr, "ProfilePictureAnnotation", (Object)img);
                    this.session.setAnnotationValue(addr, "ProfileHTMLAnnotation", (Object)this.lib.getProfileHTML(addr));
                    this.session.setAnnotationValue(addr, "ProfileMinimumHeight", (Object)this.lib.getHtmlMinimumHeight(addr));
                    if (ProfileProtocol.DEBUG.show()) {
                        this.logger.message((Object)this, "onChannelData", "received the profile of '" + p.getString(ProfileItemID.FULL_NAME, "") + "' (" + addr + ")");
                    }
                }
                catch (IOException iox) {
                    this.logger.exception((Object)this, "onChannelData", (Throwable)iox, true);
                }
                this.updateMenuItems();
                break;
            }
            case 3: {
                try {
                    DataInputStream istr = e.read();
                    short addr = istr.readShort();
                    ProfileItem item = this.factory.getInstance(istr);
                    istr.close();
                    this.lib.updateProfileItem(addr, item);
                    Image img = this.lib.getProfileImage(addr, ProfileItemID.PHOTO.getName());
                    if (img == null) {
                        img = this.defaultImage;
                    }
                    this.session.setAnnotationValue(addr, "ProfilePictureAnnotation", (Object)img);
                    if (!ProfileProtocol.DEBUG.show()) break;
                    this.logger.message((Object)this, "onChannelData", "received the profile image of '" + this.lib.getProfileText(addr, ProfileItemID.FULL_NAME.getName()) + "' (" + addr + ")");
                    break;
                }
                catch (IOException iox) {
                    this.logger.exception((Object)this, "onChannelData", (Throwable)iox, true);
                }
            }
        }
    }

    public void joinChannel(ParticipantEvent e) {
    }

    public void leaveChannel(ParticipantEvent e) {
        if (this.lib != null) {
            this.lib.deleteProfile(e.getAddress());
        }
    }

    private void chairChanged(PropertyChangeEvent e) {
        byte dist = this.clients.getProperty("profile.distribution", (byte)0);
        Chair oldChair = new Chair((Connection)this.clientProvider.get(), e.getOldValue());
        Chair chair = new Chair((Connection)this.clientProvider.get(), e.getNewValue());
        if (ProfileProtocol.DEBUG.show()) {
            this.logger.message((Object)this, "chairChanged", "The list of chairs has changed. old count = " + oldChair.getCount() + "   new count = " + chair.getCount() + "\nchair property change source owner is me?  : " + (this.clients.getPropertyOwner(e.getSource()) == this.clients.getMyAddress()) + "\nchair property change source               : " + e.getSource());
        }
        this.showFeature.setEnabled(chair.isMe());
        this.isChair = chair.isMe();
        if (this.isChair && dist == 1) {
            this.lib.addProfile(this.clientProvider.get().getAddress(), this.myProfile);
            CRParticipant part = this.session.getParticipantById(this.clientProvider.get().getAddress());
            if (part != null) {
                Image img = this.lib.getProfileImage(this.clientProvider.get().getAddress(), ProfileItemID.PHOTO.getName());
                if (img == null) {
                    img = this.defaultImage;
                }
                part.setAnnotationValue("ProfilePictureAnnotation", (Object)img);
            }
        }
        if (dist != 1) {
            return;
        }
        if (this.lib == null) {
            return;
        }
        for (ClientInfo ci : oldChair) {
            if (ci == null || chair.contains(ci.getAddress())) continue;
            this.lib.deleteProfile(ci.getAddress());
            CRParticipant part = this.session.getParticipantById(ci.getAddress());
            if (part == null) continue;
            part.setAnnotationValue("ProfilePictureAnnotation", (Object)this.defaultImage);
        }
    }

    public boolean setViewableProfileModeCmd(byte mode) {
        Chair chair = ChairProtocol.getChair((ClientList)this.clients);
        if (!chair.isMe()) {
            if (ProfileProtocol.DEBUG.show()) {
                this.logger.message((Object)this, "setViewableProfileModeCmd", "request to set the viewable profile mode denied");
            }
            return false;
        }
        switch (mode) {
            case 0: {
                if (ProfileProtocol.DEBUG.show()) {
                    this.logger.message((Object)this, "setViewableProfileModeCmd", "setting viewable profile mode to MODE_NONE");
                }
                this.showFeature.setValue((Object)"none");
                break;
            }
            case 1: {
                if (ProfileProtocol.DEBUG.show()) {
                    this.logger.message((Object)this, "setViewableProfileModeCmd", "setting viewable profile mode to MODE_MODERATORS");
                }
                this.showFeature.setValue((Object)"moderators");
                break;
            }
            case 3: {
                if (ProfileProtocol.DEBUG.show()) {
                    this.logger.message((Object)this, "setViewableProfileModeCmd", "setting viewable profile mode to MODE_ALL");
                }
                this.showFeature.setValue((Object)"all");
                break;
            }
            default: {
                if (ProfileProtocol.DEBUG.show()) {
                    this.logger.message((Object)this, "setViewableProfileModeCmd", "attempt to set viewable profile mode to invalid value");
                }
                return false;
            }
        }
        if (mode != this.clients.getProperty("profile.distribution", mode)) {
            if (ProfileProtocol.DEBUG.show()) {
                this.logger.message((Object)this, "setViewableProfileModeCmd", "the viewable profile mode has changed: " + mode);
            }
            this.clients.setProperty("profile.distribution", mode);
        }
        this.session.setAnnotationValue(this.clients.getMyAddress(), "ProfileModDisplay", this.showFeature.getValue());
        this.updateMenuItems();
        return true;
    }

    private void distributionChanged(PropertyChangeEvent e) {
        boolean updateLib = false;
        byte dist = this.clients.getProperty("profile.distribution", (byte)0);
        Chair chair = ChairProtocol.getChair((ClientList)this.clients);
        boolean updateMyProfile = false;
        switch (dist) {
            case 0: {
                if (ProfileProtocol.DEBUG.show()) {
                    this.logger.message((Object)this, "distributionChanged", "got a profile distribution change event - set to MODE_NONE");
                }
                updateLib = true;
                this.showFeature.setValue((Object)"none");
                break;
            }
            case 1: {
                if (ProfileProtocol.DEBUG.show()) {
                    this.logger.message((Object)this, "distributionChanged", "got a profile distribution change event - set to MODE_MODERATORS");
                }
                updateLib = true;
                updateMyProfile = this.isChair;
                this.showFeature.setValue((Object)"moderators");
                break;
            }
            case 3: {
                if (ProfileProtocol.DEBUG.show()) {
                    this.logger.message((Object)this, "distributionChanged", "got a profile distribution change event - set to MODE_ALL");
                }
                updateLib = false;
                updateMyProfile = true;
                this.showFeature.setValue((Object)"all");
                break;
            }
            default: {
                this.logger.message((Object)this, "distributionChanged", "got a profile distribution change event - default?!");
            }
        }
        this.session.setAnnotationValue(this.clients.getMyAddress(), "ProfileModDisplay", this.showFeature.getValue());
        if (ProfileProtocol.DEBUG.show()) {
            this.logger.message((Object)this, "distributionChanged", "distribution property change source owner is me?  : " + (this.clients.getPropertyOwner(e.getSource()) == this.clients.getMyAddress()));
            this.logger.message((Object)this, "distributionChanged", "distribution property change source               : " + e.getSource());
            this.logger.message((Object)this, "distributionChanged", "distribution property change old value            : " + e.getOldValue());
            this.logger.message((Object)this, "distributionChanged", "distribution property change new value            : " + e.getNewValue());
        }
        if (this.lib != null && updateMyProfile) {
            this.lib.addProfile(this.clientProvider.get().getAddress(), this.myProfile);
            CRParticipant part = this.session.getParticipantById(this.clientProvider.get().getAddress());
            if (part != null) {
                Image img = this.lib.getProfileImage(this.clientProvider.get().getAddress(), ProfileItemID.PHOTO.getName());
                if (img == null) {
                    img = this.defaultImage;
                }
                part.setAnnotationValue("ProfilePictureAnnotation", (Object)img);
            }
        }
        if (this.lib != null && updateLib) {
            Iterator i = this.clients.visibleIterator();
            while (i.hasNext()) {
                ClientInfo ci = (ClientInfo)i.next();
                short addr = ci.getAddress();
                boolean clear = false;
                switch (dist) {
                    case 0: {
                        clear = true;
                        break;
                    }
                    case 1: {
                        boolean bl = clear = !chair.contains(addr);
                    }
                }
                if (!clear) continue;
                this.lib.deleteProfile(addr);
                CRParticipant part = this.session.getParticipantById(addr);
                if (part == null) continue;
                part.setAnnotationValue("ProfilePictureAnnotation", (Object)this.defaultImage);
            }
        }
    }

    private void updateMenuItems() {
        boolean canView = false;
        boolean canEdit = false;
        boolean canMailToHome = false;
        boolean canMailToWork = false;
        if (this.lib != null && this.selector != null && this.selector.getSelectedParticipantCount() == 1) {
            List selected = this.selector.getSelectedParticipants();
            if (selected != null && selected.size() == 1) {
                CRParticipant part = (CRParticipant)selected.get(0);
                if (part.isMe()) {
                    if (this.profileURL == null) {
                        canEdit = true;
                    } else {
                        canView = true;
                    }
                } else if (this.lib.hasProfile(part.getID())) {
                    canView = true;
                    short addr = part.getID();
                    if (this.lib.getProfileText(addr, "email.home") != null) {
                        canMailToHome = true;
                    }
                    if (this.lib.getProfileText(addr, "email.work") != null) {
                        canMailToWork = true;
                    }
                }
            }
            if (ProfileProtocol.DEBUG.show()) {
                this.logger.message((Object)this, "updateMenuItems", "---- participant selection being processed ----\ncanView = " + canView + "   " + "canEdit = " + canEdit + "   " + "canMailToHome = " + canMailToHome + "   " + "canMailToWork = " + canMailToWork);
            }
        }
        if (this.viewFeature != null) {
            if (ProfileProtocol.DEBUG.show()) {
                this.logger.message((Object)this, "updateMenuItems", "setting viewFeature enabled to " + canView);
            }
            this.viewFeature.setEnabled(canView);
            this.editProfileFeature.setEnabled(canEdit);
            this.broker.setFeaturePublished((Feature)this.editProfileFeature, canEdit);
            this.sendWorkEmailFeature.setEnabled(canMailToWork);
            this.broker.setFeaturePublished((Feature)this.sendWorkEmailFeature, canMailToWork);
            this.sendHomeEmailFeature.setEnabled(canMailToHome);
            this.broker.setFeaturePublished((Feature)this.sendHomeEmailFeature, canMailToHome);
        }
    }

    private void labelChanged(PropertyChangeEvent e) {
        if (ProfileProtocol.DEBUG.show()) {
            this.logger.message((Object)this, "labelChanged", "New moderator label = '" + i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_DISTMOD, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Moderators")}) + "'");
        }
        this.showFeature.setValueText((Object)"moderators", i18n.getString((PropertiesEnum)StringsProperties.PROFILEMODULE_DISTMOD, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Moderators")}));
    }

    public void participantSelectionChanged() {
        this.updateMenuItems();
    }
}

