/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.profile.module;

import com.elluminate.groupware.profile.Profile;
import com.elluminate.groupware.profile.module.ProfilePanel;
import com.elluminate.groupware.profile.module.StringsProperties;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;

public class ProfileEditor
extends EasyDialog {
    private static final long serialVersionUID = 1L;
    private static I18n i18n = I18n.create(ProfileEditor.class);
    private ProfilePanel profilePanel = new ProfilePanel(false);
    private JButton closeBtn = new JButton();

    public ProfileEditor(Frame owner) {
        super((Component)owner, "");
        this.setDefaultCloseOperation(1);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_VIEWERTITLE));
        this.profilePanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("person")) {
                    String pers = (String)e.getNewValue();
                    if (pers != null && pers.length() > 0) {
                        ProfileEditor.this.setTitle(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_VIEWERNAMETITLE, new Object[]{pers}));
                    } else {
                        ProfileEditor.this.setTitle(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_VIEWERTITLE));
                    }
                }
            }
        });
        Dimension ps = this.profilePanel.getPreferredSize();
        ps.width = Math.max(ps.width, 400);
        this.profilePanel.setPreferredSize(ps);
        this.closeBtn.setText(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_CLOSELABEL));
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfileEditor.this.doClose();
            }
        });
        this.setContent(this.profilePanel);
        this.addPassiveComponent(this.profilePanel.getExportButton());
        this.addCancelButton(this.closeBtn, true);
    }

    public void show(Profile p) {
        this.profilePanel.setProfile(p, false);
        super.show();
    }

    private void doClose() {
        this.hide();
    }
}

