/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.profile.module;

import com.elluminate.groupware.profile.Profile;
import com.elluminate.groupware.profile.module.ProfileModule;
import com.elluminate.groupware.profile.module.ProfilePanel;
import com.elluminate.groupware.profile.module.StringsProperties;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;

public class MyProfilePrefsPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = 1L;
    private ProfilePanel profilePanel = new ProfilePanel(true);

    @Inject
    public MyProfilePrefsPanel(PreferencesPanelOwner owner, I18n i18n) {
        super(owner, i18n.getString((PropertiesEnum)StringsProperties.MYPROFILE_TITLE));
        this.profilePanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("modified")) {
                    MyProfilePrefsPanel.this.setModifiedLocal((Boolean)e.getNewValue());
                }
            }
        });
    }

    protected void createContent() {
        this.setLayout(new BorderLayout());
        this.add(this.profilePanel, "Center");
    }

    public boolean hasStore() {
        return true;
    }

    public Object getStore(boolean copy) {
        Profile p = ((ProfileModule)this.getOwner()).getMyProfile();
        if (copy) {
            p = new Profile(p);
        }
        return p;
    }

    public void setStore(Object store) {
        try {
            ((ProfileModule)this.getOwner()).saveMyProfile();
        }
        catch (IOException ex) {
            LogSupport.exception((Object)((Object)this), (String)"setStore", (Throwable)ex, (boolean)false);
        }
    }

    public void setModified(boolean modified) {
        if (!((ProfileModule)this.getOwner()).isProfileStoredRemotely()) {
            super.setModified(modified);
            if (this.profilePanel != null) {
                this.profilePanel.setModified(modified);
            }
        }
    }

    private void setModifiedLocal(boolean modified) {
        if (!((ProfileModule)this.getOwner()).isProfileStoredRemotely()) {
            super.setModified(modified);
        }
    }

    protected void populate(Preferences preferences) {
    }

    protected void populate(Object store) {
        this.profilePanel.setProfile((Profile)store, true);
    }

    protected void apply(Preferences preferences) {
    }

    protected void apply(Object store) {
        this.profilePanel.saveProfile((Profile)store);
    }

    protected void reset(Preferences preferences) {
    }

    protected void reset(Object store) {
        ((Profile)store).clear();
    }
}

