/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.polling.module;

import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.SetPollTypeCommand;
import com.elluminate.groupware.polling.module.PollingModel;
import com.elluminate.groupware.polling.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.ShortList;
import com.google.inject.Inject;
import java.util.HashMap;

public class SetPollTypeCmd
extends AbstractCommand
implements SetPollTypeCommand {
    private String pollType = null;
    private HashMap<String, Short> pollingTypeMap = null;
    private I18n i18n = I18n.create((Object)((Object)this));
    private PollingModel model;

    @Inject
    public SetPollTypeCmd(PollingModel model) {
        this.model = model;
        this.pollingTypeMap = new HashMap();
        this.pollingTypeMap.put("none", ShortList.get((short)0));
        this.pollingTypeMap.put("yes_no", ShortList.get((short)1));
        this.pollingTypeMap.put("a_to_c", ShortList.get((short)2));
        this.pollingTypeMap.put("a_to_d", ShortList.get((short)3));
        this.pollingTypeMap.put("a_to_e", ShortList.get((short)4));
    }

    public String[] getAvailableTypes() {
        return this.pollingTypeMap.keySet().toArray(new String[0]);
    }

    public void setType(String type) {
        this.pollType = type;
    }

    protected void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        if (this.pollType == null || this.pollType.length() == 0) {
            throw new CommandParameterException("poll type must be set", this.i18n.getString((PropertiesEnum)StringsProperties.SETPOLLTYPECMD_BADPARAMPOLLTYPENOTSET));
        }
        String[] types = this.getAvailableTypes();
        boolean found = false;
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals(this.pollType)) continue;
            found = true;
        }
        if (!found) {
            throw new CommandParameterException("unknown polling type " + this.pollType, this.i18n.getString((PropertiesEnum)StringsProperties.SETPOLLTYPECMD_BADPARAMPOLLTYPEINVALID, new Object[]{this.pollType}));
        }
        this.model.setPollingMode(this.pollingTypeMap.get(this.pollType));
    }
}

