/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.polling.module;

import com.elluminate.framework.feature.AbstractFeature;
import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.groupware.polling.module.PollingTypeAdapter;
import com.elluminate.groupware.polling.module.StringsProperties;
import com.elluminate.util.PropertiesEnum;
import java.awt.Image;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class LetterPolling
extends PollingTypeAdapter {
    private static final String FEATURE_PATH = "/polling/letter";
    private EnumeratedFeature<Character> letterAtoCFeature = null;
    private EnumeratedFeature<Character> letterAtoDFeature = null;
    private EnumeratedFeature<Character> letterAtoEFeature = null;
    private EnumeratedFeature<Character> currentFeature = null;
    private MetaDataListener changeListener = null;
    private Map<Character, Image> letterImages = new LinkedHashMap<Character, Image>();
    private Map<Character, String> letterStrings = new LinkedHashMap<Character, String>();

    @Override
    public void setupFeatures() {
        this.initializeMap();
        this.setupLetterFeature();
    }

    private void initializeMap() {
        this.letterImages.put(Character.valueOf('a'), this.i18n.getImage((PropertiesEnum)StringsProperties.POLLINGMODULE_AICON));
        this.letterImages.put(Character.valueOf('b'), this.i18n.getImage((PropertiesEnum)StringsProperties.POLLINGMODULE_BICON));
        this.letterImages.put(Character.valueOf('c'), this.i18n.getImage((PropertiesEnum)StringsProperties.POLLINGMODULE_CICON));
        this.letterImages.put(Character.valueOf('d'), this.i18n.getImage((PropertiesEnum)StringsProperties.POLLINGMODULE_DICON));
        this.letterImages.put(Character.valueOf('e'), this.i18n.getImage((PropertiesEnum)StringsProperties.POLLINGMODULE_EICON));
        this.letterImages.put(Character.valueOf(' '), this.i18n.getImage((PropertiesEnum)StringsProperties.POLLINGMODULE_NONEICON));
        this.letterStrings.put(Character.valueOf('a'), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_AMENU));
        this.letterStrings.put(Character.valueOf('b'), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_BMENU));
        this.letterStrings.put(Character.valueOf('c'), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_CMENU));
        this.letterStrings.put(Character.valueOf('d'), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_DMENU));
        this.letterStrings.put(Character.valueOf('e'), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_EMENU));
        this.letterStrings.put(Character.valueOf(' '), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_NONEMENU));
    }

    private void setupLetterFeature() {
        this.changeListener = new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                LetterPolling.this.letterEnumerationChanged(ev);
            }
        };
        this.setupAtoCFeature();
        this.setupAtoDFeature();
        this.setupAtoEFeature();
    }

    private void setPollResultValues(EnumeratedFeature<Character> feature, Character[] values) {
        if (feature != null && values != null && values.length > 0) {
            for (Character c : values) {
                feature.setValueText((Object)c, this.getStringForResponseOption(c));
                feature.setValueIconImage((Object)c, this.letterImages.get(c));
            }
        }
    }

    private String getStringForResponseOption(Character response) {
        switch (response.charValue()) {
            case 'a': {
                return this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_AMENU);
            }
            case 'b': {
                return this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_BMENU);
            }
            case 'c': {
                return this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_CMENU);
            }
            case 'd': {
                return this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_DMENU);
            }
            case 'e': {
                return this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_EMENU);
            }
        }
        return this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_NORESPONSEMENU);
    }

    private void setupAtoCFeature() {
        Object[] supported = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf(' ')};
        this.letterAtoCFeature = this.broker.createEnumeratedFeature((Object)this, FEATURE_PATH, Character.class, true, (Object)Character.valueOf(' '), supported, this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_RESPONSE), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_RESPONSE));
        this.setPollResultValues(this.letterAtoCFeature, (Character[])supported);
        this.letterAtoCFeature.setDefaultIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.POLLINGMODULE_LETTERPOLLICONACTIVE));
        this.letterAtoCFeature.addValueChangeListener(this.changeListener);
    }

    private void setupAtoDFeature() {
        Object[] supported = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf(' ')};
        this.letterAtoDFeature = this.broker.createEnumeratedFeature((Object)this, FEATURE_PATH, Character.class, true, (Object)Character.valueOf(' '), supported, this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_RESPONSE), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_RESPONSE));
        this.setPollResultValues(this.letterAtoDFeature, (Character[])supported);
        this.letterAtoDFeature.setDefaultIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.POLLINGMODULE_LETTERPOLLICONACTIVE));
        this.letterAtoDFeature.addValueChangeListener(this.changeListener);
    }

    private void setupAtoEFeature() {
        Object[] supported = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf(' ')};
        this.letterAtoEFeature = this.broker.createEnumeratedFeature((Object)this, FEATURE_PATH, Character.class, true, (Object)Character.valueOf(' '), supported, this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_RESPONSE), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_RESPONSE));
        this.setPollResultValues(this.letterAtoEFeature, (Character[])supported);
        this.letterAtoEFeature.setDefaultIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.POLLINGMODULE_LETTERPOLLICONINACTIVE));
        this.letterAtoEFeature.addValueChangeListener(this.changeListener);
    }

    private void cleanupFeature(EnumeratedFeature<Character> feature) {
        this.broker.removeFeature(feature);
        feature.removeMetaDataListener(this.changeListener);
        feature = null;
    }

    private void letterEnumerationChanged(MetaDataEvent ev) {
        char response = ' ';
        Image icon = this.i18n.getImage((PropertiesEnum)StringsProperties.POLLINGMODULE_LETTERPOLLICONINACTIVE);
        if (ev != null && ev.getNewValue() != null && (response = ((Character)ev.getNewValue()).charValue()) != ' ') {
            icon = this.letterImages.get(Character.valueOf(response));
        }
        this.model.setPollResponse(response);
        this.letterAtoCFeature.setDefaultIcon(icon);
        this.letterAtoDFeature.setDefaultIcon(icon);
        this.letterAtoEFeature.setDefaultIcon(icon);
    }

    @Override
    public void cleanupFeatures() {
        this.cleanupFeature(this.letterAtoCFeature);
        this.cleanupFeature(this.letterAtoDFeature);
        this.cleanupFeature(this.letterAtoEFeature);
    }

    @Override
    public void clearResponse() {
        this.model.setPollResponse(' ');
        this.letterAtoCFeature.setValue((Object)Character.valueOf(' '));
        this.letterAtoDFeature.setValue((Object)Character.valueOf(' '));
        this.letterAtoEFeature.setValue((Object)Character.valueOf(' '));
    }

    @Override
    public void lockFeature(Boolean locked) {
        if (locked != null) {
            this.letterAtoCFeature.setEnabled(locked == false);
            this.letterAtoDFeature.setEnabled(locked == false);
            this.letterAtoEFeature.setEnabled(locked == false);
        }
    }

    @Override
    public void updateFeature() {
        Feature current = this.broker.getFeature(FEATURE_PATH);
        if (current != null) {
            ((AbstractFeature)current).setEnabled(false);
            this.broker.setFeaturePublished(current, false);
        }
        switch (this.model.getPollingMode()) {
            case 2: {
                this.letterAtoCFeature.setEnabled(!this.model.isPollingLocked());
                this.broker.setFeaturePublished(this.letterAtoCFeature, true);
                this.currentFeature = this.letterAtoCFeature;
                break;
            }
            case 3: {
                this.letterAtoDFeature.setEnabled(!this.model.isPollingLocked());
                this.broker.setFeaturePublished(this.letterAtoDFeature, true);
                this.currentFeature = this.letterAtoDFeature;
                break;
            }
            case 4: {
                this.letterAtoEFeature.setEnabled(!this.model.isPollingLocked());
                this.broker.setFeaturePublished(this.letterAtoEFeature, true);
                this.currentFeature = this.letterAtoEFeature;
                break;
            }
            default: {
                this.currentFeature = null;
            }
        }
    }

    @Override
    public Image getImageFor(Character c) {
        return this.letterImages.get(c);
    }

    @Override
    public String getTextFor(Character c) {
        return this.letterStrings.get(c);
    }

    @Override
    public Map<Character, Image> getResponseOptions() {
        Character[] values;
        LinkedHashMap<Character, Image> reply = new LinkedHashMap<Character, Image>();
        if (this.currentFeature == null) {
            this.updateFeature();
        }
        for (Character character : values = (Character[])this.currentFeature.getAllowedValues()) {
            reply.put(character, this.currentFeature.getValueIconImage((Object)character));
        }
        return Collections.unmodifiableMap(reply);
    }
}

