/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.player.module;

import com.elluminate.groupware.player.module.PlayerModel;
import com.elluminate.groupware.player.module.WaitingStatusListener;
import com.elluminate.jinx.client.PlaybackEvent;
import com.elluminate.jinx.client.PlaybackListener;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.google.inject.Inject;

public class WaitingStatusModel
implements PlaybackListener {
    private long previousPlayingAt = -1L;
    private long lastPlayingAtChange = System.currentTimeMillis() - 1000L;
    private PlayerModel model;
    private ListenerRegistry<WaitingStatusListener> registry;
    private boolean previousResuming;
    private boolean previousWaiting;

    @Inject
    public void initPlayerModel(PlayerModel m) {
        this.model = m;
    }

    @Inject
    public void initListenerRegistry(ListenerRegistry<WaitingStatusListener> lr) {
        this.registry = lr;
    }

    public void playbackStatus(PlaybackEvent e) {
        this.handleWaitingStatus(e);
        this.handleResuming(e.getPlayingAt());
        this.previousPlayingAt = e.getPlayingAt();
    }

    private void handleWaitingStatus(PlaybackEvent e) {
        if (this.model.inState(PlayerModel.STATE.PAUSED) || this.model.inState(PlayerModel.STATE.STOPPED)) {
            this.setWaiting(false);
        }
        if (e.getPlayingAt() > 0L && !this.isPlaybackStuck(e.getPlayingAt())) {
            this.setWaiting(false);
        }
        if (this.model.inState(PlayerModel.STATE.PLAYING) && this.isPlaybackStuck(e.getPlayingAt())) {
            this.setWaiting(true);
        }
    }

    void setWaiting(boolean waiting) {
        if (waiting == this.previousWaiting) {
            return;
        }
        this.fireWaitingChanged(waiting);
        this.previousWaiting = waiting;
    }

    private void handleResuming(long playingAt) {
        boolean resuming;
        if (this.previousPlayingAt != playingAt) {
            this.lastPlayingAtChange = System.currentTimeMillis();
        }
        boolean bl = resuming = playingAt > 0L;
        if (resuming != this.previousResuming || this.previousPlayingAt == -1L) {
            this.fireResumingChanged(resuming);
        }
        this.previousPlayingAt = playingAt;
        this.previousResuming = resuming;
    }

    public void addWaitingStatusListener(WaitingStatusListener listener) {
        if (listener != null) {
            this.registry.add((Object)listener);
        }
    }

    public void removeWaitingStatusListener(WaitingStatusListener listener) {
        if (listener != null) {
            this.registry.remove((Object)listener);
        }
    }

    private void fireResumingChanged(final boolean resuming) {
        this.registry.fire((FiringFunctor)new FiringFunctor<WaitingStatusListener>(){

            public void fire(WaitingStatusListener listener) {
                listener.resumingChanged(resuming);
            }
        });
    }

    private void fireWaitingChanged(final boolean loadingBlocked) {
        this.registry.fire((FiringFunctor)new FiringFunctor<WaitingStatusListener>(){

            public void fire(WaitingStatusListener listener) {
                listener.waitingChanged(loadingBlocked);
            }
        });
    }

    private boolean isPlaybackStuck(long playingAt) {
        return playingAt == this.previousPlayingAt && System.currentTimeMillis() - this.lastPlayingAtChange > 750L || this.previousPlayingAt == -1L;
    }
}

