/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.player.module;

import com.elluminate.groupware.player.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.border.Border;

public class WaitingStatus
extends JWindow {
    private I18n i18n = I18n.create((Object)this);
    private JLabel statusMsg = new JLabel();
    private JProgressBar progressBar = new JProgressBar();
    private String host;
    private boolean resuming;

    public WaitingStatus(Frame parent, String host) {
        super(parent);
        this.host = host;
    }

    public void setResuming(boolean flag) {
        if (this.resuming == flag) {
            return;
        }
        this.resuming = flag;
        String key = this.resuming ? "PlayerModule.loadingFromHostResume" : "PlayerModule.loadingFromHostStart";
        this.statusMsg.setText(this.toHtml(this.i18n.getStringLegacy(key, new Object[]{this.host})));
        this.setSize(this.getPreferredSize());
        this.center();
    }

    private Border createBorder() {
        return BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private String toHtml(String text) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append(this.replace(text, "\n", "<br>"));
        sb.append("</html>");
        return sb.toString();
    }

    private Object replace(String text, String target, String replacement) {
        StringTokenizer st = new StringTokenizer(text, target);
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            sb.append(replacement);
        }
        return sb.toString();
    }

    public void init() {
        ((JPanel)this.getContentPane()).setBorder(this.createBorder());
        this.statusMsg.setText(this.toHtml(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_LOADINGFROMHOSTSTART, new Object[]{this.host})));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.statusMsg, "Center");
        this.setAlwaysOnTop(true);
        this.progressBar.setIndeterminate(true);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.progressBar, "South");
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)panel, "South");
        this.setSize(this.getPreferredSize());
        this.listenToParentMoves();
        this.center();
    }

    private void listenToParentMoves() {
        this.getParent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent arg0) {
                WaitingStatus.this.center();
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
                WaitingStatus.this.center();
            }
        });
    }

    private void center() {
        Point c = new Point();
        Point p = this.getParent().getLocation();
        c.x = p.x + this.getParent().getWidth() / 2 - this.getWidth() / 2;
        c.y = p.y + this.getParent().getHeight() / 2 - this.getHeight() / 2;
        this.setLocation(c);
    }
}

