/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.player.module;

import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.groupware.player.PlayerDebug;
import com.elluminate.groupware.player.module.FilteredIndexProvider;
import com.elluminate.groupware.player.module.IndexDialog;
import com.elluminate.groupware.player.module.PlaybackSlider;
import com.elluminate.groupware.player.module.PlaybackSliderModel;
import com.elluminate.groupware.player.module.PlayerIndexUtils;
import com.elluminate.groupware.player.module.PlayerModel;
import com.elluminate.groupware.player.module.SeekTimeLabel;
import com.elluminate.groupware.player.module.SeekTimeListenerImpl;
import com.elluminate.groupware.player.module.SeekTimeModel;
import com.elluminate.groupware.player.module.StringsProperties;
import com.elluminate.gui.I18nUI;
import com.elluminate.gui.component.RollOverButton;
import com.elluminate.gui.event.PopupGestureHandler;
import com.elluminate.gui.swing.CMenu;
import com.elluminate.gui.swing.CMenuItem;
import com.elluminate.gui.swing.CPopupMenu;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.VCRFile;
import com.elluminate.jinx.client.PlaybackClient;
import com.elluminate.jinx.client.PlaybackEvent;
import com.elluminate.jinx.client.PlaybackListener;
import com.elluminate.jinx.provider.ConnectionProvider;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nMessage;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.StringUtils;
import com.elluminate.util.SwingRunner;
import com.elluminate.util.event.DataChangeEvent;
import com.elluminate.util.event.DataChangeListener;
import com.elluminate.util.event.DataProvider;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class SliderView
extends JPanel
implements ComponentProvider,
PlaybackListener {
    private static final int MAX_INDECIES_IN_MENU = 10;
    private static final int DEFAULT_HEIGHT = 25;
    private I18n i18n = null;
    private Provider<PlaybackSlider> sliderProvider = null;
    private PlaybackSlider slider = null;
    private PlaybackSliderModel sliderModel = null;
    private ChangeListener changeListener = null;
    private SeekTimeLabel seekTimeMsg = null;
    private SeekTimeModel seekTimeModel = null;
    private PlayerModel model = null;
    private ConnectionProvider clientProvider = null;
    private PlayerIndexUtils indexUtils = null;
    private SwingRunner runner = null;
    private Provider<IndexDialog> indexDialogProvider = null;
    private ActionListener indexActionListener = null;
    private Logger log = null;
    private long lastLabel = -1L;
    private HashMap<I18nMessage, Icon> iconMap = new HashMap();
    private int lastIdx = -1;
    private String currentIndexInfoText = "";
    private JLabel label = null;
    private JLabel indexInfo = null;
    private JPopupMenu indexPopup = null;
    private JMenu predPopupItem = null;
    private JMenu succPopupItem = null;
    private JMenuItem showIndexPopupItem = null;
    private Icon currentIndexInfoIcon = null;
    private JButton indexMenuBtn = null;
    private ImageIcon indexMenuIcon = null;
    private JMenuItem showIndexMenu = null;
    private JLabel labelTotal;
    private int lastWidth;

    @Inject
    public SliderView() {
        super(new BorderLayout());
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.getParent() != null && this.lastWidth != this.getParent().getBounds().width) {
            this.setPreferredSize(new Dimension(this.getParent().getBounds().width - 10, 25));
        }
        this.lastWidth = this.getParent().getBounds().width;
    }

    @Inject
    public void initSliderProvider(Provider<PlaybackSlider> sp) {
        this.sliderProvider = sp;
    }

    @Inject
    public void initI18n(I18n loc) {
        this.i18n = loc;
    }

    @Inject
    public void initSliderModel(PlaybackSliderModel sm) {
        this.sliderModel = sm;
    }

    @Inject
    public void initPlayerModel(PlayerModel m) {
        this.model = m;
    }

    @Inject
    public void initConnectionProvider(ConnectionProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    public void initSeekTimeModel(SeekTimeModel m) {
        this.seekTimeModel = m;
    }

    @Inject
    public void initPlayerIndexUtils(PlayerIndexUtils u) {
        this.indexUtils = u;
    }

    @Inject
    public void initSwingRunner(SwingRunner r) {
        this.runner = r;
    }

    @Inject
    public void initIndexDialogProvider(Provider<IndexDialog> p) {
        this.indexDialogProvider = p;
    }

    @Inject
    public void initLogger(Logger l) {
        this.log = l;
    }

    public Component get(ComponentFeature feature) {
        return this;
    }

    private void setupChangeListener() {
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SliderView.this.handleStateChanged(e);
            }
        };
    }

    public void setupSlider() {
        if (PlayerDebug.PLAYER.show()) {
            this.log.message("Create slider view on thread: " + Thread.currentThread().getName());
        }
        this.setupChangeListener();
        this.setupIndex();
        this.registerDataChangeListener();
        this.setupNavigationSlider();
        ((PlaybackClient)this.clientProvider.get()).addPlaybackListener((PlaybackListener)this);
    }

    private void setupNavigationSlider() {
        this.label = new JLabel("    0:00");
        this.labelTotal = new JLabel("" + this.sliderModel.getDuration());
        this.slider = (PlaybackSlider)this.sliderProvider.get();
        this.slider.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_SLIDERTIP));
        this.slider.setPreferredSize(new Dimension(200, 25));
        this.sliderModel.addChangeListener(this.changeListener);
        this.seekTimeMsg = new SeekTimeLabel();
        this.seekTimeModel.addSeekTimeListener(new SeekTimeListenerImpl(this.seekTimeMsg));
        this.sliderModel.addChangeListener(this.seekTimeModel);
        Box buttonPane = Box.createHorizontalBox();
        buttonPane.add(Box.createHorizontalStrut(6));
        buttonPane.add(new JSeparator(1));
        buttonPane.add(Box.createHorizontalStrut(3));
        buttonPane.add(this.indexInfo);
        buttonPane.add(this.indexMenuBtn);
        buttonPane.add(new JSeparator(1));
        JPanel sliderPane = new JPanel(new BorderLayout());
        sliderPane.setOpaque(false);
        sliderPane.add((Component)this.label, "West");
        sliderPane.add((Component)this.slider, "Center");
        sliderPane.add((Component)this.labelTotal, "East");
        this.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.setOpaque(false);
        this.add(sliderPane);
    }

    public void handleStateChanged(ChangeEvent e) {
        PlaybackClient client = (PlaybackClient)this.clientProvider.get();
        if (this.sliderModel.getDesiredTime() / 1000L != this.lastLabel) {
            this.label.setText(this.setLabel(this.sliderModel.getDesiredTime()));
        }
        this.labelTotal.setText(this.setLabel(this.sliderModel.getDuration()) + " ");
        if (this.sliderModel.isAdjusting() || this.sliderModel.isSynchronized()) {
            if (this.model.inState(PlayerModel.STATE.SEEKING)) {
                client.pause();
                this.model.setState(PlayerModel.STATE.RESUME, "stateChanged");
            }
            return;
        }
        if (!this.model.inState(PlayerModel.STATE.SEEKING)) {
            this.model.saveCurrentState();
        }
        long wanted = this.sliderModel.getDesiredTime();
        long actual = this.sliderModel.getPlayingTime();
        if (wanted < 1L) {
            if (client != null) {
                client.stop();
            }
            return;
        }
        if (wanted < actual && client != null) {
            client.reset();
            ClientInfo.resetObfuscator();
        }
        this.model.setState(PlayerModel.STATE.SEEKING, "stateChanged");
    }

    protected String setLabel(long millis) {
        long sec = millis / 1000L;
        boolean empty = true;
        this.lastLabel = sec;
        int hrs = (int)(sec / 3600L);
        int min = (int)((sec -= (long)(hrs * 3600)) / 60L);
        sec -= (long)(min * 60);
        StringBuffer buf = new StringBuffer();
        if (hrs > 0) {
            if (hrs < 10) {
                buf.append(' ');
            }
            buf.append(hrs);
            buf.append(':');
            empty = false;
        } else {
            buf.append("   ");
        }
        if (min < 10) {
            if (empty) {
                buf.append(' ');
            } else {
                buf.append('0');
            }
        }
        buf.append(min);
        buf.append(':');
        if (sec < 10L) {
            buf.append(0);
        }
        buf.append(sec);
        return buf.toString();
    }

    private void setupIndex() {
        this.setupIndexActionListener();
        this.indexMenuIcon = this.i18n.getIcon((PropertiesEnum)StringsProperties.PLAYERMODULE_INDEXMENUICON);
        this.indexMenuBtn = new RollOverButton((Icon)this.indexMenuIcon);
        this.indexInfo = new JLabel();
        this.indexMenuBtn.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_INDEXMENUTIP));
        this.indexMenuBtn.setPreferredSize(new Dimension(18, 18));
        this.showIndexMenu = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_SHOWINDEXMENU));
        this.indexPopup = new CPopupMenu();
        this.showIndexPopupItem = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_SHOWINDEXPOPUPITEM));
        this.showIndexMenu.addActionListener(this.indexActionListener);
        this.showIndexPopupItem.addActionListener(this.indexActionListener);
        this.predPopupItem = new CMenu(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_PREDPOPUPITEM));
        this.succPopupItem = new CMenu(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_SUCCPOPUPITEM));
        PopupGestureHandler popupHandler = new PopupGestureHandler(this.indexPopup);
        this.indexMenuBtn.addMouseListener((MouseListener)popupHandler);
        this.indexInfo.addMouseListener((MouseListener)popupHandler);
        this.indexMenuBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SliderView.this.indexPopup.show(SliderView.this.indexMenuBtn, SliderView.this.indexMenuBtn.getWidth(), 0);
            }
        });
        Font f = this.indexInfo.getFont();
        f = Platform.getOS() == 202 ? new Font(f.getName(), 0, Math.max(10, f.getSize() - 2)) : f.deriveFont(0, Math.max(10.0f, f.getSize2D() - 2.0f));
        this.indexInfo.setFont(f);
        this.indexPopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent ev) {
                SliderView.this.handleIndexPopupVisible();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent ev) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent ev) {
            }
        });
        this.indexPopup.add(this.predPopupItem);
        this.indexPopup.add(this.succPopupItem);
        this.indexPopup.addSeparator();
        this.indexPopup.add(this.showIndexPopupItem);
    }

    private void handleIndexPopupVisible() {
        boolean playing = !this.model.inState(PlayerModel.STATE.STOPPED);
        this.predPopupItem.removeAll();
        this.succPopupItem.removeAll();
        this.predPopupItem.setEnabled(false);
        this.succPopupItem.setEnabled(false);
        if (playing) {
            JMenuItem item;
            VCRFile.IndexEntry entry;
            int ix;
            VCRFile.IndexEntry[] index = this.indexUtils.getFilteredIndex();
            long curTime = this.sliderModel.getPlayingTime();
            int curIdx = this.indexUtils.findClosest(index, curTime, this.sliderModel.getDuration());
            int prevIdx = -1;
            int nextIdx = index.length;
            int count = 0;
            if (curIdx < 0) {
                nextIdx = 0;
            } else if (curIdx >= index.length) {
                prevIdx = index.length - 1;
            } else {
                if (curTime < index[curIdx].getTime() - 500L) {
                    prevIdx = curIdx - 1;
                    nextIdx = curIdx;
                } else if (curTime > index[curIdx].getTime() + 500L) {
                    prevIdx = curIdx;
                    nextIdx = curIdx + 1;
                } else {
                    prevIdx = curIdx - 1;
                    nextIdx = curIdx + 1;
                }
                if (prevIdx >= index.length) {
                    prevIdx = index.length - 1;
                }
                if (nextIdx < 0) {
                    nextIdx = 0;
                }
            }
            for (ix = prevIdx; ix >= 0 && count < 10; --ix, ++count) {
                entry = index[ix];
                item = this.createIndexMenuItem(entry);
                this.predPopupItem.add(item);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        SliderView.this.sliderModel.setDesiredTime(entry.getTime());
                    }
                });
            }
            this.predPopupItem.setEnabled(count > 0);
            count = 0;
            for (ix = nextIdx; ix < index.length && count < 10; ++ix, ++count) {
                entry = index[ix];
                item = this.createIndexMenuItem(entry);
                this.succPopupItem.add(item);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        SliderView.this.sliderModel.setDesiredTime(entry.getTime());
                    }
                });
            }
            this.succPopupItem.setEnabled(count > 0);
        }
    }

    private JMenuItem createIndexMenuItem(VCRFile.IndexEntry entry) {
        CMenuItem item = new CMenuItem();
        String itemText = null;
        I18nMessage mod = entry.getModuleIntl();
        String modName = null;
        String kind = entry.getKind();
        String detail = entry.getDetail();
        String time = StringUtils.formatTimeStamp((long)entry.getTime(), (boolean)false);
        Icon modIcon = I18nUI.getIcon((I18nMessage)mod);
        if (modIcon == null) {
            modName = mod.toString();
        }
        itemText = modName == null && detail == null ? this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_INDEXMENUITEMSHORT, new Object[]{kind, time}) : (modName == null ? this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_INDEXMENUITEM, new Object[]{kind, detail, time}) : (detail == null ? this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_INDEXMENUITEM, new Object[]{modName, kind, time}) : this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_INDEXMENUITEMLONG, new Object[]{modName, kind, detail, time})));
        item.setIcon(modIcon);
        item.setText(itemText);
        return item;
    }

    private void updateIndexInfo() {
        long curTime;
        VCRFile.IndexEntry[] index;
        int curIdx;
        boolean playing = !this.model.inState(PlayerModel.STATE.STOPPED);
        String text = null;
        Icon icon = null;
        if (playing && (curIdx = this.indexUtils.findClosest(index = this.indexUtils.getFilteredIndex(), curTime = this.sliderModel.getPlayingTime(), this.sliderModel.getDuration())) >= 0 && curIdx < index.length && curIdx != this.lastIdx) {
            long dt = (Math.abs(curTime - index[curIdx].getTime()) + 500L) / 1000L;
            if (dt < 60L) {
                I18nMessage iconKey;
                text = index[curIdx].hasDetail() ? index[curIdx].getDetail() : index[curIdx].getKind();
                if (text != null && text.length() > 16) {
                    text = text.substring(0, 14) + "...";
                }
                if ((icon = this.iconMap.get(iconKey = index[curIdx].getModuleIntl())) == null) {
                    icon = I18nUI.getIcon((I18nMessage)iconKey);
                    this.iconMap.put(iconKey, icon);
                }
                if (text != this.currentIndexInfoText && (text == null || !text.equals(this.currentIndexInfoText)) || this.currentIndexInfoIcon != icon) {
                    this.swingUpdateInfo(icon, text);
                }
            }
            this.lastIdx = curIdx;
        }
    }

    private void swingUpdateInfo(final Icon icon, final String text) {
        this.currentIndexInfoIcon = icon;
        this.currentIndexInfoText = text;
        this.runner.invokeLater(new Runnable(){

            @Override
            public void run() {
                SliderView.this.indexInfo.setText(text);
                SliderView.this.indexInfo.setIcon(icon);
            }
        });
    }

    private void registerDataChangeListener() {
        DataProvider dp = ((PlaybackClient)this.clientProvider.get()).getRecordingIndexProvider();
        if (dp != null) {
            DataChangeListener dcl = new DataChangeListener(){

                public void dataChanged(DataChangeEvent ev) {
                    SliderView.this.updateIndexInfo();
                }
            };
            dp.addDataChangeListener(dcl);
        }
    }

    public void playbackStatus(PlaybackEvent e) {
        if (this.sliderModel.getDuration() != e.getPlaybackLength()) {
            this.sliderModel.setDuration(e.getPlaybackLength());
        }
        if (this.sliderModel.getBufferedTime() != e.getBufferedTo()) {
            this.sliderModel.setBufferedTime(e.getBufferedTo());
        }
        if (this.sliderModel.getPlayingTime() != e.getPlayingAt()) {
            this.sliderModel.setPlayingTime(e.getPlayingAt());
        }
        this.updateIndexInfo();
    }

    public void setIndexProvider(FilteredIndexProvider fip) {
        this.slider.setIndexProvider(fip);
    }

    private void setupIndexActionListener() {
        this.indexActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SliderView.this.handleShowIndexAction();
            }
        };
    }

    private void handleShowIndexAction() {
        this.runner.invokeLater(new Runnable(){

            @Override
            public void run() {
                IndexDialog indexDialog = (IndexDialog)SliderView.this.indexDialogProvider.get();
                indexDialog.pack();
                indexDialog.show();
            }
        });
    }
}

