/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.player.module;

import com.elluminate.groupware.player.module.FilteredIndexProvider;
import com.elluminate.groupware.player.module.PlaybackSliderModel;
import com.elluminate.groupware.player.module.SeekTimeLabel;
import com.elluminate.groupware.player.module.StringsProperties;
import com.elluminate.gui.component.MediaBorder;
import com.elluminate.jinx.VCRFile;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.event.DataChangeEvent;
import com.elluminate.util.event.DataChangeListener;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PlaybackSlider
extends JComponent
implements ChangeListener,
DataChangeListener {
    private static final int MIN_HEIGHT = 25;
    private static final int MIN_WIDTH = 500;
    private static final int TICK_THRESHOLD = 6;
    private static final boolean ENABLE_SLIDER_TIPS = true;
    private I18n i18n = I18n.create((Object)this);
    private PlaybackSliderModel model = null;
    private Color chnlFilled = new Color(167, 29, 29);
    private Color chnlEmpty = new Color(180, 180, 180);
    private Color chnlNotRead = new Color(185, 123, 123);
    private MediaBorder chnlBorder = new MediaBorder();
    private Icon thumbIcon;
    private Icon thumbIconOver;
    private Color thmbColor = new Color(110, 110, 110);
    private Color thmbShadow = new Color(20, 20, 20);
    private Color thmbHilite = new Color(235, 235, 235);
    private Color deltaColor = new Color(255, 205, 0);
    private Color tickColor = new Color(84, 84, 84);
    private DragHandler dragHandler = null;
    private long lastPlayingX = -1L;
    private long lastBufferX = -1L;
    private long lastThumbX = -1L;
    private FilteredIndexProvider indexer = null;
    transient Popup tipWindow;
    private JToolTip tip;
    private Rectangle popupRect = null;
    private boolean mouseDown = false;
    private Rectangle thumbTipRect;
    private Point thumbTipLocation = new Point();
    private MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(){

        @Override
        public void mouseDragged(MouseEvent e) {
            if (PlaybackSlider.this.mouseDown) {
                PlaybackSlider.this.thumbTipRect = PlaybackSlider.this.computeThumbRect();
                PlaybackSlider.this.thumbTipLocation.setLocation(((PlaybackSlider)PlaybackSlider.this).thumbTipRect.x + ((PlaybackSlider)PlaybackSlider.this).thumbTipRect.width / 2, PlaybackSlider.this.getBounds().y);
                PlaybackSlider.this.showCustomTip(new MouseEvent(PlaybackSlider.this, e.getID(), e.getWhen(), e.getModifiers(), ((PlaybackSlider)PlaybackSlider.this).thumbTipLocation.x, ((PlaybackSlider)PlaybackSlider.this).thumbTipLocation.y, e.getClickCount(), e.isPopupTrigger()));
            }
        }
    };

    @Inject
    public PlaybackSlider(PlaybackSliderModel m) {
        this.model = m;
        this.model.addChangeListener(this);
        MouseHandler mouseAdapter = new MouseHandler();
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(this.mouseMotionAdapter);
        this.thumbIcon = this.i18n.getIcon("PlaybackSlider.thumbIcon");
        this.thumbIconOver = this.i18n.getIcon("PlaybackSlider.thumbIconOver");
    }

    public int getThumbWidth() {
        if (this.thumbIcon != null) {
            return this.thumbIcon.getIconWidth();
        }
        return 12;
    }

    public int getThumbHeight() {
        if (this.thumbIcon != null) {
            return this.thumbIcon.getIconHeight();
        }
        return 23;
    }

    public PlaybackSliderModel getModel() {
        return this.model;
    }

    public void setIndexProvider(FilteredIndexProvider fip) {
        if (this.indexer != null) {
            this.indexer.removeDataChangeListener(this);
        }
        this.indexer = fip;
        if (this.indexer != null) {
            this.indexer.addDataChangeListener(this);
        }
        this.repaint();
    }

    @Override
    public String getToolTipText(MouseEvent mev) {
        FilteredIndexProvider fip = this.indexer;
        if (fip == null) {
            return super.getToolTipText(mev);
        }
        int x0 = mev.getX();
        String timeString = SeekTimeLabel.format(this.coordToTime(x0) / 1000L);
        VCRFile.IndexEntry[] list = null;
        try {
            list = (VCRFile.IndexEntry[])this.indexer.getData();
        }
        catch (Throwable t) {
            list = null;
        }
        if (list == null) {
            return this.addTimeToTip(super.getToolTipText(mev), timeString);
        }
        for (int ix = 0; ix < list.length; ++ix) {
            int x;
            long t;
            if (list[ix] == null || (t = list[ix].getTime()) < 0L || Math.abs(x0 - (x = this.timeToCoord(t))) > 3) continue;
            String tip = this.formatToolTip(list[ix], timeString);
            return tip;
        }
        return this.addTimeToTip(super.getToolTipText(mev), timeString);
    }

    private String addTimeToTip(String tip, String timeString) {
        return tip + " (" + timeString + ")";
    }

    private String formatToolTip(VCRFile.IndexEntry ie, String timeString) {
        String mod = null;
        String kind = ie.getKind();
        try {
            mod = this.i18n.getURLforPath(ie.getModule()).toString();
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        if (mod != null) {
            if (ie.hasDetail()) {
                return this.i18n.getString((PropertiesEnum)StringsProperties.PLAYBACKSLIDER_INDEXICONDETAILTIP, new Object[]{mod, kind, ie.getDetail(), timeString});
            }
            return this.i18n.getString((PropertiesEnum)StringsProperties.PLAYBACKSLIDER_INDEXICONTIP, new Object[]{mod, kind, timeString});
        }
        if (ie.hasDetail()) {
            return this.i18n.getString((PropertiesEnum)StringsProperties.PLAYBACKSLIDER_INDEXDETAILTIP, new Object[]{kind, ie.getDetail(), timeString});
        }
        return this.i18n.getString((PropertiesEnum)StringsProperties.PLAYBACKSLIDER_INDEXTIP, new Object[]{kind, timeString});
    }

    public void dataChanged(DataChangeEvent ev) {
        this.repaint();
    }

    private void hideCustomTip() {
        if (this.tipWindow != null) {
            this.tipWindow.hide();
            this.tipWindow = null;
            this.tip = null;
        }
    }

    private void showCustomTip(MouseEvent event) {
        Point screenLocation = this.getLocationOnScreen();
        Point location = new Point();
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        Rectangle sBounds = gc.getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        sBounds.x += screenInsets.left;
        sBounds.y += screenInsets.top;
        sBounds.width -= screenInsets.left + screenInsets.right;
        sBounds.height -= screenInsets.top + screenInsets.bottom;
        boolean leftToRight = this.getComponentOrientation().isLeftToRight();
        this.hideCustomTip();
        if (this.tip == null) {
            this.tip = this.createToolTip();
        }
        String toolTipText = this.getToolTipText(event);
        Point preferredLocation = this.getToolTipLocation(event);
        this.tip.setTipText(toolTipText);
        Dimension size = this.tip.getPreferredSize();
        if (preferredLocation != null) {
            location.x = screenLocation.x + preferredLocation.x;
            location.y = screenLocation.y + preferredLocation.y;
            if (!leftToRight) {
                location.x -= size.width;
            }
        } else {
            location.x = screenLocation.x + event.getX();
            location.y = screenLocation.y + event.getY() + 20;
            if (!leftToRight && location.x - size.width >= 0) {
                location.x -= size.width;
            }
        }
        if (this.popupRect == null) {
            this.popupRect = new Rectangle();
        }
        this.popupRect.setBounds(location.x, location.y, size.width, size.height);
        if (location.x < sBounds.x) {
            location.x = sBounds.x;
        } else if (location.x - sBounds.x + size.width > sBounds.width) {
            location.x = sBounds.x + Math.max(0, sBounds.width - size.width);
        }
        if (location.y < sBounds.y) {
            location.y = sBounds.y;
        } else if (location.y - sBounds.y + size.height > sBounds.height) {
            location.y = sBounds.y + Math.max(0, sBounds.height - size.height);
        }
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        this.tipWindow = popupFactory.getPopup(this, this.tip, location.x, location.y);
        this.tipWindow.show();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        boolean draw = false;
        draw = (long)this.timeToCoord(this.model.getPlayingTime()) != this.lastPlayingX;
        draw |= (long)this.timeToCoord(this.model.getDesiredTime()) != this.lastThumbX;
        if (draw |= (long)this.timeToCoord(this.model.getBufferedTime()) != this.lastBufferX) {
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle rect = this.computeChannelRect();
        int buf = this.timeToCoord(this.model.getBufferedTime());
        int play = this.timeToCoord(this.model.getPlayingTime());
        int want = this.timeToCoord(this.model.getDesiredTime());
        this.drawIndex(g);
        this.drawChannel(g, rect, play, buf);
        if (play < want) {
            g.setColor(this.deltaColor);
            g.drawLine(play, rect.y + 3, want, rect.y + 3);
        }
        this.drawThumb(g, play < want);
        this.lastPlayingX = play;
        this.lastThumbX = want;
        this.lastBufferX = buf;
    }

    private Rectangle computeChannelRect() {
        int lMin = 0;
        int len = 0;
        int wMin = 0;
        int wid = 0;
        Rectangle bounds = this.getBounds();
        lMin = 0;
        len = bounds.width;
        wMin = 0;
        wid = bounds.height;
        lMin += this.getThumbWidth() / 2 - 1;
        if ((len -= this.getThumbWidth() - 2) <= 0) {
            return new Rectangle(0, 0);
        }
        wMin = wMin + wid / 2 - 3;
        wid = 7;
        return new Rectangle(lMin, wMin, len, wid);
    }

    private Rectangle computeThumbRect() {
        Rectangle bounds = this.getBounds();
        int x = this.timeToCoord(this.model.getDesiredTime()) - this.getThumbWidth() / 2;
        int y = bounds.height / 2 - this.getThumbHeight() / 2;
        return new Rectangle(x, y, this.getThumbWidth(), this.getThumbHeight());
    }

    private int timeToCoord(long t) {
        int x = 0;
        long tMax = this.model.getDuration();
        Rectangle bounds = this.getBounds();
        if (tMax > 0L) {
            int xMax = bounds.width - this.getThumbWidth() - 2;
            if (t < 0L) {
                t = 0L;
            } else if (t > tMax) {
                t = tMax;
            }
            x += (int)(t * (long)xMax / tMax);
        }
        return x += this.getThumbWidth() / 2;
    }

    private long coordToTime(int x) {
        long t = 0L;
        long tMax = this.model.getDuration();
        Rectangle bounds = this.getBounds();
        int xMax = bounds.width - this.getThumbWidth();
        if (xMax > 0) {
            if ((x -= this.getThumbWidth() / 2) < 0) {
                x = 0;
            } else if (x > xMax) {
                x = xMax;
            }
            t = (long)x * tMax / (long)xMax;
        }
        return t;
    }

    private void drawIndex(Graphics g) {
        if (this.indexer == null) {
            return;
        }
        VCRFile.IndexEntry[] list = null;
        try {
            list = (VCRFile.IndexEntry[])this.indexer.getData();
        }
        catch (Throwable t) {
            list = null;
        }
        if (list == null) {
            return;
        }
        Insets ins = this.getInsets();
        int y = ins.top + 2;
        int h = this.getHeight() - ins.top - ins.bottom;
        int prevPos = Integer.MIN_VALUE;
        for (int ix = 0; ix < list.length; ++ix) {
            int x;
            long t;
            if (list[ix] == null || (t = list[ix].getTime()) < 0L || (x = this.timeToCoord(t)) < prevPos + 6) continue;
            prevPos = x;
            g.setColor(this.tickColor);
            g.drawLine(x, y, x, y + h);
        }
    }

    private void drawChannel(Graphics g, Rectangle chnl, int play, int bufTo) {
        int x2 = chnl.x + chnl.width - 1;
        if (bufTo < x2 - 1) {
            g.setColor(this.chnlNotRead);
            this.fillRect(g, chnl.x + 2, x2 - 2, chnl.y + 2, play, bufTo, chnl.height - 4);
            g.setColor(this.chnlEmpty);
            this.fillRect(g, chnl.x + 2, x2 - 2, chnl.y + 2, bufTo, x2, chnl.height - 4);
        }
        if (bufTo > chnl.x) {
            g.setColor(this.chnlFilled);
            this.fillRect(g, chnl.x + 2, x2 - 2, chnl.y + 2, chnl.x, play, chnl.height - 4);
        }
        this.chnlBorder.paintBorder((Component)this, g, chnl.x, chnl.y, chnl.width, chnl.height);
    }

    private void drawThumb(Graphics g, boolean isWant) {
        Rectangle thumb = this.computeThumbRect();
        if (isWant) {
            if (this.thumbIconOver != null) {
                this.thumbIconOver.paintIcon(this, g, thumb.x, thumb.y);
                return;
            }
        } else if (this.thumbIcon != null) {
            this.thumbIcon.paintIcon(this, g, thumb.x, thumb.y);
            return;
        }
        int x1 = thumb.x;
        int x2 = x1 + thumb.width - 1;
        int y1 = thumb.y;
        int y2 = y1 + thumb.height - 1;
        g.setColor(this.thmbHilite);
        g.drawLine(x1, y1, x2, y1);
        g.drawLine(x1, y1, x1, y2);
        g.drawLine(x1 + 4, y2 - 2, x1 + 7, y2 - 2);
        g.drawLine(x1 + 7, y1 + 3, x1 + 7, y2 - 2);
        g.drawLine(x1 + 9, y2 - 2, x2 - 3, y2 - 2);
        g.drawLine(x2 - 3, y1 + 3, x2 - 3, y2 - 2);
        g.setColor(this.thmbShadow);
        g.drawLine(x1 + 3, y1 + 2, x2 - 3, y1 + 2);
        g.drawLine(x1 + 3, y1 + 2, x1 + 3, y2 - 2);
        g.drawLine(x1 + 8, y1 + 2, x1 + 8, y2 - 2);
        g.drawLine(x1 + 1, y2, x2, y2);
        g.drawLine(x2, y1 + 1, x2, y2);
        g.setColor(this.thmbColor);
        g.drawLine(x1 + 1, y1 + 1, x2 - 1, y1 + 1);
        g.drawLine(x1 + 1, y1 + 1, x1 + 1, y2 - 2);
        g.drawLine(x1 + 2, y1 + 1, x1 + 2, y2 - 2);
        g.drawLine(x2 - 2, y1 + 1, x2 - 2, y2 - 1);
        g.drawLine(x2 - 1, y1 + 1, x2 - 1, y2 - 1);
        g.drawLine(x1 + 1, y2 - 1, x2 - 1, y2 - 1);
    }

    private void fillRect(Graphics g, int x1, int x2, int y, int clipLo, int clipHi, int height) {
        if (x1 < clipLo) {
            x1 = clipLo;
        }
        if (x2 > clipHi) {
            x2 = clipHi;
        }
        if (x1 > x2) {
            return;
        }
        g.fillRect(x1, y, x2 - x1 + 1, height);
    }

    private class DragHandler
    extends MouseMotionAdapter {
        private int delta = 0;

        public DragHandler(int offset) {
            this.delta = offset;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int x = e.getX() - this.delta;
            long t = PlaybackSlider.this.coordToTime(x);
            PlaybackSlider.this.model.setDesiredTime(t);
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Rectangle thumb = PlaybackSlider.this.computeThumbRect();
            if (thumb.contains(e.getPoint())) {
                PlaybackSlider.this.dragHandler = new DragHandler(e.getX() - PlaybackSlider.this.timeToCoord(PlaybackSlider.this.model.getDesiredTime()));
                PlaybackSlider.this.addMouseMotionListener(PlaybackSlider.this.dragHandler);
                PlaybackSlider.this.model.setAdjusting(true);
                PlaybackSlider.this.mouseDown = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Rectangle chnl;
            PlaybackSlider.this.mouseDown = false;
            PlaybackSlider.this.hideCustomTip();
            if (PlaybackSlider.this.dragHandler != null) {
                PlaybackSlider.this.removeMouseMotionListener(PlaybackSlider.this.dragHandler);
                PlaybackSlider.this.dragHandler = null;
                PlaybackSlider.this.model.setAdjusting(false);
            }
            if ((chnl = PlaybackSlider.this.computeChannelRect()).contains(e.getPoint())) {
                PlaybackSlider.this.model.setDesiredTime(PlaybackSlider.this.coordToTime(e.getX()));
            }
        }
    }
}

