/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.player.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandNotPlaybackException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.PausePlaybackCommand;
import com.elluminate.groupware.player.module.PlayerModule;
import com.elluminate.groupware.player.module.StringsProperties;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;

public class PausePlaybackCmd
extends AbstractCommand
implements PausePlaybackCommand {
    private I18n i18n = I18n.create((Object)((Object)this));
    private PlayerModule module;
    private ClientProvider clientProvider;

    @Inject
    public void initPlayerModule(PlayerModule pm) {
        this.module = pm;
    }

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    public void doexecute() throws CommandExecutionException {
        if (!this.clientProvider.get().isPlayback()) {
            throw new CommandNotPlaybackException();
        }
        if (this.module.isPaused()) {
            throw new CommandContextException("The recording is already paused", this.i18n.getString((PropertiesEnum)StringsProperties.PAUSEPLAYBACKCMD_BADCONTEXTALREADYPAUSED));
        }
        this.module.setPaused();
    }
}

