/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.player.module;

import com.elluminate.extra.ExTRA;
import com.elluminate.groupware.player.module.StringsProperties;
import com.elluminate.groupware.player.module.WaitingStatusModel;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunner;
import com.elluminate.util.event.URLFillErrorEvent;
import com.elluminate.util.event.URLFillErrorEventSource;
import com.elluminate.util.io.RandomAccessURL;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DownloadErrorDialog
extends EasyDialog
implements ActionListener {
    private I18n i18n = null;
    private Logger log = null;
    private WaitingStatusModel waitingModel = null;
    private SwingRunner runner = null;
    private URLFillErrorEvent error;
    private Object monitor = new Object();
    private JPanel content = new JPanel(new BorderLayout(6, 6));
    private JScrollPane scroller = null;
    private JLabel msg = null;
    private JTextArea details = new JTextArea("");
    private JButton stopBtn = null;
    private JButton continueBtn = null;
    private JButton reportBtn = null;
    private Frame parent;

    @Inject
    public DownloadErrorDialog(DialogParentProvider parentProv, I18n i18n) {
        super((Component)parentProv.getDialogParent(), i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_DOWNLOADERRORTITLE), false);
        this.i18n = i18n;
        this.parent = parentProv.getDialogParent();
    }

    @Inject
    public void initLogger(Logger l) {
        this.log = l;
    }

    @Inject
    public void initWaitingStatusModel(WaitingStatusModel m) {
        this.waitingModel = m;
    }

    @Inject
    public void initSwingRunner(SwingRunner sr) {
        this.runner = sr;
    }

    public void launch(URLFillErrorEvent errEvent) {
        this.error = errEvent;
        this.setResizable(true);
        URLFillErrorEventSource url = this.error.getSourceURL();
        String detailsText = this.error.getMessage();
        Throwable cause = this.error.getCause();
        URL src = url.getSourceURL();
        File f = null;
        if (url instanceof RandomAccessURL) {
            f = ((RandomAccessURL)url).getBackingFile();
        }
        switch (this.error.getType()) {
            case 1: {
                this.msg = new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_DOWNLOADREADERRORMSG));
                break;
            }
            case 2: {
                this.msg = new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_DOWNLOADWRITEERRORMSG));
                break;
            }
            case 3: {
                this.msg = new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_DOWNLOADPARSEERRORMSG));
                break;
            }
            default: {
                this.msg = new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_DOWNLOADOTHERERRORMSG));
            }
        }
        this.details.setLineWrap(true);
        this.details.setWrapStyleWord(true);
        if (detailsText != null) {
            this.details.append(detailsText + "\n");
        }
        if (cause != null) {
            this.details.append("\n" + cause + "\n");
        }
        if (src != null) {
            this.details.append("\n" + src.toString());
        }
        if (f != null) {
            this.details.append("\n" + f.getAbsolutePath());
        }
        this.scroller = new JScrollPane(this.details, 22, 31);
        this.scroller.setViewportBorder(BorderFactory.createEmptyBorder(6, 6, 6, 18));
        this.content.add((Component)this.msg, "North");
        this.content.add((Component)this.scroller, "Center");
        boolean changedDim = false;
        Dimension dim = this.details.getPreferredScrollableViewportSize();
        if (dim == null) {
            dim = new Dimension(400, 200);
            changedDim = true;
        }
        Dimension max = new Dimension(400, 200);
        if (this.parent != null) {
            max.width = this.parent.getWidth();
            max.height = this.parent.getHeight();
        }
        if (dim.width > max.width) {
            dim.width = max.width;
            changedDim = true;
        }
        if (dim.width < 400) {
            dim.width = 400;
            changedDim = true;
        }
        if (dim.height > max.height) {
            dim.height = max.height;
            changedDim = true;
        }
        if (dim.height < 200) {
            dim.height = 200;
            changedDim = true;
        }
        if (changedDim) {
            this.scroller.getViewport().setPreferredSize(dim);
        }
        this.setContent(this.content);
        int defaultDisposition = 0;
        if (this.error.isContinuable()) {
            this.continueBtn = this.makeButton(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_DOWNLOADERRORCONTINUEOPT));
            this.continueBtn.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_DOWNLOADERRORCONTINUEOPTTIP));
            this.continueBtn.addActionListener(this);
            if (defaultDisposition == 0) {
                defaultDisposition = 2;
                this.addActionButton(this.continueBtn, true);
            } else {
                this.addAlternateActionButton(this.continueBtn);
            }
        }
        this.stopBtn = this.makeButton(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_DOWNLOADERRORCANCELOPT));
        this.stopBtn.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_DOWNLOADERRORCANCELOPTTIP));
        this.stopBtn.addActionListener(this);
        if (defaultDisposition == 0) {
            defaultDisposition = 1;
            this.addActionButton(this.stopBtn, true);
        } else {
            this.addAlternateActionButton(this.stopBtn);
        }
        if (cause != null) {
            this.reportBtn = new JButton(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_DOWNLOADERRORREPORTOPT));
            this.reportBtn.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_DOWNLOADERRORREPORTOPTTIP));
            this.reportBtn.addActionListener(this);
            this.addPassiveComponent(this.reportBtn);
        }
        this.error.setDisposition(defaultDisposition);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object src = ev.getSource();
        if (src == null) {
            return;
        }
        if (src == this.stopBtn) {
            try {
                this.error.setDisposition(1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ExTRA.exit((int)1);
        } else if (src == this.continueBtn) {
            this.error.setDisposition(2);
        } else if (src == this.reportBtn && this.error != null) {
            this.log.exception((Object)this, "actionPerformed", this.error.getCause(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide() {
        Object object = this.monitor;
        synchronized (object) {
            super.hide();
            this.monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayAndWait() {
        Runnable showAction = new Runnable(){

            @Override
            public void run() {
                DownloadErrorDialog.this.waitingModel.setWaiting(false);
                DownloadErrorDialog.this.show();
            }
        };
        Object object = this.monitor;
        synchronized (object) {
            this.runner.invokeLater(showAction);
            do {
                try {
                    this.monitor.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.isVisible());
        }
    }
}

