/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.player.module;

import com.elluminate.groupware.player.module.StringsProperties;
import com.elluminate.gui.swing.CDialog;
import com.elluminate.gui.swing.CFileChooser;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.io.FileSysUtils;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class ChooseVCR
extends CDialog {
    private JFileChooser chooser;
    private JTextField urlText = new JTextField();
    private JPanel modePanel = new JPanel();
    private JPanel chooserPanel = new JPanel(new BorderLayout());
    private JPanel buttonPanel = new JPanel(new GridBagLayout());
    private JButton cancelButton;
    private JButton acceptButton;
    private ButtonGroup group = new ButtonGroup();
    private JRadioButton urlButton;
    private JRadioButton fileButton;
    private String url = null;

    @Inject
    public ChooseVCR(DialogParentProvider parentProv, final I18n i18n) {
        super(parentProv.getDialogParent(), i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_SELECTVCRDIALOG), true);
        Container contentPane = this.getContentPane();
        this.chooser = new CFileChooser();
        this.chooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return FileSysUtils.isTraversableDirectory((File)file) || file.getName().toLowerCase(Locale.ENGLISH).endsWith(".vcr") && file.length() > 0L;
            }

            @Override
            public String getDescription() {
                return i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_VCRFILEDESCRIPTION);
            }
        });
        this.chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("ApproveSelection")) {
                    ChooseVCR.this.url = ChooseVCR.this.chooser.getSelectedFile().getPath();
                } else {
                    ChooseVCR.this.url = null;
                }
                ChooseVCR.this.hide();
            }
        });
        this.cancelButton = new JButton(i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_CANCEL));
        this.acceptButton = new JButton(i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_ACCEPT));
        this.chooser.setApproveButtonText(this.acceptButton.getText());
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseVCR.this.url = null;
                ChooseVCR.this.hide();
            }
        });
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ChooseVCR.this.urlButton.isSelected()) {
                    ChooseVCR.this.url = ChooseVCR.this.urlText.getText();
                } else {
                    ChooseVCR.this.url = ChooseVCR.this.chooser.getSelectedFile().getPath();
                }
                if (ChooseVCR.this.url.length() > 0) {
                    ChooseVCR.this.hide();
                }
            }
        });
        this.urlButton = new JRadioButton(i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_SELECTURL));
        this.fileButton = new JRadioButton(i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_SELECTFILE));
        this.urlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseVCR.this.urlText.setVisible(true);
                ChooseVCR.this.chooser.setVisible(false);
                ChooseVCR.this.buttonPanel.setVisible(true);
                ChooseVCR.this.pack();
            }
        });
        this.fileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseVCR.this.urlText.setVisible(false);
                ChooseVCR.this.chooser.setVisible(true);
                ChooseVCR.this.buttonPanel.setVisible(false);
                ChooseVCR.this.pack();
            }
        });
        contentPane.setLayout(new BorderLayout());
        this.modePanel.add(this.urlButton);
        this.modePanel.add(this.fileButton);
        this.group.add(this.urlButton);
        this.group.add(this.fileButton);
        this.urlButton.setSelected(true);
        this.fileButton.setSelected(false);
        this.urlText.setVisible(true);
        this.chooser.setVisible(false);
        this.chooserPanel.add((Component)this.urlText, "North");
        this.chooserPanel.add((Component)this.chooser, "Center");
        contentPane.add((Component)this.modePanel, "North");
        contentPane.add((Component)this.chooserPanel, "Center");
        this.buttonPanel.add((Component)this.acceptButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.buttonPanel.add((Component)this.cancelButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        contentPane.add((Component)this.buttonPanel, "South");
        this.pack();
        Frame parent = parentProv.getDialogParent();
        Point location = parent.getLocation();
        location.x += (parent.getSize().width - this.getSize().width) / 2;
        location.y += (parent.getSize().height - this.getSize().height) / 2;
        this.setLocation(location);
        this.setDefaultCloseOperation(1);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ChooseVCR.this.url = null;
            }
        });
    }

    protected String getURL() {
        return this.url;
    }
}

