/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.webkit.cocoa;

import com.jniwrapper.AnsiString;
import com.jniwrapper.ExternalStringPointer;
import com.jniwrapper.Function;
import com.jniwrapper.Library;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Structure;
import com.jniwrapper.Union;
import com.teamdev.jxbrowser.webkit.cocoa.CClass;
import com.teamdev.jxbrowser.webkit.cocoa.CocoaLibLeopard;
import com.teamdev.jxbrowser.webkit.cocoa.CocoaLibTiger;
import com.teamdev.jxbrowser.webkit.cocoa.Id;
import com.teamdev.jxbrowser.webkit.cocoa.Imp;
import com.teamdev.jxbrowser.webkit.cocoa.PlatformContext;
import com.teamdev.jxbrowser.webkit.cocoa.Sel;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CocoaLib
extends Library {
    private static final String LIBOBJC_NAME = "libobjc.dylib";
    private static volatile CocoaLib instance;
    private final Function getClass;
    private final Function getUID;
    private final Function getName;
    private final Function msgSend;
    private final Function msgSendStret;
    protected final Map<String, Id> uid2IDMap = new HashMap<String, Id>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CocoaLib getInstance() {
        if (instance != null) return instance;
        Class<CocoaLib> clazz = CocoaLib.class;
        synchronized (CocoaLib.class) {
            if (instance != null) return instance;
            Library.ensureNativeCode();
            instance = CocoaLibFactory.newLib();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected CocoaLib() {
        super(LIBOBJC_NAME);
        this.getClass = this.getFunction("objc_getClass");
        this.getUID = this.getFunction("sel_getUid");
        this.getName = this.getFunction("sel_getName");
        this.msgSend = this.getFunction("objc_msgSend");
        this.msgSendStret = this.getFunction("objc_msgSend_stret");
    }

    CClass getClass(String string) {
        CClass cClass = new CClass(string);
        this.getClass.invoke((Parameter)cClass, (Parameter)new AnsiString(string));
        return cClass;
    }

    void getClass(CClass cClass) {
        if (cClass.getValue() == 0L) {
            this.getClass.invoke((Parameter)cClass, (Parameter)new AnsiString(cClass.getName()));
        }
    }

    Id selGetUID(String string) {
        Id id = this.uid2IDMap.get(string);
        if (id == null) {
            id = new Id();
            this.getUID.invoke((Parameter)id, (Parameter)new AnsiString(string));
            this.uid2IDMap.put(string, id);
        }
        return id;
    }

    String selGetName(Sel sel) {
        ExternalStringPointer externalStringPointer = new ExternalStringPointer();
        this.getName.invoke((Parameter)externalStringPointer, (Parameter)sel);
        return externalStringPointer.readString();
    }

    Parameter msgSend(Parameter parameter, Sel sel, Class<?> clazz, Object[] objectArray) {
        Parameter parameter2 = null;
        if (parameter instanceof CClass) {
            this.getClass((CClass)parameter);
        }
        if (clazz != null && ((parameter2 = this.createParameter(clazz)) instanceof Structure || parameter2 instanceof Union)) {
            this.msgSendStret.invoke(parameter2, this.createInvokeParameters(parameter, sel, objectArray));
            return parameter2;
        }
        this.msgSend.invoke(parameter2, this.createInvokeParameters(parameter, sel, objectArray));
        return parameter2;
    }

    void msgSend(Parameter parameter, Sel sel, Parameter parameter2, Object[] objectArray) {
        if (parameter instanceof CClass) {
            this.getClass((CClass)parameter);
        }
        if (parameter2 instanceof Structure || parameter2 instanceof Union) {
            this.msgSendStret.invoke(parameter2, this.createInvokeParameters(parameter, sel, objectArray));
        } else {
            this.msgSend.invoke(parameter2, this.createInvokeParameters(parameter, sel, objectArray));
        }
    }

    Parameter createParameter(Class<?> clazz) {
        try {
            Object obj = clazz.newInstance();
            return (Parameter)obj;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    Parameter[] createInvokeParameters(Parameter parameter, Sel sel, Object[] objectArray) {
        Parameter[] parameterArray;
        int n = objectArray.length;
        if (n > 0 && objectArray[n - 1] instanceof Parameter[]) {
            Parameter[] parameterArray2 = (Parameter[])objectArray[n - 1];
            parameterArray = new Parameter[n + parameterArray2.length + 1];
            int n2 = 0;
            int n3 = n;
            while (n2 < parameterArray2.length) {
                parameterArray[n3] = parameterArray2[n2];
                ++n2;
                ++n3;
            }
            --n;
        } else {
            parameterArray = new Parameter[n + 2];
        }
        parameterArray[0] = parameter;
        parameterArray[1] = sel;
        for (int i = 0; i < n; ++i) {
            parameterArray[2 + i] = (Parameter)objectArray[i];
        }
        return parameterArray;
    }

    abstract Id selRegisterUID(String var1);

    abstract Pointer.Void classGetInstanceMethod(CClass var1, Sel var2);

    abstract Imp methogGetImplementation(Pointer.Void var1);

    abstract Imp methodSetImplementation(Pointer.Void var1, Pointer.Void var2);

    private static class CocoaLibFactory {
        private CocoaLibFactory() {
        }

        public static CocoaLib newLib() {
            if (PlatformContext.isTiger()) {
                return new CocoaLibTiger();
            }
            return new CocoaLibLeopard();
        }
    }
}

