/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.invite.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.invite.module.InviteDialog;
import com.elluminate.groupware.invite.module.InviteOptionsPrefsPanel;
import com.elluminate.groupware.invite.module.StringsProperties;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.JinxServerProps;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;

@Singleton
public class InviteModule
extends AbstractClientModule
implements ModulePublisherInfo,
PropertyChangeListener,
PreferencesPanelOwner {
    public static final String MODULE_NAME = "invite";
    private I18n i18n = I18n.create((Object)this);
    Client client = null;
    ClientList clients = null;
    private final String prefix = this.getClass().getName();
    private ClientProvider clientProvider;
    private FeatureBroker broker;
    private Provider<InviteOptionsPrefsPanel> inviteOptionsPrefsProvider;
    private String guestLink = "";
    private String sessionPassword = "";
    private boolean amChair = false;
    private ActionFeature inviteParticipantFeature;
    private ComponentFeature inviteOptionsPrefsFeature;
    private DialogParentProvider parentProvider;
    private Preferences preferences;

    @Inject
    public InviteModule() {
    }

    @Inject
    protected void initVersionManager(ComponentRegistrar cr) {
        cr.registerComponent((Object)this);
    }

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initParentProvider(DialogParentProvider dpp) {
        this.parentProvider = dpp;
    }

    @Inject
    public void initPreferences(Preferences prefs) {
        this.preferences = prefs;
    }

    @Inject
    public void initInviteOptionsPrefsProvider(Provider<InviteOptionsPrefsPanel> inviteProvider) {
        this.inviteOptionsPrefsProvider = inviteProvider;
    }

    public String getNameOfModule() {
        return MODULE_NAME;
    }

    public String getDisplayNameOfModule() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.INVITEMODULE_NAME);
    }

    public Icon getModuleIcon() {
        return this.i18n.getIcon("InviteModule.icon");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getTitle() {
        return this.getDisplayNameOfModule();
    }

    public Icon getIcon() {
        return this.getModuleIcon();
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public String getGuestLink() {
        return this.guestLink;
    }

    public String getSessionPassword() {
        return this.sessionPassword;
    }

    private void setGuestLink(String s) {
        this.guestLink = s == null ? "" : s;
    }

    private void setSessionPassword(String s) {
        this.sessionPassword = s == null ? "" : s;
    }

    public boolean isGuestLinkAvailable() {
        return this.guestLink != null && this.guestLink.length() > 0;
    }

    public boolean isSessionPasswordAvailable() {
        return this.sessionPassword != null && this.sessionPassword.length() > 0;
    }

    public String getSessionLabel() {
        return JinxServerProps.get((PropertyAccessAPI)this.clients, (String)"Label.session");
    }

    public String getSessionTitleLabel() {
        return JinxServerProps.get((PropertyAccessAPI)this.clients, (String)"Label.Session");
    }

    public String getSessionDisplayName() {
        return this.client.getConferenceName().getDisplayName();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("chair")) {
            this.amChair = ChairProtocol.getChair((Connection)this.client).isMe();
        } else if (prop.equals("guestLink")) {
            this.setGuestLink((String)e.getNewValue());
        } else if (prop.equals("sessionPassword")) {
            this.setSessionPassword((String)e.getNewValue());
        }
        this.broker.setFeaturePublished((Feature)this.inviteParticipantFeature, this.amChair && this.isGuestLinkAvailable());
    }

    private void doInviteParticipant() {
        String userPluralLabel = JinxServerProps.get((PropertyAccessAPI)this.clients, (String)"Label.Participants");
        new InviteDialog(this.parentProvider.getDialogParent(), this.i18n.getString((PropertiesEnum)StringsProperties.INVITEMODULE_DIALOGTITLE, new Object[]{userPluralLabel}), this).setVisible(true);
    }

    public void start() {
    }

    public void attach() {
        this.client = this.clientProvider.get();
        this.clients = this.client.getClientList();
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("guestLink", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("sessionPassword", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Label.participant", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Label.session", (PropertyChangeListener)this);
    }

    public void detach() {
        this.clients.removePropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients.removePropertyChangeListener("guestLink", (PropertyChangeListener)this);
        this.clients.removePropertyChangeListener("sessionPassword", (PropertyChangeListener)this);
        this.clients.removePropertyChangeListener("Label.participant", (PropertyChangeListener)this);
        this.clients.removePropertyChangeListener("Label.session", (PropertyChangeListener)this);
        this.clients = null;
        this.client = null;
    }

    public void stop() {
    }

    public void setupUI() {
        String featurePath = "/invite/inviteParticipantMenuItem";
        String featureName = this.i18n.getString((PropertiesEnum)StringsProperties.INVITEMODULE_INVITEATTENDEE);
        this.inviteParticipantFeature = this.broker.createActionFeature((Object)this, featurePath, featureName, null);
        this.inviteParticipantFeature.setInteractive(true);
        this.inviteParticipantFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                InviteModule.this.doInviteParticipant();
            }
        });
        this.inviteOptionsPrefsFeature = this.broker.createComponentFeature((Object)this, "/invite/prefs/inviteOptions", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return (Component)InviteModule.this.inviteOptionsPrefsProvider.get();
            }
        }, this.i18n.getString((PropertiesEnum)StringsProperties.INVITEOPTIONS_TITLE), this.i18n.getString((PropertiesEnum)StringsProperties.INVITEOPTIONS_TITLE));
        this.broker.addFeature((Feature)this.inviteOptionsPrefsFeature);
    }

    public void cleanupUI() {
        this.broker.setFeaturePublished((Feature)this.inviteParticipantFeature, false);
        this.broker.setFeaturePublished((Feature)this.inviteOptionsPrefsFeature, false);
    }
}

