/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.hand.module;

import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.hand.module.HandPublisher;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.util.I18n;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class HandEmoticonAnnotations
implements PropertyChangeListener {
    volatile ClientList clients;
    CRSession session = null;
    EnumeratedFeature<Integer> emoticonFeature = null;
    I18n i18n = null;
    private HandPublisher msgPublisher;

    public HandEmoticonAnnotations(CRSession session, ClientList clients, EnumeratedFeature<Integer> emoticonFeature, I18n i18n, HandPublisher msgPublisher) {
        this.session = session;
        this.clients = clients;
        this.emoticonFeature = emoticonFeature;
        this.i18n = i18n;
        this.msgPublisher = msgPublisher;
        clients.addClientPropertyChangeListener("hand.emotion", (PropertyChangeListener)this);
        clients.addClientPropertyChangeListener("hand.index", (PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this.clients == null) {
            return;
        }
        short addr = this.clients.getPropertyOwner(e.getSource());
        ClientInfo ci = this.clients.get(addr);
        if (ci == null) {
            return;
        }
        if (e.getPropertyName().equals("hand.emotion")) {
            this.sendEmoticonAnnotation(ci);
        }
    }

    private void sendEmoticonAnnotation(ClientInfo ci) {
        Integer val = 0;
        char emoticon = ci.getProperty("hand.emotion", ' ');
        switch (emoticon) {
            case ')': {
                val = 1;
                this.msgPublisher.sendSmileMessage(ci.getDisplayName(), ci.isMe());
                break;
            }
            case 'l': {
                val = 2;
                this.msgPublisher.sendLaughMessage(ci.getDisplayName(), ci.isMe());
                break;
            }
            case 'c': {
                val = 3;
                this.msgPublisher.sendClapMessage(ci.getDisplayName(), ci.isMe());
                break;
            }
            case '?': {
                val = 4;
                this.msgPublisher.sendConfusedMessage(ci.getDisplayName(), ci.isMe());
                break;
            }
            case 'a': {
                val = 6;
                this.msgPublisher.sendAngryDisapprovalMessage(ci.getDisplayName(), ci.isMe());
                break;
            }
            case 'p': {
                val = 5;
                this.msgPublisher.sendAngryApprovalMessage(ci.getDisplayName(), ci.isMe());
                break;
            }
            case 's': {
                val = 7;
                this.msgPublisher.sendSlowerMessage(ci.getDisplayName(), ci.isMe());
                break;
            }
            case 'f': {
                val = 8;
                this.msgPublisher.sendFasterMessage(ci.getDisplayName(), ci.isMe());
            }
        }
        if (ci.isMe()) {
            this.emoticonFeature.setValue((Object)val);
            if (val != 0) {
                Image im = this.emoticonFeature.getValueIconImage((Object)val);
                this.emoticonFeature.setDefaultIcon(im);
            } else {
                this.emoticonFeature.setDefaultIcon(this.i18n.getImage("HandBean.emoticonButtonIcon"));
            }
        }
        this.session.setAnnotationValue(ci.getAddress(), "EmoticonAnnotation", (Object)val);
    }
}

