/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml;

import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Section;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.xml.Tags;
import java.util.EmptyStackException;
import java.util.Properties;
import java.util.Stack;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;

public class SAXiTextHandler
extends HandlerBase {
    private Document document;
    private Tags tags;
    private Stack stack;
    private int chapters = 0;
    private boolean title = false;
    private Chunk currentChunk = null;

    public SAXiTextHandler(Document document, Tags tags) {
        this.document = document;
        this.tags = tags;
        this.stack = new Stack();
    }

    public void startElement(String string, AttributeList attributeList) {
        Object object;
        int n;
        Properties properties = new Properties();
        if (attributeList != null) {
            n = 0;
            while (n < attributeList.getLength()) {
                object = attributeList.getName(n);
                properties.setProperty((String)object, attributeList.getValue(n));
                ++n;
            }
        }
        if (this.tags.isChunk(string)) {
            this.currentChunk = this.tags.getChunk(properties);
        } else if (this.tags.isPhrase(string)) {
            this.stack.push(this.tags.getPhrase(properties));
        } else if (this.tags.isParagraph(string)) {
            this.stack.push(this.tags.getParagraph(properties));
        } else if (this.tags.isTitle(string)) {
            this.title = true;
        } else if (this.tags.isSection(string)) {
            Element element = (Element)this.stack.pop();
            object = ((Section)element).addSection(0, "", 0);
            this.stack.push(element);
            this.tags.setSection((Section)object, properties);
            this.stack.push(object);
        } else if (this.tags.isChapter(string)) {
            Chapter chapter = new Chapter("", ++this.chapters);
            this.tags.setSection(chapter, properties);
            this.stack.push(chapter);
        } else if (this.tags.isDocumentRoot(string)) {
            if (attributeList != null) {
                n = 0;
                while (n < attributeList.getLength()) {
                    switch (this.tags.getMetaType(attributeList.getName(n))) {
                        case 1: {
                            this.document.addTitle(attributeList.getValue(n));
                            break;
                        }
                        case 2: {
                            this.document.addSubject(attributeList.getValue(n));
                            break;
                        }
                        case 3: {
                            this.document.addKeywords(attributeList.getValue(n));
                            break;
                        }
                        case 4: {
                            this.document.addAuthor(attributeList.getValue(n));
                            break;
                        }
                    }
                    ++n;
                }
            }
            this.document.open();
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.currentChunk != null) {
            this.currentChunk.append(new String(cArray, n, n2));
        }
    }

    public void endElement(String string) {
        try {
            Element element;
            if (this.tags.isChunk(string)) {
                element = (TextElementArray)this.stack.pop();
                element.add(this.currentChunk);
                this.stack.push(element);
                this.currentChunk = null;
            }
            if (this.tags.isPhrase(string)) {
                element = (Element)this.stack.pop();
                try {
                    TextElementArray textElementArray = (TextElementArray)this.stack.pop();
                    textElementArray.add(element);
                    this.stack.push(textElementArray);
                }
                catch (EmptyStackException emptyStackException) {
                    this.document.add(element);
                }
            } else if (this.tags.isParagraph(string)) {
                element = (Element)this.stack.pop();
                try {
                    TextElementArray textElementArray = (TextElementArray)this.stack.pop();
                    while (element.type() != 12) {
                        textElementArray.add(element);
                        element = textElementArray;
                        textElementArray = (TextElementArray)this.stack.pop();
                    }
                    if (this.title) {
                        ((Section)textElementArray).setTitle((Paragraph)element);
                    } else {
                        textElementArray.add(element);
                    }
                    this.stack.push(textElementArray);
                }
                catch (EmptyStackException emptyStackException) {
                    this.document.add(element);
                }
            } else if (this.tags.isTitle(string)) {
                this.title = false;
            }
            if (this.tags.isSection(string)) {
                this.stack.pop();
            } else if (this.tags.isChapter(string)) {
                this.document.add((Element)this.stack.pop());
            } else if (this.tags.isDocumentRoot(string)) {
                this.document.close();
            }
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
    }
}

