/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfContent;
import com.lowagie.text.pdf.PdfFont;
import com.lowagie.text.pdf.PdfPrintable;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTextArray;

class PdfText
extends PdfContent {
    protected int offset = 0;
    protected int y = 0;
    protected int leading = 0;

    public PdfText() {
    }

    PdfText(int n, int n2, int n3) {
        this.offset = n;
        this.y = n2;
        this.leading = n3;
    }

    final String toPdf() {
        String string = this.toString();
        if (string.length() == 0) {
            return "";
        }
        return "BT\n" + string + "ET";
    }

    final int offset() {
        return this.offset;
    }

    final int y() {
        return this.y;
    }

    final int leading() {
        return this.leading;
    }

    final void add(PdfText pdfText) {
        this.offset += pdfText.offset();
        this.y += pdfText.y();
        this.content.append(pdfText.toString());
    }

    final void setCharacterSpacing(int n) {
        this.content.append(n).append(" Tc ");
    }

    final void setCharacterSpacing(double d) {
        this.content.append(d).append(" Tc ");
    }

    final void setWordSpacing(int n) {
        this.content.append(n).append(" Tw ");
    }

    final void setWordSpacing(double d) {
        this.content.append(d).append(" Tw ");
    }

    final void setHorizontalScaling(int n) {
        this.content.append(n).append(" Tz\n");
    }

    final void setLeading(int n) {
        this.leading = n;
        this.content.append(n).append(" TL\n");
    }

    final void setFont(PdfFont pdfFont) {
        this.content.append(pdfFont.getName().toString()).append(' ').append(pdfFont.size()).append(" Tf\n");
    }

    final void setRenderingMode(int n) {
        this.content.append(n).append(" Tr ");
    }

    final void setTextRise(int n) {
        this.content.append(n).append(" Ts ");
    }

    final void move(int n, int n2) {
        this.offset += n;
        this.y += n2;
        this.content.append(n).append(' ').append(n2).append(" Td\n");
    }

    final void move(float f, float f2) {
        this.offset = (int)((float)this.offset + f);
        this.y = (int)((float)this.y + f2);
        this.content.append(f).append(' ').append(f2).append(" Td\n");
    }

    final void moveWithLeading(int n, int n2) {
        this.offset += n;
        this.y += n2;
        this.leading = -n2;
        this.content.append(n).append(' ').append(n2).append(" TD\n");
    }

    final void setMatrix(int n, int n2, int n3, int n4, int n5, int n6) {
        this.content.append(n).append(' ').append(n2).append(' ').append(n3).append(' ').append(n4).append(' ').append(n5).append(' ').append(n6).append(" Tm\n");
    }

    final void newLine() {
        this.y -= this.leading;
        this.content.append("T* ");
    }

    final void show(PdfPrintable pdfPrintable) {
        this.content.append(new PdfString(pdfPrintable).get()).append(" Tj\n");
    }

    final void show(String string) {
        this.content.append(new PdfString(string).get()).append(" Tj\n");
    }

    final void newLineShow(PdfPrintable pdfPrintable) {
        this.y -= this.leading;
        this.content.append(new PdfString(pdfPrintable).get()).append(" '\n");
    }

    final void newLineShow(String string) {
        this.y -= this.leading;
        this.content.append(new PdfString(string).get()).append(" '\n");
    }

    final void newLineShow(int n, int n2, PdfPrintable pdfPrintable) {
        this.y -= this.leading;
        this.content.append(n).append(' ').append(n2).append(' ').append(new PdfString(pdfPrintable).get()).append(" \"\n");
    }

    final void newLineShow(int n, int n2, String string) {
        this.y -= this.leading;
        this.content.append(n).append(' ').append(n2).append(' ').append(new PdfString(string).get()).append(" \"\n");
    }

    final void show(PdfTextArray pdfTextArray) {
        this.content.append(pdfTextArray.toString()).append(" TJ\n");
    }
}

