/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfFontMetrics;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfPrintable;
import com.lowagie.text.pdf.PdfString;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

class PdfFont
extends PdfDictionary
implements Comparable {
    private PdfName name;
    private PdfFontMetrics font;

    PdfFont(String string, int n, int n2, int n3) {
        super(PdfDictionary.FONT);
        n3 = PdfFontMetrics.checkEncoding(n3);
        this.font = PdfFontMetrics.getFont(n, n3, n2);
        try {
            this.name = new PdfName(string);
        }
        catch (BadPdfFormatException badPdfFormatException) {
            try {
                this.name = new PdfName("F" + n + "_" + n3);
            }
            catch (BadPdfFormatException badPdfFormatException2) {
                this.name = this.font.name();
            }
        }
        this.put(PdfName.SUBTYPE, PdfName.TYPE1);
        this.put(PdfName.NAME, this.name);
        this.put(PdfName.BASEFONT, this.font.name());
        if (n3 != 0) {
            this.put(PdfName.ENCODING, this.font.encoding());
        }
    }

    PdfFont(int n, int n2, int n3) {
        this("F" + n, n, n2, n3);
    }

    PdfFont(int n, int n2) {
        this("F" + n, n, n2, -1);
    }

    public final int compareTo(Object object) {
        if (object == null) {
            return -1;
        }
        try {
            PdfFont pdfFont = (PdfFont)object;
            if (this.name.compareTo(pdfFont.getName()) != 0) {
                return 1;
            }
            if (this.size() != pdfFont.size()) {
                return 2;
            }
            return 0;
        }
        catch (ClassCastException classCastException) {
            return -2;
        }
    }

    int size() {
        return this.font.size();
    }

    PdfName getName() {
        return this.name;
    }

    double width() {
        return this.font.widthTextSpace();
    }

    double width(char c) {
        return this.font.widthTextSpace(c);
    }

    double width(PdfPrintable pdfPrintable) {
        String string = pdfPrintable.toString();
        int n = string.length();
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += this.font.widthTextSpace(string.charAt(n2));
            ++n2;
        }
        return d + this.font.widthTextSpace();
    }

    double offset(PdfPrintable pdfPrintable, double d, int n, int n2, int n3) {
        if (n == 0) {
            n = pdfPrintable.isString() ? 2 : 1;
        }
        if (n == 2) {
            return 0.0;
        }
        double d2 = n3 - n2;
        double d3 = d * this.width(pdfPrintable);
        switch (n) {
            case 3: {
                return (d2 - d3) / 2.0;
            }
            case 1: {
                return d2 - d3;
            }
        }
        return 0.0;
    }

    PdfString truncate(PdfPrintable pdfPrintable, double d, double d2) {
        char c = this.font.ellipsis();
        int n = 0;
        double d3 = this.font.widthTextSpace(c) * d2;
        if (d < d3) {
            return new PdfString(String.valueOf(c));
        }
        String string = pdfPrintable.toString();
        int n2 = string.length();
        while (n < n2 && d3 < d) {
            char c2 = string.charAt(n);
            d3 += this.font.widthTextSpace(c2) * d2;
            ++n;
        }
        if (n == n2) {
            return new PdfString(pdfPrintable);
        }
        if ((n -= 2) < 0) {
            return new PdfString(String.valueOf(c));
        }
        return new PdfString(string.substring(0, n) + c);
    }

    Iterator split(PdfPrintable pdfPrintable, double d, double d2) {
        ArrayList<PdfString> arrayList = new ArrayList<PdfString>();
        if (d <= 0.0) {
            return ((AbstractList)arrayList).iterator();
        }
        String string = pdfPrintable.toString();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        double d3 = this.font.widthTextSpace() * d2;
        while (n3 < n4) {
            char c = string.charAt(n3);
            if (++n3 >= n4) {
                arrayList.add(new PdfString(string.substring(n)));
                break;
            }
            if (c == '\r' || c == '\n') {
                arrayList.add(new PdfString(string.substring(n, n3 - 1)));
                d3 = this.font.widthTextSpace() * d2;
                n = n3;
                continue;
            }
            if (PdfFontMetrics.isSplitCharacter(c)) {
                n2 = n3 + 1;
            }
            if (!((d3 += this.font.widthTextSpace(c) * d2) > d)) continue;
            if (n >= n2) {
                n2 = Math.max(n + 1, n3 - 2);
            }
            arrayList.add(new PdfString(PdfFontMetrics.trim(string.substring(n, n2))));
            n3 = n2;
            d3 = this.font.widthTextSpace() * d2;
            n = n3;
        }
        return ((AbstractList)arrayList).iterator();
    }
}

