/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;

class PdfDictionary
extends PdfObject {
    public static final PdfName FONT = PdfName.FONT;
    public static final PdfName OUTLINES = PdfName.OUTLINES;
    public static final PdfName PAGE = PdfName.PAGE;
    public static final PdfName PAGES = PdfName.PAGES;
    public static final PdfName CATALOG = PdfName.CATALOG;
    private PdfName dictionaryType = null;
    protected TreeMap treeMap = new TreeMap();

    PdfDictionary() {
        super(6);
    }

    PdfDictionary(PdfName pdfName) {
        this();
        this.dictionaryType = pdfName;
        this.put(PdfName.TYPE, this.dictionaryType);
    }

    byte[] toPdf() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write("<<\n".getBytes());
            Iterator iterator = this.treeMap.keySet().iterator();
            while (iterator.hasNext()) {
                PdfName pdfName = (PdfName)iterator.next();
                PdfObject pdfObject = (PdfObject)this.treeMap.get(pdfName);
                byteArrayOutputStream.write(pdfName.toPdf());
                byteArrayOutputStream.write(" ".getBytes());
                byteArrayOutputStream.write(pdfObject.toPdf());
                byteArrayOutputStream.write("\n".getBytes());
            }
            byteArrayOutputStream.write(">>".getBytes());
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    final PdfObject put(PdfName pdfName, PdfObject pdfObject) {
        return this.treeMap.put(pdfName, pdfObject);
    }

    final PdfObject remove(PdfName pdfName) {
        return (PdfObject)this.treeMap.remove(pdfName);
    }

    final PdfObject get(PdfName pdfName) {
        return (PdfObject)this.treeMap.get(pdfName);
    }

    final boolean isDictionaryType(PdfName pdfName) {
        return this.dictionaryType.compareTo(pdfName) == 0;
    }

    final boolean isFont() {
        return this.dictionaryType.compareTo(FONT) == 0;
    }

    final boolean isPage() {
        return this.dictionaryType.compareTo(PAGE) == 0;
    }

    final boolean isPages() {
        return this.dictionaryType.compareTo(PAGES) == 0;
    }

    final boolean isCatalog() {
        return this.dictionaryType.compareTo(CATALOG) == 0;
    }

    final boolean isOutlineTree() {
        return this.dictionaryType.compareTo(OUTLINES) == 0;
    }
}

