/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import java.io.UnsupportedEncodingException;

public class ByteBuffer {
    protected int count;
    protected byte[] buf;

    public ByteBuffer() {
        this(128);
    }

    public ByteBuffer(int n) {
        if (n < 1) {
            n = 128;
        }
        this.buf = new byte[n];
    }

    public ByteBuffer append_i(int n) {
        int n2 = this.count + 1;
        if (n2 > this.buf.length) {
            byte[] byArray = new byte[Math.max(this.buf.length << 1, n2)];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
        this.buf[this.count] = (byte)n;
        this.count = n2;
        return this;
    }

    public ByteBuffer append(byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0 || n2 == 0) {
            return this;
        }
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            byte[] byArray2 = new byte[Math.max(this.buf.length << 1, n3)];
            System.arraycopy(this.buf, 0, byArray2, 0, this.count);
            this.buf = byArray2;
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count = n3;
        return this;
    }

    public ByteBuffer append(byte[] byArray) {
        return this.append(byArray, 0, byArray.length);
    }

    public ByteBuffer append(String string) {
        return this.append(string.getBytes());
    }

    public ByteBuffer append(int n) {
        return this.append(String.valueOf(n));
    }

    public ByteBuffer append(float f) {
        return this.append((double)f);
    }

    public ByteBuffer append(double d) {
        return this.append(ByteBuffer.formatDouble(d));
    }

    public static String formatDouble(double d) {
        if (Math.abs(d) < 1.5E-5) {
            return "0";
        }
        long l = (long)(d * 100000.0);
        String string = String.valueOf(l);
        String string2 = string.length() <= 5 ? "0" : string.substring(0, string.length() - 5);
        String string3 = ("00000" + string).substring(string.length());
        if (string3.equals("00000")) {
            return string2;
        }
        int n = 4;
        while (n >= 0) {
            if (string3.charAt(n) != '0') break;
            --n;
        }
        return string2 + "." + string3.substring(0, n + 1);
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, string);
    }
}

