/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.CJKFont;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.TrueType;
import com.lowagie.text.pdf.Type1;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public abstract class BaseFont {
    public static final String notdef = new String(".notdef");
    protected int[] widths = new int[256];
    protected String[] differences = new String[256];
    protected String encoding;
    protected boolean embedded;
    protected boolean fontSpecific = true;
    protected static final HashMap BuiltinFonts14 = new HashMap();

    public static BaseFont createFont(String string, String string2, boolean bl) throws DocumentException, IOException {
        if (BuiltinFonts14.containsKey(string) || string.toLowerCase().endsWith(".afm")) {
            return new Type1(string, string2, bl);
        }
        if (string.toLowerCase().endsWith(".ttf")) {
            return new TrueType(string, string2, bl);
        }
        if (CJKFont.isCJKFont(string, string2)) {
            return new CJKFont(string, string2, bl);
        }
        throw new DocumentException("Font '" + string + "' with '" + string2 + "' is not recognized.");
    }

    protected void normalizeEncoding(String string) {
        this.encoding = string.equals("winansi") || string.equals("") ? "Cp1252" : (string.equals("macroman") ? "MacRoman" : string);
    }

    protected void createEncoding() throws UnsupportedEncodingException {
        byte[] byArray = new byte[256];
        int n = 0;
        while (n < 256) {
            byArray[n] = (byte)n;
            ++n;
        }
        if (this.fontSpecific) {
            int n2 = 0;
            while (n2 < 256) {
                this.widths[n2] = this.getRawWidth(n2, null);
                ++n2;
            }
        } else {
            String string = new String(byArray, this.encoding);
            int n3 = 0;
            while (n3 < 256) {
                char c = string.charAt(n3);
                String string2 = GlyphList.unicodeToName(c);
                if (string2 == null) {
                    string2 = notdef;
                }
                this.differences[n3] = string2;
                this.widths[n3] = this.getRawWidth(c, string2);
                ++n3;
            }
        }
    }

    protected abstract int getRawWidth(int var1, String var2);

    public abstract int getKerning(char var1, char var2);

    public int getWidth(char c) {
        return this.getWidth(new String(new char[]{c}));
    }

    public int getWidth(String string) {
        int n = 0;
        try {
            byte[] byArray = string.getBytes(this.encoding);
            int n2 = 0;
            while (n2 < byArray.length) {
                n += this.widths[0xFF & byArray[n2]];
                ++n2;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return n;
    }

    public float getWidthPoint(String string, int n) {
        return (float)((double)this.getWidth(string) * 0.001 * (double)n);
    }

    byte[] convertToBytes(String string) throws UnsupportedEncodingException {
        return string.getBytes(this.encoding);
    }

    abstract PdfObject getFontInfo(PdfIndirectReference var1, int var2) throws DocumentException;

    static {
        BuiltinFonts14.put("Courier", PdfName.COURIER);
        BuiltinFonts14.put("Courier-Bold", PdfName.COURIER_BOLD);
        BuiltinFonts14.put("Courier-BoldOblique", PdfName.COURIER_BOLDOBLIQUE);
        BuiltinFonts14.put("Courier-Oblique", PdfName.COURIER_OBLIQUE);
        BuiltinFonts14.put("Helvetica", PdfName.HELVETICA);
        BuiltinFonts14.put("Helvetica-Bold", PdfName.HELVETICA_BOLD);
        BuiltinFonts14.put("Helvetica-BoldOblique", PdfName.HELVETICA_BOLDOBLIQUE);
        BuiltinFonts14.put("Helvetica-Oblique", PdfName.HELVETICA_OBLIQUE);
        BuiltinFonts14.put("Symbol", PdfName.SYMBOL);
        BuiltinFonts14.put("Times-Roman", PdfName.TIMES_ROMAN);
        BuiltinFonts14.put("Times-Bold", PdfName.TIMES_BOLD);
        BuiltinFonts14.put("Times-BoldItalic", PdfName.TIMES_BOLDITALIC);
        BuiltinFonts14.put("Times-Italic", PdfName.TIMES_ITALIC);
        BuiltinFonts14.put("ZapfDingbats", PdfName.ZAPFDINGBATS);
    }

    class StreamFont
    extends PdfStream {
        public StreamFont(byte[] byArray, int[] nArray) throws DocumentException {
            try {
                this.bytes = byArray;
                this.dictionary.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                int n = 0;
                while (n < nArray.length) {
                    this.dictionary.put(new PdfName("Length" + (n + 1)), new PdfNumber(nArray[n]));
                    ++n;
                }
                this.flateCompress();
            }
            catch (Exception exception) {
                throw new DocumentException(exception.getMessage());
            }
        }
    }
}

