/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Font;
import java.util.ArrayList;

public class Chunk
implements Element {
    private StringBuffer content;
    private Font font;

    public Chunk(String string, Font font) {
        this.content = new StringBuffer(string);
        this.font = font;
    }

    public Chunk(String string) {
        this(string, new Font());
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 10;
    }

    public ArrayList getChunks() {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        arrayList.add(this);
        return arrayList;
    }

    public StringBuffer append(String string) {
        return this.content.append(string);
    }

    public final Font font() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public final String content() {
        return this.content.toString();
    }

    public final boolean isEmpty() {
        String string = this.content.toString();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) != ' ') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<chunk");
        stringBuffer.append(this.font.toString());
        stringBuffer.append(">");
        stringBuffer.append("\t");
        stringBuffer.append(this.content());
        stringBuffer.append("\n</chunk>\n");
        return stringBuffer.toString();
    }
}

