/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.contentcapture;

import com.elluminate.mediastream.imageprocessing.CompressedTile;
import com.elluminate.mediastream.imageprocessing.ImageUtilities;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.zip.CRC32;

public class CaptureTile {
    private static CRC32 crc = new CRC32();
    private static int DEFAULT_FILL_COLOR = -1;
    private Point tileLoc;
    private Integer tileNumber;
    private byte[] tileData;
    private CompressedTile compressedTile = null;
    private Integer crcValue = null;
    private long tileTime = 0L;

    public CaptureTile(int x, int y, long tileTime) {
        this.tileNumber = new Integer(ImageUtilities.getTileNumberFromPixel((int)x, (int)y));
        this.tileLoc = ImageUtilities.getPixelFloorFromTileNumber((int)this.tileNumber);
        this.tileTime = tileTime;
        this.setTileData((int[])null);
    }

    public CaptureTile(CaptureTile tile, Integer tileNumber) {
        this.tileNumber = tileNumber;
        this.tileLoc = ImageUtilities.getPixelFloorFromTileNumber((int)tileNumber);
        this.tileData = tile.tileData;
        this.compressedTile = tile.compressedTile;
        this.crcValue = tile.crcValue;
        this.tileTime = tile.getTileTime();
    }

    public Point getLoc() {
        return this.tileLoc;
    }

    public Integer getTileNumber() {
        return this.tileNumber;
    }

    public long getTileTime() {
        return this.tileTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTileData(int[] tileData) {
        if (tileData != null) {
            this.tileData = new byte[tileData.length * 4];
            int j = 0;
            for (int i = 0; i < tileData.length; ++i) {
                this.tileData[j++] = (byte)(tileData[i] >> 24 & 0xFF);
                this.tileData[j++] = (byte)(tileData[i] >> 16 & 0xFF);
                this.tileData[j++] = (byte)(tileData[i] >> 8 & 0xFF);
                this.tileData[j++] = (byte)(tileData[i] & 0xFF);
            }
            CRC32 cRC32 = crc;
            synchronized (cRC32) {
                crc.update(this.tileData);
                this.crcValue = new Integer((int)crc.getValue());
                crc.reset();
            }
        } else {
            tileData = null;
            this.crcValue = null;
        }
        this.compressedTile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTileData(int[] imageData, int imageWidth, int imageHeight) throws IOException {
        this.tileData = new byte[1024];
        int lastX = Math.min(this.tileLoc.x + 16, imageWidth);
        int lastY = Math.min(this.tileLoc.y + 16, imageHeight);
        boolean pixelIndex = false;
        int pixelCount = 256;
        int alphaIndex = 0;
        int redIndex = alphaIndex + pixelCount;
        int greenIndex = redIndex + pixelCount;
        int blueIndex = greenIndex + pixelCount;
        for (int y = this.tileLoc.y; y < this.tileLoc.y + 16; ++y) {
            for (int x = this.tileLoc.x; x < this.tileLoc.x + 16; ++x) {
                int pixel = x < lastX && y < lastY ? imageData[x + y * imageWidth] : DEFAULT_FILL_COLOR;
                this.tileData[alphaIndex++] = (byte)(pixel >> 24 & 0xFF);
                this.tileData[redIndex++] = (byte)(pixel >> 16 & 0xFF);
                this.tileData[greenIndex++] = (byte)(pixel >> 8 & 0xFF);
                this.tileData[blueIndex++] = (byte)(pixel & 0xFF);
            }
        }
        CRC32 cRC32 = crc;
        synchronized (cRC32) {
            crc.update(this.tileData);
            this.crcValue = new Integer((int)crc.getValue());
            crc.reset();
        }
        this.compressedTile = null;
    }

    public void setTileData(BufferedImage image) {
        Point loc = ImageUtilities.getPixelFloorFromTileNumber((int)this.tileNumber);
        int width = Math.min(loc.x + 16, image.getWidth()) - loc.x;
        int height = Math.min(loc.y + 16, image.getHeight()) - loc.y;
        try {
            this.setTileData(image.getRGB(loc.x, loc.y, Math.min(width, 16), Math.min(height, 16), null, 0, 16));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.compressedTile = null;
    }

    public void setTileTime(long tileTime) {
        this.tileTime = tileTime;
    }

    public byte[] getCompressedTile() {
        if (this.compressedTile == null) {
            this.compressedTile = ImageUtilities.compressTileData((byte[])this.tileData);
            this.tileData = null;
        }
        return this.compressedTile.getCompressedTile();
    }

    public Integer getTileCRC() {
        return this.crcValue;
    }

    public Image getTileImage() {
        return ImageUtilities.getImageForTile((byte[])this.tileData);
    }

    public String toString() {
        return "Tile: CRC: " + this.crcValue + ", compressedTile: " + this.compressedTile + ", tileData: " + this.tileData + ", tileNumber: " + this.tileNumber + ", tileLoc: " + this.tileLoc;
    }
}

