/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream.imageprocessing;

import com.elluminate.mediastream.imageprocessing.CoeffsBuf;

public class VideoBlock {
    private static final int AC_COEFFS_CNT_SIZE = 6;
    private static final int AC_COEFFS_FMT_CODED_ABS = 0;
    private static final int AC_COEFFS_FMT_CODED_REL = 1;
    private static final int AC_COEFFS_FMT_PLAIN_ABS = 2;
    private static final int AC_COEFFS_FMT_SIZE = 2;
    private static final int AC_COEFFS_FMT_SUPPRESSED = 3;
    public static final int BLOCK_DIM = 8;
    private static final int BYTE_MASK = 255;
    private static final int BYTE_SIZE = 8;
    public static final int COARSE_RES = 0;
    public static final int COLOR = 1;
    private static final int ENCODING_TYPE_SIZE = 1;
    private static final int ENCODING_TYPE_Y = 1;
    private static final int ENCODING_TYPE_YUV = 0;
    public static final int FIDELITY_MASK = 1;
    public static final int FILTERED_COEFFS_BUFS_PER_BLOCK = 9;
    public static final int FINE_RES = 2;
    public static final int GRAYS = 0;
    private static final int GREEN8_SHIFT = 8;
    private static final int MAX_FREE_BYTE_WORKING_BUFS = 64;
    private static final int MAX_FREE_INT_WORKING_BUFS = 64;
    public static final int MEDIUM_RES = 1;
    private static final int RED8_SHIFT = 16;
    private static final int RES_CNT = 3;
    public static final int RES_SHIFT = 1;
    private static final int SIG_CHG = 8;
    private static final int U_PRESENT_MASK = 2;
    public static final int UNFILTERED_COEFFS_BUFS_PER_BLOCK = 6;
    public static final int USE_AVERAGE_FILTER = 2;
    public static final int USE_DELTA_FILTER = 1;
    public static final int USE_NO_FILTER = 0;
    private static final int UV_PRESENCE_SIZE = 2;
    private static final int V_PRESENT_MASK = 1;
    public static final int COEFFS_CNT = 64;
    private static final int AC_COEFFS_CNT = 63;
    public static final int COARSE_COLOR = 1;
    public static final int COARSE_GRAYS = 0;
    public static final int COLOR_ENCODING_MAX_LEN = 196;
    public static final int DEFAULT_MAX_FREE_VIDEO_BLOCKS = 1200;
    public static final int GRAYS_ENCODING_MAX_LEN = 66;
    public static final int FINE_COLOR = 5;
    public static final int FINE_GRAYS = 4;
    public static final int MEDIUM_COLOR = 3;
    public static final int MEDIUM_GRAYS = 2;
    private static final int HALF_8FB = 128;
    private static final int HALF_16FB = 32768;
    private static final int HALF_19FB = 262144;
    private static final int ONE_7FB = 128;
    private static final int ONE_8FB = 256;
    private static final int ONE_16FB = 65536;
    private static final double PI = Math.PI;
    private static final int C1_16FB;
    private static final int C3_16FB;
    private static final int R2_8FB;
    private static final int R2C6_16FB;
    private static final int R2S6_16FB;
    private static final int S1_16FB;
    private static final int S3_16FB;
    private static final int C1_8FB;
    private static final int C3_8FB;
    private static final int R2_7FB;
    private static final int R2C6_8FB;
    private static final int R2S6_8FB;
    private static final int S1_8FB;
    private static final int S3_8FB;
    private static final int C1_MINUS_S1_8FB;
    private static final int C1_MINUS_S1_16FB;
    private static final int C1_PLUS_S1_8FB;
    private static final int C1_PLUS_S1_16FB;
    private static final int C3_MINUS_S3_8FB;
    private static final int C3_MINUS_S3_16FB;
    private static final int C3_PLUS_S3_8FB;
    private static final int C3_PLUS_S3_16FB;
    private static final int R2C6_MINUS_R2S6_8FB;
    private static final int R2C6_MINUS_R2S6_16FB;
    private static final int R2C6_PLUS_R2S6_8FB;
    private static final int R2C6_PLUS_R2S6_16FB;
    private static final byte[][] CodeInverseTbl;
    private static final byte[] CodeLen;
    private static final byte[] CodePrefixLen;
    private static final byte[] CodePrefixType;
    private static final byte[] CodeSuffixLen;
    private static final short[] CodeTbl;
    private static int[] Map2x2To8x8UL;
    private static int[] Map4x4To8x8UL;
    private static int[] NominalYQuantizer;
    private static int[] UQuantizer;
    private static int[] VQuantizer;
    private static int[][] YQuantizer;
    private static int[] UQuantizerRecip_10FB;
    private static int[] VQuantizerRecip_10FB;
    private static int[][] YQuantizerRecip_10FB;
    private static int[] Zigzag;
    private static long importedBlkCnt;
    private static long receivedBlkCnt;
    private static long receivedCodedAbsACCoeffsCnt;
    private static long receivedCodedRelACCoeffsCnt;
    private static long receivedPlainAbsACCoeffsCnt;
    private static long receivedSuppressedACCoeffsCnt;
    private static long receivedUCoeffsCnt;
    private static long receivedUCoeffsCumSize;
    private static long receivedVCoeffsCnt;
    private static long receivedVCoeffsCumSize;
    private static long receivedYCoeffsCnt;
    private static long receivedYCoeffsCumSize;
    private static long sentBlkCnt;
    private static long sentCodedAbsACCoeffsCnt;
    private static long sentCodedRelACCoeffsCnt;
    private static long sentPlainAbsACCoeffsCnt;
    private static long sentSuppressedACCoeffsCnt;
    private static long sentUCoeffsCnt;
    private static long sentUCoeffsCumSize;
    private static long sentVCoeffsCnt;
    private static long sentVCoeffsCumSize;
    private static long sentYCoeffsCnt;
    private static long sentYCoeffsCumSize;
    private static int byteWorkingBufCreateCnt;
    private static int byteWorkingBufDiscardCnt;
    private static int byteWorkingBufFreeCnt;
    private static Object[] byteWorkingBufStack;
    private static int intWorkingBufCreateCnt;
    private static int intWorkingBufDiscardCnt;
    private static int intWorkingBufFreeCnt;
    private static Object[] intWorkingBufStack;
    private static int maxFreeVideoBlocks;
    public static int sigChg;
    private static int videoBlockCreateCnt;
    private static int videoBlockDiscardCnt;
    private static int videoBlockFreeCnt;
    private static VideoBlock[] videoBlockStack;
    private static Object videoBlockStackLock;
    private int desiredFidelity = 1;
    private CoeffsBuf prevBlu = null;
    private CoeffsBuf prevGrn = null;
    private CoeffsBuf prevRed = null;
    private boolean prevRGBValid = false;
    private CoeffsBuf prevUCoeffs = null;
    private CoeffsBuf prevVCoeffs = null;
    private CoeffsBuf prevYCoeffs = null;
    private boolean prevCoeffsValid = false;
    private int resolution = 0;
    private int trueFidelity = 1;
    private CoeffsBuf uCoeffs = null;
    private CoeffsBuf vCoeffs = null;
    private CoeffsBuf yCoeffs = null;

    private VideoBlock() {
    }

    public void clear() {
        if (this.yCoeffs != null) {
            this.yCoeffs.release();
            this.yCoeffs = null;
        }
        if (this.uCoeffs != null) {
            this.uCoeffs.release();
            this.uCoeffs = null;
        }
        if (this.vCoeffs != null) {
            this.vCoeffs.release();
            this.vCoeffs = null;
        }
        if (this.prevYCoeffs != null) {
            this.prevYCoeffs.release();
            this.prevYCoeffs = null;
        }
        if (this.prevUCoeffs != null) {
            this.prevUCoeffs.release();
            this.prevUCoeffs = null;
        }
        if (this.prevVCoeffs != null) {
            this.prevVCoeffs.release();
            this.prevVCoeffs = null;
        }
        this.prevCoeffsValid = false;
        if (this.prevRed != null) {
            this.prevRed.release();
            this.prevRed = null;
        }
        if (this.prevGrn != null) {
            this.prevGrn.release();
            this.prevGrn = null;
        }
        if (this.prevBlu != null) {
            this.prevBlu.release();
            this.prevBlu = null;
        }
        this.prevRGBValid = false;
        this.trueFidelity = this.desiredFidelity;
    }

    private static int decodeBytes(byte[] buf, int bufOff, byte[] values, int valuesOff, int valuesCnt) {
        int oldBufOff = bufOff;
        for (int i = 0; i < valuesCnt; ++i) {
            int prefix = VideoBlock.getBitField(buf, bufOff, 7);
            byte pl = CodePrefixLen[prefix];
            byte sl = CodeSuffixLen[prefix];
            int codeLen = pl + sl;
            int code = VideoBlock.getBitField(buf, bufOff, codeLen);
            byte pt = CodePrefixType[prefix];
            int suffix = code & (1 << sl) - 1;
            values[i + valuesOff] = CodeInverseTbl[pt][suffix];
            bufOff += codeLen;
        }
        return bufOff - oldBufOff;
    }

    private int decodeCoeffs(byte[] encodingBuf, int encodingOff, byte[] coeffs) {
        int oldEncodingOff = encodingOff;
        coeffs[0] = (byte)VideoBlock.getBitField(encodingBuf, encodingOff, 8);
        int encodingFmt = VideoBlock.getBitField(encodingBuf, encodingOff += 8, 2);
        encodingOff += 2;
        if (encodingFmt == 3) {
            ++receivedSuppressedACCoeffsCnt;
        } else {
            int acCoeffCnt = VideoBlock.getBitField(encodingBuf, encodingOff, 6);
            encodingOff += 6;
            if (encodingFmt == 0) {
                encodingOff += VideoBlock.decodeBytes(encodingBuf, encodingOff, coeffs, 1, acCoeffCnt);
                for (int i = acCoeffCnt + 1; i < 64; ++i) {
                    coeffs[i] = 0;
                }
                ++receivedCodedAbsACCoeffsCnt;
            } else if (encodingFmt == 1) {
                byte[] deltas = VideoBlock.getByteWorkingBuffer();
                encodingOff += VideoBlock.decodeBytes(encodingBuf, encodingOff, deltas, 1, acCoeffCnt);
                for (int i = 1; i <= acCoeffCnt; ++i) {
                    int n = i;
                    coeffs[n] = (byte)(coeffs[n] + deltas[i]);
                }
                VideoBlock.freeByteWorkingBuffer(deltas);
                ++receivedCodedRelACCoeffsCnt;
            } else if (encodingFmt == 2) {
                int i;
                for (i = 1; i <= acCoeffCnt; ++i) {
                    coeffs[i] = (byte)VideoBlock.getBitField(encodingBuf, encodingOff, 8);
                    encodingOff += 8;
                }
                for (i = acCoeffCnt + 1; i < 64; ++i) {
                    coeffs[i] = 0;
                }
                ++receivedPlainAbsACCoeffsCnt;
            }
        }
        return encodingOff - oldEncodingOff;
    }

    public void derivePixels(int[] rgb24Buf, int xOff, int yOff, int n, int fidelity, byte[] uCoeffs, byte[] vCoeffs, byte[] yCoeffs) {
        int[] yBuf = VideoBlock.getIntWorkingBuffer();
        VideoBlock.i8x8qdct(yCoeffs, YQuantizer[this.resolution], yBuf);
        if (fidelity == 0) {
            int resultRowOff = n * yOff + xOff;
            int sourceIdx = 0;
            for (int i = 0; i < 8; ++i) {
                int resultIdx = resultRowOff;
                resultRowOff += n;
                for (int j = 0; j < 8; ++j) {
                    int y;
                    if (((y = yBuf[sourceIdx++] + 128) & 0xFFFFFF00) != 0) {
                        y = ~y >> 31 & 0xFF;
                    }
                    rgb24Buf[resultIdx++] = (y << 16) + (y << 8) + y;
                }
            }
        } else {
            int[] uBuf = VideoBlock.getIntWorkingBuffer();
            VideoBlock.i8x8qdct(uCoeffs, UQuantizer, uBuf);
            int[] vBuf = VideoBlock.getIntWorkingBuffer();
            VideoBlock.i8x8qdct(vCoeffs, VQuantizer, vBuf);
            int resultRowOff = n * yOff + xOff;
            int sourceIdx = 0;
            for (int i = 0; i < 8; ++i) {
                int resultIdx = resultRowOff;
                resultRowOff += n;
                for (int j = 0; j < 8; ++j) {
                    int b;
                    int g;
                    int v;
                    int r;
                    int y = yBuf[sourceIdx] + 128;
                    int u = uBuf[sourceIdx];
                    int yTimes1024 = y << 10;
                    if (((r = yTimes1024 + 1167 * (v = vBuf[sourceIdx++]) + 512 >> 10) & 0xFFFFFF00) != 0) {
                        r = ~r >> 31 & 0xFF;
                    }
                    if (((g = yTimes1024 - 404 * u - 595 * v + 512 >> 10) & 0xFFFFFF00) != 0) {
                        g = ~g >> 31 & 0xFF;
                    }
                    if (((b = yTimes1024 + 2081 * u + 512 >> 10) & 0xFFFFFF00) != 0) {
                        b = ~b >> 31 & 0xFF;
                    }
                    rgb24Buf[resultIdx++] = (r << 16) + (g << 8) + b;
                }
            }
            VideoBlock.freeIntWorkingBuffer(uBuf);
            VideoBlock.freeIntWorkingBuffer(vBuf);
        }
        VideoBlock.freeIntWorkingBuffer(yBuf);
    }

    public void discardHistory() {
        if (this.prevYCoeffs != null) {
            this.prevYCoeffs.release();
            this.prevYCoeffs = null;
        }
        if (this.prevUCoeffs != null) {
            this.prevUCoeffs.release();
            this.prevUCoeffs = null;
        }
        if (this.prevVCoeffs != null) {
            this.prevVCoeffs.release();
            this.prevVCoeffs = null;
        }
        this.prevCoeffsValid = false;
        if (this.prevRed != null) {
            this.prevRed.release();
            this.prevRed = null;
        }
        if (this.prevGrn != null) {
            this.prevGrn.release();
            this.prevGrn = null;
        }
        if (this.prevBlu != null) {
            this.prevBlu.release();
            this.prevBlu = null;
        }
        this.prevRGBValid = false;
    }

    public void dispose() {
        if (this.yCoeffs != null) {
            this.yCoeffs.release();
            this.yCoeffs = null;
        }
        if (this.uCoeffs != null) {
            this.uCoeffs.release();
            this.uCoeffs = null;
        }
        if (this.vCoeffs != null) {
            this.vCoeffs.release();
            this.vCoeffs = null;
        }
        if (this.prevYCoeffs != null) {
            this.prevYCoeffs.release();
            this.prevYCoeffs = null;
        }
        if (this.prevUCoeffs != null) {
            this.prevUCoeffs.release();
            this.prevUCoeffs = null;
        }
        if (this.prevVCoeffs != null) {
            this.prevVCoeffs.release();
            this.prevVCoeffs = null;
        }
        if (this.prevRed != null) {
            this.prevRed.release();
            this.prevRed = null;
        }
        if (this.prevGrn != null) {
            this.prevGrn.release();
            this.prevGrn = null;
        }
        if (this.prevBlu != null) {
            this.prevBlu.release();
            this.prevBlu = null;
        }
        this.desiredFidelity = 1;
        this.prevCoeffsValid = false;
        this.prevRGBValid = false;
        this.resolution = 0;
        this.trueFidelity = 1;
    }

    private static int encodeBytes(byte[] buf, int bufOff, byte[] values, int valuesOff, int valuesCnt) {
        int oldBufOff = bufOff;
        for (int i = 0; i < valuesCnt; ++i) {
            int value = values[i + valuesOff] & 0xFF;
            short code = CodeTbl[value];
            byte codeLen = CodeLen[value];
            if (buf != null) {
                VideoBlock.putBitField(buf, bufOff, codeLen, code);
            }
            bufOff += codeLen;
        }
        return bufOff - oldBufOff;
    }

    private int encodeCoeffs(byte[] encodingBuf, int encodingOff, byte[] coeffs, byte[] prevCoeffs) {
        boolean disallowCodedRelFmt;
        byte[] deltas = VideoBlock.getByteWorkingBuffer();
        int leadingACCoeffCnt = 63;
        int oldEncodingOff = encodingOff;
        int lastChangedACCoeff = 0;
        if (prevCoeffs == null) {
            disallowCodedRelFmt = true;
            lastChangedACCoeff = 63;
        } else {
            disallowCodedRelFmt = false;
            for (int i = 1; i < 64; ++i) {
                byte delta = (byte)(coeffs[i] - prevCoeffs[i]);
                if (delta != 0) {
                    lastChangedACCoeff = i;
                }
                deltas[i] = delta;
                if (delta != -128) continue;
                disallowCodedRelFmt = true;
            }
        }
        int bestFmt = 3;
        if (lastChangedACCoeff > 0) {
            for (leadingACCoeffCnt = 63; leadingACCoeffCnt > 0 && coeffs[leadingACCoeffCnt] == 0; --leadingACCoeffCnt) {
            }
            int codedAbsFmtSize = VideoBlock.encodeBytes(null, 0, coeffs, 1, leadingACCoeffCnt);
            int codedRelFmtSize = disallowCodedRelFmt ? 512 : VideoBlock.encodeBytes(null, 0, deltas, 1, lastChangedACCoeff);
            int plainAbsFmtSize = leadingACCoeffCnt * 8;
            bestFmt = 2;
            int bestSize = plainAbsFmtSize;
            if (codedAbsFmtSize < bestSize) {
                bestFmt = 0;
                bestSize = codedAbsFmtSize;
            }
            if (codedRelFmtSize < bestSize && !disallowCodedRelFmt) {
                bestFmt = 1;
            }
        }
        VideoBlock.putBitField(encodingBuf, encodingOff, 8, coeffs[0]);
        VideoBlock.putBitField(encodingBuf, encodingOff += 8, 2, bestFmt);
        encodingOff += 2;
        if (bestFmt == 3) {
            ++sentSuppressedACCoeffsCnt;
        } else {
            VideoBlock.putBitField(encodingBuf, encodingOff, 6, bestFmt == 1 ? lastChangedACCoeff : leadingACCoeffCnt);
            encodingOff += 6;
            if (bestFmt == 0) {
                encodingOff += VideoBlock.encodeBytes(encodingBuf, encodingOff, coeffs, 1, leadingACCoeffCnt);
                ++sentCodedAbsACCoeffsCnt;
            } else if (bestFmt == 1) {
                encodingOff += VideoBlock.encodeBytes(encodingBuf, encodingOff, deltas, 1, lastChangedACCoeff);
                ++sentCodedRelACCoeffsCnt;
            } else if (bestFmt == 2) {
                for (int i = 0; i < leadingACCoeffCnt; ++i) {
                    VideoBlock.putBitField(encodingBuf, encodingOff, 8, coeffs[i + 1]);
                    encodingOff += 8;
                }
                ++sentPlainAbsACCoeffsCnt;
            }
        }
        VideoBlock.freeByteWorkingBuffer(deltas);
        return encodingOff - oldEncodingOff;
    }

    private static void f8x8qdct(int[] data, int[] quantizerRecip_10FB, byte[] result) {
        int u1;
        int xx;
        int u2;
        int u3;
        int u4;
        int u5;
        int u6;
        int u7;
        int t7;
        int t6;
        int t5;
        int t4;
        int t3;
        int t2;
        int t1;
        int t0;
        int dataIdx = 0;
        for (int row = 0; row < 8; ++row) {
            t0 = data[dataIdx++];
            t1 = data[dataIdx++];
            t2 = data[dataIdx++];
            t3 = data[dataIdx++];
            t4 = data[dataIdx++];
            t5 = data[dataIdx++];
            t6 = data[dataIdx++];
            t7 = data[dataIdx++];
            u7 = t0 - t7;
            u6 = t1 - t6;
            u5 = t2 - t5;
            u4 = t3 - t4;
            u3 = (t0 += t7) - (t3 += t4);
            t0 += t3;
            u2 = (t1 += t6) - (t2 += t5);
            t1 += t2;
            xx = C3_16FB * (u4 + u7);
            t4 = xx - C3_MINUS_S3_16FB * u7;
            t7 = xx - C3_PLUS_S3_16FB * u4;
            xx = C1_16FB * (u5 + u6);
            t5 = xx - C1_MINUS_S1_16FB * u6;
            t6 = xx - C1_PLUS_S1_16FB * u5;
            u1 = t0 - t1;
            t0 += t1;
            xx = R2C6_16FB * (u2 + u3);
            t2 = xx - R2C6_MINUS_R2S6_16FB * u3;
            t3 = xx - R2C6_PLUS_R2S6_16FB * u2;
            u6 = t4 - t6;
            u5 = t7 - t5;
            dataIdx -= 8;
            data[dataIdx++] = t0 << 8;
            data[dataIdx++] = (t7 += t5) + (t4 += t6) >> 8;
            data[dataIdx++] = t2 >> 8;
            data[dataIdx++] = (u5 >> 7) * R2_7FB >> 8;
            data[dataIdx++] = u1 << 8;
            data[dataIdx++] = (u6 >> 7) * R2_7FB >> 8;
            data[dataIdx++] = t3 >> 8;
            data[dataIdx++] = t7 - t4 >> 8;
        }
        for (int col = 0; col < 8; ++col) {
            dataIdx = col;
            t0 = data[dataIdx];
            t1 = data[dataIdx += 8];
            t2 = data[dataIdx += 8];
            t3 = data[dataIdx += 8];
            t4 = data[dataIdx += 8];
            t5 = data[dataIdx += 8];
            t6 = data[dataIdx += 8];
            t7 = data[dataIdx += 8];
            u7 = t0 - t7;
            u6 = t1 - t6;
            u5 = t2 - t5;
            u4 = t3 - t4;
            u3 = (t0 += t7) - (t3 += t4);
            t0 += t3;
            u2 = (t1 += t6) - (t2 += t5);
            t1 += t2;
            xx = C3_8FB * (u4 + u7);
            t4 = xx - C3_MINUS_S3_8FB * u7;
            t7 = xx - C3_PLUS_S3_8FB * u4;
            xx = C1_8FB * (u5 + u6);
            t5 = xx - C1_MINUS_S1_8FB * u6;
            t6 = xx - C1_PLUS_S1_8FB * u5;
            u1 = t0 - t1;
            t0 += t1;
            xx = R2C6_8FB * (u2 + u3);
            t2 = xx - R2C6_MINUS_R2S6_8FB * u3;
            t3 = xx - R2C6_PLUS_R2S6_8FB * u2;
            u6 = t4 - t6;
            u5 = t7 - t5;
            dataIdx = col;
            data[dataIdx] = t0 << 8;
            data[dataIdx += 8] = (t7 += t5) + (t4 += t6);
            data[dataIdx += 8] = t2;
            data[dataIdx += 8] = (u5 >> 7) * R2_7FB;
            data[dataIdx += 8] = u1 << 8;
            data[dataIdx += 8] = (u6 >> 7) * R2_7FB;
            data[dataIdx += 8] = t3;
            data[dataIdx += 8] = t7 - t4;
        }
        for (int i = 0; i < 64; ++i) {
            int r = (data[i] >> 13) * quantizerRecip_10FB[i] + 32768 >> 16;
            int clipper = -128 - r;
            r += clipper & ~(clipper >> 31);
            clipper = 127 - r;
            result[VideoBlock.Zigzag[i]] = (byte)(r += clipper & clipper >> 31);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void freeByteWorkingBuffer(byte[] buffer) {
        if (buffer.length != 64) {
            throw new IllegalArgumentException("Invalid buffer length: " + buffer.length);
        }
        Object[] objectArray = byteWorkingBufStack;
        synchronized (byteWorkingBufStack) {
            if (byteWorkingBufFreeCnt >= 64) {
                buffer = null;
                ++byteWorkingBufDiscardCnt;
            } else {
                VideoBlock.byteWorkingBufStack[VideoBlock.byteWorkingBufFreeCnt++] = buffer;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void freeIntWorkingBuffer(int[] buffer) {
        if (buffer.length != 64) {
            throw new IllegalArgumentException("Invalid buffer length: " + buffer.length);
        }
        Object[] objectArray = intWorkingBufStack;
        synchronized (intWorkingBufStack) {
            if (intWorkingBufFreeCnt >= 64) {
                buffer = null;
                ++intWorkingBufDiscardCnt;
            } else {
                VideoBlock.intWorkingBufStack[VideoBlock.intWorkingBufFreeCnt++] = buffer;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeVideoBlock(VideoBlock block) {
        block.dispose();
        Object object = videoBlockStackLock;
        synchronized (object) {
            if (videoBlockFreeCnt >= maxFreeVideoBlocks) {
                block = null;
                ++videoBlockDiscardCnt;
            } else {
                if (videoBlockStack == null) {
                    videoBlockStack = new VideoBlock[maxFreeVideoBlocks];
                }
                VideoBlock.videoBlockStack[VideoBlock.videoBlockFreeCnt++] = block;
            }
        }
    }

    public static int getBitField(byte[] buffer, int bitOff, int bitCnt) {
        if (bitCnt < 1 || bitCnt > 25) {
            throw new IllegalArgumentException("Invalid bitCnt: " + bitCnt);
        }
        if (bitOff < 0 || bitOff >= 8 * buffer.length) {
            throw new IllegalArgumentException("Invalid bitOff: " + bitOff);
        }
        int fieldLim = (bitOff + bitCnt + 7) / 8;
        int fieldOff = bitOff / 8;
        int fieldMask = (1 << bitCnt) - 1;
        int trailingJunkCnt = 8 * fieldLim - bitOff - bitCnt;
        int value = 0;
        for (int bufIdx = fieldOff; bufIdx < fieldLim; ++bufIdx) {
            value <<= 8;
            if (bufIdx >= buffer.length) continue;
            value |= buffer[bufIdx] & 0xFF;
        }
        value = value >> trailingJunkCnt & fieldMask;
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getByteWorkingBuffer() {
        Object[] objectArray = byteWorkingBufStack;
        synchronized (byteWorkingBufStack) {
            byte[] buffer;
            if (byteWorkingBufFreeCnt < 1) {
                buffer = new byte[64];
                ++byteWorkingBufCreateCnt;
            } else {
                buffer = (byte[])byteWorkingBufStack[--byteWorkingBufFreeCnt];
                VideoBlock.byteWorkingBufStack[VideoBlock.byteWorkingBufFreeCnt] = null;
            }
            // ** MonitorExit[var1] (shouldn't be in output)
            return buffer;
        }
    }

    public int getEncoding(byte[] encodingBuf, int encodingOff) {
        boolean yChanged;
        boolean vChanged;
        int i;
        boolean uChanged;
        int oldEncodingOff = encodingOff;
        if (this.yCoeffs == null) {
            this.yCoeffs = CoeffsBuf.get();
            VideoBlock.zeroArray(this.yCoeffs.buffer, 0, 64);
        }
        if (this.prevYCoeffs == null) {
            this.prevYCoeffs = CoeffsBuf.get();
            VideoBlock.zeroArray(this.prevYCoeffs.buffer, 0, 64);
        }
        if (this.trueFidelity == 1) {
            if (this.uCoeffs == null) {
                this.uCoeffs = CoeffsBuf.get();
                VideoBlock.zeroArray(this.uCoeffs.buffer, 0, 64);
                this.vCoeffs = CoeffsBuf.get();
                VideoBlock.zeroArray(this.vCoeffs.buffer, 0, 64);
            }
            if (this.prevUCoeffs == null) {
                this.prevUCoeffs = CoeffsBuf.get();
                VideoBlock.zeroArray(this.prevUCoeffs.buffer, 0, 64);
                this.prevVCoeffs = CoeffsBuf.get();
                VideoBlock.zeroArray(this.prevVCoeffs.buffer, 0, 64);
            }
        }
        if (this.trueFidelity == 0) {
            uChanged = false;
        } else if (!this.prevCoeffsValid) {
            uChanged = true;
        } else if (this.uCoeffs == this.prevUCoeffs) {
            uChanged = false;
        } else {
            uChanged = false;
            for (i = 0; i < 64; ++i) {
                if (this.uCoeffs.buffer[i] == this.prevUCoeffs.buffer[i]) continue;
                uChanged = true;
                break;
            }
        }
        if (this.trueFidelity == 0) {
            vChanged = false;
        } else if (!this.prevCoeffsValid) {
            vChanged = true;
        } else if (this.vCoeffs == this.prevVCoeffs) {
            vChanged = false;
        } else {
            vChanged = false;
            for (i = 0; i < 64; ++i) {
                if (this.vCoeffs.buffer[i] == this.prevVCoeffs.buffer[i]) continue;
                vChanged = true;
                break;
            }
        }
        if (!this.prevCoeffsValid) {
            yChanged = true;
        } else if (this.yCoeffs == this.prevYCoeffs) {
            yChanged = false;
        } else {
            yChanged = false;
            for (i = 0; i < 64; ++i) {
                if (this.yCoeffs.buffer[i] == this.prevYCoeffs.buffer[i]) continue;
                yChanged = true;
                break;
            }
        }
        if (yChanged || uChanged || vChanged) {
            if (uChanged || vChanged) {
                int typeAndPresence = 0;
                if (uChanged) {
                    typeAndPresence |= 2;
                }
                if (vChanged) {
                    typeAndPresence |= 1;
                }
                VideoBlock.putBitField(encodingBuf, encodingOff, 3, typeAndPresence);
                encodingOff += 3;
            } else {
                VideoBlock.putBitField(encodingBuf, encodingOff, 1, 1);
                ++encodingOff;
            }
            int size = this.encodeCoeffs(encodingBuf, encodingOff, this.yCoeffs.buffer, this.prevCoeffsValid ? this.prevYCoeffs.buffer : null);
            encodingOff += size;
            ++sentYCoeffsCnt;
            sentYCoeffsCumSize += (long)size;
            if (uChanged) {
                size = this.encodeCoeffs(encodingBuf, encodingOff, this.uCoeffs.buffer, this.prevCoeffsValid ? this.prevUCoeffs.buffer : null);
                encodingOff += size;
                ++sentUCoeffsCnt;
                sentUCoeffsCumSize += (long)size;
            }
            if (vChanged) {
                size = this.encodeCoeffs(encodingBuf, encodingOff, this.vCoeffs.buffer, this.prevCoeffsValid ? this.prevVCoeffs.buffer : null);
                encodingOff += size;
                ++sentVCoeffsCnt;
                sentVCoeffsCumSize += (long)size;
            }
            ++sentBlkCnt;
        }
        if (this.prevYCoeffs != null) {
            this.prevYCoeffs.release();
        }
        this.prevYCoeffs = this.yCoeffs.share();
        if (this.trueFidelity == 1) {
            if (this.prevUCoeffs != null) {
                this.prevUCoeffs.release();
            }
            this.prevUCoeffs = this.uCoeffs.share();
            if (this.prevVCoeffs != null) {
                this.prevVCoeffs.release();
            }
            this.prevVCoeffs = this.vCoeffs.share();
        }
        this.prevCoeffsValid = true;
        return encodingOff - oldEncodingOff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] getIntWorkingBuffer() {
        Object[] objectArray = intWorkingBufStack;
        synchronized (intWorkingBufStack) {
            int[] buffer;
            if (intWorkingBufFreeCnt < 1) {
                buffer = new int[64];
                ++intWorkingBufCreateCnt;
            } else {
                buffer = (int[])intWorkingBufStack[--intWorkingBufFreeCnt];
                VideoBlock.intWorkingBufStack[VideoBlock.intWorkingBufFreeCnt] = null;
            }
            // ** MonitorExit[var1] (shouldn't be in output)
            return buffer;
        }
    }

    public void getPixels(int[] rgb24Buf, int xOff, int yOff, int n) {
        if (this.yCoeffs == null) {
            this.yCoeffs = CoeffsBuf.get();
            VideoBlock.zeroArray(this.yCoeffs.buffer, 0, 64);
        }
        if (this.trueFidelity == 1 && this.uCoeffs == null) {
            this.uCoeffs = CoeffsBuf.get();
            VideoBlock.zeroArray(this.uCoeffs.buffer, 0, 64);
            this.vCoeffs = CoeffsBuf.get();
            VideoBlock.zeroArray(this.vCoeffs.buffer, 0, 64);
        }
        if (this.trueFidelity == 1) {
            this.derivePixels(rgb24Buf, xOff, yOff, n, this.trueFidelity, this.uCoeffs.buffer, this.vCoeffs.buffer, this.yCoeffs.buffer);
        } else {
            this.derivePixels(rgb24Buf, xOff, yOff, n, this.trueFidelity, null, null, this.yCoeffs.buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VideoBlock getVideoBlock() {
        VideoBlock block;
        Object object = videoBlockStackLock;
        synchronized (object) {
            if (videoBlockFreeCnt < 1) {
                block = new VideoBlock();
                ++videoBlockCreateCnt;
            } else {
                block = videoBlockStack[--videoBlockFreeCnt];
                VideoBlock.videoBlockStack[VideoBlock.videoBlockFreeCnt] = null;
            }
        }
        return block;
    }

    private static void i2x2dct(int[] data) {
        int t1;
        int t0;
        int dataIdx = 0;
        for (int row = 0; row < 2; ++row) {
            t0 = data[dataIdx++];
            t1 = data[dataIdx++];
            dataIdx -= 2;
            data[dataIdx++] = t0 + t1;
            data[dataIdx++] = t0 - t1;
        }
        for (int col = 0; col < 2; ++col) {
            dataIdx = col;
            t0 = data[dataIdx];
            t1 = data[dataIdx += 2];
            dataIdx = col;
            data[dataIdx] = t0 + t1 + 4 >> 3;
            data[dataIdx += 2] = t0 - t1 + 4 >> 3;
        }
    }

    private static void i4x4dct(int[] data) {
        int u3;
        int u2;
        int u1;
        int u0;
        int t3;
        int t1;
        int t2;
        int t0;
        int r2c3_8FB = 139;
        int r2c3_16FB = 35468;
        int r2s3_8FB = 334;
        int r2s3_16FB = 85627;
        int dataIdx = 0;
        for (int row = 0; row < 4; ++row) {
            t0 = data[dataIdx++];
            t2 = data[dataIdx++];
            t1 = data[dataIdx++];
            t3 = data[dataIdx++];
            u0 = t0 + t1 << 16;
            u1 = t0 - t1 << 16;
            u2 = 35468 * t2 - 85627 * t3;
            u3 = 35468 * t3 + 85627 * t2;
            dataIdx -= 4;
            data[dataIdx++] = u0 + u3;
            data[dataIdx++] = u1 + u2;
            data[dataIdx++] = u1 - u2;
            data[dataIdx++] = u0 - u3;
        }
        for (int col = 0; col < 4; ++col) {
            dataIdx = col;
            t0 = data[dataIdx];
            t2 = data[dataIdx += 4] >> 8;
            t1 = data[dataIdx += 4];
            t3 = data[dataIdx += 4] >> 8;
            u0 = t0 + t1;
            u1 = t0 - t1;
            u2 = 139 * t2 - 334 * t3;
            u3 = 139 * t3 + 334 * t2;
            dataIdx = col;
            data[dataIdx] = u0 + u3 + 262144 >> 19;
            data[dataIdx += 4] = u1 + u2 + 262144 >> 19;
            data[dataIdx += 4] = u1 - u2 + 262144 >> 19;
            data[dataIdx += 4] = u0 - u3 + 262144 >> 19;
        }
    }

    private static void i8x8qdct(byte[] data, int[] quantizer, int[] result) {
        int u3;
        int u5;
        int u6;
        int u2;
        int xx;
        int u1;
        int u4;
        int t4;
        int t3;
        int t6;
        int t1;
        int t5;
        int t2;
        int t7;
        int t0;
        for (int i = 0; i < 64; ++i) {
            result[i] = data[Zigzag[i]] * quantizer[i];
        }
        int resultIdx = 0;
        for (int row = 0; row < 8; ++row) {
            t0 = result[resultIdx++];
            t7 = result[resultIdx++];
            t2 = result[resultIdx++];
            t5 = result[resultIdx++];
            t1 = result[resultIdx++];
            t6 = result[resultIdx++];
            if ((t0 | t1 | t2 | (t3 = result[resultIdx++]) | (t4 = result[resultIdx++]) | t5 | t6 | t7) == 0) continue;
            u4 = t7 - t4 << 8;
            t7 = t7 + t4 << 8;
            t5 = R2_8FB * t5;
            t6 = R2_8FB * t6;
            u1 = t0 - t1 << 16;
            t0 = t0 + t1 << 16;
            xx = R2C6_16FB * (t2 + t3);
            u2 = xx - R2C6_PLUS_R2S6_16FB * t3;
            t3 = xx - R2C6_MINUS_R2S6_16FB * t2;
            u6 = u4 - t6;
            u4 += t6;
            u5 = t7 - t5;
            u3 = t0 - t3;
            t0 += t3;
            t2 = u1 - u2;
            u1 += u2;
            xx = C3_8FB * (u4 + (t7 += t5));
            t4 = xx - C3_PLUS_S3_8FB * t7;
            t7 = xx - C3_MINUS_S3_8FB * u4;
            xx = C1_8FB * (u5 + u6);
            t5 = xx - C1_PLUS_S1_8FB * u6;
            t6 = xx - C1_MINUS_S1_8FB * u5;
            resultIdx -= 8;
            result[resultIdx++] = t0 + t7;
            result[resultIdx++] = u1 + t6;
            result[resultIdx++] = t2 + t5;
            result[resultIdx++] = u3 + t4;
            result[resultIdx++] = u3 - t4;
            result[resultIdx++] = t2 - t5;
            result[resultIdx++] = u1 - t6;
            result[resultIdx++] = t0 - t7;
        }
        for (int col = 0; col < 8; ++col) {
            resultIdx = col;
            t0 = result[resultIdx];
            t7 = result[resultIdx += 8] >> 8;
            t2 = result[resultIdx += 8] >> 8;
            t5 = result[resultIdx += 8] >> 8;
            t1 = result[resultIdx += 8];
            t6 = result[resultIdx += 8] >> 8;
            t3 = result[resultIdx += 8] >> 8;
            t4 = result[resultIdx += 8] >> 8;
            u4 = t7 - t4;
            t7 += t4;
            t5 = R2_8FB * t5 >> 8;
            t6 = R2_8FB * t6 >> 8;
            u1 = t0 - t1;
            t0 += t1;
            xx = R2C6_8FB * (t2 + t3);
            u2 = xx - R2C6_PLUS_R2S6_8FB * t3;
            t3 = xx - R2C6_MINUS_R2S6_8FB * t2;
            u6 = u4 - t6;
            u4 += t6;
            u5 = t7 - t5;
            u3 = t0 - t3;
            t0 += t3;
            t2 = u1 - u2;
            u1 += u2;
            xx = C3_8FB * (u4 + (t7 += t5));
            t4 = xx - C3_PLUS_S3_8FB * t7;
            t7 = xx - C3_MINUS_S3_8FB * u4;
            xx = C1_8FB * (u5 + u6);
            t5 = xx - C1_PLUS_S1_8FB * u6;
            t6 = xx - C1_MINUS_S1_8FB * u5;
            resultIdx = col;
            result[resultIdx] = t0 + t7 + 262144 >> 19;
            result[resultIdx += 8] = u1 + t6 + 262144 >> 19;
            result[resultIdx += 8] = t2 + t5 + 262144 >> 19;
            result[resultIdx += 8] = u3 + t4 + 262144 >> 19;
            result[resultIdx += 8] = u3 - t4 + 262144 >> 19;
            result[resultIdx += 8] = t2 - t5 + 262144 >> 19;
            result[resultIdx += 8] = u1 - t6 + 262144 >> 19;
            result[resultIdx += 8] = t0 - t7 + 262144 >> 19;
        }
    }

    public void importPixels(VideoBlock source, boolean replace) {
        boolean isColor;
        boolean bl = isColor = this.desiredFidelity == 1 && source.trueFidelity == 1;
        if (this.yCoeffs != null) {
            this.yCoeffs.release();
        }
        this.yCoeffs = source.yCoeffs.share();
        if (isColor) {
            if (this.uCoeffs != null) {
                this.uCoeffs.release();
            }
            this.uCoeffs = source.uCoeffs.share();
            if (this.vCoeffs != null) {
                this.vCoeffs.release();
            }
            this.vCoeffs = source.vCoeffs.share();
        }
        if (replace) {
            if (this.prevYCoeffs != null) {
                this.prevYCoeffs.release();
            }
            this.prevYCoeffs = this.yCoeffs.share();
            if (isColor) {
                if (this.prevUCoeffs != null) {
                    this.prevUCoeffs.release();
                }
                this.prevUCoeffs = this.uCoeffs.share();
                if (this.prevVCoeffs != null) {
                    this.prevVCoeffs.release();
                }
                this.prevVCoeffs = this.vCoeffs.share();
            }
            this.prevCoeffsValid = true;
        }
        this.trueFidelity = isColor ? 1 : 0;
        ++importedBlkCnt;
        this.prevRGBValid = false;
    }

    public void importPixelsReducing4To1(VideoBlock[] sources, boolean replace) {
        boolean isColor = this.desiredFidelity == 1 && sources[0].trueFidelity == 1;
        int srcIdx = 0;
        int[] u16Buf = VideoBlock.getIntWorkingBuffer();
        int[] u64Buf = VideoBlock.getIntWorkingBuffer();
        int[] v16Buf = VideoBlock.getIntWorkingBuffer();
        int[] v64Buf = VideoBlock.getIntWorkingBuffer();
        int[] y16Buf = VideoBlock.getIntWorkingBuffer();
        int[] y64Buf = VideoBlock.getIntWorkingBuffer();
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 2; ++col) {
                VideoBlock src;
                if ((src = sources[srcIdx++]) == null) {
                    VideoBlock.zeroArray(y16Buf, 0, 16);
                    VideoBlock.zeroArray(u16Buf, 0, 16);
                    VideoBlock.zeroArray(v16Buf, 0, 16);
                } else {
                    int j;
                    int i;
                    if (src.yCoeffs == null) {
                        VideoBlock.zeroArray(y16Buf, 0, 16);
                    } else {
                        for (i = 0; i < 16; ++i) {
                            j = Map4x4To8x8UL[i];
                            y16Buf[i] = src.yCoeffs.buffer[Zigzag[j]] * YQuantizer[src.resolution][j];
                        }
                        VideoBlock.i4x4dct(y16Buf);
                    }
                    if (isColor) {
                        if (src.uCoeffs == null) {
                            VideoBlock.zeroArray(u16Buf, 0, 16);
                        } else {
                            for (i = 0; i < 16; ++i) {
                                j = Map4x4To8x8UL[i];
                                u16Buf[i] = src.uCoeffs.buffer[Zigzag[j]] * UQuantizer[j];
                            }
                            VideoBlock.i4x4dct(u16Buf);
                        }
                        if (src.vCoeffs == null) {
                            VideoBlock.zeroArray(v16Buf, 0, 16);
                        } else {
                            for (i = 0; i < 16; ++i) {
                                j = Map4x4To8x8UL[i];
                                v16Buf[i] = src.vCoeffs.buffer[Zigzag[j]] * VQuantizer[j];
                            }
                            VideoBlock.i4x4dct(v16Buf);
                        }
                    }
                }
                int resultRowOff = (row << 3) + col << 2;
                int sourceIdx = 0;
                for (int r = 0; r < 4; ++r) {
                    int resultIdx = resultRowOff;
                    resultRowOff += 8;
                    for (int c = 0; c < 4; ++c) {
                        if (isColor) {
                            u64Buf[resultIdx] = u16Buf[sourceIdx];
                            v64Buf[resultIdx] = v16Buf[sourceIdx];
                        }
                        y64Buf[resultIdx++] = y16Buf[sourceIdx++];
                    }
                }
            }
        }
        VideoBlock.freeIntWorkingBuffer(u16Buf);
        VideoBlock.freeIntWorkingBuffer(v16Buf);
        VideoBlock.freeIntWorkingBuffer(y16Buf);
        this.yCoeffs = this.yCoeffs == null ? CoeffsBuf.get() : this.yCoeffs.unshare();
        VideoBlock.f8x8qdct(y64Buf, YQuantizerRecip_10FB[this.resolution], this.yCoeffs.buffer);
        if (isColor) {
            this.uCoeffs = this.uCoeffs == null ? CoeffsBuf.get() : this.uCoeffs.unshare();
            this.vCoeffs = this.vCoeffs == null ? CoeffsBuf.get() : this.vCoeffs.unshare();
            VideoBlock.f8x8qdct(u64Buf, UQuantizerRecip_10FB, this.uCoeffs.buffer);
            VideoBlock.f8x8qdct(v64Buf, VQuantizerRecip_10FB, this.vCoeffs.buffer);
        }
        VideoBlock.freeIntWorkingBuffer(u64Buf);
        VideoBlock.freeIntWorkingBuffer(v64Buf);
        VideoBlock.freeIntWorkingBuffer(y64Buf);
        if (replace) {
            if (this.prevYCoeffs != null) {
                this.prevYCoeffs.release();
            }
            this.prevYCoeffs = this.yCoeffs.share();
            if (isColor) {
                if (this.prevUCoeffs != null) {
                    this.prevUCoeffs.release();
                }
                this.prevUCoeffs = this.uCoeffs.share();
                if (this.prevVCoeffs != null) {
                    this.prevVCoeffs.release();
                }
                this.prevVCoeffs = this.vCoeffs.share();
            }
            this.prevCoeffsValid = true;
        }
        this.trueFidelity = isColor ? 1 : 0;
        ++importedBlkCnt;
        this.prevRGBValid = false;
    }

    public void importPixelsReducing16To1(VideoBlock[] sources, boolean replace) {
        boolean isColor = this.desiredFidelity == 1 && sources[0].trueFidelity == 1;
        int srcIdx = 0;
        int[] u4Buf = VideoBlock.getIntWorkingBuffer();
        int[] u64Buf = VideoBlock.getIntWorkingBuffer();
        int[] v4Buf = VideoBlock.getIntWorkingBuffer();
        int[] v64Buf = VideoBlock.getIntWorkingBuffer();
        int[] y4Buf = VideoBlock.getIntWorkingBuffer();
        int[] y64Buf = VideoBlock.getIntWorkingBuffer();
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 4; ++col) {
                VideoBlock src;
                if ((src = sources[srcIdx++]) == null) {
                    VideoBlock.zeroArray(y4Buf, 0, 4);
                    VideoBlock.zeroArray(u4Buf, 0, 4);
                    VideoBlock.zeroArray(v4Buf, 0, 4);
                } else {
                    int j;
                    int i;
                    if (src.yCoeffs == null) {
                        VideoBlock.zeroArray(y4Buf, 0, 4);
                    } else {
                        for (i = 0; i < 4; ++i) {
                            j = Map2x2To8x8UL[i];
                            y4Buf[i] = src.yCoeffs.buffer[Zigzag[j]] * YQuantizer[src.resolution][j];
                        }
                        VideoBlock.i2x2dct(y4Buf);
                    }
                    if (isColor) {
                        if (src.uCoeffs == null) {
                            VideoBlock.zeroArray(u4Buf, 0, 4);
                            VideoBlock.zeroArray(v4Buf, 0, 4);
                        } else {
                            for (i = 0; i < 4; ++i) {
                                j = Map2x2To8x8UL[i];
                                u4Buf[i] = src.uCoeffs.buffer[Zigzag[j]] * UQuantizer[j];
                                v4Buf[i] = src.vCoeffs.buffer[Zigzag[j]] * VQuantizer[j];
                            }
                            VideoBlock.i2x2dct(u4Buf);
                            VideoBlock.i2x2dct(v4Buf);
                        }
                    }
                }
                int resultRowOff = (row << 3) + col << 1;
                int sourceIdx = 0;
                for (int r = 0; r < 2; ++r) {
                    int resultIdx = resultRowOff;
                    resultRowOff += 8;
                    for (int c = 0; c < 2; ++c) {
                        if (isColor) {
                            u64Buf[resultIdx] = u4Buf[sourceIdx];
                            v64Buf[resultIdx] = v4Buf[sourceIdx];
                        }
                        y64Buf[resultIdx++] = y4Buf[sourceIdx++];
                    }
                }
            }
        }
        VideoBlock.freeIntWorkingBuffer(u4Buf);
        VideoBlock.freeIntWorkingBuffer(v4Buf);
        VideoBlock.freeIntWorkingBuffer(y4Buf);
        this.yCoeffs = this.yCoeffs == null ? CoeffsBuf.get() : this.yCoeffs.unshare();
        VideoBlock.f8x8qdct(y64Buf, YQuantizerRecip_10FB[this.resolution], this.yCoeffs.buffer);
        if (isColor) {
            this.uCoeffs = this.uCoeffs == null ? CoeffsBuf.get() : this.uCoeffs.unshare();
            this.vCoeffs = this.vCoeffs == null ? CoeffsBuf.get() : this.vCoeffs.unshare();
            VideoBlock.f8x8qdct(u64Buf, UQuantizerRecip_10FB, this.uCoeffs.buffer);
            VideoBlock.f8x8qdct(v64Buf, VQuantizerRecip_10FB, this.vCoeffs.buffer);
        }
        VideoBlock.freeIntWorkingBuffer(u64Buf);
        VideoBlock.freeIntWorkingBuffer(v64Buf);
        VideoBlock.freeIntWorkingBuffer(y64Buf);
        if (replace) {
            if (this.prevYCoeffs != null) {
                this.prevYCoeffs.release();
            }
            this.prevYCoeffs = this.yCoeffs.share();
            if (isColor) {
                if (this.prevUCoeffs != null) {
                    this.prevUCoeffs.release();
                }
                this.prevUCoeffs = this.uCoeffs.share();
                if (this.prevVCoeffs != null) {
                    this.prevVCoeffs.release();
                }
                this.prevVCoeffs = this.vCoeffs.share();
            }
            this.prevCoeffsValid = true;
        }
        this.trueFidelity = isColor ? 1 : 0;
        ++importedBlkCnt;
        this.prevRGBValid = false;
    }

    public static void logStatistics() {
        double pct;
        if (importedBlkCnt > 0L) {
            importedBlkCnt = 0L;
        }
        if (receivedBlkCnt > 0L) {
            long receivedCoeffsCnt = receivedCodedAbsACCoeffsCnt + receivedCodedRelACCoeffsCnt + receivedPlainAbsACCoeffsCnt + receivedSuppressedACCoeffsCnt;
            if (receivedCodedAbsACCoeffsCnt > 0L) {
                pct = (double)((int)(1000.0 * (double)receivedCodedAbsACCoeffsCnt / (double)receivedCoeffsCnt + 0.5)) / 10.0;
            }
            if (receivedCodedRelACCoeffsCnt > 0L) {
                pct = (double)((int)(1000.0 * (double)receivedCodedRelACCoeffsCnt / (double)receivedCoeffsCnt + 0.5)) / 10.0;
            }
            if (receivedPlainAbsACCoeffsCnt > 0L) {
                pct = (double)((int)(1000.0 * (double)receivedPlainAbsACCoeffsCnt / (double)receivedCoeffsCnt + 0.5)) / 10.0;
            }
            if (receivedSuppressedACCoeffsCnt > 0L) {
                pct = (double)((int)(1000.0 * (double)receivedSuppressedACCoeffsCnt / (double)receivedCoeffsCnt + 0.5)) / 10.0;
            }
            if (receivedUCoeffsCnt > 0L) {
                pct = (double)((int)(1000.0 * (double)receivedUCoeffsCnt / (double)receivedBlkCnt + 0.5)) / 10.0;
            }
            if (receivedVCoeffsCnt > 0L) {
                pct = (double)((int)(1000.0 * (double)receivedVCoeffsCnt / (double)receivedBlkCnt + 0.5)) / 10.0;
            }
            if (receivedYCoeffsCnt > 0L) {
                pct = (double)((int)(1000.0 * (double)receivedYCoeffsCnt / (double)receivedBlkCnt + 0.5)) / 10.0;
            }
            receivedBlkCnt = 0L;
            receivedCodedAbsACCoeffsCnt = 0L;
            receivedCodedRelACCoeffsCnt = 0L;
            receivedPlainAbsACCoeffsCnt = 0L;
            receivedSuppressedACCoeffsCnt = 0L;
            receivedUCoeffsCnt = 0L;
            receivedVCoeffsCnt = 0L;
            receivedYCoeffsCnt = 0L;
        }
        if (sentBlkCnt > 0L) {
            long sentCoeffsCnt = sentCodedAbsACCoeffsCnt + sentCodedRelACCoeffsCnt + sentPlainAbsACCoeffsCnt + sentSuppressedACCoeffsCnt;
            if (sentCodedAbsACCoeffsCnt > 0L) {
                pct = (double)((int)(1000.0 * (double)sentCodedAbsACCoeffsCnt / (double)sentCoeffsCnt + 0.5)) / 10.0;
            }
            if (sentCodedRelACCoeffsCnt > 0L) {
                pct = (double)((int)(1000.0 * (double)sentCodedRelACCoeffsCnt / (double)sentCoeffsCnt + 0.5)) / 10.0;
            }
            if (sentPlainAbsACCoeffsCnt > 0L) {
                pct = (double)((int)(1000.0 * (double)sentPlainAbsACCoeffsCnt / (double)sentCoeffsCnt + 0.5)) / 10.0;
            }
            if (sentSuppressedACCoeffsCnt > 0L) {
                pct = (double)((int)(1000.0 * (double)sentSuppressedACCoeffsCnt / (double)sentCoeffsCnt + 0.5)) / 10.0;
            }
            if (sentUCoeffsCnt > 0L) {
                pct = (double)((int)(1000.0 * (double)sentUCoeffsCnt / (double)sentBlkCnt + 0.5)) / 10.0;
            }
            if (sentVCoeffsCnt > 0L) {
                pct = (double)((int)(1000.0 * (double)sentVCoeffsCnt / (double)sentBlkCnt + 0.5)) / 10.0;
            }
            if (sentYCoeffsCnt > 0L) {
                double d = (double)((int)(1000.0 * (double)sentYCoeffsCnt / (double)sentBlkCnt + 0.5)) / 10.0;
            }
            sentBlkCnt = 0L;
            sentCodedAbsACCoeffsCnt = 0L;
            sentCodedRelACCoeffsCnt = 0L;
            sentPlainAbsACCoeffsCnt = 0L;
            sentSuppressedACCoeffsCnt = 0L;
            sentUCoeffsCnt = 0L;
            sentVCoeffsCnt = 0L;
            sentYCoeffsCnt = 0L;
        }
    }

    public void previewPixels(int[] rgb24Buf, int xOff, int yOff, int n, int fidelity, int filterType) {
        byte[] uCoeffs = VideoBlock.getByteWorkingBuffer();
        byte[] vCoeffs = VideoBlock.getByteWorkingBuffer();
        byte[] yCoeffs = VideoBlock.getByteWorkingBuffer();
        this.transformPixels(rgb24Buf, xOff, yOff, n, fidelity, uCoeffs, vCoeffs, yCoeffs, filterType);
        this.derivePixels(rgb24Buf, xOff, yOff, n, fidelity, uCoeffs, vCoeffs, yCoeffs);
        VideoBlock.freeByteWorkingBuffer(uCoeffs);
        VideoBlock.freeByteWorkingBuffer(vCoeffs);
        VideoBlock.freeByteWorkingBuffer(yCoeffs);
    }

    public static void putBitField(byte[] buffer, int bitOff, int bitCnt, int value) {
        if (bitCnt < 1 || bitCnt > 25) {
            throw new IllegalArgumentException("Invalid bitCnt: " + bitCnt);
        }
        if (bitOff < 0 || bitOff + bitCnt > 8 * buffer.length) {
            throw new IllegalArgumentException("Invalid bitOff: " + bitOff);
        }
        int fieldLim = (bitOff + bitCnt + 7) / 8;
        int fieldMask = (1 << bitCnt) - 1;
        int fieldOff = bitOff / 8;
        int leadingJunkCnt = bitOff % 8;
        int trailingJunkCnt = 8 * fieldLim - bitOff - bitCnt;
        value = (value & fieldMask) << trailingJunkCnt;
        fieldMask <<= trailingJunkCnt;
        switch (fieldLim - fieldOff) {
            case 1: {
                buffer[fieldOff] = (byte)(buffer[fieldOff] & ~fieldMask | value);
                break;
            }
            case 2: {
                buffer[fieldOff] = (byte)(buffer[fieldOff] & ~(fieldMask >> 8) | value >> 8);
                buffer[fieldOff + 1] = (byte)(buffer[fieldOff + 1] & ~fieldMask | value);
                break;
            }
            case 3: {
                buffer[fieldOff] = (byte)(buffer[fieldOff] & ~(fieldMask >> 16) | value >> 16);
                buffer[fieldOff + 1] = (byte)(value >> 8);
                buffer[fieldOff + 2] = (byte)(buffer[fieldOff + 2] & ~fieldMask | value);
                break;
            }
            case 4: {
                buffer[fieldOff] = (byte)(buffer[fieldOff] & ~(fieldMask >> 24) | value >> 24);
                buffer[fieldOff + 1] = (byte)(value >> 16);
                buffer[fieldOff + 2] = (byte)(value >> 8);
                buffer[fieldOff + 3] = (byte)(buffer[fieldOff + 3] & ~fieldMask | value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid bitCnt: " + bitCnt);
            }
        }
    }

    public int putEncoding(byte[] encodingBuf, int encodingOff) {
        boolean vChanged;
        boolean uChanged;
        int oldEncodingOff = encodingOff;
        int encodingType = VideoBlock.getBitField(encodingBuf, encodingOff, 1);
        ++encodingOff;
        if (encodingType == 1) {
            uChanged = false;
            vChanged = false;
        } else {
            int uvPresenceCode = VideoBlock.getBitField(encodingBuf, encodingOff, 2);
            encodingOff += 2;
            uChanged = (uvPresenceCode & 2) != 0;
            boolean bl = vChanged = (uvPresenceCode & 1) != 0;
        }
        if (this.yCoeffs == null) {
            this.yCoeffs = CoeffsBuf.get();
            VideoBlock.zeroArray(this.yCoeffs.buffer, 0, 64);
        } else {
            this.yCoeffs = this.yCoeffs.unshare();
        }
        int size = this.decodeCoeffs(encodingBuf, encodingOff, this.yCoeffs.buffer);
        encodingOff += size;
        ++receivedYCoeffsCnt;
        receivedYCoeffsCumSize += (long)size;
        if (uChanged) {
            if (this.uCoeffs == null) {
                this.uCoeffs = CoeffsBuf.get();
                VideoBlock.zeroArray(this.uCoeffs.buffer, 0, 64);
            } else {
                this.uCoeffs = this.uCoeffs.unshare();
            }
            size = this.decodeCoeffs(encodingBuf, encodingOff, this.uCoeffs.buffer);
            encodingOff += size;
            ++receivedUCoeffsCnt;
            receivedUCoeffsCumSize += (long)size;
        }
        if (vChanged) {
            if (this.vCoeffs == null) {
                this.vCoeffs = CoeffsBuf.get();
                VideoBlock.zeroArray(this.vCoeffs.buffer, 0, 64);
            } else {
                this.vCoeffs = this.vCoeffs.unshare();
            }
            size = this.decodeCoeffs(encodingBuf, encodingOff, this.vCoeffs.buffer);
            encodingOff += size;
            ++receivedVCoeffsCnt;
            receivedVCoeffsCumSize += (long)size;
        }
        this.prevRGBValid = false;
        ++receivedBlkCnt;
        return encodingOff - oldEncodingOff;
    }

    public void putPixels(int[] rgb24Buf, int xOff, int yOff, int n, int filterType) {
        this.yCoeffs = this.yCoeffs == null ? CoeffsBuf.get() : this.yCoeffs.unshare();
        if (this.desiredFidelity == 1) {
            this.uCoeffs = this.uCoeffs == null ? CoeffsBuf.get() : this.uCoeffs.unshare();
            this.vCoeffs = this.vCoeffs == null ? CoeffsBuf.get() : this.vCoeffs.unshare();
        }
        if (this.desiredFidelity == 1) {
            this.transformPixels(rgb24Buf, xOff, yOff, n, this.desiredFidelity, this.uCoeffs.buffer, this.vCoeffs.buffer, this.yCoeffs.buffer, filterType);
        } else {
            this.transformPixels(rgb24Buf, xOff, yOff, n, this.desiredFidelity, null, null, this.yCoeffs.buffer, filterType);
        }
        this.trueFidelity = this.desiredFidelity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMaxFreeVideoBlocks(int count) {
        Object object = videoBlockStackLock;
        synchronized (object) {
            if (videoBlockStack != null && videoBlockStack.length != count) {
                VideoBlock[] newStack = new VideoBlock[count];
                int oldStackLen = videoBlockStack.length;
                if (videoBlockFreeCnt <= count) {
                    System.arraycopy(videoBlockStack, 0, newStack, 0, videoBlockFreeCnt);
                } else {
                    System.arraycopy(videoBlockStack, 0, newStack, 0, count);
                    for (int i = count; i < videoBlockFreeCnt; ++i) {
                        VideoBlock.videoBlockStack[i] = null;
                    }
                    videoBlockFreeCnt = count;
                }
                videoBlockStack = newStack;
            }
            maxFreeVideoBlocks = count;
        }
    }

    public void setQuality(int quality) {
        switch (quality) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid quality: " + quality);
            }
        }
        int newFidelity = quality & 1;
        int newResolution = quality >> 1;
        if (this.desiredFidelity != newFidelity || this.resolution != newResolution) {
            this.desiredFidelity = newFidelity;
            this.trueFidelity = newFidelity;
            this.clear();
        }
    }

    public void transformPixels(int[] rgb24Buf, int xOff, int yOff, int n, int fidelity, byte[] uCoeffs, byte[] vCoeffs, byte[] yCoeffs, int filterType) {
        int sourceRowOff;
        int pixelIdx;
        boolean useAverageFilter = filterType == 2;
        boolean useDeltaFilter = filterType == 1;
        boolean filterInput = useAverageFilter || useDeltaFilter;
        byte[] prevBlu = null;
        byte[] prevGrn = null;
        byte[] prevRed = null;
        if (filterInput) {
            if (this.prevRed == null) {
                this.prevBlu = CoeffsBuf.get();
                this.prevGrn = CoeffsBuf.get();
                this.prevRed = CoeffsBuf.get();
                this.prevRGBValid = false;
            }
            prevBlu = this.prevBlu.buffer;
            prevGrn = this.prevGrn.buffer;
            prevRed = this.prevRed.buffer;
        }
        if (filterInput && !this.prevRGBValid) {
            pixelIdx = 0;
            sourceRowOff = n * yOff + xOff;
            for (int row = 0; row < 8; ++row) {
                int sourceIdx = sourceRowOff;
                sourceRowOff += n;
                for (int col = 0; col < 8; ++col) {
                    int rgb24 = rgb24Buf[sourceIdx++];
                    prevRed[pixelIdx] = (byte)(rgb24 >> 16);
                    prevGrn[pixelIdx] = (byte)(rgb24 >> 8);
                    prevBlu[pixelIdx++] = (byte)rgb24;
                }
            }
            this.prevRGBValid = true;
        }
        pixelIdx = 0;
        sourceRowOff = n * yOff + xOff;
        int[] u = VideoBlock.getIntWorkingBuffer();
        int[] v = VideoBlock.getIntWorkingBuffer();
        int[] y = VideoBlock.getIntWorkingBuffer();
        for (int row = 0; row < 8; ++row) {
            int sourceIdx = sourceRowOff;
            sourceRowOff += n;
            for (int col = 0; col < 8; ++col) {
                int prevR;
                int prevG;
                int prevB;
                int rgb24 = rgb24Buf[sourceIdx++];
                int r = rgb24 >> 16 & 0xFF;
                int g = rgb24 >> 8 & 0xFF;
                int b = rgb24 & 0xFF;
                if (useDeltaFilter) {
                    prevB = prevBlu[pixelIdx] & 0xFF;
                    prevG = prevGrn[pixelIdx] & 0xFF;
                    prevR = prevRed[pixelIdx] & 0xFF;
                    if (prevB - sigChg < b && b < prevB + sigChg && prevG - sigChg < g && g < prevG + sigChg && prevR - sigChg < r && r < prevR + sigChg) {
                        b = prevB;
                        g = prevG;
                        r = prevR;
                    } else {
                        prevBlu[pixelIdx] = (byte)b;
                        prevGrn[pixelIdx] = (byte)g;
                        prevRed[pixelIdx] = (byte)r;
                    }
                } else if (useAverageFilter) {
                    prevB = prevBlu[pixelIdx] & 0xFF;
                    prevG = prevGrn[pixelIdx] & 0xFF;
                    prevR = prevRed[pixelIdx] & 0xFF;
                    prevBlu[pixelIdx] = (byte)b;
                    prevGrn[pixelIdx] = (byte)g;
                    prevRed[pixelIdx] = (byte)r;
                    b = b + prevB + 1 >> 1;
                    g = g + prevG + 1 >> 1;
                    r = r + prevR + 1 >> 1;
                }
                if (fidelity == 1) {
                    u[pixelIdx] = -151 * r - 296 * g + 446 * b + 512 >> 10;
                    v[pixelIdx] = 630 * r - 527 * g - 102 * b + 512 >> 10;
                }
                y[pixelIdx++] = (306 * r + 601 * g + 117 * b + 512 >> 10) - 128;
            }
        }
        VideoBlock.f8x8qdct(y, YQuantizerRecip_10FB[this.resolution], yCoeffs);
        if (fidelity == 1) {
            VideoBlock.f8x8qdct(u, UQuantizerRecip_10FB, uCoeffs);
            VideoBlock.f8x8qdct(v, VQuantizerRecip_10FB, vCoeffs);
        }
        VideoBlock.freeIntWorkingBuffer(u);
        VideoBlock.freeIntWorkingBuffer(v);
        VideoBlock.freeIntWorkingBuffer(y);
    }

    private static void zeroArray(byte[] array, int start, int count) {
        for (int i = 0; i < count; ++i) {
            array[start + i] = 0;
        }
    }

    private static void zeroArray(int[] array, int start, int count) {
        for (int i = 0; i < count; ++i) {
            array[start + i] = 0;
        }
    }

    static {
        int yMin;
        int vMin;
        int i;
        int uMin;
        C1_16FB = (int)Math.round(65536.0 * Math.cos(0.19634954084936207));
        C3_16FB = (int)Math.round(65536.0 * Math.cos(0.5890486225480862));
        R2_8FB = (int)Math.round(256.0 * Math.sqrt(2.0));
        R2C6_16FB = (int)Math.round(65536.0 * Math.sqrt(2.0) * Math.cos(1.1780972450961724));
        R2S6_16FB = (int)Math.round(65536.0 * Math.sqrt(2.0) * Math.sin(1.1780972450961724));
        S1_16FB = (int)Math.round(65536.0 * Math.sin(0.19634954084936207));
        S3_16FB = (int)Math.round(65536.0 * Math.sin(0.5890486225480862));
        C1_8FB = C1_16FB + 128 >> 8;
        C3_8FB = C3_16FB + 128 >> 8;
        R2_7FB = R2_8FB + 1 >> 1;
        R2C6_8FB = R2C6_16FB + 128 >> 8;
        R2S6_8FB = R2S6_16FB + 128 >> 8;
        S1_8FB = S1_16FB + 128 >> 8;
        S3_8FB = S3_16FB + 128 >> 8;
        C1_MINUS_S1_8FB = C1_8FB - S1_8FB;
        C1_MINUS_S1_16FB = C1_16FB - S1_16FB;
        C1_PLUS_S1_8FB = C1_8FB + S1_8FB;
        C1_PLUS_S1_16FB = C1_16FB + S1_16FB;
        C3_MINUS_S3_8FB = C3_8FB - S3_8FB;
        C3_MINUS_S3_16FB = C3_16FB - S3_16FB;
        C3_PLUS_S3_8FB = C3_8FB + S3_8FB;
        C3_PLUS_S3_16FB = C3_16FB + S3_16FB;
        R2C6_MINUS_R2S6_8FB = R2C6_8FB - R2S6_8FB;
        R2C6_MINUS_R2S6_16FB = R2C6_16FB - R2S6_16FB;
        R2C6_PLUS_R2S6_8FB = R2C6_8FB + R2S6_8FB;
        R2C6_PLUS_R2S6_16FB = R2C6_16FB + R2S6_16FB;
        CodeInverseTbl = new byte[][]{{0}, {-1, 1}, {-3, -2, 2, 3}, {-7, -6, -5, -4, 4, 5, 6, 7}, {-15, -14, -13, -12, -11, -10, -9, -8, 8, 9, 10, 11, 12, 13, 14, 15}, {-31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31}, {-63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63}, {-127, -126, -125, -124, -123, -122, -121, -120, -119, -118, -117, -116, -115, -114, -113, -112, -111, -110, -109, -108, -107, -106, -105, -104, -103, -102, -101, -100, -99, -98, -97, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, -86, -85, -84, -83, -82, -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -64, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127}};
        CodeLen = new byte[]{1, 3, 5, 5, 7, 7, 7, 7, 9, 9, 9, 9, 9, 9, 9, 9, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 5, 5, 3};
        CodePrefixLen = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 7, 7};
        CodePrefixType = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 6, 7};
        CodeSuffixLen = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 6, 7};
        CodeTbl = new short[]{0, 5, 26, 27, 116, 117, 118, 119, 488, 489, 490, 491, 492, 493, 494, 495, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 8096, 8097, 8098, 8099, 8100, 8101, 8102, 8103, 8104, 8105, 8106, 8107, 8108, 8109, 8110, 8111, 8112, 8113, 8114, 8115, 8116, 8117, 8118, 8119, 8120, 8121, 8122, 8123, 8124, 8125, 8126, 8127, 16320, 16321, 16322, 16323, 16324, 16325, 16326, 16327, 16328, 16329, 16330, 16331, 16332, 16333, 16334, 16335, 16336, 16337, 16338, 16339, 16340, 16341, 16342, 16343, 16344, 16345, 16346, 16347, 16348, 16349, 16350, 16351, 16352, 16353, 16354, 16355, 16356, 16357, 16358, 16359, 16360, 16361, 16362, 16363, 16364, 16365, 16366, 16367, 16368, 16369, 16370, 16371, 16372, 16373, 16374, 16375, 16376, 16377, 16378, 16379, 16380, 16381, 16382, 16383, 16256, 16256, 16257, 16258, 16259, 16260, 16261, 16262, 16263, 16264, 16265, 16266, 16267, 16268, 16269, 16270, 16271, 16272, 16273, 16274, 16275, 16276, 16277, 16278, 16279, 16280, 16281, 16282, 16283, 16284, 16285, 16286, 16287, 16288, 16289, 16290, 16291, 16292, 16293, 16294, 16295, 16296, 16297, 16298, 16299, 16300, 16301, 16302, 16303, 16304, 16305, 16306, 16307, 16308, 16309, 16310, 16311, 16312, 16313, 16314, 16315, 16316, 16317, 16318, 16319, 8064, 8065, 8066, 8067, 8068, 8069, 8070, 8071, 8072, 8073, 8074, 8075, 8076, 8077, 8078, 8079, 8080, 8081, 8082, 8083, 8084, 8085, 8086, 8087, 8088, 8089, 8090, 8091, 8092, 8093, 8094, 8095, 1984, 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 480, 481, 482, 483, 484, 485, 486, 487, 112, 113, 114, 115, 24, 25, 4};
        Map2x2To8x8UL = new int[]{0, 1, 8, 9};
        Map4x4To8x8UL = new int[]{0, 1, 2, 3, 8, 9, 10, 11, 16, 17, 18, 19, 24, 25, 26, 27};
        NominalYQuantizer = new int[]{16, 11, 10, 16, 24, 40, 51, 61, 12, 12, 14, 19, 26, 58, 60, 55, 14, 13, 16, 24, 40, 57, 69, 56, 14, 17, 22, 29, 51, 87, 80, 62, 18, 22, 37, 56, 68, 109, 103, 77, 24, 35, 55, 64, 81, 104, 113, 92, 49, 64, 78, 87, 103, 121, 120, 101, 72, 92, 95, 98, 112, 100, 103, 99};
        UQuantizer = new int[]{17, 18, 24, 47, 99, 99, 99, 99, 18, 21, 26, 66, 99, 99, 99, 99, 24, 26, 56, 99, 99, 99, 99, 99, 47, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
        VideoBlock.UQuantizer[0] = uMin = 7;
        for (i = 1; i < 64; ++i) {
            if (UQuantizer[i] >= uMin) continue;
            VideoBlock.UQuantizer[i] = uMin;
        }
        VQuantizer = new int[]{17, 18, 24, 47, 99, 99, 99, 99, 18, 21, 26, 66, 99, 99, 99, 99, 24, 26, 56, 99, 99, 99, 99, 99, 47, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
        VideoBlock.VQuantizer[0] = vMin = 10;
        for (i = 1; i < 64; ++i) {
            if (VQuantizer[i] >= vMin) continue;
            VideoBlock.VQuantizer[i] = vMin;
        }
        YQuantizer = new int[3][];
        VideoBlock.YQuantizer[0] = new int[64];
        VideoBlock.YQuantizer[1] = new int[64];
        VideoBlock.YQuantizer[2] = new int[64];
        VideoBlock.YQuantizer[0][0] = yMin = 8;
        VideoBlock.YQuantizer[1][0] = yMin;
        VideoBlock.YQuantizer[2][0] = yMin;
        double coarseQFactor = 6.0;
        double mediumQFactor = 1.5;
        double fineQFactor = 1.0;
        for (int i2 = 1; i2 < 64; ++i2) {
            VideoBlock.YQuantizer[0][i2] = Math.max(yMin, (int)((double)NominalYQuantizer[i2] / coarseQFactor + 0.5));
            VideoBlock.YQuantizer[1][i2] = Math.max(yMin, (int)((double)NominalYQuantizer[i2] / mediumQFactor + 0.5));
            VideoBlock.YQuantizer[2][i2] = Math.max(yMin, (int)((double)NominalYQuantizer[i2] / fineQFactor + 0.5));
        }
        UQuantizerRecip_10FB = new int[64];
        VQuantizerRecip_10FB = new int[64];
        YQuantizerRecip_10FB = new int[3][64];
        VideoBlock.YQuantizerRecip_10FB[0] = new int[64];
        VideoBlock.YQuantizerRecip_10FB[1] = new int[64];
        VideoBlock.YQuantizerRecip_10FB[2] = new int[64];
        for (int i3 = 0; i3 < 64; ++i3) {
            VideoBlock.UQuantizerRecip_10FB[i3] = (int)Math.round(1024.0 / (double)UQuantizer[i3]);
            VideoBlock.VQuantizerRecip_10FB[i3] = (int)Math.round(1024.0 / (double)VQuantizer[i3]);
            VideoBlock.YQuantizerRecip_10FB[0][i3] = (int)Math.round(1024.0 / (double)YQuantizer[0][i3]);
            VideoBlock.YQuantizerRecip_10FB[1][i3] = (int)Math.round(1024.0 / (double)YQuantizer[1][i3]);
            VideoBlock.YQuantizerRecip_10FB[2][i3] = (int)Math.round(1024.0 / (double)YQuantizer[2][i3]);
        }
        Zigzag = new int[]{0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63};
        importedBlkCnt = 0L;
        receivedBlkCnt = 0L;
        receivedCodedAbsACCoeffsCnt = 0L;
        receivedCodedRelACCoeffsCnt = 0L;
        receivedPlainAbsACCoeffsCnt = 0L;
        receivedSuppressedACCoeffsCnt = 0L;
        receivedUCoeffsCnt = 0L;
        receivedUCoeffsCumSize = 0L;
        receivedVCoeffsCnt = 0L;
        receivedVCoeffsCumSize = 0L;
        receivedYCoeffsCnt = 0L;
        receivedYCoeffsCumSize = 0L;
        sentBlkCnt = 0L;
        sentCodedAbsACCoeffsCnt = 0L;
        sentCodedRelACCoeffsCnt = 0L;
        sentPlainAbsACCoeffsCnt = 0L;
        sentSuppressedACCoeffsCnt = 0L;
        sentUCoeffsCnt = 0L;
        sentUCoeffsCumSize = 0L;
        sentVCoeffsCnt = 0L;
        sentVCoeffsCumSize = 0L;
        sentYCoeffsCnt = 0L;
        sentYCoeffsCumSize = 0L;
        byteWorkingBufCreateCnt = 0;
        byteWorkingBufDiscardCnt = 0;
        byteWorkingBufFreeCnt = 0;
        byteWorkingBufStack = new Object[64];
        intWorkingBufCreateCnt = 0;
        intWorkingBufDiscardCnt = 0;
        intWorkingBufFreeCnt = 0;
        intWorkingBufStack = new Object[64];
        maxFreeVideoBlocks = 1200;
        sigChg = 8;
        videoBlockCreateCnt = 0;
        videoBlockDiscardCnt = 0;
        videoBlockFreeCnt = 0;
        videoBlockStack = null;
        videoBlockStackLock = new Object();
    }
}

