/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream.imageprocessing;

import com.elluminate.mediastream.imageprocessing.CompressedTile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class ImageUtilities {
    public static final boolean COMPRESSED_DATA = true;
    private static final char[] COLOR_CHAR = new char[]{'M', 'N', 'O', 'p', '8', '7', '6', '5', '4', '3', '2', '1', '-', ',', '.', ' '};
    public static final byte TILE_REPAINT = 0;
    public static final byte FRAME_REPAINT = 1;
    public static final boolean COLOR_GROUP_PIXEL_BYTES = true;
    public static final int TILE_WIDTH = 16;
    public static final int TILE_WIDTH_SHIFT = 4;
    public static final int TILE_HEIGHT = 16;
    public static final int TILE_HEIGHT_SHIFT = 4;
    public static final int TILE_X_MASK = 255;
    public static final int TILE_Y_MASK = 255;
    private static Inflater decompresser = null;
    private static Deflater deflater = null;
    private static PrintStream out = null;
    private static Thread shutdownHook;
    private Vector updateListeners = new Vector();
    private static Component dummyFrame;

    public static CompressedTile compressTileData(Image image) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        int[] pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException ie) {
            return ImageUtilities.compressTileData(new byte[0]);
        }
        return ImageUtilities.compressTileData(ImageUtilities.intsToBytes(pixels));
    }

    public static CompressedTile compressTileData(int[] tileData) {
        return ImageUtilities.compressTileData(ImageUtilities.intsToBytes(tileData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompressedTile compressTileData(byte[] tileData) {
        byte[] output = new byte[tileData.length];
        int size = 0;
        if (deflater == null) {
            deflater = new Deflater();
        }
        Deflater deflater = ImageUtilities.deflater;
        synchronized (deflater) {
            ImageUtilities.deflater.setInput(tileData);
            ImageUtilities.deflater.finish();
            size = ImageUtilities.deflater.deflate(output);
            ImageUtilities.deflater.reset();
        }
        byte[] compressedTile = new byte[size];
        System.arraycopy(output, 0, compressedTile, 0, size);
        return new CompressedTile(compressedTile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] decompressTileData(byte[] compressed) {
        if (compressed.length > 0) {
            int length = 0;
            byte[] result = new byte[1024];
            if (decompresser == null) {
                decompresser = new Inflater();
            }
            Inflater inflater = decompresser;
            synchronized (inflater) {
                decompresser.setInput(compressed);
                try {
                    length = decompresser.inflate(result);
                }
                catch (Exception e) {
                    System.err.println("ImageUtilities.decompressTileData: " + e.getMessage());
                }
                decompresser.reset();
            }
            return ImageUtilities.bytesToInts(result, length);
        }
        return new int[0];
    }

    public static int[] bytesToInts(byte[] bytes, int length) {
        int[] ints = new int[length / 4];
        int pixelIndex = 0;
        int pixelCount = length / 4;
        int alphaByte = 0;
        int redByte = alphaByte + pixelCount;
        int greenByte = redByte + pixelCount;
        int blueByte = greenByte + pixelCount;
        for (int byteCounter = 0; byteCounter < pixelCount; ++byteCounter) {
            ints[pixelIndex++] = bytes[alphaByte++] << 24 & 0xFF000000 | bytes[redByte++] << 16 & 0xFF0000 | bytes[greenByte++] << 8 & 0xFF00 | bytes[blueByte++] & 0xFF;
        }
        return ints;
    }

    public static byte[] intsToBytes(int[] ints) {
        byte[] bytes = new byte[ints.length * 4];
        int alphaByte = 0;
        int redByte = alphaByte + ints.length;
        int greenByte = redByte + ints.length;
        int blueByte = greenByte + ints.length;
        for (int i = 0; i < ints.length; ++i) {
            bytes[alphaByte++] = (byte)(ints[i] >> 24 & 0xFF);
            bytes[redByte++] = (byte)(ints[i] >> 16 & 0xFF);
            bytes[greenByte++] = (byte)(ints[i] >> 8 & 0xFF);
            bytes[blueByte++] = (byte)(ints[i] & 0xFF);
        }
        return bytes;
    }

    public static Image getImageForTile(byte[] compressed) {
        return ImageUtilities.getImageForTile(ImageUtilities.decompressTileData(compressed));
    }

    public static Image getImageForTile(int[] tileData) {
        MemoryImageSource source = new MemoryImageSource(16, 16, tileData, 0, 16);
        Image tileImage = Toolkit.getDefaultToolkit().createImage(source);
        return tileImage;
    }

    public static Dimension getPixelDimension(Dimension tiles) {
        return new Dimension(tiles.width * 16, tiles.height * 16);
    }

    public static int getTileNumberFromPixel(int x, int y) {
        return ImageUtilities.getTileNumber(x >> 4, y >> 4);
    }

    public static int getTileNumberFromPixel(Point point) {
        return ImageUtilities.getTileNumberFromPixel(point.x, point.y);
    }

    public static int getTileNumber(int tileX, int tileY) {
        return (tileY & 0xFF) << 8 | tileX & 0xFF;
    }

    public static Rectangle getTileRectangle(int tileNumber, int overScan) {
        Point floor = ImageUtilities.getPixelFloorFromTileNumber(tileNumber);
        Point ceil = ImageUtilities.getPixelCeilFromTileNumber(tileNumber);
        Rectangle rect = new Rectangle(floor.x, floor.y, ceil.x - floor.x, ceil.y - floor.y);
        rect.grow(overScan, overScan);
        return rect;
    }

    public static Rectangle getTileRectangle(int tileNumber) {
        Point floor = ImageUtilities.getPixelFloorFromTileNumber(tileNumber);
        Point ceil = ImageUtilities.getPixelCeilFromTileNumber(tileNumber);
        return new Rectangle(floor.x, floor.y, ceil.x - floor.x, ceil.y - floor.y);
    }

    public static Dimension getTiledDimension(int width, int height) {
        int tilesWide = (width + 16 - 1) / 16;
        int tilesHigh = (height + 16 - 1) / 16;
        return new Dimension(tilesWide, tilesHigh);
    }

    public static Dimension getTiledDimension(Dimension pixels) {
        return ImageUtilities.getTiledDimension(pixels.width, pixels.height);
    }

    public static Rectangle getTiledRectangle(Rectangle rect) {
        Rectangle result = new Rectangle();
        result.x = rect.x / 16 * 16;
        result.y = rect.y / 16 * 16;
        result.width = ((rect.x + rect.width - result.x) / 16 + 1) * 16;
        result.height = ((rect.y + rect.height - result.y) / 16 + 1) * 16;
        return result;
    }

    public static Rectangle getScaledRect(Rectangle rect, double scaleX, double scaleY) {
        Rectangle result = new Rectangle();
        result.x = (int)Math.floor(rect.getX() * scaleX);
        result.y = (int)Math.floor(rect.getY() * scaleY);
        double right = (double)(rect.x + rect.width) * scaleX;
        double bottom = (double)(rect.y + rect.height) * scaleY;
        result.width = (int)Math.ceil(right - (double)result.x);
        result.height = (int)Math.ceil(bottom - (double)result.y);
        return result;
    }

    public static Point getPixelFloorFromTileNumber(int tileNumber) {
        return new Point((tileNumber & 0xFF) << 4, (tileNumber & 0xFF00) >> 4);
    }

    public static Point getPixelCeilFromTileNumber(int tileNumber) {
        Point floor = ImageUtilities.getPixelFloorFromTileNumber(tileNumber);
        return new Point(floor.x + 16 - 1, floor.y + 16 - 1);
    }

    public static int getHorizontalTileNumber(int x) {
        return x / 16;
    }

    public static int getVerticalTileNumber(int y) {
        return y / 16;
    }

    public static void drawTile(BufferedImage tile, Dimension size, short tileNumber) {
        if (out == null) {
            try {
                out = new PrintStream(new FileOutputStream(File.createTempFile("Tiles", ".txt")));
            }
            catch (FileNotFoundException ex) {
            }
            catch (IOException ex) {
                // empty catch block
            }
            shutdownHook = new Thread(){

                @Override
                public void run() {
                    out.close();
                }
            };
        }
        int tileWidth = size.width / 16;
        int tileHeight = size.height / 16;
        int x1 = tileNumber & 0xFF;
        int y1 = tileNumber >> 8 & 0xFF;
        char[] line = new char[19 + tileWidth];
        for (int i = 0; i < line.length; ++i) {
            line[i] = 32;
        }
        out.println("ImageUtilities.drawTile: " + Integer.toHexString(tileNumber) + ", loc: " + x1 * 16 + ", " + y1 * 16);
        for (int y = 0; y < tileWidth; ++y) {
            for (int x = 0; x < tileHeight; ++x) {
                if (x < 16 && y < 16) {
                    int color = tile.getRGB(x, y);
                    int b = color & 0xFF;
                    int g = (color >>= 8) & 0xFF;
                    int r = (color >>= 8) & 0xFF;
                    int a = (color >>= 8) & 0xFF;
                    color = (r + g + b) * a / 192;
                    line[1 + x] = COLOR_CHAR[color];
                }
                line[19 + x] = x == x1 ? 77 : 46;
            }
            out.println(new String(line));
        }
    }

    public static void insertPixels(int[] pixelFrag, int pixelFragWidth, int pixelFragHeight, int pixelTargetX, int pixelTargetY, int[] pixelTarget, int pixelTargetWidth, int pixelTargetHeight) {
        int fragOffset = 0;
        int targetOffset = pixelTargetX + pixelTargetY * pixelTargetWidth;
        int horizontalLength = pixelFragWidth + pixelTargetX > pixelTargetWidth ? pixelTargetWidth - pixelTargetX : pixelFragWidth;
        for (int y = pixelTargetY; y < pixelTargetHeight && y < pixelFragHeight + pixelTargetY; ++y) {
            System.arraycopy(pixelFrag, fragOffset, pixelTarget, targetOffset, horizontalLength);
            fragOffset += pixelFragWidth;
            targetOffset += pixelTargetWidth;
        }
    }

    public static void insertTile(int[] tile, int tileNumber, int width, int height, int[] pixelFrame) {
        if (pixelFrame.length != width * height * 16 * 16) {
            throw new RuntimeException("pixelFrame is not a multiple of tiles.");
        }
        int tileOffset = 0;
        Point tileLocation = ImageUtilities.getPixelFloorFromTileNumber(tileNumber);
        int pixelFrameOffset = tileLocation.x + tileLocation.y * width;
        for (int y = 0; y < 16; ++y) {
            System.arraycopy(tile, tileOffset, pixelFrame, pixelFrameOffset, 16);
        }
    }

    public static void fillFrame(int[] pixels, int width, int height, Color backgroundColor) {
        int colorPixel = backgroundColor.getRGB() | 0xFF000000;
        for (int x = 0; x < width; ++x) {
            pixels[x] = colorPixel;
        }
        int offset = width;
        for (int y = 1; y < height; ++y) {
            System.arraycopy(pixels, 0, pixels, offset, width);
            offset += width;
        }
    }

    static {
        dummyFrame = new Frame();
        dummyFrame.addNotify();
    }
}

