/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream;

import com.elluminate.mediastream.MRFPacket;
import java.io.IOException;

public class MRFUnknown
extends MRFPacket {
    private byte packetType;
    private byte[] payload;

    public MRFUnknown(byte type, byte[] packetData) throws IOException {
        super((byte)0);
        this.payload = packetData;
        this.packetType = type;
    }

    @Override
    public byte getPacketType() {
        return this.packetType;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPacketType(byte packetType) {
        this.packetType = packetType;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    @Override
    public byte[] toByteArray() {
        return this.payload;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("MRFUnknown: type: " + this.packetType);
        if (this.packetType < MRFPacket.MRF_PACKET_TYPES.length) {
            buf.append(" (" + MRFPacket.MRF_PACKET_TYPES[this.packetType] + ")");
        }
        buf.append("\n");
        for (int index = 0; index < this.payload.length; index += 16) {
            int i;
            String digits = Integer.toHexString(index);
            for (i = 4; i > digits.length(); --i) {
                buf.append("0");
            }
            for (i = 0; i < 16 && i + index < this.payload.length; ++i) {
                digits = Integer.toHexString(this.payload[i + index] & 0xFF);
                if (digits.length() == 1) {
                    buf.append(" 0");
                }
                buf.append(digits);
                if (i != 7) continue;
                buf.append("  ");
            }
            buf.append("\n");
        }
        return buf.toString();
    }
}

