/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream;

import com.elluminate.mediastream.MRFPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MRFHeader
extends MRFPacket {
    private long date;
    private int height;
    private short majorVersion = 1;
    private short minorVersion = 1;
    private String recordingName;
    private int width;

    public MRFHeader(String recordingName, long date, int width, int height) {
        super((byte)1);
        this.date = date;
        this.recordingName = recordingName;
        this.width = width;
        this.height = height;
    }

    public MRFHeader(byte[] packetData) throws IOException {
        super((byte)1);
        ByteArrayInputStream bistr = new ByteArrayInputStream(packetData);
        DataInputStream istr = new DataInputStream(bistr);
        this.date = istr.readLong();
        this.recordingName = istr.readUTF();
        this.majorVersion = istr.readShort();
        this.minorVersion = istr.readShort();
        this.width = istr.readInt();
        this.height = istr.readInt();
    }

    public int getHeight() {
        return this.height;
    }

    public String getRecordingName() {
        return this.recordingName;
    }

    public long getTime() {
        return this.date;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setRecordingName(String recordingName) {
        this.recordingName = recordingName;
    }

    public void setTime(long time) {
        this.date = time;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bostr = new ByteArrayOutputStream();
        DataOutputStream ostr = new DataOutputStream(bostr);
        ostr.writeLong(this.date);
        ostr.writeUTF(this.recordingName);
        ostr.writeShort(this.majorVersion);
        ostr.writeShort(this.minorVersion);
        ostr.writeInt(this.width);
        ostr.writeInt(this.height);
        return bostr.toByteArray();
    }

    @Override
    public String toString() {
        return "MRFHeader: " + this.recordingName + ", date: " + this.date + ", width: " + this.width + ", height: " + this.height + "Version: " + this.majorVersion + "." + this.minorVersion;
    }
}

