/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.profile.module;

import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.SetViewableProfilesCommand;
import com.elluminate.groupware.profile.module.ProfileModule;
import com.elluminate.groupware.profile.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;

public class SetViewableProfilesCmd
extends AbstractCommand
implements SetViewableProfilesCommand {
    private static final long serialVersionUID = 1L;
    private String mode = null;
    @Inject
    private I18n i18n;
    @Inject
    private ProfileModule myModule;

    private String[] getAvailableModeStrings() {
        String[] modes = new String[]{"none", "moderators", "all"};
        return modes;
    }

    private byte[] getAvailableModeValues() {
        byte[] modes = new byte[]{0, 1, 3};
        return modes;
    }

    public String[] getAvailableModes() {
        return this.getAvailableModeStrings();
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        if (this.mode == null || this.mode.length() == 0) {
            throw new CommandParameterException("Profile viewing mode not set", this.i18n.getString((PropertiesEnum)StringsProperties.SETVIEWABLEPROFILESCMD_BADPARAMMODENOTSET));
        }
        String[] availableModeString = this.getAvailableModeStrings();
        byte[] availableModeValue = this.getAvailableModeValues();
        byte modeByte = 127;
        for (int i = 0; i < availableModeValue.length; ++i) {
            if (!this.mode.equalsIgnoreCase(availableModeString[i])) continue;
            modeByte = availableModeValue[i];
            break;
        }
        if (modeByte == 127) {
            throw new CommandParameterException("Profile viewing mode invalid", this.i18n.getString((PropertiesEnum)StringsProperties.SETVIEWABLEPROFILESCMD_BADPARAMMODEINVALID, new Object[]{this.mode}));
        }
        ProfileModule mod = this.myModule;
        if (!mod.setViewableProfileModeCmd(modeByte)) {
            throw new CommandExecutionException("Cannot set mode to " + this.mode, this.i18n.getString((PropertiesEnum)StringsProperties.SETVIEWABLEPROFILESCMD_BADRESULTERROROCCURRED, new Object[]{this.mode}));
        }
    }
}

