/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.profile.module;

import com.elluminate.groupware.profile.Profile;
import com.elluminate.groupware.profile.ProfileItemID;
import com.elluminate.groupware.profile.module.StringsProperties;
import com.elluminate.gui.FixedLengthDocument;
import com.elluminate.gui.FontUtils;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.FileSaveDialog;
import com.elluminate.gui.swing.CFileChooser;
import com.elluminate.gui.swing.CTabbedPane;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.browser.BrowserUtil;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

class ProfilePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String MODIFIED = "modified";
    public static final String PERSON = "person";
    private static final int MAX_PHOTO_WIDTH = 96;
    private static final int MAX_PHOTO_HEIGHT = 96;
    private static final int EXPORT_GENERIC = 0;
    private static final int EXPORT_OUTLOOK = 1;
    private static I18n i18n = I18n.create(ProfilePanel.class);
    private static File lastDir = null;
    private static Image NO_PHOTO_IMAGE = i18n.getImage("ProfileEditor.notAvailableImage");
    private Image NO_PHOTO = null;
    private Image photo = null;
    private CTabbedPane jTabbedPane1 = new CTabbedPane();
    private JPanel buttonPanel = new JPanel();
    private JPanel identityPanel = new JPanel();
    private JPanel identityPanel2 = new JPanel();
    private JPanel contactPanel = new JPanel();
    private JPanel contactPanel2 = new JPanel();
    private JPanel addressPanel = new JPanel();
    private JPanel addressPanel2 = new JPanel();
    private BorderLayout contactLayout = new BorderLayout();
    private BorderLayout contactLayout2 = new BorderLayout();
    private JPanel phonePanel = new JPanel();
    private Border border2;
    private JPanel emailPanel = new JPanel();
    private Border border3;
    private JPanel wwwPanel = new JPanel();
    private Border border4;
    private GridBagLayout phoneLayout = new GridBagLayout();
    private JLabel homePhoneLabel = new JLabel();
    private JTextField homePhone = new JTextField();
    private JLabel workPhoneLabel = new JLabel();
    private JTextField workPhone = new JTextField();
    private JTextField cellPhone = new JTextField();
    private JLabel cellPhoneLabel = new JLabel();
    private GridBagLayout emailLayout = new GridBagLayout();
    private JLabel homeEmailLabel = new JLabel();
    private JLabel workEmailLabel = new JLabel();
    private JTextField homeEmail = new JTextField();
    private JTextField workEmail = new JTextField();
    private GridBagLayout wwwLayout = new GridBagLayout();
    private JLabel urlLabel = new JLabel();
    private JTextField urlField = new JTextField();
    private JButton launchBtn = new JButton();
    private BorderLayout identityLayout = new BorderLayout();
    private BorderLayout identityLayout2 = new BorderLayout();
    private JPanel photoPanel = new JPanel();
    private JPanel infoPanel = new JPanel();
    private JPanel infoPanel2 = new JPanel();
    private JButton photoBtn = new JButton();
    private JButton clearBtn = new JButton();
    private BorderLayout photoLayout = new BorderLayout();
    private BorderLayout infoLayout = new BorderLayout();
    private GridBagLayout infoLayout2 = new GridBagLayout();
    private JTextField firstName = new JTextField();
    private JTextField lastName = new JTextField();
    private JTextField fullName = new JTextField();
    private JTextField title = new JTextField();
    private JTextField company = new JTextField();
    private JLabel firstNameLabel = new JLabel();
    private JLabel lastNameLabel = new JLabel();
    private JLabel fullNameLabel = new JLabel();
    private JLabel titleLabel = new JLabel();
    private JLabel companyLabel = new JLabel();
    private JButton exportBtn = new JButton();
    private JButton importBtn = new JButton();
    private Filter gifFilter = new Filter("gif");
    private Filter jpegFilter = new Filter("jpeg");
    private Filter imageFilter = new Filter("image");
    private Filter vcardFilter = new Filter("vcard");
    private BorderLayout addressLayout = new BorderLayout();
    private BorderLayout addressLayout2 = new BorderLayout();
    private JPanel homeAddress = new JPanel();
    private JPanel workAddress = new JPanel();
    private TitledBorder titledBorder4;
    private TitledBorder titledBorder5;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel homeStreetLabel = new JLabel();
    private JLabel homeCityLabel = new JLabel();
    private JLabel homeRegionLabel = new JLabel();
    private JLabel homePostalLabel = new JLabel();
    private JLabel homeCountryLabel = new JLabel();
    private JTextField homeStreet = new JTextField();
    private JTextField homeCity = new JTextField();
    private JTextField homeRegion = new JTextField();
    private JTextField homePostal = new JTextField();
    private JTextField homeCountry = new JTextField();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JLabel workStreetLabel = new JLabel();
    private JLabel workCityLabel = new JLabel();
    private JLabel workRegionLabel = new JLabel();
    private JLabel workPostalLabel = new JLabel();
    private JLabel workCountryLabel = new JLabel();
    private JTextField workStreet = new JTextField();
    private JTextField workCity = new JTextField();
    private JTextField workRegion = new JTextField();
    private JTextField workPostal = new JTextField();
    private JTextField workCountry = new JTextField();
    private int defaultExport = 0;
    private String[] exportOptions = new String[]{i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_GENERICOPTION), i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_OUTLOOKOPTION), i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_CANCELOPTION)};
    private Profile profile = null;
    private boolean modified = false;
    private String person = null;
    private boolean fullNameSync = true;
    private LinkedList items = new LinkedList();

    public ProfilePanel(boolean showButtons) {
        super(new BorderLayout(0, 6));
        this.NO_PHOTO = ProfilePanel.compositeImageAndText(NO_PHOTO_IMAGE, i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_NOTAVAILABLETEXT));
        this.titledBorder4 = new TitledBorder(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_WORKTITLE));
        this.titledBorder5 = new TitledBorder(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_HOMETITLE));
        this.newItem(ProfileItemID.FIRST_NAME, this.firstName, this.firstNameLabel);
        this.newItem(ProfileItemID.LAST_NAME, this.lastName, this.lastNameLabel);
        this.newItem(ProfileItemID.FULL_NAME, this.fullName, this.fullNameLabel);
        this.newItem(ProfileItemID.TITLE, this.title, this.titleLabel);
        this.newItem(ProfileItemID.COMPANY, this.company, this.companyLabel);
        this.newItem(ProfileItemID.HOME_PHONE, this.homePhone, this.homePhoneLabel);
        this.newItem(ProfileItemID.WORK_PHONE, this.workPhone, this.workPhoneLabel);
        this.newItem(ProfileItemID.CELL_PHONE, this.cellPhone, this.cellPhoneLabel);
        this.newItem(ProfileItemID.HOME_EMAIL, this.homeEmail, this.homeEmailLabel);
        this.newItem(ProfileItemID.WORK_EMAIL, this.workEmail, this.workEmailLabel);
        this.newItem(ProfileItemID.URL, this.urlField, this.urlLabel);
        this.newAddress("address.home", this.titledBorder5, this.homeStreet, this.homeCity, this.homeRegion, this.homePostal, this.homeCountry);
        this.newAddress("address.work", this.titledBorder4, this.workStreet, this.workCity, this.workRegion, this.workPostal, this.workCountry);
        this.firstName.getDocument().addDocumentListener(new Updater());
        this.lastName.getDocument().addDocumentListener(new Updater());
        this.fullName.getDocument().addDocumentListener(new Updater(){

            @Override
            protected void doUpdate() {
                this.checkSync();
            }
        });
        this.photo = this.NO_PHOTO;
        this.photoBtn.setHorizontalTextPosition(0);
        this.setPhoto(new ImageIcon(this.NO_PHOTO));
        if (Platform.getLAF() == 502) {
            this.photoBtn.putClientProperty("JButton.buttonType", "icon");
        }
        Insets mrgn = this.photoBtn.getMargin();
        int val = Math.min(mrgn.top, mrgn.left);
        this.photoBtn.setMargin(new Insets(val, val, val, val));
        this.photoBtn.setText(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_CHANGEIMAGELABEL));
        this.photoBtn.setVerticalTextPosition(3);
        this.photoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilePanel.this.doPhotoButton(e);
            }
        });
        this.photoBtn.setPreferredSize(this.photoBtn.getPreferredSize());
        this.clearBtn.setText(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_CLEARIMAGELABEL));
        this.clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilePanel.this.doClearButton(e);
            }
        });
        this.homePhone.setText("");
        this.workPhone.setText("");
        this.cellPhone.setText("");
        this.homeEmail.setText("");
        this.workEmail.setText("");
        this.urlField.setText("");
        this.urlField.getDocument().addDocumentListener(new Updater(){

            @Override
            protected void doUpdate() {
                boolean valid = false;
                try {
                    String text = ProfilePanel.this.urlField.getText().trim();
                    if (text != null && text.length() > 0) {
                        URI uri = new URI(text);
                        valid = true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ProfilePanel.this.launchBtn.setEnabled(valid);
            }
        });
        this.firstName.setText("");
        this.lastName.setText("");
        this.fullName.setText("");
        this.title.setText("");
        this.company.setText("");
        this.exportBtn.setText(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_EXPORTLABEL));
        this.exportBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilePanel.this.doExportButton();
            }
        });
        this.importBtn.setText(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_IMPORTLABEL));
        this.importBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilePanel.this.doImportButton();
            }
        });
        this.launchBtn.setText(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_LAUNCHLABEL));
        this.launchBtn.setEnabled(false);
        this.launchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilePanel.this.doLaunchButton();
            }
        });
        this.homeStreetLabel.setText(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_STREETFIELD));
        this.homeCityLabel.setText(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_CITYFIELD));
        this.homeRegionLabel.setText(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_REGIONFIELD));
        this.homePostalLabel.setText(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_POSTALFIELD));
        this.homeCountryLabel.setText(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_COUNTRYFIELD));
        this.homeStreet.setText("");
        this.homeCity.setText("");
        this.homeRegion.setText("");
        this.homePostal.setText("");
        this.homeCountry.setText("");
        this.workStreetLabel.setText(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_STREETFIELD));
        this.workCityLabel.setText(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_CITYFIELD));
        this.workRegionLabel.setText(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_REGIONFIELD));
        this.workPostalLabel.setText(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_POSTALFIELD));
        this.workCountryLabel.setText(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_COUNTRYFIELD));
        this.workCountry.setText("");
        this.workPostal.setText("");
        this.workRegion.setText("");
        this.workCity.setText("");
        this.workStreet.setText("");
        this.jTabbedPane1.add((Component)this.identityPanel, (Object)i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_IDENTITYLABEL));
        this.identityPanel.setLayout(this.identityLayout);
        this.identityPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.identityPanel.add((Component)this.identityPanel2, "North");
        this.identityLayout2.setHgap(10);
        this.identityPanel2.setLayout(this.identityLayout2);
        this.identityPanel2.add((Component)this.photoPanel, "West");
        this.photoLayout.setVgap(6);
        this.photoPanel.setLayout(this.photoLayout);
        this.photoPanel.setDebugGraphicsOptions(0);
        this.photoPanel.add((Component)this.photoBtn, "Center");
        this.photoPanel.add((Component)this.clearBtn, "South");
        this.identityPanel2.add((Component)this.infoPanel, "Center");
        this.infoPanel.setLayout(this.infoLayout);
        this.infoPanel.add((Component)this.infoPanel2, "North");
        this.infoPanel2.setLayout(this.infoLayout2);
        this.infoPanel2.add((Component)this.firstName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 6, 0, 0), 0, 0));
        this.infoPanel2.add((Component)this.lastName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 6, 0, 0), 0, 0));
        this.infoPanel2.add((Component)this.fullName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 6, 0, 0), 0, 0));
        this.infoPanel2.add((Component)this.title, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 6, 0, 0), 0, 0));
        this.infoPanel2.add((Component)this.company, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 6, 0, 0), 0, 0));
        this.infoPanel2.add((Component)this.firstNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.infoPanel2.add((Component)this.lastNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 0, 0, 0), 0, 0));
        this.infoPanel2.add((Component)this.fullNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 0, 0, 0), 0, 0));
        this.infoPanel2.add((Component)this.titleLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 0, 0, 0), 0, 0));
        this.infoPanel2.add((Component)this.companyLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 0, 0, 0), 0, 0));
        this.jTabbedPane1.add((Component)this.contactPanel, (Object)i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_CONTACTLABEL));
        this.contactPanel.setLayout(this.contactLayout);
        this.contactPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.contactPanel.add((Component)this.contactPanel2, "North");
        this.contactLayout2.setVgap(6);
        this.contactPanel2.setLayout(this.contactLayout2);
        this.contactPanel2.add((Component)this.phonePanel, "North");
        this.border2 = BorderFactory.createCompoundBorder(new TitledBorder(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_TELEPHONETITLE)), BorderFactory.createEmptyBorder(4, 10, 10, 10));
        this.phonePanel.setBorder(this.border2);
        this.phonePanel.setLayout(this.phoneLayout);
        this.phonePanel.add((Component)this.homePhoneLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.phonePanel.add((Component)this.homePhone, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 6, 0, 0), 0, 0));
        this.phonePanel.add((Component)this.workPhoneLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 0), 0, 0));
        this.phonePanel.add((Component)this.workPhone, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(4, 6, 0, 0), 0, 0));
        this.phonePanel.add((Component)this.cellPhone, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(4, 6, 0, 0), 0, 0));
        this.phonePanel.add((Component)this.cellPhoneLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 0), 0, 0));
        this.border3 = BorderFactory.createCompoundBorder(new TitledBorder(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_EMAILTITLE)), BorderFactory.createEmptyBorder(4, 10, 10, 10));
        this.emailPanel.setBorder(this.border3);
        this.emailPanel.setLayout(this.emailLayout);
        this.contactPanel2.add((Component)this.emailPanel, "Center");
        this.emailPanel.add((Component)this.homeEmailLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.emailPanel.add((Component)this.workEmailLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 0), 0, 0));
        this.emailPanel.add((Component)this.homeEmail, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 6, 0, 0), 0, 0));
        this.emailPanel.add((Component)this.workEmail, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(4, 6, 0, 0), 0, 0));
        this.border4 = BorderFactory.createCompoundBorder(new TitledBorder(i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_WWWTITLE)), BorderFactory.createEmptyBorder(4, 10, 10, 10));
        this.wwwPanel.setBorder(this.border4);
        this.wwwPanel.setLayout(this.wwwLayout);
        this.contactPanel2.add((Component)this.wwwPanel, "South");
        this.wwwPanel.add((Component)this.urlLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.wwwPanel.add((Component)this.urlField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 6, 0, 0), 0, 0));
        this.wwwPanel.add((Component)this.launchBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
        if (Platform.getLAF() == 502) {
            this.launchBtn.putClientProperty("JComponent.sizeVariant", "small");
            this.launchBtn.putClientProperty("JButton.buttonType", "square");
        }
        this.jTabbedPane1.add((Component)this.addressPanel, (Object)i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_ADDRESSESLABEL));
        this.addressPanel.setLayout(this.addressLayout);
        this.addressPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.addressPanel.add(this.addressPanel2);
        this.addressLayout2.setVgap(6);
        this.addressPanel2.setLayout(this.addressLayout2);
        this.addressPanel2.add((Component)this.homeAddress, "North");
        this.homeAddress.setBorder(BorderFactory.createCompoundBorder(this.titledBorder5, BorderFactory.createEmptyBorder(4, 10, 10, 10)));
        JComponent[] streetComp = new JComponent[]{this.homeStreetLabel, this.homeStreet};
        JComponent[] cityComp = new JComponent[]{this.homeCityLabel, this.homeCity};
        JComponent[] regionComp = new JComponent[]{this.homeRegionLabel, this.homeRegion};
        JComponent[] postalComp = new JComponent[]{this.homePostalLabel, this.homePostal};
        JComponent[] countryComp = new JComponent[]{this.homeCountryLabel, this.homeCountry};
        this.buildAddressPanel(this.homeAddress, this.gridBagLayout1, streetComp, cityComp, regionComp, postalComp, countryComp);
        this.addressPanel2.add((Component)this.workAddress, "Center");
        this.workAddress.setBorder(BorderFactory.createCompoundBorder(this.titledBorder4, BorderFactory.createEmptyBorder(4, 10, 10, 10)));
        streetComp = new JComponent[]{this.workStreetLabel, this.workStreet};
        cityComp = new JComponent[]{this.workCityLabel, this.workCity};
        regionComp = new JComponent[]{this.workRegionLabel, this.workRegion};
        postalComp = new JComponent[]{this.workPostalLabel, this.workPostal};
        countryComp = new JComponent[]{this.workCountryLabel, this.workCountry};
        this.buildAddressPanel(this.workAddress, this.gridBagLayout2, streetComp, cityComp, regionComp, postalComp, countryComp);
        streetComp = null;
        cityComp = null;
        regionComp = null;
        postalComp = null;
        countryComp = null;
        this.add((Component)this.jTabbedPane1, "Center");
        if (showButtons) {
            this.buttonPanel.setLayout(new FlowLayout(2, 0, 0));
            this.buttonPanel.add(this.importBtn);
            this.buttonPanel.add(Box.createHorizontalStrut(6));
            this.buttonPanel.add(this.exportBtn);
            this.add((Component)this.buttonPanel, "South");
        }
        DocumentListener l = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProfilePanel.this.setModified(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProfilePanel.this.setModified(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProfilePanel.this.setModified(true);
            }
        };
        this.firstName.getDocument().addDocumentListener(l);
        this.lastName.getDocument().addDocumentListener(l);
        this.fullName.getDocument().addDocumentListener(l);
        this.title.getDocument().addDocumentListener(l);
        this.company.getDocument().addDocumentListener(l);
        this.homePhone.getDocument().addDocumentListener(l);
        this.workPhone.getDocument().addDocumentListener(l);
        this.cellPhone.getDocument().addDocumentListener(l);
        this.homeEmail.getDocument().addDocumentListener(l);
        this.workEmail.getDocument().addDocumentListener(l);
        this.urlField.getDocument().addDocumentListener(l);
        this.homeStreet.getDocument().addDocumentListener(l);
        this.homeCity.getDocument().addDocumentListener(l);
        this.homeRegion.getDocument().addDocumentListener(l);
        this.homePostal.getDocument().addDocumentListener(l);
        this.homeCountry.getDocument().addDocumentListener(l);
        this.workStreet.getDocument().addDocumentListener(l);
        this.workCity.getDocument().addDocumentListener(l);
        this.workRegion.getDocument().addDocumentListener(l);
        this.workPostal.getDocument().addDocumentListener(l);
        this.workCountry.getDocument().addDocumentListener(l);
    }

    public JButton getImportButton() {
        return this.importBtn;
    }

    public JButton getExportButton() {
        return this.exportBtn;
    }

    private void setEditable(boolean editable) {
        this.homePhone.setEditable(editable);
        this.workPhone.setEditable(editable);
        this.cellPhone.setEditable(editable);
        this.homeEmail.setEditable(editable);
        this.workEmail.setEditable(editable);
        this.urlField.setEditable(editable);
        this.firstName.setEditable(editable);
        this.lastName.setEditable(editable);
        this.fullName.setEditable(editable);
        this.title.setEditable(editable);
        this.company.setEditable(editable);
        this.homeStreet.setEditable(editable);
        this.homeCity.setEditable(editable);
        this.homeRegion.setEditable(editable);
        this.homePostal.setEditable(editable);
        this.homeCountry.setEditable(editable);
        this.workStreet.setEditable(editable);
        this.workCity.setEditable(editable);
        this.workRegion.setEditable(editable);
        this.workPostal.setEditable(editable);
        this.workCountry.setEditable(editable);
        this.importBtn.setVisible(editable);
        this.photoBtn.setEnabled(editable);
        this.clearBtn.setEnabled(editable);
    }

    private void setPhoto(Icon icon) {
        this.photoBtn.setIcon(icon);
        this.photoBtn.setDisabledIcon(icon);
    }

    public void setProfile(Profile p, boolean editable) {
        this.profile = p;
        this.setEditable(editable);
        this.showAll(this.profile);
    }

    public void saveProfile(Profile p) {
        this.saveAll(p);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        boolean oldModified = this.modified;
        this.modified = modified;
        if (modified != oldModified) {
            this.firePropertyChange(MODIFIED, oldModified, modified);
        }
    }

    private void setPerson(String person) {
        String oldPerson = this.person;
        this.person = person;
        if (!person.equals(oldPerson)) {
            this.firePropertyChange(PERSON, oldPerson, person);
        }
    }

    private String makeFullName(String first, String last) {
        String full = first == null || first.length() == 0 ? (last == null || last.length() == 0 ? "" : last) : (last == null || last.length() == 0 ? first : first + " " + last);
        return full;
    }

    private void showAll(Profile p) {
        String first = p.getString(ProfileItemID.FIRST_NAME);
        String last = p.getString(ProfileItemID.LAST_NAME);
        String full = this.makeFullName(first, last);
        this.setPerson(full);
        if (!p.contains(ProfileItemID.FULL_NAME)) {
            this.fullName.setText(full);
            this.fullNameSync = true;
        } else {
            String pfn = p.getString(ProfileItemID.FULL_NAME);
            this.fullNameSync = pfn.equals(full);
            this.fullName.setText(pfn);
        }
        if (p.getImage(ProfileItemID.PHOTO) != null) {
            this.photo = p.getImage(ProfileItemID.PHOTO);
            this.setPhoto(new ImageIcon(this.photo));
        } else {
            this.photo = this.NO_PHOTO;
            this.setPhoto(new ImageIcon(this.NO_PHOTO));
        }
        for (Item item : this.items) {
            item.show(p);
        }
    }

    private void saveAll(Profile p) {
        String full = this.fullName.getText().trim();
        Image oldImage = null;
        oldImage = p.contains(ProfileItemID.PHOTO) ? p.getImage(ProfileItemID.PHOTO) : this.NO_PHOTO;
        if (this.photo != oldImage) {
            if (this.photo == this.NO_PHOTO) {
                p.set(ProfileItemID.PHOTO, (Image)null);
            } else {
                p.set(ProfileItemID.PHOTO, this.photo);
            }
        }
        if (!full.equals(p.getString(ProfileItemID.FULL_NAME))) {
            if (full.equals("")) {
                p.remove(ProfileItemID.FULL_NAME);
            } else {
                p.set(ProfileItemID.FULL_NAME, full);
            }
        }
        for (Item item : this.items) {
            item.save(p);
        }
    }

    private void newItem(ProfileItemID id, JTextComponent f, JLabel l) {
        Item item = new Item(l, f, id);
        this.items.add(item);
        f.setDocument((Document)new FixedLengthDocument(64));
    }

    private void newAddress(String base, TitledBorder b, JTextComponent c0, JTextComponent c1, JTextComponent c2, JTextComponent c3, JTextComponent c4) {
        JTextComponent[] parts = new JTextComponent[]{c0, c1, c2, c3, c4};
        for (int i = 0; i < parts.length; ++i) {
            parts[i].setDocument((Document)new FixedLengthDocument(64));
        }
        AddressItem item = new AddressItem(b, base, parts);
        this.items.add(item);
    }

    private void buildAddressPanel(JPanel addressPanel, GridBagLayout layout, JComponent[] streetComponents, JComponent[] cityComponents, JComponent[] regionComponents, JComponent[] zipComponents, JComponent[] countryComponents) {
        addressPanel.setLayout(layout);
        int[] allComponentsIndex = new int[]{i18n.getInt((PropertiesEnum)StringsProperties.PROFILEEDITOR_ADDRESSINDEX_STREET), i18n.getInt((PropertiesEnum)StringsProperties.PROFILEEDITOR_ADDRESSINDEX_CITY), i18n.getInt((PropertiesEnum)StringsProperties.PROFILEEDITOR_ADDRESSINDEX_REGION), i18n.getInt((PropertiesEnum)StringsProperties.PROFILEEDITOR_ADDRESSINDEX_ZIP), i18n.getInt((PropertiesEnum)StringsProperties.PROFILEEDITOR_ADDRESSINDEX_COUNTRY)};
        for (int i = 0; i < allComponentsIndex.length; ++i) {
            if (allComponentsIndex[i] > 5 || allComponentsIndex[i] < 1) {
                allComponentsIndex = new int[]{1, 2, 3, 4, 5};
            }
            for (int j = 0; j < allComponentsIndex.length; ++j) {
                if (i == j || allComponentsIndex[i] != allComponentsIndex[j]) continue;
                allComponentsIndex = new int[]{1, 2, 3, 4, 5};
            }
        }
        addressPanel.add((Component)streetComponents[0], new GridBagConstraints(0, allComponentsIndex[0] - 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        addressPanel.add((Component)streetComponents[1], new GridBagConstraints(1, allComponentsIndex[0] - 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 6, 0, 0), 0, 0));
        addressPanel.add((Component)cityComponents[0], new GridBagConstraints(0, allComponentsIndex[1] - 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 0), 0, 0));
        addressPanel.add((Component)cityComponents[1], new GridBagConstraints(1, allComponentsIndex[1] - 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 6, 0, 0), 0, 0));
        addressPanel.add((Component)regionComponents[0], new GridBagConstraints(0, allComponentsIndex[2] - 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 0), 0, 0));
        addressPanel.add((Component)regionComponents[1], new GridBagConstraints(1, allComponentsIndex[2] - 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 6, 0, 0), 0, 0));
        addressPanel.add((Component)zipComponents[0], new GridBagConstraints(0, allComponentsIndex[3] - 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 0), 0, 0));
        addressPanel.add((Component)zipComponents[1], new GridBagConstraints(1, allComponentsIndex[3] - 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 6, 0, 0), 0, 0));
        addressPanel.add((Component)countryComponents[0], new GridBagConstraints(0, allComponentsIndex[4] - 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 0), 0, 0));
        addressPanel.add((Component)countryComponents[1], new GridBagConstraints(1, allComponentsIndex[4] - 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 6, 0, 0), 0, 0));
        allComponentsIndex = null;
    }

    private URL getURL() {
        String text = this.urlField.getText().trim();
        if (text.length() == 0) {
            return null;
        }
        URL url = null;
        try {
            URI uri = new URI(text);
            url = uri.toURL();
        }
        catch (Throwable t) {
            try {
                URI uri = new URI("http://" + text);
                url = uri.toURL();
            }
            catch (Throwable t2) {
                url = null;
            }
        }
        return url;
    }

    private void doLaunchButton() {
        URL url = this.getURL();
        if (url != null) {
            try {
                BrowserUtil.gotoURL((String)url.toString());
                return;
            }
            catch (Throwable t) {
                LogSupport.message((Object)this, (String)"doLaunchButton", (String)("Exception processing URL '" + url + "': " + Debug.getStackTrace((Throwable)t)));
            }
        }
        ModalDialog.showMessageDialog((Component)this, (Object)i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_CANTLAUNCHMSG, new Object[]{this.urlField.getText()}), (String)i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_CANTLAUNCHTITLE), (int)0);
    }

    private void doPhotoButton(ActionEvent e) {
        CFileChooser chooser = new CFileChooser(lastDir);
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.addChoosableFileFilter(this.gifFilter);
        chooser.addChoosableFileFilter(this.jpegFilter);
        chooser.addChoosableFileFilter(this.imageFilter);
        if (chooser.showOpenDialog(this) == 0) {
            File f = chooser.getSelectedFile();
            lastDir = chooser.getCurrentDirectory();
            try {
                ImageIcon icon = new ImageIcon(f.getAbsolutePath());
                if (ImageSupport.encodeAsJPEG((Image)icon.getImage(), (int)70) == null) {
                    ModalDialog.showMessageDialog((Component)this, (Object)i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_LOADFAILEDMSG, new Object[]{f.getName()}), (String)i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_LOADFAILEDTITLE), (int)0);
                    return;
                }
                int w = icon.getIconWidth();
                int h = icon.getIconHeight();
                if (w > 96 || h > 96) {
                    if (ModalDialog.showConfirmDialog((Component)this, (Object)i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_TOOLARGEMSG), (String)i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_TOOLARGETITLE), (int)2, (int)3) != 0) {
                        return;
                    }
                    double dx = 96.0 / (double)w;
                    double dy = 96.0 / (double)h;
                    if (dx < dy) {
                        w = 96;
                        h = (int)((double)h * dx);
                    } else {
                        h = 96;
                        w = (int)((double)w * dy);
                    }
                    Image img = icon.getImage().getScaledInstance(w, h, 0);
                    icon = new ImageIcon(img);
                    this.photo = img;
                } else {
                    this.photo = icon.getImage();
                }
                this.setPhoto(icon);
                this.setModified(true);
            }
            catch (Throwable t) {
                ModalDialog.showMessageDialog((Component)this, (Object)i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_LOADFAILEDMSG, new Object[]{t.getMessage()}), (String)i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_LOADFAILEDTITLE), (int)0);
            }
        }
    }

    private void doImportButton() {
        CFileChooser chooser = new CFileChooser(lastDir);
        Profile imp = new Profile(this.profile);
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.addChoosableFileFilter(this.vcardFilter);
        if (chooser.showOpenDialog(this) == 0) {
            File f = chooser.getSelectedFile();
            lastDir = chooser.getCurrentDirectory();
            f = FileSysUtils.setExtensionDefault((File)f, (String)"vcf");
            try {
                imp.importVCard(f);
                this.showAll(imp);
            }
            catch (IOException iox) {
                ModalDialog.showMessageDialog((Component)this, (Object)i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_IMPORTFAILMSG, new Object[]{iox.getMessage()}), (String)i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_IMPORTFAILTITLE), (int)0);
            }
        }
    }

    private void doExportButton() {
        FileSaveDialog chooser = new FileSaveDialog(lastDir);
        Profile exp = new Profile(this.profile);
        String enc = "UTF-8";
        this.saveAll(exp);
        if (exp.isEmpty()) {
            ModalDialog.showMessageDialogAsync((int)-1, (Component)this, (Object)i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_EMPTYPROFILEMSG), (String)i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_EMPTYPROFILETITLE), (int)1);
            return;
        }
        if (!exp.isAscii() && Platform.getPlatform() == 1) {
            int result = ModalDialog.showOptionDialog((Component)this, (Object)i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_OUTLOOKMSG), (String)i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_OUTLOOKTITLE), (int)2, (int)3, null, (Object[])this.exportOptions, (Object)this.exportOptions[this.defaultExport]);
            switch (result) {
                case 0: {
                    this.defaultExport = result;
                    enc = "UTF-8";
                    break;
                }
                case 1: {
                    this.defaultExport = result;
                    enc = System.getProperty("file.encoding");
                    break;
                }
                default: {
                    return;
                }
            }
        }
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.addChoosableFileFilter((FileFilter)this.vcardFilter);
        chooser.setRequiredSuffix((FileFilter)this.vcardFilter, "vcf");
        if (chooser.showSaveDialog((Component)this) == 0) {
            File f = chooser.getSelectedFile();
            lastDir = chooser.getCurrentDirectory();
            try {
                exp.exportVCard(f, enc);
            }
            catch (IOException iox) {
                ModalDialog.showMessageDialog((Component)this, (Object)i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_EXPORTFAILMSG, new Object[]{iox.getMessage()}), (String)i18n.getString((PropertiesEnum)StringsProperties.PROFILEEDITOR_EXPORTFAILTITLE), (int)0);
            }
        }
    }

    void doClearButton(ActionEvent e) {
        this.photo = this.NO_PHOTO;
        this.setPhoto(new ImageIcon(this.NO_PHOTO));
        this.setModified(true);
    }

    private static Image compositeImageAndText(Image image, String text) {
        BufferedImage im;
        Graphics g;
        int imageWidth = -1;
        int imageHeight = -1;
        if (image != null) {
            ImageSupport.waitForImage((Image)image);
            imageWidth = image.getWidth(null);
            imageHeight = image.getHeight(null);
        }
        if (imageWidth < 0) {
            imageWidth = 99;
        }
        if (imageHeight < 0) {
            imageHeight = 99;
        }
        if ((g = ((Image)(im = new BufferedImage(imageWidth, imageHeight, 1))).getGraphics()) != null) {
            if (image != null) {
                g.drawImage(image, 0, 0, imageWidth, imageHeight, null);
            } else {
                g.setColor(Color.lightGray);
                g.fillRect(0, 0, imageWidth, imageHeight);
            }
            g.setFont(FontUtils.setFontStyleAndSize((Font)g.getFont(), (int)1, (int)14));
            FontMetrics fm = g.getFontMetrics();
            int textWidth = fm.stringWidth(text);
            g.setColor(Color.black);
            g.drawString(text, (imageWidth - textWidth) / 2, imageHeight - 20);
            g.dispose();
            image = im;
        }
        return image;
    }

    private static class AddressItem
    extends Item {
        TitledBorder label;
        Item[] parts;
        I18n i18n = I18n.create(Profile.class);

        public AddressItem(TitledBorder lbl, String base, JTextComponent[] fields) {
            super(null, null, null);
            this.label = lbl;
            if (this.label != null) {
                this.label.setTitle(this.i18n.getStringLegacy("ProfileItemID." + base));
            }
            this.parts = new Item[5];
            this.parts[0] = new Item(null, fields[0], ProfileItemID.get((String)(base + ".street")));
            this.parts[1] = new Item(null, fields[1], ProfileItemID.get((String)(base + ".locality")));
            this.parts[2] = new Item(null, fields[2], ProfileItemID.get((String)(base + ".region")));
            this.parts[3] = new Item(null, fields[3], ProfileItemID.get((String)(base + ".postal")));
            this.parts[4] = new Item(null, fields[4], ProfileItemID.get((String)(base + ".country")));
        }

        @Override
        public void show(Profile p) {
            for (int i = 0; i < this.parts.length; ++i) {
                this.parts[i].show(p);
            }
        }

        @Override
        public void save(Profile p) {
            for (int i = 0; i < this.parts.length; ++i) {
                this.parts[i].save(p);
            }
        }
    }

    private static class Filter
    extends FileFilter {
        String desc;
        ArrayList suffixes = new ArrayList();

        public Filter(String base) {
            String s = i18n.getStringLegacy("ProfileEditor." + base + "Filters");
            StringTokenizer parser = new StringTokenizer(s, ",");
            this.desc = i18n.getStringLegacy("ProfileEditor." + base + "FilterDesc");
            while (parser.hasMoreTokens()) {
                this.suffixes.add(parser.nextToken());
            }
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public boolean accept(File f) {
            if (FileSysUtils.isTraversableDirectory((File)f)) {
                return true;
            }
            String nm = f.getName();
            int dotx = nm.lastIndexOf(46);
            if (dotx < 0) {
                return false;
            }
            String suffix = nm.substring(dotx);
            for (int i = 0; i < this.suffixes.size(); ++i) {
                if (!suffix.equalsIgnoreCase((String)this.suffixes.get(i))) continue;
                return true;
            }
            return false;
        }
    }

    private static class Item {
        JLabel label;
        JTextComponent field;
        ProfileItemID which;

        public Item(JLabel lbl, JTextComponent fld, ProfileItemID id) {
            this.label = lbl;
            this.field = fld;
            this.which = id;
            if (this.label != null) {
                this.label.setText(id.getLabel());
                this.label.setLabelFor(fld);
            }
        }

        public void show(Profile p) {
            if (p.contains(this.which)) {
                this.field.setText(p.getString(this.which));
            } else {
                this.field.setText("");
            }
        }

        public void save(Profile p) {
            String old;
            String txt = this.field.getText().trim();
            String string = old = p.contains(this.which) ? p.getString(this.which) : "";
            if (old == txt) {
                return;
            }
            if (txt.equals("")) {
                p.remove(this.which);
            } else {
                p.set(this.which, txt);
            }
        }
    }

    private class Updater
    implements DocumentListener {
        private Updater() {
        }

        protected void doUpdate() {
            if (ProfilePanel.this.fullNameSync) {
                String full = ProfilePanel.this.makeFullName(ProfilePanel.this.firstName.getText(), ProfilePanel.this.lastName.getText());
                ProfilePanel.this.fullName.setText(full);
                ProfilePanel.this.setPerson(full);
            } else {
                this.checkSync();
            }
        }

        protected void checkSync() {
            String full = ProfilePanel.this.fullName.getText();
            String cat = ProfilePanel.this.makeFullName(ProfilePanel.this.firstName.getText(), ProfilePanel.this.lastName.getText());
            ProfilePanel.this.fullNameSync = full.equals(cat);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.doUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.doUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

