/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.profile.module;

import com.elluminate.groupware.profile.DefaultProfileItemFactory;
import com.elluminate.groupware.profile.ProfileItem;
import com.elluminate.groupware.profile.ProfileItemID;
import com.elluminate.groupware.profile.TextProfileItem;
import com.elluminate.groupware.profile.module.ImageProfileItem;
import com.elluminate.util.log.LogSupport;
import java.awt.Image;
import java.io.DataInputStream;
import java.io.IOException;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;

public class ModuleProfileItemFactory
extends DefaultProfileItemFactory {
    public ProfileItem getInstance(Element e) throws JDOMException {
        Attribute a = e.getAttribute("mime");
        if (a == null) {
            return null;
        }
        try {
            if (a.getValue().equals("text/plain")) {
                return new TextProfileItem(e);
            }
            if (a.getValue().equals("image/jpeg")) {
                return new ImageProfileItem(e);
            }
        }
        catch (JDOMException jdomx) {
            LogSupport.error((Object)((Object)this), (String)"getInstance", (String)jdomx.toString());
        }
        return null;
    }

    public ProfileItem getInstance(DataInputStream str) throws IOException {
        byte itemType = str.readByte();
        if (itemType == 0) {
            return null;
        }
        ProfileItemID id = ProfileItemID.read((DataInputStream)str);
        if (itemType == 1) {
            return new TextProfileItem(id, str);
        }
        if (itemType == 2) {
            return new ImageProfileItem(id, str);
        }
        if (itemType == 3) {
            return super.getProxy(id, str);
        }
        return null;
    }

    public ProfileItem getInstance(ProfileItemID id, Image value) {
        return new ImageProfileItem(id, value);
    }

    public ProfileItem getInstance(ProfileItemID id, byte[] data, String mime) {
        return new ImageProfileItem(id, data, mime);
    }
}

