/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.location;

import com.elluminate.framework.location.LocationDebug;
import com.elluminate.framework.location.MenuTreeNode;
import com.elluminate.framework.location.OrderedContainer;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public class Submenu
implements MenuTreeNode {
    private OrderedContainer<JMenu, JMenuItem> ordered;
    private MenuTreeNode parent;
    private String name;
    private Float order;
    private boolean showing = false;
    private Map<String, Submenu> children = new HashMap<String, Submenu>();
    private Logger logger;
    private Provider<Component> separatorFactory = new Provider<Component>(){

        public Component get() {
            return new JSeparator();
        }
    };

    @Inject
    public Submenu(OrderedContainer<JMenu, JMenuItem> oc, Logger log) {
        this.logger = log;
        this.ordered = oc;
        this.ordered.setSeparatorFactory(this.separatorFactory);
    }

    public void init(MenuTreeNode parent, String name, JMenu menu, float order) {
        this.ordered.setContainer(menu);
        this.parent = parent;
        this.name = name;
        this.order = Float.valueOf(order);
        parent.addSubmenu(this);
    }

    public MenuTreeNode getParent() {
        return this.parent;
    }

    @Override
    public JMenu getMenu() {
        return this.ordered.getContainer();
    }

    public float getOrder() {
        return this.order.floatValue();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void addSubmenu(Submenu submenu) {
        if (LocationDebug.MENUS.show()) {
            this.logger.message((Object)this, "addSubmenu", "Adding menu " + this.getPath() + "->" + submenu.getName() + " at position " + submenu.getOrder());
        }
        this.children.put(submenu.getName(), submenu);
    }

    @Override
    public void removeSubmenu(Submenu submenu) {
        this.children.remove(submenu.getName());
    }

    @Override
    public boolean containsSubmenu(String name) {
        return this.children.containsKey(name);
    }

    @Override
    public Submenu getSubmenu(String name) {
        return this.children.get(name);
    }

    @Override
    public void setSubmenuShowing(String name, boolean show) {
        Submenu submenu = this.children.get(name);
        if (submenu == null) {
            throw new IllegalArgumentException("Requested submenu '" + name + "' is not a child of this parent");
        }
        if (show) {
            if (submenu.isShowing()) {
                return;
            }
            this.add(submenu.getMenu(), submenu.getOrder());
            submenu.setShowing(true);
        } else {
            submenu.setShowing(false);
            this.remove(submenu.getMenu());
        }
    }

    public boolean isShowing() {
        return this.showing;
    }

    public void setShowing(boolean showing) {
        this.showing = showing;
    }

    @Override
    public void add(JMenuItem item, float order) {
        if (LocationDebug.MENUS.show()) {
            this.logger.message((Object)this, "add", "Adding item '" + this.getPath() + "->" + item.getText() + "' at position " + order);
        }
        if (this.ordered.isEmpty()) {
            this.parent.setSubmenuShowing(this.name, true);
        }
        this.ordered.doAdd(item, order);
    }

    @Override
    public void remove(JMenuItem item) {
        if (LocationDebug.MENUS.show()) {
            this.logger.message((Object)this, "remove", "Removing item '" + this.getPath() + "->" + item.getText() + "'");
        }
        this.ordered.doRemove(item);
        if (this.ordered.isEmpty()) {
            this.parent.setSubmenuShowing(this.name, false);
        }
    }

    @Override
    public String getPath() {
        return this.parent.getPath() + "->" + this.name;
    }
}

