/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.location;

import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.location.CachedImageIcon;
import com.elluminate.framework.location.FeatureAdapter;
import com.elluminate.framework.location.FeaturePair;
import com.elluminate.framework.location.ImageSetter;
import com.elluminate.gui.AccessibilityUtils;
import com.elluminate.platform.PlatformIssues;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;

public class PairedFeatureAdapter
extends FeatureAdapter
implements ActionListener,
MetaDataListener {
    private boolean text = false;
    private boolean icon = false;
    private boolean tips = false;
    private FeaturePair pair;
    private AbstractButton button;
    private String nameOverride = null;
    private String tipOverride = null;
    private CachedImageIcon trueIcon;
    private CachedImageIcon falseIcon;

    public void init(String prefix, FeaturePair pair, AbstractButton btn, Container parent) {
        super.init(prefix, (Feature)pair.getOn(), btn, parent);
        this.pair = pair;
        this.button = btn;
        this.trueIcon = new CachedImageIcon(new ImageSetter(){

            @Override
            public void setIcon(Icon i) {
                PairedFeatureAdapter.this.button.setSelectedIcon(i);
            }
        });
        this.falseIcon = new CachedImageIcon(new ImageSetter(){

            @Override
            public void setIcon(Icon i) {
                PairedFeatureAdapter.this.button.setIcon(i);
            }
        });
        this.nameOverride = (String)pair.getOn().getHintValue(".nameOverride", String.class);
        if (this.nameOverride == null) {
            this.nameOverride = (String)pair.getOff().getHintValue(".nameOverride", String.class);
        }
        this.tipOverride = (String)pair.getOn().getHintValue(".tooltipOverride", String.class);
        if (this.tipOverride == null) {
            this.tipOverride = (String)pair.getOff().getHintValue(".tooltipOverride", String.class);
        }
        pair.getOn().addMetaDataListener((MetaDataListener)this);
        pair.getOff().addMetaDataListener((MetaDataListener)this);
        this.button.setEnabled(pair.isEnabled());
        this.button.setSelected(pair.isSelected());
        this.button.addActionListener(this);
        this.setAccessibilityInfo(pair.getOn());
        this.setAccessibilityInfo(pair.getOff());
    }

    private void setAccessibilityInfo(ActionFeature feature) {
        String name = feature.getAccessibleName() != null ? feature.getAccessibleName() : feature.getName();
        String description = feature.getAccessibleDescription() != null ? feature.getAccessibleDescription() : feature.getDescription();
        AccessibilityUtils.setAccessibleInfo((Object)this.button, (String)name, (String)description);
    }

    @Override
    public void setHasText(boolean value) {
        if (this.text == value) {
            return;
        }
        this.text = value;
        if (this.text) {
            String txt = this.nameOverride = (String)this.pair.getOn().getHintValue(this.getHintName(".nameOverride"), String.class);
            if (this.pair.isSelected()) {
                if (txt == null) {
                    txt = this.pair.getOff().getName();
                }
                this.button.setText(txt);
            } else {
                if (txt == null) {
                    txt = this.pair.getOn().getName();
                }
                this.button.setText(txt);
            }
        } else {
            this.getButton().setText(null);
        }
    }

    public void setHasIcon(boolean value) {
        if (this.icon == value) {
            return;
        }
        this.icon = value;
        if (this.icon) {
            this.falseIcon.set(this.pair.getOn().getDefaultIcon());
            this.trueIcon.set(this.pair.getOff().getDefaultIcon());
        } else {
            this.getButton().setSelectedIcon(null);
            this.getButton().setIcon(null);
        }
    }

    @Override
    public void setHasToolTip(boolean value) {
        if (this.tips == value) {
            return;
        }
        this.tips = value;
        if (this.tips) {
            this.updateTip();
        } else {
            this.getButton().setToolTipText(null);
        }
    }

    public AbstractButton getButton() {
        return this.button;
    }

    @Override
    public Feature getFeature() {
        return this.pair.isSelected() ? this.pair.getOff() : this.pair.getOn();
    }

    @Override
    public void dispose() {
        this.button.removeActionListener(this);
        this.pair.getOn().removeMetaDataListener((MetaDataListener)this);
        this.pair.getOff().removeMetaDataListener((MetaDataListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (PlatformIssues.JWS_HAS_MULTIPLE_CONTEXTS) {
            SwingRunnerSupport.invokeOnEventThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    PairedFeatureAdapter.this.doPerformAction();
                }
            });
        } else {
            this.doPerformAction();
        }
    }

    private void doPerformAction() {
        this.updateState();
        if (this.pair.isEnabled()) {
            this.pair.setSelected(!this.pair.isSelected());
        }
    }

    private void updateText() {
        if (!this.text) {
            return;
        }
        String label = this.nameOverride;
        if (label == null) {
            label = this.pair.isSelected() ? this.pair.getOff().getName() : this.pair.getOn().getName();
        }
        if (label == null) {
            if (this.button.getText() != null) {
                this.button.setText(label);
            }
        } else if (!label.equals(this.button.getText())) {
            this.button.setText(label);
        }
    }

    private void updateTip() {
        if (!this.tips) {
            return;
        }
        String tooltip = this.tipOverride;
        if (tooltip == null) {
            tooltip = this.pair.isSelected() ? this.pair.getOff().getDescription() : this.pair.getOn().getDescription();
        }
        this.button.setToolTipText(tooltip);
    }

    @Override
    public void doMetaDataChanged(MetaDataEvent e) {
        String id = e.getID();
        if (id.equals("Feature.enabled")) {
            this.updateState();
        } else if (this.icon && id.equals("Action.dftIcon")) {
            if (e.getSourceFeature() == this.pair.getOn()) {
                this.falseIcon.set(this.pair.getOn().getDefaultIcon());
            } else {
                this.trueIcon.set(this.pair.getOff().getDefaultIcon());
            }
        } else if (this.text && id.equals("Feature.name")) {
            this.updateText();
        }
    }

    private void updateState() {
        this.button.setEnabled(this.pair.isEnabled());
        this.button.setSelected(this.pair.isSelected());
        this.updateText();
        this.updateTip();
    }

    private String getHintName(String hint) {
        return this.getHintPrefix() + hint;
    }
}

