/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.location;

import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.NumericFeature;
import com.elluminate.framework.location.FeatureAdapter;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import java.awt.Container;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class NumericLabelFeatureAdapter
extends FeatureAdapter {
    private NumericFeature feature;
    private JLabel label;
    private Logger log;

    @Inject
    public void initLogger(Logger l) {
        this.log = l;
    }

    public void initAdapter(String prefix, NumericFeature nf, JLabel lbl, Container c) {
        super.init(prefix, (Feature)nf, lbl, c);
        this.label = lbl;
        this.feature = nf;
        this.feature.addMetaDataListener((MetaDataListener)this);
        this.updateValue(nf.getValue().toString());
        if (nf.getDefaultIcon() != null) {
            this.updateIcon(nf.getDefaultIcon());
        }
    }

    @Override
    public void dispose() {
        this.getNumericFeature().removeMetaDataListener((MetaDataListener)this);
    }

    public NumericFeature getNumericFeature() {
        return this.feature;
    }

    @Override
    public void doMetaDataChanged(MetaDataEvent e) {
        String id = e.getID();
        if (!id.equals("Feature.name")) {
            if (id.equals("NumericFeature.defaultIcon")) {
                this.updateIcon(e.getNewValue());
            } else if (id.equals("ValueFeature.value")) {
                this.updateValue(e.getNewValue().toString());
            } else if (id.equals("Feature.description")) {
                this.updateToolTip();
            } else if (id.equals("Feature.enabled")) {
                this.label.setVisible(this.feature.isEnabled());
            }
        }
    }

    private void updateToolTip() {
        if (this.label != null) {
            this.label.setToolTipText(this.feature.getDescription());
        }
    }

    private void updateIcon(Object image) {
        if (image != null && image instanceof Image && this.label != null) {
            this.label.setIcon(new ImageIcon((Image)image));
        }
    }

    private void updateValue(String newValue) {
        if (this.label != null) {
            this.label.setText(newValue);
        }
    }

    @Override
    public void setHasText(boolean hasText) {
    }

    @Override
    public void setHasToolTip(boolean hasTip) {
    }
}

