/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.location;

import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.StringFeature;
import com.elluminate.framework.location.FeatureAdapter;
import com.elluminate.gui.AccessibilityUtils;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;

public class EnumStringFeatureAdapter
extends FeatureAdapter
implements ActionListener,
FocusListener {
    private EnumeratedFeature eFeature;
    private StringFeature sFeature;
    private JComboBox comboBox = null;
    private ComboBoxEditor editor = null;
    private boolean hideWhenDisabled = true;
    private Map<Object, Object> enumMap = new HashMap<Object, Object>();

    void init(String prefix, EnumeratedFeature ef, StringFeature sf, JComboBox item, Container parent) {
        super.init(prefix, (Feature)ef, item, parent);
        this.eFeature = ef;
        this.sFeature = sf;
        this.comboBox = item;
        this.comboBox.addActionListener(this);
        this.comboBox.setEditable(true);
        this.editor = this.comboBox.getEditor();
        this.editor.addActionListener(this);
        this.editor.getEditorComponent().addFocusListener(this);
        this.sFeature.addValueChangeListener((MetaDataListener)this);
        this.sFeature.addMetaDataListener("Feature.enabled", (MetaDataListener)this);
        this.eFeature.addMetaDataListener((MetaDataListener)this);
        this.hideWhenDisabled = true;
        if (item != null) {
            item.setEnabled(this.eFeature.isEnabled());
            if (this.hideWhenDisabled) {
                item.setVisible(this.eFeature.isEnabled());
            }
        }
        this.setContainerAccessibilityInfo();
    }

    private void setContainerAccessibilityInfo() {
        String name = this.eFeature.getAccessibleName() != null ? this.eFeature.getAccessibleName() : this.eFeature.getName();
        String description = this.eFeature.getAccessibleDescription() != null ? this.eFeature.getAccessibleDescription() : this.eFeature.getDescription();
        AccessibilityUtils.setAccessibleInfo((Object)this.comboBox, (String)name, (String)description);
    }

    public void addItem(Object val) {
        if (val == null) {
            throw new IllegalArgumentException("associated enum value is NULL: " + this.eFeature);
        }
        String item = this.eFeature.getValueText(val);
        this.enumMap.put(item, val);
        this.comboBox.removeActionListener(this);
        this.comboBox.addItem(item);
        this.comboBox.addActionListener(this);
        if (val.equals(this.eFeature.getValue())) {
            this.comboBox.setSelectedItem(item);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("comboBoxEdited")) {
            String str = (String)this.editor.getItem();
            this.sFeature.removeMetaDataListener((MetaDataListener)this);
            this.sFeature.setValue((Object)str);
            this.sFeature.addMetaDataListener((MetaDataListener)this);
        } else if (e.getActionCommand().equals("comboBoxChanged")) {
            Object val = this.enumMap.get(this.comboBox.getSelectedItem());
            if (val == null) {
                return;
            }
            this.eFeature.removeMetaDataListener((MetaDataListener)this);
            this.sFeature.removeMetaDataListener((MetaDataListener)this);
            this.eFeature.setValue(val);
            this.sFeature.setValue((Object)((String)this.comboBox.getSelectedItem()));
            this.eFeature.addMetaDataListener((MetaDataListener)this);
            this.sFeature.addMetaDataListener((MetaDataListener)this);
        }
    }

    @Override
    public void doMetaDataChanged(MetaDataEvent ev) {
        this.comboBox.removeActionListener(this);
        if (ev.getSource() == this.sFeature) {
            if (ev.getID().equals("Feature.enabled")) {
                boolean isEnabled = (Boolean)ev.getNewValue();
                this.comboBox.setEditable(isEnabled);
            } else {
                String str = (String)ev.getNewValue();
                if (!str.equals(this.comboBox.getSelectedItem())) {
                    this.comboBox.setSelectedItem(str);
                }
            }
        }
        this.comboBox.addActionListener(this);
    }

    @Override
    public void dispose() {
        this.eFeature.removeMetaDataListener((MetaDataListener)this);
        this.comboBox.removeActionListener(this);
        this.enumMap.clear();
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.editor.selectAll();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
    }

    @Override
    public void setHasText(boolean hasText) {
    }

    @Override
    public void setHasToolTip(boolean hasTip) {
    }
}

