/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.location;

import com.elluminate.framework.feature.AbstractFeature;
import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.location.FeatureAdapter;
import com.elluminate.gui.AccessibilityUtils;
import com.elluminate.platform.PlatformIssues;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;

public class EnumFeatureAdapter
extends FeatureAdapter
implements ActionListener {
    private EnumeratedFeature feature;
    private Container enumContainer = null;
    private boolean hideWhenDisabled = true;
    private boolean wantsText = false;
    private boolean wantsIcons = false;
    private Logger logger;
    private Map<Object, Object> enumMap = new HashMap<Object, Object>();

    @Inject
    public EnumFeatureAdapter(Logger logger) {
        this.logger = logger;
    }

    void init(String prefix, EnumeratedFeature f, Container item, Container parent) {
        super.init(prefix, (Feature)f, item, parent);
        this.feature = f;
        this.enumContainer = item == null ? parent : item;
        if (this.enumContainer instanceof JComboBox) {
            ((JComboBox)this.enumContainer).addActionListener(this);
        }
        this.hideWhenDisabled = true;
        if (item != null) {
            item.setEnabled(this.feature.isEnabled());
            if (this.hideWhenDisabled) {
                item.setVisible(this.feature.isEnabled());
            }
        }
        this.feature.addMetaDataListener((MetaDataListener)this);
        this.setContainerAccessibilityInfo();
    }

    private void setContainerAccessibilityInfo() {
        String name = this.feature.getAccessibleName() != null ? this.feature.getAccessibleName() : this.feature.getName();
        String description = this.feature.getAccessibleDescription() != null ? this.feature.getAccessibleDescription() : this.feature.getDescription();
        AccessibilityUtils.setAccessibleInfo((Object)this.enumContainer, (String)name, (String)description);
    }

    private void setItemAccessibilityInfo(AbstractButton btn, String accessibleName) {
        AccessibilityUtils.setAccessibleInfo((Object)btn, (String)accessibleName, null);
    }

    @Override
    public void setHasText(boolean b) {
        if (this.wantsText == b) {
            return;
        }
        this.wantsText = b;
        if (this.wantsText) {
            this.setText();
        } else if (this.enumContainer instanceof AbstractButton) {
            ((AbstractButton)this.enumContainer).setText(null);
        }
    }

    public void setText() {
        if (this.enumContainer instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)this.enumContainer;
            b.setText(this.feature.getName());
        }
    }

    public void setHasIcon(boolean b) {
        if (this.wantsIcons == b) {
            return;
        }
        this.wantsIcons = b;
        if (this.wantsIcons) {
            this.setIcon();
        } else if (this.enumContainer instanceof AbstractButton) {
            ((AbstractButton)this.enumContainer).setIcon(null);
        }
    }

    public void setIcon() {
        if (this.enumContainer instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)this.enumContainer;
            Image img = this.feature.getDefaultIcon();
            if (img != null) {
                b.setIcon(new ImageIcon(img));
            } else {
                b.setIcon(null);
            }
        }
    }

    public void addItem(AbstractButton button, Object val) {
        if (val == null) {
            throw new IllegalArgumentException("associated enum value is NULL: " + this.feature);
        }
        this.enumMap.put(button, val);
        button.addActionListener(this);
        if (this.wantsText) {
            String text = this.feature.getValueText(val);
            if (text == null && val != null) {
                text = val.toString();
            }
            button.setText(text);
            this.setItemAccessibilityInfo(button, text);
        }
        if (this.wantsIcons) {
            Image img = this.feature.getValueIconImage(val);
            ImageIcon icon = img == null ? null : new ImageIcon(img);
            button.setIcon(icon);
        }
        button.setSelected(val.equals(this.feature.getValue()));
        if (this.hideWhenDisabled) {
            button.setVisible(this.feature.isEnabled());
        }
        if (!this.feature.isMutable() && !this.feature.isChangeRequestSupported()) {
            button.setEnabled(false);
        }
        this.enumContainer.add(button);
    }

    public void addItem(Object val) {
        if (!(this.enumContainer instanceof JComboBox)) {
            throw new IllegalArgumentException("incompatible enum container type: " + this.enumContainer.getClass().getName());
        }
        if (val == null) {
            throw new IllegalArgumentException("associated enum value is NULL: " + this.feature);
        }
        String item = this.feature.getValueText(val);
        this.enumMap.put(item, val);
        JComboBox cb = (JComboBox)this.enumContainer;
        cb.removeActionListener(this);
        cb.addItem(item);
        cb.addActionListener(this);
        if (val.equals(this.feature.getValue())) {
            cb.setSelectedItem(item);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final Object src = e.getSource();
        if (PlatformIssues.JWS_HAS_MULTIPLE_CONTEXTS) {
            SwingRunnerSupport.invokeOnEventThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    EnumFeatureAdapter.this.doPerformAction(src);
                }
            });
        } else {
            this.doPerformAction(src);
        }
    }

    private void doPerformAction(Object src) {
        if (src instanceof JComboBox) {
            JComboBox cb = (JComboBox)this.enumContainer;
            Object val = this.enumMap.get(cb.getSelectedItem());
            if (val == null) {
                this.logger.error("Enumerated feature " + this.feature.getPath() + ": action event maps to null value");
                cb.setSelectedItem(null);
                return;
            }
            if (!val.equals(this.feature.getValue())) {
                if (this.feature.isChangeRequestSupported()) {
                    this.applySelection(this.feature.getValue());
                    this.feature.requestValue(val);
                } else {
                    this.feature.setValue(val);
                }
            }
        } else {
            AbstractButton button = (AbstractButton)src;
            Object val = this.enumMap.get(button);
            if (val == null) {
                this.logger.error("Enumerated feature " + this.feature.getPath() + ": action event maps to null value");
                button.setSelected(false);
                return;
            }
            if (!val.equals(this.feature.getValue())) {
                if (this.feature.isChangeRequestSupported()) {
                    this.applySelection(this.feature.getValue());
                    this.feature.requestValue(val);
                } else {
                    this.feature.setValue(val);
                }
            } else {
                button.setSelected(true);
            }
        }
    }

    private void applySelection(Object val) {
        if (this.enumContainer instanceof JComboBox) {
            String item = this.feature.getValueText(val);
            ((JComboBox)this.enumContainer).setSelectedItem(item);
        } else {
            for (Object button : this.enumMap.keySet()) {
                if (button == null) continue;
                ((AbstractButton)button).setSelected(val != null && val.equals(this.enumMap.get(button)));
            }
        }
    }

    @Override
    public void doMetaDataChanged(MetaDataEvent ev) {
        String id = ev.getID();
        if (id.equals("ValueFeature.value")) {
            String valueText;
            Object val = ev.getNewValue();
            this.applySelection(val);
            if (this.enumContainer != null && (valueText = this.feature.getValueText(val)) != null) {
                valueText = valueText.replace("&", "");
                this.enumContainer.getAccessibleContext().firePropertyChange("AccessibleDescription", "", valueText);
            }
        } else if (id.equals("Feature.enabled")) {
            Component cmp = this.getComponent();
            if (cmp != null) {
                cmp.setEnabled(this.feature.isEnabled());
                if (this.hideWhenDisabled) {
                    cmp.setVisible(this.feature.isEnabled());
                }
            }
            if (!(cmp instanceof JComboBox)) {
                for (Object obj : this.enumMap.keySet()) {
                    AbstractButton button = (AbstractButton)obj;
                    if (button == null) continue;
                    button.setEnabled(this.feature.isEnabled());
                    if (!this.hideWhenDisabled) continue;
                    button.setVisible(this.feature.isEnabled());
                }
            }
        } else if (id.equals("Feature.name")) {
            Component cmp;
            if (this.wantsText && (cmp = this.getComponent()) != null && cmp instanceof AbstractButton) {
                this.setButtonText((AbstractButton)cmp, (AbstractFeature)this.feature);
            }
        } else if ("EnumeratedFeature.valueText" == id) {
            if (this.wantsText && !(this.enumContainer instanceof JComboBox)) {
                for (Object obj : this.enumMap.keySet()) {
                    AbstractButton button = (AbstractButton)obj;
                    Object val = this.enumMap.get(button);
                    if (val == null) continue;
                    String text = this.feature.getValueText(val);
                    if (text == null && val != null) {
                        this.logger.message((Object)this, "addItem", "Feature item " + this.feature + " has no per-value display text for " + val + ", using toString text.");
                        text = val.toString();
                    }
                    button.setText(text);
                }
            }
        } else if ("EnumeratedFeature.valueIconImage" == id) {
            if (this.wantsIcons && !(this.enumContainer instanceof JComboBox)) {
                for (Object obj : this.enumMap.keySet()) {
                    AbstractButton button = (AbstractButton)obj;
                    Object val = this.enumMap.get(button);
                    if (val == null) continue;
                    Image img = this.feature.getValueIconImage(val);
                    ImageIcon icon = img == null ? null : new ImageIcon(img);
                    button.setIcon(icon);
                }
            }
        } else if ("EnumeratedFeature.defaultIcon" == id && this.wantsIcons) {
            this.setIcon();
        }
    }

    @Override
    public void dispose() {
        this.feature.removeMetaDataListener((MetaDataListener)this);
        if (this.enumContainer instanceof JComboBox) {
            ((JComboBox)this.enumContainer).removeActionListener(this);
        } else {
            for (Object obj : this.enumMap.keySet()) {
                AbstractButton button = (AbstractButton)obj;
                if (button == null) continue;
                button.removeActionListener(this);
                this.enumContainer.remove(button);
            }
        }
        this.enumMap.clear();
    }

    private void setButtonText(AbstractButton button, AbstractFeature feature) {
        if (!this.wantsText) {
            return;
        }
        String text = this.getNameOverride();
        if (text == null) {
            text = feature.getName();
        }
        button.setText(text);
    }

    @Override
    public void setHasToolTip(boolean hasTip) {
    }
}

