/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.hand.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.hand.module.HandAnnotationHandler;
import com.elluminate.groupware.hand.module.HandBean;
import com.elluminate.groupware.hand.module.HandEmoticonAnnotations;
import com.elluminate.groupware.hand.module.HandPublisher;
import com.elluminate.groupware.hand.module.LowerHandCmd;
import com.elluminate.groupware.hand.module.RaiseHandCmd;
import com.elluminate.groupware.hand.module.ShowEmotionCmd;
import com.elluminate.groupware.hand.module.StringsProperties;
import com.elluminate.groupware.imps.ParticipantSelectionListener;
import com.elluminate.groupware.imps.ParticipantSelectorAPI;
import com.elluminate.groupware.imps.TelephonyAPI;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class HandModule
extends AbstractClientModule
implements PropertyChangeListener,
ParticipantSelectionListener,
ModulePublisherInfo {
    private static final String MODULE_NAME = "Hand";
    private I18n i18n = I18n.create((Object)this);
    private HandBean handBean = null;
    private ClientList clients = null;
    private HandPublisher msgPublisher;
    private Provider<HandBean> beanProvider;
    private Provider<LowerHandCmd> lowerHandCmdProvider;
    private Provider<RaiseHandCmd> raiseHandCmdProvider;
    private Provider<ShowEmotionCmd> showEmotionCmdProvider;
    private ClientProvider clientProvider;
    private ConferencingEngine confEngine;
    private FeatureBroker broker;
    private ParticipantSelectorAPI selector = null;
    private Imps imps;
    private ActionFeature lowerHandFeature;
    private ActionFeature lowerAllFeature;
    private BooleanFeature raiseLowerHandFeature;
    private BooleanFeature autoRaiseFeature;
    private CRSession session;
    private Provider<HandAnnotationHandler> handAnnotationHandlerProvider = null;
    private EnumeratedFeature<Integer> emoticonFeature = null;
    private boolean updating = false;
    private HandEmoticonAnnotations handEmoticonAnnotations = null;
    private MetaDataListener emoticonChangeListener = null;
    private ChairProtocol chairProtocol;

    @Inject
    public HandModule(ComponentRegistrar registrar, ConferencingEngine ce) {
        registrar.registerComponent((Object)this);
        this.confEngine = ce;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initHandBeanProvider(Provider<HandBean> beanProvider) {
        this.beanProvider = beanProvider;
    }

    @Inject
    protected void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public void initChairProtocol(ChairProtocol chairProtocol) {
        this.chairProtocol = chairProtocol;
    }

    @Inject
    public void initHandCmdProviders(Provider<LowerHandCmd> lowerHandCmdProvider, Provider<RaiseHandCmd> raiseHandCmdProvider, Provider<ShowEmotionCmd> showEmotionCmdProvider) {
        this.lowerHandCmdProvider = lowerHandCmdProvider;
        this.raiseHandCmdProvider = raiseHandCmdProvider;
        this.showEmotionCmdProvider = showEmotionCmdProvider;
    }

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    protected void initSession(CRSession session) {
        this.session = session;
    }

    @Inject
    public void initHandAnnotationHandlerProvider(Provider<HandAnnotationHandler> handAnnotationHandlerProvider) {
        this.handAnnotationHandlerProvider = handAnnotationHandlerProvider;
    }

    @Inject
    public void initHandPublisher(HandPublisher msgPublisher) {
        this.msgPublisher = msgPublisher;
    }

    public String getNameOfModule() {
        return MODULE_NAME;
    }

    public String getDisplayNameOfModule() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.HANDMODULE_TITLE);
    }

    public Icon getModuleIcon() {
        return this.i18n.getIcon("HandModule.moduleIcon");
    }

    protected HandBean getHandBean() {
        return this.handBean;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("hand.count")) {
            if (e.getOldValue() == null || e.getNewValue() == null) {
                // empty if block
            }
            if (e.getNewValue() != null && e.getNewValue() instanceof Number) {
                // empty if block
            }
        } else if (e.getPropertyName().equals("chair")) {
            this.updateFeatures();
        }
    }

    public void participantSelectionChanged() {
        ClientInfo[] selectedClients = this.getSelectedClients();
        boolean hasBridgeSelected = this.getHasBridgeSelected(selectedClients);
        if (hasBridgeSelected) {
            this.broker.setFeaturePublished((Feature)this.lowerHandFeature, false);
        }
    }

    private boolean getHasBridgeSelected(ClientInfo[] selectedClients) {
        boolean hasBridgeSelected = false;
        TelephonyAPI telephony = (TelephonyAPI)this.imps.findBest(TelephonyAPI.class);
        if (telephony != null && selectedClients != null) {
            for (int ix = 0; !hasBridgeSelected && ix < selectedClients.length; ++ix) {
                hasBridgeSelected = telephony.isBridge(selectedClients[ix].getAddress());
            }
        }
        return hasBridgeSelected;
    }

    private ClientInfo[] getSelectedClients() {
        List selectedClients = this.selector != null ? this.selector.getSelectedClients() : new ArrayList();
        ClientInfo[] info = new ClientInfo[selectedClients.size()];
        return selectedClients.toArray(info);
    }

    public void setHandFeatureValue(boolean raiseHand) {
        this.raiseLowerHandFeature.setValue((Object)raiseHand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFeatures() {
        boolean handRaised = this.handBean.isHandRaised();
        boolean autoRaise = this.handBean.isRaiseOnJoinEnabled();
        boolean isChair = this.chairProtocol.fetchChair(this.clients).isMe();
        HandModule handModule = this;
        synchronized (handModule) {
            if (this.updating) {
                return;
            }
            this.updating = true;
        }
        if (this.createFeatures(handRaised, autoRaise)) {
            this.raiseLowerHandFeature.setEnabled(true);
            this.emoticonFeature.setEnabled(true);
            this.broker.setFeaturePublished((Feature)this.raiseLowerHandFeature, true);
            this.broker.setFeaturePublished(this.emoticonFeature, true);
        } else {
            this.raiseLowerHandFeature.setValue((Object)handRaised);
            this.autoRaiseFeature.setValue((Object)autoRaise);
        }
        this.lowerHandFeature.setEnabled(isChair);
        this.lowerAllFeature.setEnabled(isChair);
        this.autoRaiseFeature.setEnabled(isChair);
        this.broker.setFeaturePublished((Feature)this.lowerHandFeature, isChair);
        this.broker.setFeaturePublished((Feature)this.lowerAllFeature, isChair);
        this.broker.setFeaturePublished((Feature)this.autoRaiseFeature, isChair);
        handModule = this;
        synchronized (handModule) {
            this.updating = false;
        }
    }

    private boolean createFeatures(boolean handRaised, boolean autoRaise) {
        if (this.raiseLowerHandFeature != null) {
            return false;
        }
        this.raiseLowerHandFeature = this.broker.createBooleanFeature((Object)this, "/hand/raise", true, false, this.i18n.getString((PropertiesEnum)StringsProperties.HANDBEAN_RAISEHAND_ACCESSIBLENAME), this.i18n.getString((PropertiesEnum)StringsProperties.HANDBEAN_RAISETIP));
        this.raiseLowerHandFeature.setFalseIcon(this.i18n.getImage("HandModule.handIcon"));
        this.raiseLowerHandFeature.setTrueIcon(this.i18n.getImage("HandModule.handIcon"));
        this.raiseLowerHandFeature.addHint("badge", (Object)"HandRaiseAnnotation");
        this.raiseLowerHandFeature.addHint("JAWSTrue", (Object)this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_TYPE_HAND_UP));
        this.raiseLowerHandFeature.addHint("JAWSFalse", (Object)this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_TYPE_HAND_DOWN));
        this.raiseLowerHandFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_TYPE_HAND_UP));
        this.raiseLowerHandFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.HANDPUBLISHER_TYPE_HAND_DOWN));
        this.raiseLowerHandFeature.setValue((Object)handRaised);
        this.raiseLowerHandFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent event) {
                ClientInfo myClient = HandModule.this.clients.getMyClient();
                if (((Boolean)HandModule.this.raiseLowerHandFeature.getValue()).booleanValue()) {
                    HandModule.this.handBean.raiseHand();
                    HandModule.this.raiseLowerHandFeature.setDescription(HandModule.this.i18n.getString((PropertiesEnum)StringsProperties.HANDBEAN_LOWERTIP));
                } else {
                    HandModule.this.handBean.lowerHand(myClient);
                    HandModule.this.raiseLowerHandFeature.setDescription(HandModule.this.i18n.getString((PropertiesEnum)StringsProperties.HANDBEAN_RAISETIP));
                }
            }
        });
        this.lowerHandFeature = this.broker.createActionFeature((Object)this, "/hand/lower", this.i18n.getString((PropertiesEnum)StringsProperties.HANDMODULE_AUXLOWERMENU), this.i18n.getString((PropertiesEnum)StringsProperties.HANDMODULE_AUXLOWERMENU));
        this.lowerHandFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ClientInfo[] selectedClients = HandModule.this.getSelectedClients();
                boolean hasBridgeSelected = HandModule.this.getHasBridgeSelected(selectedClients);
                if (selectedClients != null && !hasBridgeSelected) {
                    if (selectedClients.length == 1) {
                        HandModule.this.handBean.lowerHand(selectedClients[0]);
                    } else if (selectedClients.length > 1) {
                        for (ClientInfo ci : selectedClients) {
                            if (ci == null) continue;
                            HandModule.this.handBean.lowerHand(ci);
                        }
                    }
                }
                HandModule.this.handBean.lowerHand(null);
            }
        });
        this.lowerAllFeature = this.broker.createActionFeature((Object)this, "/hand/lowerAll", this.i18n.getString((PropertiesEnum)StringsProperties.HANDMODULE_AUXMENULOWERALL), this.i18n.getString((PropertiesEnum)StringsProperties.HANDMODULE_AUXMENULOWERALL));
        this.lowerAllFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                HandModule.this.handBean.lowerAllHands();
            }
        });
        this.autoRaiseFeature = this.broker.createBooleanFeature((Object)this, "/hand/handAutoRaise", true, false, this.i18n.getString((PropertiesEnum)StringsProperties.HANDBEAN_AUTORAISETITLE), this.i18n.getString((PropertiesEnum)StringsProperties.HANDBEAN_AUTORAISETOOLTIP));
        this.autoRaiseFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.HANDBEAN_AUTORAISETITLE));
        this.autoRaiseFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.HANDBEAN_AUTORAISETITLE));
        this.autoRaiseFeature.setValue((Object)autoRaise);
        this.autoRaiseFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                if (((Boolean)HandModule.this.autoRaiseFeature.getValue()).booleanValue()) {
                    HandModule.this.handBean.setAutoRaise(true);
                } else {
                    HandModule.this.handBean.setAutoRaise(false);
                }
            }
        });
        this.createEmotionFeature();
        return true;
    }

    private void createEmotionFeature() {
        Object[] supported = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 0};
        this.emoticonFeature = this.broker.createEnumeratedFeature((Object)this, "/hand/emoticon", Integer.class, true, (Object)0, supported, this.i18n.getString((PropertiesEnum)StringsProperties.HANDBEAN_EMOTICONMENU), this.i18n.getString((PropertiesEnum)StringsProperties.HANDBEAN_EMOTIONTOOLTIP));
        this.emoticonFeature.setDefaultIcon(this.i18n.getImage("HandBean.emoticonButtonIcon"));
        this.emoticonFeature.setValueText((Object)1, this.i18n.getString((PropertiesEnum)StringsProperties.HANDBEAN_SMILEMENU));
        this.emoticonFeature.setValueIconImage((Object)1, this.i18n.getImage("HandBean.smileIcon"));
        this.emoticonFeature.setValueText((Object)2, this.i18n.getString((PropertiesEnum)StringsProperties.HANDBEAN_LAUGHMENU));
        this.emoticonFeature.setValueIconImage((Object)2, this.i18n.getImage("HandBean.laughIcon"));
        this.emoticonFeature.setValueText((Object)3, this.i18n.getString((PropertiesEnum)StringsProperties.HANDBEAN_CLAPMENU));
        this.emoticonFeature.setValueIconImage((Object)3, this.i18n.getImage("HandBean.clapIcon"));
        this.emoticonFeature.setValueText((Object)4, this.i18n.getString((PropertiesEnum)StringsProperties.HANDBEAN_CONFUSEDMENU));
        this.emoticonFeature.setValueIconImage((Object)4, this.i18n.getImage("HandBean.confusedIcon"));
        this.emoticonFeature.setValueText((Object)5, this.i18n.getString((PropertiesEnum)StringsProperties.HANDBEAN_APPROVEMENU));
        this.emoticonFeature.setValueIconImage((Object)5, this.i18n.getImage("HandBean.approveIcon"));
        this.emoticonFeature.setValueText((Object)6, this.i18n.getString((PropertiesEnum)StringsProperties.HANDBEAN_ANGRYMENU));
        this.emoticonFeature.setValueIconImage((Object)6, this.i18n.getImage("HandBean.angryIcon"));
        this.emoticonFeature.setValueText((Object)7, this.i18n.getString((PropertiesEnum)StringsProperties.HANDBEAN_SLOWERMENU));
        this.emoticonFeature.setValueIconImage((Object)7, this.i18n.getImage("HandBean.slowerIcon"));
        this.emoticonFeature.setValueText((Object)8, this.i18n.getString((PropertiesEnum)StringsProperties.HANDBEAN_FASTERMENU));
        this.emoticonFeature.setValueIconImage((Object)8, this.i18n.getImage("HandBean.fasterIcon"));
        this.emoticonFeature.setValueText((Object)0, this.i18n.getString((PropertiesEnum)StringsProperties.HANDBEAN_NOEMOTICONMENU));
        this.emoticonFeature.setValueIconImage((Object)0, this.i18n.getImage("HandBean.noEmoticonIcon"));
        this.emoticonFeature.setValue((Object)0);
        this.handEmoticonAnnotations = new HandEmoticonAnnotations(this.session, this.clients, this.emoticonFeature, this.i18n, this.msgPublisher);
        this.emoticonChangeListener = new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                int request = 0;
                if (ev != null && ev.getNewValue() != null) {
                    request = (Integer)ev.getNewValue();
                }
                HandModule.this.handBean.setEmotion(request);
            }
        };
        this.emoticonFeature.addValueChangeListener(this.emoticonChangeListener);
    }

    public void start() {
    }

    public void attach() {
        this.handBean = (HandBean)this.beanProvider.get();
        this.session.registerAnnotation("EmoticonAnnotation", (Object)0);
        this.clients = this.clientProvider.get().getClientList();
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        this.confEngine.registerCommand(this.lowerHandCmdProvider);
        this.confEngine.registerCommand(this.raiseHandCmdProvider);
        this.confEngine.registerCommand(this.showEmotionCmdProvider);
    }

    public void setupUI() {
        this.selector = (ParticipantSelectorAPI)this.imps.findBest(ParticipantSelectorAPI.class);
        if (this.selector != null) {
            this.selector.addSelectionListener((ParticipantSelectionListener)this);
        }
        ((HandAnnotationHandler)this.handAnnotationHandlerProvider.get()).setup(this.handBean);
    }

    public void cleanupUI() {
        ((HandAnnotationHandler)this.handAnnotationHandlerProvider.get()).cleanup();
    }

    public void detach() {
        this.session.deRegisterAnnotation("EmoticonAnnotation");
        this.clients.removePropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients = null;
        this.handBean.dispose();
        this.handBean = null;
    }

    public void stop() {
    }
}

