/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.AbstractRemotelyCallable;
import com.hazelcast.cluster.AbstractRemotelyProcessable;
import com.hazelcast.cluster.ClusterManager;
import com.hazelcast.cluster.MemberInfo;
import com.hazelcast.cluster.RemotelyProcessable;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.Member;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.base.DataRecordEntry;
import com.hazelcast.impl.base.RecordSet;
import com.hazelcast.impl.base.SystemLogService;
import com.hazelcast.impl.concurrentmap.CostAwareRecordList;
import com.hazelcast.impl.concurrentmap.ValueHolder;
import com.hazelcast.impl.partition.MemberGroupFactory;
import com.hazelcast.impl.partition.MigratingPartition;
import com.hazelcast.impl.partition.MigrationNotification;
import com.hazelcast.impl.partition.MigrationRequestTask;
import com.hazelcast.impl.partition.MigrationStatus;
import com.hazelcast.impl.partition.PartitionInfo;
import com.hazelcast.impl.partition.PartitionListener;
import com.hazelcast.impl.partition.PartitionReplicaChangeEvent;
import com.hazelcast.impl.partition.PartitionRuntimeState;
import com.hazelcast.impl.partition.PartitionStateGenerator;
import com.hazelcast.impl.partition.PartitionStateGeneratorFactory;
import com.hazelcast.impl.partition.PartitionStateProcessable;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.partition.MigrationEvent;
import com.hazelcast.util.Clock;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public class PartitionManager {
    public static final String MIGRATION_EXECUTOR_NAME = "hz.migration";
    private static final long MIGRATING_PARTITION_CHECK_INTERVAL = TimeUnit.SECONDS.toMillis(300L);
    private static final long REPARTITIONING_CHECK_INTERVAL = TimeUnit.SECONDS.toMillis(300L);
    private static final int REPARTITIONING_TASK_COUNT_THRESHOLD = 20;
    private static final int REPARTITIONING_TASK_REPLICA_THRESHOLD = 2;
    private final ConcurrentMapManager concurrentMapManager;
    private final ILogger logger;
    private final int partitionCount;
    private final PartitionInfo[] partitions;
    private volatile MigratingPartition migratingPartition;
    private volatile boolean initialized = false;
    private final AtomicInteger version = new AtomicInteger();
    private final List<PartitionListener> lsPartitionListeners = new CopyOnWriteArrayList<PartitionListener>();
    private final int partitionMigrationInterval;
    private final long partitionMigrationTimeout;
    private final int immediateBackupInterval;
    private final MigrationService migrationService;
    private boolean running = true;
    private final BlockingQueue<Runnable> immediateTasksQueue = new LinkedBlockingQueue<Runnable>();
    private final Queue<Runnable> scheduledTasksQueue = new LinkedBlockingQueue<Runnable>();
    private final AtomicBoolean sendingDiffs = new AtomicBoolean(false);
    private final AtomicBoolean migrationActive = new AtomicBoolean(true);
    private final AtomicLong lastRepartitionTime = new AtomicLong();
    private final SystemLogService systemLogService;

    public PartitionManager(final ConcurrentMapManager concurrentMapManager) {
        this.partitionCount = concurrentMapManager.getPartitionCount();
        this.concurrentMapManager = concurrentMapManager;
        this.logger = concurrentMapManager.node.getLogger(PartitionManager.class.getName());
        this.partitions = new PartitionInfo[this.partitionCount];
        final Node node = concurrentMapManager.node;
        this.systemLogService = node.getSystemLogService();
        for (int i = 0; i < this.partitionCount; ++i) {
            this.partitions[i] = new PartitionInfo(i, new PartitionListener(){

                public void replicaChanged(PartitionReplicaChangeEvent event) {
                    for (PartitionListener partitionListener : PartitionManager.this.lsPartitionListeners) {
                        partitionListener.replicaChanged(event);
                    }
                    if (event.getReplicaIndex() == 0 && event.getNewAddress() == null && node.isActive() && node.joined()) {
                        String warning = "Owner of partition is being removed! Possible data loss for partition[" + event.getPartitionId() + "]. " + event;
                        PartitionManager.this.logger.log(Level.WARNING, warning);
                        PartitionManager.this.systemLogService.logPartition(warning);
                    }
                    if (concurrentMapManager.isMaster()) {
                        PartitionManager.this.version.incrementAndGet();
                    }
                }
            });
        }
        this.partitionMigrationInterval = node.groupProperties.PARTITION_MIGRATION_INTERVAL.getInteger() * 1000;
        this.partitionMigrationTimeout = (long)((float)node.groupProperties.PARTITION_MIGRATION_TIMEOUT.getLong() * 1.5f);
        this.immediateBackupInterval = node.groupProperties.IMMEDIATE_BACKUP_INTERVAL.getInteger() * 1000;
        this.migrationService = new MigrationService(node);
        this.migrationService.start();
        int partitionTableSendInterval = node.groupProperties.PARTITION_TABLE_SEND_INTERVAL.getInteger();
        if (partitionTableSendInterval <= 0) {
            partitionTableSendInterval = 1;
        }
        node.executorManager.getScheduledExecutorService().scheduleAtFixedRate(new SendClusterStateTask(), partitionTableSendInterval, partitionTableSendInterval, TimeUnit.SECONDS);
        node.executorManager.getScheduledExecutorService().scheduleAtFixedRate(new CheckMigratingPartitionTask(), partitionTableSendInterval, partitionTableSendInterval, TimeUnit.SECONDS);
        node.executorManager.getScheduledExecutorService().scheduleAtFixedRate(new Runnable(){

            public void run() {
                if (concurrentMapManager.isMaster() && node.isActive() && PartitionManager.this.initialized && PartitionManager.this.shouldCheckRepartitioning()) {
                    PartitionManager.this.logger.log(Level.FINEST, "Checking partition table for repartitioning...");
                    PartitionManager.this.immediateTasksQueue.add(new CheckRepartitioningTask());
                }
            }
        }, 180L, 180L, TimeUnit.SECONDS);
    }

    public MigratingPartition getMigratingPartition() {
        return this.migratingPartition;
    }

    public void addPartitionListener(PartitionListener partitionListener) {
        this.lsPartitionListeners.add(partitionListener);
    }

    public PartitionInfo[] getPartitions() {
        return this.partitions;
    }

    public Address getOwner(int partitionId) {
        Address owner;
        this.concurrentMapManager.checkServiceThread();
        if (!this.initialized) {
            this.firstArrangement();
        }
        if ((owner = this.partitions[partitionId].getOwner()) == null && !this.concurrentMapManager.isMaster()) {
            this.concurrentMapManager.sendProcessableTo((RemotelyProcessable)new AssignPartitions(), this.concurrentMapManager.getMasterAddress());
        }
        return owner;
    }

    public void firstArrangement() {
        this.concurrentMapManager.checkServiceThread();
        if (!this.concurrentMapManager.isMaster() || !this.concurrentMapManager.isActive()) {
            return;
        }
        if (!this.hasStorageMember()) {
            return;
        }
        if (!this.initialized) {
            PartitionStateGenerator psg = this.getPartitionStateGenerator();
            this.logger.log(Level.INFO, "Initializing cluster partition table first arrangement...");
            PartitionInfo[] newState = psg.initialize(this.concurrentMapManager.lsMembers, this.partitionCount);
            if (newState != null) {
                for (PartitionInfo partitionInfo : newState) {
                    this.partitions[partitionInfo.getPartitionId()].setPartitionInfo(partitionInfo);
                }
            }
            this.sendPartitionRuntimeState();
            this.initialized = true;
        }
    }

    private void sendPartitionRuntimeState() {
        if (!(this.concurrentMapManager.isMaster() && this.concurrentMapManager.isActive() && this.concurrentMapManager.node.joined())) {
            return;
        }
        if (!this.migrationActive.get()) {
            return;
        }
        if (!this.initialized) {
            return;
        }
        long clusterTime = this.concurrentMapManager.node.getClusterImpl().getClusterTime();
        List lsMembers = this.concurrentMapManager.lsMembers;
        ArrayList<MemberInfo> memberInfos = new ArrayList<MemberInfo>(lsMembers.size());
        for (MemberImpl member : lsMembers) {
            memberInfos.add(new MemberInfo(member.getAddress(), member.getNodeType(), member.getUuid()));
        }
        PartitionStateProcessable processable = new PartitionStateProcessable(memberInfos, this.partitions, clusterTime, this.version.get());
        this.concurrentMapManager.sendProcessableToAll(processable, false);
    }

    private PartitionStateGenerator getPartitionStateGenerator() {
        return PartitionStateGeneratorFactory.newConfigPartitionStateGenerator(this.concurrentMapManager.node.getConfig().getPartitionGroupConfig());
    }

    public CostAwareRecordList getActivePartitionRecords(final int partitionId, final int replicaIndex, final Address newAddress, boolean diffOnly) {
        final Address thisAddress = this.concurrentMapManager.node.getThisAddress();
        this.concurrentMapManager.enqueueAndWait(new Processable(){

            public void process() {
                PartitionManager.this.addActiveMigration(partitionId, replicaIndex, thisAddress, newAddress);
            }
        });
        long now = Clock.currentTimeMillis();
        Collection cmaps = this.concurrentMapManager.maps.values();
        CostAwareRecordList lsResultSet = new CostAwareRecordList(1000);
        for (CMap cmap : cmaps) {
            boolean bl = diffOnly ? cmap.getTotalBackupCount() == replicaIndex : cmap.getTotalBackupCount() >= replicaIndex;
            boolean includeCMap = bl;
            if (!includeCMap) continue;
            for (Record rec : cmap.mapRecords.values()) {
                if (!rec.isActive() || !rec.isValid(now)) continue;
                if (rec.getKeyData() == null || rec.getKeyData().size() == 0) {
                    throw new RuntimeException("Record.key is null or empty " + rec.getKeyData());
                }
                if (rec.getBlockId() != partitionId) continue;
                cmap.onMigrate(rec);
                if (cmap.isMultiMap()) {
                    Collection<ValueHolder> colValues = rec.getMultiValues();
                    if (colValues != null) {
                        for (ValueHolder valueHolder : colValues) {
                            Record record = rec.copy();
                            record.setValueData(valueHolder.getData());
                            lsResultSet.add(record);
                        }
                    }
                } else {
                    lsResultSet.add(rec);
                }
                lsResultSet.addCost(rec.getCost());
            }
        }
        return lsResultSet;
    }

    private void addActiveMigration(MigratingPartition migrationRequestTask) {
        this.addActiveMigration(migrationRequestTask.getPartitionId(), migrationRequestTask.getReplicaIndex(), migrationRequestTask.getFromAddress(), migrationRequestTask.getToAddress());
    }

    private void addActiveMigration(int partitionId, int replicaIndex, Address currentAddress, Address newAddress) {
        this.concurrentMapManager.checkServiceThread();
        MigratingPartition currentMigratingPartition = this.migratingPartition;
        MigratingPartition newMigratingPartition = new MigratingPartition(partitionId, replicaIndex, currentAddress, newAddress);
        if (!newMigratingPartition.equals(currentMigratingPartition)) {
            if (currentMigratingPartition != null) {
                this.logger.log(Level.FINEST, "Replacing current " + currentMigratingPartition + " with " + newMigratingPartition);
            }
            this.migratingPartition = newMigratingPartition;
        }
    }

    private void compareAndSetActiveMigratingPartition(MigratingPartition expectedMigratingPartition, MigratingPartition newMigratingPartition) {
        this.concurrentMapManager.checkServiceThread();
        if (expectedMigratingPartition == null) {
            if (this.migratingPartition == null) {
                this.migratingPartition = newMigratingPartition;
            }
        } else if (expectedMigratingPartition.equals(this.migratingPartition)) {
            this.migratingPartition = newMigratingPartition;
        }
    }

    public void doMigrate(final int partitionId, final int replicaIndex, final RecordSet recordSet, final Address from) {
        this.concurrentMapManager.enqueueAndWait(new Processable(){

            public void process() {
                PartitionManager.this.addActiveMigration(partitionId, replicaIndex, from, ((PartitionManager)PartitionManager.this).concurrentMapManager.thisAddress);
                for (DataRecordEntry dataRecordEntry : recordSet.getRecords()) {
                    CMap cmap = PartitionManager.this.concurrentMapManager.getOrCreateMap(dataRecordEntry.getName());
                    if (replicaIndex == 0) {
                        cmap.own(dataRecordEntry);
                        continue;
                    }
                    cmap.storeAsBackup(dataRecordEntry);
                }
            }
        });
    }

    public MemberImpl getMember(Address address) {
        if (address != null) {
            for (Member member : this.concurrentMapManager.node.getClusterImpl().getMembers()) {
                MemberImpl memberImpl = (MemberImpl)member;
                if (!memberImpl.getAddress().equals(address)) continue;
                return memberImpl;
            }
        }
        return null;
    }

    public void reset() {
        this.initialized = false;
        this.clearTaskQueues();
        this.migratingPartition = null;
        for (PartitionInfo partition : this.partitions) {
            for (int i = 0; i < 7; ++i) {
                partition.setReplicaAddress(i, null);
            }
        }
        this.version.set(0);
    }

    private void clearTaskQueues() {
        this.immediateTasksQueue.clear();
        this.scheduledTasksQueue.clear();
    }

    public void shutdown() {
        this.logger.log(Level.FINEST, "Shutting down the partition manager");
        try {
            this.clearTaskQueues();
            final CountDownLatch stopLatch = new CountDownLatch(1);
            this.immediateTasksQueue.offer(new Runnable(){

                public void run() {
                    PartitionManager.this.running = false;
                    stopLatch.countDown();
                }
            });
            stopLatch.await(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean hasStorageMember() {
        for (MemberImpl member : this.concurrentMapManager.lsMembers) {
            if (member.isLiteMember()) continue;
            return true;
        }
        return false;
    }

    public void syncForDead(MemberImpl deadMember) {
        Address deadAddress = deadMember.getAddress();
        Address thisAddress = this.concurrentMapManager.getThisAddress();
        if (deadAddress == null || deadAddress.equals(thisAddress)) {
            return;
        }
        if (!this.hasStorageMember()) {
            this.reset();
        }
        final boolean migrationStatus = this.migrationActive.getAndSet(false);
        this.concurrentMapManager.partitionServiceImpl.reset();
        this.checkMigratingPartitionForDead(deadAddress);
        int[] indexesOfDead = new int[this.partitions.length];
        for (PartitionInfo partition : this.partitions) {
            indexesOfDead[partition.getPartitionId()] = partition.getReplicaIndexOf(deadAddress);
        }
        if (!deadMember.isLiteMember()) {
            this.clearTaskQueues();
            for (PartitionInfo partition : this.partitions) {
                while (partition.onDeadAddress(deadAddress)) {
                }
            }
        }
        this.fixCMapsForDead(deadAddress, indexesOfDead);
        this.fixReplicasAndPartitionsForDead(deadMember, indexesOfDead);
        Node node = this.concurrentMapManager.node;
        long waitBeforeMigrationActivate = node.groupProperties.CONNECTION_MONITOR_INTERVAL.getLong() * (long)node.groupProperties.CONNECTION_MONITOR_MAX_FAULTS.getInteger() * 10L;
        node.executorManager.getScheduledExecutorService().schedule(new Runnable(){

            public void run() {
                PartitionManager.this.migrationActive.compareAndSet(false, migrationStatus);
            }
        }, waitBeforeMigrationActivate, TimeUnit.MILLISECONDS);
    }

    private void fixReplicasAndPartitionsForDead(MemberImpl deadMember, int[] indexesOfDead) {
        if (!deadMember.isLiteMember() && this.concurrentMapManager.isMaster() && this.concurrentMapManager.isActive()) {
            this.sendingDiffs.set(true);
            this.logger.log(Level.INFO, "Starting to send partition replica diffs..." + this.sendingDiffs.get());
            int diffCount = 0;
            int maxBackupCount = this.getMaxBackupCount();
            for (int partitionId = 0; partitionId < indexesOfDead.length; ++partitionId) {
                int indexOfDead = indexesOfDead[partitionId];
                if (indexOfDead == -1) continue;
                PartitionInfo partition = this.partitions[partitionId];
                Address owner = partition.getOwner();
                if (owner == null) {
                    this.logger.log(Level.FINEST, "Owner of one of the replicas of Partition[" + partitionId + "] is dead, but partition owner " + "could not be found either!");
                    this.logger.log(Level.FINEST, partition.toString());
                    continue;
                }
                for (int replicaIndex = indexOfDead; replicaIndex < maxBackupCount; ++replicaIndex) {
                    Address target = partition.getReplicaAddress(replicaIndex);
                    if (target == null || target.equals(owner)) continue;
                    if (this.getMember(target) != null) {
                        MigrationRequestTask mrt = new MigrationRequestTask(partitionId, owner, target, replicaIndex, false, true);
                        this.immediateTasksQueue.offer(new Migrator(mrt));
                        ++diffCount;
                        continue;
                    }
                    this.logger.log(Level.WARNING, "Target member of replica diff task couldn't found! Replica: " + replicaIndex + ", Dead: " + deadMember + "\n" + partition);
                }
                if (indexOfDead > maxBackupCount) continue;
                for (int index = maxBackupCount; index < 7; ++index) {
                    partition.setReplicaAddress(index, null);
                }
            }
            this.sendPartitionRuntimeState();
            final int totalDiffCount = diffCount;
            this.immediateTasksQueue.offer(new Runnable(){

                public void run() {
                    PartitionManager.this.logger.log(Level.INFO, "Total " + totalDiffCount + " partition replica diffs have been processed.");
                    PartitionManager.this.sendingDiffs.set(false);
                }
            });
            this.immediateTasksQueue.offer(new PrepareRepartitioningTask());
        }
    }

    private void checkMigratingPartitionForDead(Address deadAddress) {
        if (this.migratingPartition != null && (deadAddress.equals(this.migratingPartition.getFromAddress()) || deadAddress.equals(this.migratingPartition.getToAddress()))) {
            this.migratingPartition = null;
        }
    }

    private void fixCMapsForDead(Address deadAddress, int[] indexesOfDead) {
        Address thisAddress = this.concurrentMapManager.getThisAddress();
        for (CMap cmap : this.concurrentMapManager.maps.values()) {
            Object[] records;
            cmap.onDisconnect(deadAddress);
            for (Object recordObject : records = cmap.mapRecords.values().toArray()) {
                if (recordObject == null) continue;
                Record record = (Record)recordObject;
                cmap.onDisconnect(record, deadAddress);
                int partitionId = record.getBlockId();
                if (indexesOfDead[partitionId] != 0 || !record.isActive() || !thisAddress.equals(this.partitions[partitionId].getOwner())) continue;
                cmap.markAsDirty(record, true);
                cmap.updateIndexes(record);
            }
        }
    }

    private int getMaxBackupCount() {
        Collection cmaps = this.concurrentMapManager.maps.values();
        if (!cmaps.isEmpty()) {
            int maxBackupCount = 0;
            for (CMap cmap : cmaps) {
                maxBackupCount = Math.max(maxBackupCount, cmap.getTotalBackupCount());
            }
            return maxBackupCount;
        }
        return 1;
    }

    public void syncForAdd() {
        if (this.concurrentMapManager.isMaster() && this.concurrentMapManager.node.isActive()) {
            if (this.sendingDiffs.get()) {
                this.logger.log(Level.INFO, "MigrationService is already sending diffs for dead member, no need to initiate task!");
            } else {
                this.clearTaskQueues();
                this.immediateTasksQueue.offer(new PrepareRepartitioningTask());
            }
            this.migrationActive.set(true);
        }
    }

    public int getVersion() {
        return this.version.get();
    }

    void forcePartitionOwnerMigration(int partitionId, int replicaIndex, Address from, Address to) {
        MigrationRequestTask mrt = new MigrationRequestTask(partitionId, from, to, replicaIndex, true);
        this.immediateTasksQueue.offer(new Migrator(mrt));
    }

    public void setPartitionRuntimeState(PartitionRuntimeState runtimeState) {
        Address sender;
        if (!this.concurrentMapManager.isActive() || !this.concurrentMapManager.node.joined()) {
            return;
        }
        this.concurrentMapManager.checkServiceThread();
        Connection conn = runtimeState.getConnection();
        Address address = sender = conn != null ? conn.getEndPoint() : null;
        if (this.concurrentMapManager.isMaster()) {
            this.logger.log(Level.WARNING, "This is the master node and received a PartitionRuntimeState from " + (sender != null ? sender : conn) + ". Ignoring incoming state! ");
            return;
        }
        Address master = this.concurrentMapManager.getMasterAddress();
        if (sender == null || !sender.equals(master)) {
            this.logger.log(Level.WARNING, "Received a ClusterRuntimeState, but its sender doesn't seem master! => Sender: " + sender + ", Master: " + master + "! " + "(Ignore if master node has changed recently.)");
        }
        for (PartitionInfo newPartition : runtimeState.getPartitions()) {
            PartitionInfo currentPartition = this.partitions[newPartition.getPartitionId()];
            for (int index = 0; index < 7; ++index) {
                Address address2 = newPartition.getReplicaAddress(index);
                if (address2 == null || this.concurrentMapManager.getMember(address2) != null) continue;
                this.logger.log(Level.WARNING, "Unknown " + address2 + " is found in received partition table from master " + sender + ". Probably it is dead. Partition: " + newPartition);
            }
            currentPartition.setPartitionInfo(newPartition);
            this.checkMigratingPartitionFor(currentPartition);
        }
        this.initialized = true;
        this.version.set(runtimeState.getVersion());
    }

    private void checkMigratingPartitionFor(PartitionInfo partition) {
        Address targetAddress;
        this.concurrentMapManager.checkServiceThread();
        MigratingPartition mPartition = this.migratingPartition;
        if (mPartition != null && partition.getPartitionId() == mPartition.getPartitionId() && (targetAddress = mPartition.getToAddress()) != null && targetAddress.equals(partition.getReplicaAddress(mPartition.getReplicaIndex()))) {
            this.migratingPartition = null;
        }
    }

    public boolean shouldPurge(int partitionId, int maxBackupCount) {
        if (this.isPartitionMigrating(partitionId)) {
            return false;
        }
        Address thisAddress = this.concurrentMapManager.getThisAddress();
        PartitionInfo partitionInfo = this.getPartition(partitionId);
        return !partitionInfo.isOwnerOrBackup(thisAddress, maxBackupCount);
    }

    public boolean isPartitionMigrating(int partitionId) {
        MigratingPartition currentMigratingPartition = this.migratingPartition;
        return currentMigratingPartition != null && currentMigratingPartition.getPartitionId() == partitionId;
    }

    public boolean isOwnedPartitionMigrating(int partitionId) {
        return this.isPartitionMigrating(partitionId, 0);
    }

    public boolean isPartitionMigrating(int partitionId, int replicaIndex) {
        MigratingPartition currentMigratingPartition = this.migratingPartition;
        return currentMigratingPartition != null && currentMigratingPartition.getPartitionId() == partitionId && currentMigratingPartition.getReplicaIndex() == replicaIndex;
    }

    public PartitionInfo getPartition(int partitionId) {
        return this.partitions[partitionId];
    }

    public boolean hasActiveBackupTask() {
        if (!this.initialized) {
            return false;
        }
        if (this.concurrentMapManager.isLiteMember()) {
            return false;
        }
        int maxBackupCount = this.getMaxBackupCount();
        if (maxBackupCount == 0) {
            return false;
        }
        HashSet<MemberImpl> members = new HashSet<MemberImpl>();
        for (Member member : this.concurrentMapManager.node.getClusterImpl().getMembers()) {
            members.add((MemberImpl)member);
        }
        MemberGroupFactory mgf = PartitionStateGeneratorFactory.newMemberGroupFactory(this.concurrentMapManager.node.config.getPartitionGroupConfig());
        if (mgf.createMemberGroups(members).size() < 2) {
            return false;
        }
        boolean needBackup = false;
        if (this.immediateTasksQueue.isEmpty()) {
            for (PartitionInfo partition : this.partitions) {
                if (partition.getReplicaAddress(1) != null) continue;
                needBackup = true;
                this.logger.log(Level.WARNING, this.concurrentMapManager.thisAddress + " still has no replica for partitionId:" + partition.getPartitionId());
                break;
            }
        }
        return needBackup || !this.immediateTasksQueue.isEmpty();
    }

    public void fireMigrationEvent(MigrationStatus status, int partitionId, Address from, Address to) {
        MemberImpl current = this.concurrentMapManager.getMember(from);
        MemberImpl newOwner = this.concurrentMapManager.getMember(to);
        MigrationEvent migrationEvent = new MigrationEvent(this.concurrentMapManager.node, partitionId, current, newOwner);
        this.systemLogService.logPartition("MigrationEvent [" + (Object)((Object)status) + "] " + migrationEvent);
        this.concurrentMapManager.partitionServiceImpl.doFireMigrationEvent(status, migrationEvent);
    }

    private void sendMigrationEvent(MigrationStatus status, MigrationRequestTask migrationRequestTask) {
        this.concurrentMapManager.sendProcessableToAll(new MigrationNotification(status, migrationRequestTask), true);
    }

    private boolean shouldCheckRepartitioning() {
        return this.immediateTasksQueue.isEmpty() && this.scheduledTasksQueue.isEmpty() && this.lastRepartitionTime.get() < Clock.currentTimeMillis() - REPARTITIONING_CHECK_INTERVAL && this.migratingPartition == null;
    }

    public int getImmediateTasksCount() {
        return this.immediateTasksQueue.size();
    }

    public int getScheduledTasksCount() {
        return this.scheduledTasksQueue.size();
    }

    public boolean activateMigration() {
        return this.migrationActive.compareAndSet(false, true);
    }

    public boolean inactivateMigration() {
        this.migrationActive.compareAndSet(true, false);
        while (this.migratingPartition != null) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                return true;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PartitionManager[" + this.version + "] {\n");
        sb.append("migratingPartition: " + this.migratingPartition);
        sb.append("\n");
        sb.append("immediateQ:" + this.immediateTasksQueue.size());
        sb.append(", scheduledQ:" + this.scheduledTasksQueue.size());
        sb.append("\n}");
        return sb.toString();
    }

    public static class AssignPartitions
    extends AbstractRemotelyProcessable {
        public void process() {
            this.node.concurrentMapManager.getPartitionManager().getOwner(0);
        }
    }

    private class CheckMigratingPartitionTask
    implements Runnable {
        private CheckMigratingPartitionTask() {
        }

        public void run() {
            MigratingPartition currentMigratingPartition;
            if (!PartitionManager.this.concurrentMapManager.isMaster() && (currentMigratingPartition = PartitionManager.this.migratingPartition) != null && Clock.currentTimeMillis() - currentMigratingPartition.getCreationTime() > MIGRATING_PARTITION_CHECK_INTERVAL) {
                try {
                    Node node = ((PartitionManager)PartitionManager.this).concurrentMapManager.node;
                    ClusterManager clusterManager = node.clusterManager;
                    clusterManager.getClass();
                    ClusterManager.AsyncRemotelyBooleanOp op = clusterManager.new ClusterManager.AsyncRemotelyBooleanOp(new RemotelyCheckMigratingPartition(currentMigratingPartition), node.getMasterAddress(), true);
                    op.execute();
                    boolean valid = op.getResultAsBoolean(1);
                    if (valid) {
                        PartitionManager.this.logger.log(Level.FINEST, "Master has confirmed current " + currentMigratingPartition);
                    } else {
                        PartitionManager.this.logger.log(Level.INFO, currentMigratingPartition + " could not be validated with master! " + "Removing current MigratingPartition...");
                        PartitionManager.this.concurrentMapManager.enqueueAndReturn(new Processable(){

                            public void process() {
                                PartitionManager.this.migratingPartition = null;
                            }
                        });
                    }
                }
                catch (Throwable t) {
                    PartitionManager.this.logger.log(Level.WARNING, t.getMessage(), t);
                }
            }
        }
    }

    private class CheckRepartitioningTask
    extends PrepareRepartitioningTask
    implements Runnable {
        private CheckRepartitioningTask() {
        }

        void doRun() {
            if (PartitionManager.this.shouldCheckRepartitioning()) {
                int v = PartitionManager.this.version.get();
                this.prepareMigrationTasks();
                int totalTasks = 0;
                for (MigrationRequestTask task : this.immediateQ) {
                    if (task.getReplicaIndex() > 2) continue;
                    ++totalTasks;
                }
                for (MigrationRequestTask task : this.scheduledQ) {
                    if (task.getReplicaIndex() > 2) continue;
                    ++totalTasks;
                }
                if (!this.lostQ.isEmpty() || totalTasks > 20) {
                    PartitionManager.this.logger.log(Level.WARNING, "Something weird! Migration task queues are empty, last repartitioning executed on " + PartitionManager.this.lastRepartitionTime.get() + " but repartitioning check resulted " + totalTasks + " tasks" + " and " + this.lostQ.size() + " lost partitions!");
                    if (PartitionManager.this.version.get() == v && PartitionManager.this.shouldCheckRepartitioning()) {
                        this.fillMigrationQueues();
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LostPartitionsAssignmentProcess
    implements Processable {
        final List<MigrationRequestTask> lostQ;

        private LostPartitionsAssignmentProcess(List<MigrationRequestTask> lostQ) {
            this.lostQ = lostQ;
        }

        @Override
        public void process() {
            if (!PartitionManager.this.concurrentMapManager.isMaster() || !((PartitionManager)PartitionManager.this).concurrentMapManager.node.isActive()) {
                return;
            }
            for (MigrationRequestTask migrationRequestTask : this.lostQ) {
                int partitionId = migrationRequestTask.getPartitionId();
                int replicaIndex = migrationRequestTask.getReplicaIndex();
                if (replicaIndex != 0 || partitionId >= PartitionManager.this.partitionCount) {
                    PartitionManager.this.logger.log(Level.WARNING, "Wrong task for lost partitions assignment process => " + migrationRequestTask);
                    continue;
                }
                PartitionInfo partition = PartitionManager.this.partitions[partitionId];
                Address newOwner = migrationRequestTask.getToAddress();
                MemberImpl ownerMember = PartitionManager.this.concurrentMapManager.getMember(newOwner);
                if (ownerMember == null) continue;
                partition.setReplicaAddress(replicaIndex, newOwner);
                PartitionManager.this.sendMigrationEvent(MigrationStatus.COMPLETED, migrationRequestTask);
            }
            PartitionManager.this.sendPartitionRuntimeState();
        }
    }

    private class MigrationService
    extends Thread
    implements Runnable {
        MigrationService(Node node) {
            super(node.threadGroup, node.getThreadNamePrefix("MigrationThread"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ThreadContext.get().setCurrentFactory(((PartitionManager)PartitionManager.this).concurrentMapManager.node.factory);
            try {
                try {
                    while (PartitionManager.this.running) {
                        long start;
                        Runnable r = null;
                        while (this.isActive() && (r = (Runnable)PartitionManager.this.immediateTasksQueue.poll()) != null) {
                            this.safeRunImmediate(r);
                        }
                        if (!PartitionManager.this.running) break;
                        for (long totalWait = 0L; this.isActive() && (r != null || totalWait < (long)PartitionManager.this.partitionMigrationInterval); totalWait += Clock.currentTimeMillis() - start) {
                            start = Clock.currentTimeMillis();
                            r = (Runnable)PartitionManager.this.immediateTasksQueue.poll(1L, TimeUnit.SECONDS);
                            this.safeRunImmediate(r);
                        }
                        if (this.isActive()) {
                            r = (Runnable)PartitionManager.this.scheduledTasksQueue.poll();
                            this.safeRun(r);
                        }
                        if (PartitionManager.this.migrationActive.get() && !this.hasNoTasks()) continue;
                        Thread.sleep(250L);
                    }
                    Object var7_6 = null;
                }
                catch (InterruptedException e) {
                    PartitionManager.this.logger.log(Level.FINEST, "MigrationService is interrupted: " + e.getMessage(), e);
                    PartitionManager.this.running = false;
                    Object var7_7 = null;
                    PartitionManager.this.clearTaskQueues();
                    return;
                }
                catch (OutOfMemoryError oom) {
                    OutOfMemoryErrorDispatcher.onOutOfMemory(oom);
                    Object var7_8 = null;
                    PartitionManager.this.clearTaskQueues();
                    return;
                }
                PartitionManager.this.clearTaskQueues();
                return;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                PartitionManager.this.clearTaskQueues();
                throw throwable;
            }
        }

        private boolean hasNoTasks() {
            return PartitionManager.this.immediateTasksQueue.isEmpty() && PartitionManager.this.scheduledTasksQueue.isEmpty();
        }

        private boolean isActive() {
            return PartitionManager.this.migrationActive.get() && PartitionManager.this.running;
        }

        boolean safeRun(Runnable r) {
            if (r == null || !PartitionManager.this.running) {
                return false;
            }
            try {
                r.run();
            }
            catch (Throwable t) {
                PartitionManager.this.logger.log(Level.WARNING, t.getMessage(), t);
            }
            return true;
        }

        void safeRunImmediate(Runnable r) throws InterruptedException {
            if (this.safeRun(r) && PartitionManager.this.immediateBackupInterval > 0) {
                Thread.sleep(PartitionManager.this.immediateBackupInterval);
            }
        }
    }

    private class Migrator
    implements Runnable {
        final MigrationRequestTask migrationRequestTask;

        Migrator(MigrationRequestTask migrationRequestTask) {
            this.migrationRequestTask = migrationRequestTask;
        }

        public void run() {
            try {
                if (!((PartitionManager)PartitionManager.this).concurrentMapManager.node.isActive() || !((PartitionManager)PartitionManager.this).concurrentMapManager.node.isMaster()) {
                    return;
                }
                if (this.migrationRequestTask.isMigration() && this.migrationRequestTask.getReplicaIndex() == 0) {
                    PartitionManager.this.concurrentMapManager.enqueueAndWait(new Processable(){

                        public void process() {
                            PartitionManager.this.sendMigrationEvent(MigrationStatus.STARTED, Migrator.this.migrationRequestTask);
                        }
                    }, 100);
                }
                if (this.migrationRequestTask.getToAddress() == null) {
                    PartitionManager.this.logger.log(Level.FINEST, "Fixing partition, " + this.migrationRequestTask.getReplicaIndex() + ". replica of partition[" + this.migrationRequestTask.getPartitionId() + "] should be removed.");
                    PartitionManager.this.concurrentMapManager.enqueueAndWait(new Processable(){

                        public void process() {
                            int partitionId = Migrator.this.migrationRequestTask.getPartitionId();
                            int replicaIndex = Migrator.this.migrationRequestTask.getReplicaIndex();
                            PartitionInfo partition = PartitionManager.this.partitions[partitionId];
                            partition.setReplicaAddress(replicaIndex, null);
                            PartitionManager.this.migratingPartition = null;
                        }
                    });
                } else {
                    MemberImpl fromMember = null;
                    Boolean result = Boolean.FALSE;
                    if (this.migrationRequestTask.isMigration()) {
                        fromMember = PartitionManager.this.getMember(this.migrationRequestTask.getFromAddress());
                    } else {
                        int partitionId = this.migrationRequestTask.getPartitionId();
                        fromMember = PartitionManager.this.getMember(PartitionManager.this.partitions[partitionId].getOwner());
                    }
                    PartitionManager.this.logger.log(Level.FINEST, "Started Migration : " + this.migrationRequestTask);
                    PartitionManager.this.systemLogService.logPartition("Started Migration : " + this.migrationRequestTask);
                    if (fromMember != null) {
                        this.migrationRequestTask.setFromAddress(fromMember.getAddress());
                        DistributedTask<Boolean> task = new DistributedTask<Boolean>(this.migrationRequestTask, fromMember);
                        PartitionManager.this.concurrentMapManager.enqueueAndWait(new Processable(){

                            public void process() {
                                PartitionManager.this.addActiveMigration(Migrator.this.migrationRequestTask);
                            }
                        });
                        Future<?> future = ((PartitionManager)PartitionManager.this).concurrentMapManager.node.factory.getExecutorService(PartitionManager.MIGRATION_EXECUTOR_NAME).submit(task);
                        try {
                            result = future.get(PartitionManager.this.partitionMigrationTimeout, TimeUnit.SECONDS);
                        }
                        catch (Throwable e) {
                            PartitionManager.this.logger.log(Level.WARNING, "Failed migrating from " + fromMember);
                        }
                    } else {
                        result = Boolean.TRUE;
                    }
                    PartitionManager.this.logger.log(Level.FINEST, "Finished Migration : " + this.migrationRequestTask);
                    PartitionManager.this.systemLogService.logPartition("Finished Migration : " + this.migrationRequestTask);
                    if (Boolean.TRUE.equals(result)) {
                        PartitionManager.this.concurrentMapManager.enqueueAndWait(new ProcessMigrationResult(this.migrationRequestTask), 10000);
                    } else {
                        PartitionManager.this.logger.log(Level.WARNING, "Migration task has failed => " + this.migrationRequestTask);
                        this.migrationTaskFailed();
                    }
                }
            }
            catch (Throwable t) {
                PartitionManager.this.logger.log(Level.WARNING, "Error [" + t.getClass().getName() + ": " + t.getMessage() + "] " + "while executing " + this.migrationRequestTask);
                PartitionManager.this.logger.log(Level.FINEST, t.getMessage(), t);
                this.migrationTaskFailed();
            }
        }

        private void migrationTaskFailed() {
            PartitionManager.this.systemLogService.logPartition("Migration task has failed => " + this.migrationRequestTask);
            PartitionManager.this.concurrentMapManager.enqueueAndWait(new Processable(){

                public void process() {
                    PartitionManager.this.compareAndSetActiveMigratingPartition(Migrator.this.migrationRequestTask, null);
                    if (Migrator.this.migrationRequestTask.getReplicaIndex() == 0) {
                        PartitionManager.this.sendMigrationEvent(MigrationStatus.FAILED, Migrator.this.migrationRequestTask);
                    }
                }
            });
        }
    }

    private class PrepareRepartitioningTask
    implements Runnable {
        final List<MigrationRequestTask> lostQ = new ArrayList<MigrationRequestTask>();
        final List<MigrationRequestTask> scheduledQ = new ArrayList<MigrationRequestTask>(PartitionManager.access$2000(PartitionManager.this));
        final List<MigrationRequestTask> immediateQ = new ArrayList<MigrationRequestTask>(PartitionManager.access$2000(PartitionManager.this) * 2);

        private PrepareRepartitioningTask() {
        }

        public final void run() {
            if (PartitionManager.this.concurrentMapManager.isMaster() && ((PartitionManager)PartitionManager.this).concurrentMapManager.node.isActive() && PartitionManager.this.initialized) {
                this.doRun();
            }
        }

        void doRun() {
            this.prepareMigrationTasks();
            PartitionManager.this.logger.log(Level.INFO, "Re-partitioning cluster data... Immediate-Tasks: " + this.immediateQ.size() + ", Scheduled-Tasks: " + this.scheduledQ.size());
            this.fillMigrationQueues();
        }

        void prepareMigrationTasks() {
            LinkedList<MemberImpl> members = new LinkedList<MemberImpl>();
            Set<Member> memberSet = ((PartitionManager)PartitionManager.this).concurrentMapManager.node.getClusterImpl().getMembers();
            for (Member member : memberSet) {
                members.add((MemberImpl)member);
            }
            PartitionStateGenerator psg = PartitionManager.this.getPartitionStateGenerator();
            psg.reArrange(PartitionManager.this.partitions, members, PartitionManager.this.partitionCount, this.lostQ, this.immediateQ, this.scheduledQ);
        }

        void fillMigrationQueues() {
            PartitionManager.this.lastRepartitionTime.set(Clock.currentTimeMillis());
            if (!this.lostQ.isEmpty()) {
                PartitionManager.this.concurrentMapManager.enqueueAndReturn(new LostPartitionsAssignmentProcess(this.lostQ));
                PartitionManager.this.logger.log(Level.WARNING, "Assigning new owners for " + this.lostQ.size() + " LOST partitions!");
            }
            for (MigrationRequestTask migrationRequestTask : this.immediateQ) {
                PartitionManager.this.immediateTasksQueue.offer(new Migrator(migrationRequestTask));
            }
            this.immediateQ.clear();
            for (MigrationRequestTask migrationRequestTask : this.scheduledQ) {
                PartitionManager.this.scheduledTasksQueue.offer(new Migrator(migrationRequestTask));
            }
            this.scheduledQ.clear();
        }
    }

    private class ProcessMigrationResult
    implements Processable {
        final MigrationRequestTask migrationRequestTask;

        private ProcessMigrationResult(MigrationRequestTask migrationRequestTask) {
            this.migrationRequestTask = migrationRequestTask;
        }

        public void process() {
            int partitionId = this.migrationRequestTask.getPartitionId();
            int replicaIndex = this.migrationRequestTask.getReplicaIndex();
            PartitionInfo partition = PartitionManager.this.partitions[partitionId];
            if (7 < replicaIndex) {
                String msg = "Migrated [" + partitionId + ":" + replicaIndex + "] but cannot assign. Length:" + 7;
                PartitionManager.this.logger.log(Level.WARNING, msg);
            } else {
                Address newOwner = this.migrationRequestTask.getToAddress();
                MemberImpl ownerMember = PartitionManager.this.concurrentMapManager.getMember(newOwner);
                if (ownerMember == null) {
                    return;
                }
                partition.setReplicaAddress(replicaIndex, newOwner);
                if (this.migrationRequestTask.getSelfCopyReplicaIndex() > -1) {
                    partition.setReplicaAddress(this.migrationRequestTask.getSelfCopyReplicaIndex(), this.migrationRequestTask.getFromAddress());
                }
                PartitionManager.this.sendPartitionRuntimeState();
                PartitionManager.this.compareAndSetActiveMigratingPartition(this.migrationRequestTask, null);
                if (replicaIndex == 0) {
                    PartitionManager.this.sendMigrationEvent(MigrationStatus.COMPLETED, this.migrationRequestTask);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemotelyCheckMigratingPartition
    extends AbstractRemotelyCallable<Boolean> {
        MigratingPartition migratingPartition;

        public RemotelyCheckMigratingPartition() {
        }

        public RemotelyCheckMigratingPartition(MigratingPartition migratingPartition) {
            this.migratingPartition = migratingPartition;
        }

        @Override
        public Boolean call() throws Exception {
            if (this.migratingPartition != null) {
                MigratingPartition masterMigratingPartition = this.node.concurrentMapManager.getPartitionManager().migratingPartition;
                return this.migratingPartition.equals(masterMigratingPartition);
            }
            return Boolean.FALSE;
        }

        @Override
        public void readData(DataInput in) throws IOException {
            if (in.readBoolean()) {
                this.migratingPartition = new MigratingPartition();
                this.migratingPartition.readData(in);
            }
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            boolean b = this.migratingPartition != null;
            out.writeBoolean(b);
            if (b) {
                this.migratingPartition.writeData(out);
            }
        }
    }

    private class SendClusterStateTask
    implements Runnable {
        private SendClusterStateTask() {
        }

        public void run() {
            if (PartitionManager.this.concurrentMapManager.isMaster() && ((PartitionManager)PartitionManager.this).concurrentMapManager.node.isActive()) {
                if (!(PartitionManager.this.scheduledTasksQueue.isEmpty() && PartitionManager.this.immediateTasksQueue.isEmpty() || !PartitionManager.this.migrationActive.get())) {
                    PartitionManager.this.logger.log(Level.INFO, "Remaining migration tasks in queue => Immediate-Tasks: " + PartitionManager.this.immediateTasksQueue.size() + ", Scheduled-Tasks: " + PartitionManager.this.scheduledTasksQueue.size());
                }
                final Node node = ((PartitionManager)PartitionManager.this).concurrentMapManager.node;
                PartitionManager.this.concurrentMapManager.enqueueAndReturn(new Processable(){

                    public void process() {
                        if (!node.isActive() || !node.isMaster()) {
                            return;
                        }
                        PartitionManager.this.sendPartitionRuntimeState();
                    }
                });
            }
        }
    }
}

