/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.webkit.events;

import com.jniwrapper.Pointer;
import com.teamdev.jxbrowser.webkit.WebPolicyDelegate;
import com.teamdev.jxbrowser.webkit.cocoa.Id;
import com.teamdev.jxbrowser.webkit.cocoa.nsdictionary.NSDictionary;
import com.teamdev.jxbrowser.webkit.cocoa.nserror.NSError;
import com.teamdev.jxbrowser.webkit.cocoa.nserror.URLErrorCodes;
import com.teamdev.jxbrowser.webkit.cocoa.nsstring.NSString;
import com.teamdev.jxbrowser.webkit.cocoa.nsurl.NSURL;
import com.teamdev.jxbrowser.webkit.cocoa.nsurlrequest.NSURLRequest;
import com.teamdev.jxbrowser.webkit.events.DOMEventHandler;
import com.teamdev.jxbrowser.webkit.events.Events;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameLoadEvents
extends Events {
    private static final Logger LOG = LoggerFactory.getLogger(FrameLoadEvents.class);
    private long startFrame = -1L;
    private WebPolicyDelegate policyDelegate;

    public void didStartProvisionalLoad(long l, long l2) {
        if (this.startFrame == -1L) {
            this.startFrame = l2;
            this.fireDownloadBegin();
        }
    }

    public void didFinishLoad(long l, long l2, long l3, long l4) {
        if (l2 == this.startFrame) {
            this.startFrame = -1L;
            String string = new NSString(new Pointer.Void(l4)).UTF8String().toString();
            this.fireDownloadComplete(l3, string);
        }
    }

    public void didReceiveTitle(long l, long l2, long l3) {
        try {
            NSString nSString = new NSString(new Pointer.Void(l2));
            String string = nSString.UTF8String().getValue();
            this.fireTitleChangeEvent(string);
        }
        catch (Exception exception) {
            LOG.error("Cannot get title", (Throwable)exception);
        }
    }

    public void didFailProvisionalLoadWithError(long l) {
        NSError nSError = new NSError(new Pointer.Void(l));
        long l2 = nSError.code().getValue();
        String string = nSError.domain().UTF8String().toString();
        String string2 = nSError.localizedDescription().UTF8String().toString();
        this.fireNavigationErrorOccurred(l2, string2);
        if (string.equals("NSURLErrorDomain") && l2 <= (long)URLErrorCodes.NSURLErrorServerCertificateHasBadDate.getCode() && l2 >= (long)URLErrorCodes.NSURLErrorServerCertificateNotYetValid.getCode()) {
            NSDictionary nSDictionary = nSError.userInfo();
            Id id = nSDictionary.objectForKey(new NSString("NSErrorFailingURLKey"));
            NSURL nSURL = new NSURL(id);
            NSString nSString = new NSString(nSURL.absoluteString());
            String string3 = nSString.UTF8String().toString();
            this.showCertificate(string3);
        }
    }

    public void didProgressChanged(long l, double d) {
        long l2 = Double.valueOf(d * 100.0).longValue();
        this.fireProgressChanged(l2);
    }

    public boolean decidePolicyForNavigationAction(long l, long l2, long l3) {
        if (this.policyDelegate != null) {
            NSURLRequest nSURLRequest = new NSURLRequest(new Pointer.Void(l2));
            NSString nSString = new NSString(nSURLRequest.URL().absoluteString());
            String string = nSString.UTF8String().getValue();
            return this.policyDelegate.allowNavigation(string);
        }
        return true;
    }

    public boolean decidePolicyForMIMEType(long l, long l2, long l3) {
        if (this.policyDelegate != null) {
            String string = new NSString(new Pointer.Void(l)).UTF8String().getValue();
            NSURLRequest nSURLRequest = new NSURLRequest(new Pointer.Void(l2));
            NSString nSString = new NSString(nSURLRequest.URL().absoluteString());
            String string2 = nSString.UTF8String().getValue();
            return this.policyDelegate.allowMimeType(string, string2);
        }
        return true;
    }

    public void handleEvent(long l, long l2) {
        DOMEventHandler dOMEventHandler = this.getDomEventHandler();
        if (dOMEventHandler != null) {
            dOMEventHandler.handleEvent(l, l2);
        }
    }

    public WebPolicyDelegate getWebPolicyDelegate() {
        return this.policyDelegate;
    }

    public void setWebPolicyDelegate(WebPolicyDelegate webPolicyDelegate) {
        this.policyDelegate = webPolicyDelegate;
    }
}

