/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream.imageprocessing;

import com.elluminate.mediastream.imageprocessing.CompressedTile;
import com.elluminate.mediastream.imageprocessing.ImageUtilities;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class Tile {
    public static final boolean COLOR_GROUP_PIXEL_BYTES = true;
    public static final Dimension TILE_DIMENSION = new Dimension(16, 16);
    public static final Rectangle TILE_RECT = new Rectangle(0, 0, 16, 16);
    private static Inflater decompresser = null;
    private static Deflater deflater = null;
    private static CRC32 crc = new CRC32();
    private Point tileLoc;
    private Integer tileNumber;
    private int[] tileData = null;
    private CompressedTile compressedTile = null;
    private Integer crcValue = null;

    public Tile(Tile tile, Integer tileNumber) {
        this.tileNumber = tileNumber;
        this.tileLoc = ImageUtilities.getPixelFloorFromTileNumber(tileNumber);
        this.tileData = tile.tileData;
        this.compressedTile = tile.compressedTile;
        this.crcValue = tile.crcValue;
    }

    public Tile(int[] pixels, short tileX, short tileY) {
        this.tileNumber = new Integer(Tile.getTileNumber(tileX, tileY));
        this.tileLoc = ImageUtilities.getPixelFloorFromTileNumber(this.tileNumber);
        this.setTileData(pixels);
    }

    public Tile(int[] pixels, int tileNumber) {
        this.tileNumber = new Integer(tileNumber);
        this.tileLoc = ImageUtilities.getPixelFloorFromTileNumber(tileNumber);
        this.setTileData(pixels);
    }

    public Tile(int x, int y, int[] pixels) {
        this(pixels, Tile.xIndex(x), Tile.yIndex(y));
    }

    public Tile(Tile tile, short tileX, short tileY) {
        this(tile, new Integer(Tile.getTileNumber(tileX, tileY)));
    }

    public Tile(byte[] compressedTileData, Integer tileNumber) {
        this.tileNumber = tileNumber;
        this.tileLoc = ImageUtilities.getPixelFloorFromTileNumber(tileNumber);
        this.tileData = ImageUtilities.decompressTileData(compressedTileData);
        this.compressedTile = new CompressedTile(compressedTileData);
        this.crcValue = this.getTileCRC();
    }

    private int[] bytesToInts(byte[] bytes) {
        return Tile.bytesToInts(bytes, bytes.length);
    }

    public static int[] bytesToInts(byte[] bytes, int length) {
        int[] ints = new int[length / 4];
        int pixelIndex = 0;
        int pixelCount = length / 4;
        int alphaByte = 0;
        int redByte = alphaByte + pixelCount;
        int greenByte = redByte + pixelCount;
        int blueByte = greenByte + pixelCount;
        for (int byteCounter = 0; byteCounter < pixelCount; ++byteCounter) {
            ints[pixelIndex++] = bytes[alphaByte++] << 24 & 0xFF000000 | bytes[redByte++] << 16 & 0xFF0000 | bytes[greenByte++] << 8 & 0xFF00 | bytes[blueByte++] & 0xFF;
        }
        return ints;
    }

    public byte[] getCompressedTile() {
        if (this.compressedTile == null) {
            this.compressedTile = ImageUtilities.compressTileData(this.tileData);
        }
        return this.compressedTile.getCompressedTile();
    }

    public BufferedImage getImageForTile() {
        if (this.tileData == null) {
            this.tileData = this.bytesToInts(this.getCompressedTile());
        }
        return Tile.getImageForTile(this.tileData);
    }

    public static BufferedImage getImageForTile(byte[] compressed) {
        return Tile.getImageForTile(ImageUtilities.decompressTileData(compressed));
    }

    public static BufferedImage getImageForTile(int[] tileData) {
        BufferedImage tileImage = new BufferedImage(16, 16, 1);
        tileImage.setRGB(0, 0, 16, 16, tileData, 0, 16);
        return tileImage;
    }

    public Point getLoc() {
        return this.tileLoc;
    }

    public Point getPixelFloorFromTileNumber() {
        return ImageUtilities.getPixelFloorFromTileNumber(this.tileNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getTileCRC() {
        if (this.crcValue == null && this.tileData != null) {
            CRC32 cRC32 = crc;
            synchronized (cRC32) {
                byte[] bytes = Tile.intsToBytes(this.tileData);
                crc.update(bytes);
                this.crcValue = new Integer((int)crc.getValue());
                crc.reset();
            }
        }
        return this.crcValue;
    }

    public int[] getTileData() {
        return this.tileData;
    }

    public BufferedImage getTileImage() {
        return Tile.getImageForTile(this.tileData);
    }

    public Integer getTileNumber() {
        return this.tileNumber;
    }

    public static int getTileNumber(short tileX, short tileY) {
        return ImageUtilities.getTileNumber(tileX, tileY);
    }

    public static int getTileNumberFromPixel(int x, int y) {
        return ImageUtilities.getTileNumberFromPixel(x, y);
    }

    public Rectangle getTileRect() {
        return new Rectangle(this.getLoc(), TILE_DIMENSION);
    }

    public static byte[] intsToBytes(int[] ints) {
        byte[] bytes = new byte[ints.length * 4];
        int alphaByte = 0;
        int redByte = alphaByte + ints.length;
        int greenByte = redByte + ints.length;
        int blueByte = greenByte + ints.length;
        for (int i = 0; i < ints.length; ++i) {
            bytes[alphaByte++] = (byte)(ints[i] >> 24 & 0xFF);
            bytes[redByte++] = (byte)(ints[i] >> 16 & 0xFF);
            bytes[greenByte++] = (byte)(ints[i] >> 8 & 0xFF);
            bytes[blueByte++] = (byte)(ints[i] & 0xFF);
        }
        return bytes;
    }

    public static Tile readTile(DataInputStream istr) throws IOException {
        Tile tile;
        int tileNumber = istr.readInt();
        int len = istr.readShort();
        if (len == 0) {
            tile = new Tile(new int[256], tileNumber);
        } else {
            byte[] bytes = new byte[len];
            int offset = 0;
            int read = 0;
            while (read >= 0 && offset < len) {
                read = istr.read(bytes, offset, len - offset);
                if (read <= 0) continue;
                offset += read;
            }
            int[] data = ImageUtilities.decompressTileData(bytes);
            tile = new Tile(data, tileNumber);
            tile.compressedTile = new CompressedTile(bytes);
            tile.crcValue = null;
        }
        return tile;
    }

    public void setTileData(int[] tileIntData) {
        if (tileIntData != null) {
            byte[] tileByteData = new byte[tileIntData.length * 4];
            int j = 0;
            for (int i = 0; i < tileIntData.length; ++i) {
                tileByteData[j++] = (byte)(tileIntData[i] >> 24 & 0xFF);
                tileByteData[j++] = (byte)(tileIntData[i] >> 16 & 0xFF);
                tileByteData[j++] = (byte)(tileIntData[i] >> 8 & 0xFF);
                tileByteData[j++] = (byte)(tileIntData[i] & 0xFF);
            }
            this.setTileData(tileByteData);
        } else {
            this.crcValue = null;
        }
        this.compressedTile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTileData(byte[] tileByteData) {
        if (tileByteData != null) {
            this.tileData = this.bytesToInts(tileByteData);
            CRC32 cRC32 = crc;
            synchronized (cRC32) {
                crc.update(tileByteData);
                this.crcValue = new Integer((int)crc.getValue());
                crc.reset();
            }
        } else {
            this.tileData = null;
            this.crcValue = null;
        }
        this.compressedTile = null;
    }

    public void setTileData(int[] imageData, int imageWidth, int imageHeight) throws IOException {
        byte[] tileByteData = new byte[1024];
        Point loc = ImageUtilities.getPixelFloorFromTileNumber(this.tileNumber);
        int lastX = Math.min(loc.x + 16, imageWidth);
        int lastY = Math.min(loc.y + 16, imageHeight);
        boolean pixelIndex = false;
        int pixelCount = 256;
        int alphaIndex = 0;
        int redIndex = alphaIndex + pixelCount;
        int greenIndex = redIndex + pixelCount;
        int blueIndex = greenIndex + pixelCount;
        for (int y = loc.y; y < loc.y + 16; ++y) {
            for (int x = loc.x; x < loc.x + 16; ++x) {
                int pixel = x < lastX && y < lastY ? imageData[x + y * imageWidth] : 0;
                tileByteData[alphaIndex++] = (byte)(pixel >> 24 & 0xFF);
                tileByteData[redIndex++] = (byte)(pixel >> 16 & 0xFF);
                tileByteData[greenIndex++] = (byte)(pixel >> 8 & 0xFF);
                tileByteData[blueIndex++] = (byte)(pixel & 0xFF);
            }
        }
        this.tileData = imageData;
        this.compressedTile = null;
        this.crcValue = null;
    }

    public void setTileData(BufferedImage image) {
        Point loc = ImageUtilities.getPixelFloorFromTileNumber(this.tileNumber);
        int width = Math.min(loc.x + 16, image.getWidth()) - loc.x;
        int height = Math.min(loc.y + 16, image.getHeight()) - loc.y;
        try {
            this.setTileData(image.getRGB(loc.x, loc.y, Math.min(width, 16), Math.min(height, 16), null, 0, 16));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.compressedTile = null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Tile: CRC: " + this.getTileCRC() + ", compressedTile: " + this.compressedTile + ", tileNumber: " + Integer.toHexString(0xFFFF & this.tileNumber) + ", tileLoc: " + this.tileLoc + "\n");
        int index = 0;
        for (int j = 0; j < 16; ++j) {
            for (int i = 0; i < 16; ++i) {
                String digits;
                if ((digits = Integer.toHexString(this.tileData[index++] & 0xFF)).length() < 2) {
                    digits = "0" + digits;
                }
                buf.append(" " + digits);
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public void writeTile(DataOutputStream ostr) throws IOException {
        try {
            ostr.writeInt(this.tileNumber);
            if (this.tileData != null && this.compressedTile == null) {
                this.compressedTile = ImageUtilities.compressTileData(this.tileData);
            }
            if (this.compressedTile == null) {
                ostr.writeShort(0);
            }
            ostr.writeShort(this.compressedTile.getCompressedTile().length);
            ostr.write(this.compressedTile.getCompressedTile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static short xIndex(int xPixel) {
        return (short)(xPixel / 16);
    }

    public static short yIndex(int yPixel) {
        return (short)(yPixel / 16);
    }
}

