/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream;

import com.elluminate.mediastream.FeedPacket;
import com.elluminate.mediastream.MRFPacket;
import com.elluminate.mediastream.TimedPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MRFDuplicateTiles
extends MRFPacket
implements FeedPacket,
TimedPacket {
    private short[] indicies = null;
    private short feedIndex;
    private short masterTile;
    private long time;

    public MRFDuplicateTiles(short feedIndex, short[] indicies, long time) {
        super((byte)12);
        this.feedIndex = feedIndex;
        this.masterTile = indicies[0];
        this.indicies = new short[indicies.length - 1];
        this.time = time;
        System.arraycopy(indicies, 1, this.indicies, 0, indicies.length - 1);
    }

    public MRFDuplicateTiles(byte[] packetData) throws IOException {
        super((byte)12);
        ByteArrayInputStream bistr = new ByteArrayInputStream(packetData);
        DataInputStream istr = new DataInputStream(bistr);
        this.feedIndex = istr.readShort();
        this.time = istr.readLong();
        int tileCount = istr.readShort();
        if (tileCount > 0) {
            this.masterTile = istr.readShort();
            this.indicies = new short[tileCount - 1];
            for (int i = 1; i < tileCount; ++i) {
                this.indicies[i - 1] = istr.readShort();
            }
        }
    }

    @Override
    public short getFeedIdx() {
        return this.feedIndex;
    }

    public short[] getDuplicateTiles() {
        return this.indicies;
    }

    public short getMasterTile() {
        return this.masterTile;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public void setFeedIdx(short feedIdx) {
        this.feedIndex = feedIdx;
    }

    @Override
    public void setTime(long time) {
        this.time = time;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bostr = new ByteArrayOutputStream();
        DataOutputStream ostr = new DataOutputStream(bostr);
        ostr.writeShort(this.feedIndex);
        ostr.writeLong(this.time);
        ostr.writeShort(this.indicies.length + 1);
        if (this.indicies.length > 0) {
            ostr.writeShort(this.masterTile);
            for (int i = 0; i < this.indicies.length; ++i) {
                ostr.writeShort(this.indicies[i]);
            }
        }
        return bostr.toByteArray();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.indicies != null && this.indicies.length > 0) {
            buf.append("MRFDuplicateTiles: (" + this.indicies.length + ") Master: " + Integer.toHexString(0xFFFF & this.masterTile) + "\n");
            int index = 0;
            while (index < this.indicies.length) {
                buf.append(" ");
                for (int i = 0; i < 16 && index < this.indicies.length; ++index, ++i) {
                    String digits = Integer.toHexString(this.indicies[index] & 0xFFFF);
                    buf.append(" ");
                    for (int j = 4; j > digits.length(); --j) {
                        buf.append(" ");
                    }
                    buf.append(digits);
                    if (i != 7) continue;
                    buf.append("  ");
                }
                buf.append("\n");
            }
        } else {
            buf.append("MRFDuplicateTiles: - NO TILES -\n");
        }
        return buf.toString();
    }
}

