/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.transfer;

import com.elluminate.groupware.transfer.AbstractLoader;
import com.elluminate.groupware.transfer.LoaderListener;
import com.elluminate.groupware.transfer.TransferLibrary;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.platform.Platform;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.io.FileSysUtils;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Map;

public class URLLoader
extends AbstractLoader {
    private static final long TIMEOUT = 15000L;
    private static final byte ST_IDLE = 0;
    private static final byte ST_OPENING = 1;
    private static final byte ST_TIMEOUT = 2;
    private static final byte ST_CONNECTED = 3;
    private URL url;
    private URLConnection connection = null;
    private DataInputStream str = null;
    private LightweightTimer timeout = null;
    private byte state = 0;
    private File spool = null;
    private FileOutputStream sstr = null;

    public URLLoader(int seq, int id, Map attrs, Object lock, URL url, LoaderListener lst, TransferLibrary lib, short notify) {
        super(seq, url.toString(), id, attrs, lock, lst, lib, notify);
        this.url = url;
    }

    public URLLoader(int seq, int id, Map attrs, Object lock, URL url, LoaderListener lst, TransferLibrary lib) {
        super(seq, url.toString(), id, attrs, lock, lst, lib);
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean open() throws IOException {
        String type;
        long length;
        boolean doLoad = true;
        this.timeout = new LightweightTimer(new Runnable(){

            @Override
            public void run() {
                URLLoader.this.timeout();
            }
        });
        try {
            int sep22;
            String file;
            int q;
            int semi;
            HttpURLConnection hc;
            int code;
            URLLoader uRLLoader = this;
            synchronized (uRLLoader) {
                this.timeout.scheduleIn(15000L);
                this.state = 1;
            }
            this.connection = this.url.openConnection();
            if (this.connection instanceof HttpURLConnection && (code = (hc = (HttpURLConnection)this.connection).getResponseCode()) >= 400) {
                throw new IOException(code + ": " + hc.getResponseMessage());
            }
            length = this.connection.getContentLength();
            type = this.connection.getContentType();
            if (type != null && (semi = type.indexOf(59)) > 0) {
                type = type.substring(0, semi);
            }
            if ((q = (file = this.url.getFile()).lastIndexOf(63)) > 0) {
                file = file.substring(0, q);
            }
            if ((sep22 = file.lastIndexOf(47)) >= 0) {
                file = file.substring(sep22 + 1);
            }
            file = file.length() == 0 ? "index.html" : URLDecoder.decode(file, "UTF-8");
            if (type == null || type.equals("text/plain") || type.equals("application/octet-stream")) {
                String guess = Platform.getMimeType((String)file);
                if (guess != "application/octet-stream") {
                    type = guess;
                }
            } else {
                String mimeSuffix;
                String mime = Platform.getMimeType((String)file);
                if (!mime.equalsIgnoreCase(type) && !mime.equals("application/octet-stream") && (mimeSuffix = Platform.getSuffix((String)type)).length() > 0) {
                    file = FileSysUtils.setExtensionDefault((String)file, (String)mimeSuffix);
                }
            }
            this.setName(file);
        }
        catch (IOException io) {
            boolean rethrow;
            URLLoader sep22 = this;
            synchronized (sep22) {
                rethrow = this.state == 1;
            }
            if (rethrow) {
                throw io;
            }
            boolean sep22 = false;
            return sep22;
        }
        finally {
            this.timeout.cancel();
        }
        URLLoader io = this;
        synchronized (io) {
            if (this.state == 2) {
                return false;
            }
            this.state = (byte)3;
        }
        this.str = new DataInputStream(this.connection.getInputStream());
        if (length == -1L) {
            int nRead;
            byte[] buffer = new byte[8192];
            this.spool = File.createTempFile("transfer", "spool");
            this.spool.deleteOnExit();
            this.sstr = new FileOutputStream(this.spool);
            length = 0L;
            while ((nRead = this.str.read(buffer)) >= 0) {
                this.sstr.write(buffer, 0, nRead);
                length += (long)nRead;
                if (this.listener.quotaCheck(this)) continue;
                doLoad = false;
                break;
            }
            try {
                this.str.close();
            }
            catch (IOException iox) {
                // empty catch block
            }
            try {
                this.sstr.close();
            }
            catch (IOException iox) {
                // empty catch block
            }
            if (doLoad) {
                this.str = new DataInputStream(new FileInputStream(this.spool));
            }
        }
        this.setLength(length);
        this.setMimeType(type);
        return doLoad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeout() {
        URLLoader uRLLoader = this;
        synchronized (uRLLoader) {
            if (this.state == 3) {
                return;
            }
            this.state = (byte)2;
        }
        this.reportError("Transfer.timedOut", "");
    }

    @Override
    protected void close() {
        if (this.str != null) {
            try {
                this.str.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.str = null;
            this.connection = null;
            if (this.spool != null) {
                this.spool.delete();
                this.spool = null;
            }
        }
    }

    private void setup(URL url) throws IOException {
        this.url = url;
    }

    @Override
    protected boolean read(ProtocolBuffer buf, int nBytes) {
        try {
            buf.readFrom((DataInput)this.str, 0, nBytes);
            return true;
        }
        catch (IOException ex) {
            this.reportError("AbstractLoader.readError", ex.toString());
            return false;
        }
    }
}

