/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.transfer;

import com.elluminate.groupware.transfer.StreamEvent;
import com.elluminate.groupware.transfer.StreamListener;
import com.elluminate.groupware.transfer.XferDebug;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.util.CPropertyChangeSupport;
import com.elluminate.util.log.LogSupport;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;

public class StreamCache
implements StreamListener {
    private static final int BLOCK_SIZE = 396;
    public static final String LOCATION_PROP = "location";
    private File file = null;
    private RandomAccessFile store = null;
    private int id;
    private long size = 0L;
    private long cursor = 0L;
    private HashMap subscribers = new HashMap();
    private Object listenerLock = new Object();
    private Object lock = new Object();
    private CPropertyChangeSupport cSupport = new CPropertyChangeSupport((Object)this);

    public StreamCache(int uid, long len) throws IOException {
        this(uid, File.createTempFile("StreamCache", ".xfer"), len);
        this.file.deleteOnExit();
    }

    public StreamCache(int uid, File f, long len) throws IOException {
        this.file = f;
        this.store = new RandomAccessFile(this.file, "rw");
        this.size = len;
        this.id = uid;
        ByteArrayOutputStream bstr = new ByteArrayOutputStream(4);
        DataOutputStream dstr = new DataOutputStream(bstr);
        dstr.writeInt(this.id);
        dstr.close();
    }

    public void setLock(Object o) {
        this.lock = o;
    }

    public int getStreamID() {
        return this.id;
    }

    public void setLocation(long where) {
        long prev = this.cursor;
        this.cursor = where;
        this.cSupport.firePropertyChange(LOCATION_PROP, prev, this.cursor);
    }

    public long getLocation() {
        return this.cursor;
    }

    public long getLength() {
        return this.size;
    }

    public void addStreamListener(StreamListener lst) {
        this.addStreamListener(lst, 0L, this.size);
    }

    public void addStreamListener(StreamListener lst, long from) {
        this.addStreamListener(lst, from, this.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStreamListener(StreamListener lst, long from, long to) {
        SubscriberData sd = new SubscriberData(lst);
        sd.position = from;
        sd.last = to;
        Object object = this.listenerLock;
        synchronized (object) {
            HashMap newMap = (HashMap)this.subscribers.clone();
            newMap.put(lst, sd);
            this.subscribers = newMap;
        }
        sd.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStreamListener(StreamListener lst) {
        SubscriberData sd = null;
        Object object = this.listenerLock;
        synchronized (object) {
            HashMap newMap = (HashMap)this.subscribers.clone();
            sd = (SubscriberData)newMap.remove(lst);
            this.subscribers = newMap;
        }
        if (sd != null) {
            sd.suspend();
        }
    }

    public void suspendStreamListener(StreamListener lst) {
        SubscriberData sd = (SubscriberData)this.subscribers.get(lst);
        if (sd != null) {
            sd.suspend();
        }
    }

    public void resumeStreamListener(StreamListener lst) {
        SubscriberData sd = (SubscriberData)this.subscribers.get(lst);
        if (sd != null) {
            sd.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void streamingData(StreamEvent e) {
        ProtocolBuffer buf = e.getBuffer();
        Object object = this.lock;
        synchronized (object) {
            try {
                this.store.seek(this.cursor);
                buf.writeTo((DataOutput)this.store);
                this.setLocation(this.cursor + (long)buf.getSize());
            }
            catch (IOException ex) {
                this.size = this.cursor;
            }
        }
        e.dispose();
        this.transmit();
    }

    @Override
    public void streamAbort(StreamEvent e) {
        try {
            this.size = this.store.length();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.transmit();
    }

    public void dispose() {
        Iterator i = this.subscribers.values().iterator();
        while (i.hasNext()) {
            SubscriberData sd = (SubscriberData)i.next();
            i.remove();
            sd.dispose();
        }
        try {
            this.store.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.file.delete();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.cSupport.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.cSupport.addPropertyChangeListener(prop, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.cSupport.removePropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        this.cSupport.removePropertyChangeListener(prop, l);
    }

    private void transmit() {
        for (SubscriberData sd : this.subscribers.values()) {
            if (sd.isSuspended()) continue;
            sd.transmit();
        }
    }

    class SubscriberData {
        private StreamListener listener = null;
        private boolean suspended = true;
        private boolean transmitting = false;
        private long position = 0L;
        private long last = StreamCache.access$000(StreamCache.this);

        public SubscriberData(StreamListener lst) {
            this.listener = lst;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            boolean doTransmit;
            SubscriberData subscriberData = this;
            synchronized (subscriberData) {
                doTransmit = this.suspended && !this.transmitting;
                this.suspended = false;
            }
            if (doTransmit) {
                if (XferDebug.CACHE.show()) {
                    LogSupport.message((String)("Stream " + StreamCache.this.id + " resumed."));
                }
                this.transmit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void suspend() {
            if (XferDebug.CACHE.show()) {
                LogSupport.message((String)("Stream " + StreamCache.this.id + " suspended."));
            }
            SubscriberData subscriberData = this;
            synchronized (subscriberData) {
                this.suspended = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isSuspended() {
            boolean susp;
            SubscriberData subscriberData = this;
            synchronized (subscriberData) {
                susp = this.suspended;
            }
            return susp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isComplete() {
            boolean complete;
            SubscriberData subscriberData = this;
            synchronized (subscriberData) {
                complete = this.position == this.last;
            }
            return complete;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transmit() {
            int nBytes;
            SubscriberData subscriberData = this;
            synchronized (subscriberData) {
                if (this.listener == null) {
                    return;
                }
                if (this.transmitting) {
                    return;
                }
                this.transmitting = true;
            }
            while ((nBytes = this.getTransmitSize()) > 0) {
                ProtocolBuffer buf = ProtocolBuffer.getInstance();
                Object object = StreamCache.this.lock;
                synchronized (object) {
                    try {
                        StreamCache.this.store.seek(this.position);
                        buf.readFrom((DataInput)StreamCache.this.store, 0, nBytes);
                    }
                    catch (IOException ex) {
                        buf.dispose();
                        if (!StreamCache.this.file.exists()) {
                            return;
                        }
                        LogSupport.message((String)("reading " + nBytes + " bytes at " + this.position + " (file contains " + StreamCache.this.cursor + "/" + StreamCache.this.size + ")"));
                        LogSupport.exception((Object)this, (String)"transmit", (Throwable)ex, (boolean)true);
                        return;
                    }
                    SubscriberData subscriberData2 = this;
                    synchronized (subscriberData2) {
                        this.position += (long)nBytes;
                    }
                }
                this.listener.streamingData(StreamEvent.getInstance(StreamCache.this, StreamCache.this.id, buf));
            }
        }

        private synchronized int getTransmitSize() {
            long remaining = this.last - this.position;
            long avail = StreamCache.this.cursor - this.position;
            int nBytes = 0;
            if (remaining == 0L) {
                this.listener = null;
                return 0;
            }
            if (!(this.isSuspended() || avail < 396L && avail != remaining)) {
                nBytes = (int)Math.min(avail, 396L);
            }
            if (nBytes == 0) {
                this.transmitting = false;
            }
            return nBytes;
        }

        public void dispose() {
            if (this.listener != null) {
                ProtocolBuffer buf = ProtocolBuffer.getInstance();
                StreamEvent event = StreamEvent.getInstance(StreamCache.this, StreamCache.this.id, buf);
                this.listener.streamAbort(event);
            }
        }
    }
}

