/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.transfer;

import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.imps.RecorderIndexAPI;
import com.elluminate.groupware.imps.filetransfer.FileTransferRequestListener;
import com.elluminate.groupware.transfer.StreamCache;
import com.elluminate.groupware.transfer.StringsProperties;
import com.elluminate.groupware.transfer.TransferLibrary;
import com.elluminate.groupware.transfer.TransferLibraryEntry;
import com.elluminate.groupware.transfer.TransferProtocol;
import com.elluminate.groupware.transfer.Urgency;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.jinx.RecvWindow;
import com.elluminate.jinx.RecvWindowListener;
import com.elluminate.jinx.TransmitStatusEvent;
import com.elluminate.util.I18nMessage;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;

public class ResponderTransferLibrary
extends TransferLibrary {
    private boolean loadedRecorderAPI = false;
    private RecorderIndexAPI recorderIndexAPI = null;
    private Imps imps;

    public ResponderTransferLibrary() {
        super(null);
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Override
    public int load(File f, Map attrs, FileTransferRequestListener lst) {
        throw new RuntimeException("Load operation not supported from responders.");
    }

    @Override
    public int load(URL u, Map attrs, FileTransferRequestListener lst) {
        throw new RuntimeException("Load operation not supported from responders.");
    }

    @Override
    public int remove(int id, FileTransferRequestListener lst) {
        throw new RuntimeException("Remove operation not supported from responders.");
    }

    @Override
    public int setAttributes(int id, Map attrs, FileTransferRequestListener lst) {
        throw new RuntimeException("Set attributes operation not supported from responders.");
    }

    @Override
    protected void doSendAck(RecvWindow window, TransferLibraryEntry entry) {
        ChannelDataEvent resp = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)7);
        DataOutputStream ostr = resp.write();
        try {
            ostr.writeInt(entry.getUID());
            ostr.writeInt(window.ack());
            ostr.close();
            if (this.channel != null) {
                this.channel.onChannelData(resp);
            }
        }
        catch (IOException iox) {
            LogSupport.exception((Object)this, (String)"doSendAck", (Throwable)iox, (boolean)true);
        }
    }

    protected void doSendOK(int seq, int id) {
        ChannelDataEvent resp = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)11);
        DataOutputStream ostr = resp.write();
        try {
            ostr.writeInt(seq);
            ostr.writeInt(id);
            ostr.close();
            this.channel.onChannelData(resp);
        }
        catch (IOException iox) {
            LogSupport.exception((Object)this, (String)"doSendOK", (Throwable)iox, (boolean)true);
        }
    }

    @Override
    public void onChannelData(ChannelDataEvent event) {
        DataInputStream istr = null;
        Object ostr = null;
        RMLEntry entry = null;
        String name = null;
        String type = null;
        String owner = null;
        Object resp = null;
        ProtocolBuffer buf = null;
        try {
            istr = event.read();
            switch (event.getCommand()) {
                case 6: {
                    buf = event.getBuffer();
                    istr.close();
                    istr = buf.readHeader(4);
                    int id = istr.readInt();
                    istr.close();
                    istr = null;
                    entry = (RMLEntry)this.get(id);
                    if (entry == null) break;
                    entry.write(buf);
                    break;
                }
                case 4: {
                    int seq = istr.readInt();
                    int id = istr.readInt();
                    this.delete(id);
                    this.doSendOK(seq, id);
                    break;
                }
                case 2: {
                    int seq = istr.readInt();
                    int id = istr.readInt();
                    name = istr.readUTF();
                    type = istr.readUTF();
                    owner = istr.readUTF();
                    long len = istr.readLong();
                    long posn = istr.readLong();
                    String auth = istr.readUTF();
                    Map<String, String> attrs = TransferProtocol.readAttrs(istr);
                    entry = (RMLEntry)this.get(id);
                    if (entry == null) {
                        entry = new RMLEntry(id, len, name, type, attrs, this.windowListener, (Urgency)this);
                        this.insert(id, entry);
                    } else {
                        entry.reset();
                    }
                    this.doSendOK(seq, id);
                    break;
                }
            }
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"onChannelData", (Throwable)ex, (boolean)true);
        }
        if (istr != null) {
            try {
                istr.close();
            }
            catch (IOException io) {
                // empty catch block
            }
        }
    }

    @Override
    public void transmitStatusChange(TransmitStatusEvent e) {
    }

    @Override
    public void removeProxy(short addr) {
    }

    @Override
    public void setUrgent(int id, boolean isUrgent) {
        TransferLibraryEntry ent = this.get(id);
        if (ent == null) {
            return;
        }
        if (ent.isComplete()) {
            return;
        }
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)8);
        try {
            DataOutputStream ostr = e.write();
            ostr.writeInt(id);
            ostr.writeByte(isUrgent ? 1 : 0);
            ostr.close();
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"sendUrgent", (Throwable)ex, (boolean)true);
            return;
        }
        this.channel.onChannelData(e);
    }

    @Override
    public void addProxy(short addr) {
        if (addr != 0) {
            throw new IllegalArgumentException("Only the server may be a client proxy.");
        }
        if (this.channel == null) {
            throw new IllegalStateException("Cannot add proxy when not connected.");
        }
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)5);
        try {
            DataOutputStream ostr = e.write();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                TransferLibraryEntry ent = (TransferLibraryEntry)i.next();
                ent.encodeStatus(ostr, this.getConnection().getAddress());
            }
            ostr.writeInt(0);
            ostr.close();
            this.channel.onChannelData(e);
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"addProxy", (Throwable)ex, (boolean)true);
        }
    }

    class RMLEntry
    extends TransferLibraryEntry {
        long posn;

        public RMLEntry(int id, long len, String nm, String type, Map attrs, RecvWindowListener lst, Urgency u) {
            super(id, len, null, nm, type, " ---", attrs, lst, u);
            this.posn = 0L;
        }

        @Override
        public long getPosition() {
            return this.posn;
        }

        @Override
        public void write(ProtocolBuffer b) {
            this.posn += (long)b.getSize();
            super.write(b);
            if (this.posn == this.getLength()) {
                this.notifyComplete();
            }
        }

        @Override
        public StreamCache getCache() {
            return null;
        }

        @Override
        public void setCache(StreamCache cache) {
        }

        private void notifyComplete() {
            if (!ResponderTransferLibrary.this.loadedRecorderAPI) {
                ResponderTransferLibrary.this.loadedRecorderAPI = true;
                try {
                    Connection context = ResponderTransferLibrary.this.channel.getConnection();
                    ResponderTransferLibrary.this.recorderIndexAPI = (RecorderIndexAPI)ResponderTransferLibrary.this.imps.findBest(RecorderIndexAPI.class);
                }
                catch (Throwable t) {
                    ResponderTransferLibrary.this.recorderIndexAPI = null;
                }
            }
            if (ResponderTransferLibrary.this.recorderIndexAPI != null) {
                I18nMessage mod = ResponderTransferLibrary.this.i18n.getMessage((PropertiesEnum)StringsProperties.RESPONDERTRANSFERLIBRARY_INDEXICON);
                I18nMessage kind = ResponderTransferLibrary.this.i18n.getMessage((PropertiesEnum)StringsProperties.RESPONDERTRANSFERLIBRARY_INDEXFILECOMPLETETYPE);
                ResponderTransferLibrary.this.recorderIndexAPI.addIndexMark(mod, kind, new I18nMessage(this.getName()));
            }
        }
    }
}

