/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.transfer.module;

import com.elluminate.groupware.transfer.module.StringsProperties;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LoadDialog
extends EasyDialog {
    private static final I18n i18n = I18n.create(LoadDialog.class);
    private JPanel content = new JPanel();
    private JButton loadBtn = new JButton();
    private JButton cancelBtn = new JButton();
    private JLabel urlLabel = new JLabel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JTextField urlField = new JTextField();
    private JCheckBox push = new JCheckBox();
    private URL url = null;
    private File file = null;
    private File wdir = null;
    private boolean canceled;

    public LoadDialog(Component parent) {
        super(parent, i18n.getString((PropertiesEnum)StringsProperties.TRANSFERBEAN_LOADURLTITLE));
        try {
            this.jbInit();
            this.pack();
            this.setSize(425, this.getSize().height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(1);
        this.content.setLayout(this.gridBagLayout1);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.fill = 0;
        this.urlLabel.setText(i18n.getString((PropertiesEnum)StringsProperties.LOADDIALOG_SRCURLLABEL));
        this.content.add((Component)this.urlLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 100.0;
        gbc.insets.left = 6;
        gbc.fill = 2;
        if (this.url != null) {
            this.urlField.setText(this.url.getRef());
        }
        this.content.add((Component)this.urlField, gbc);
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.insets.top = 6;
        gbc.insets.left = 0;
        gbc.fill = 0;
        this.push.setText(i18n.getString((PropertiesEnum)StringsProperties.LOADDIALOG_PUSH));
        this.content.add((Component)this.push, gbc);
        this.setContent(this.content);
        this.cancelBtn.setText(i18n.getString((PropertiesEnum)StringsProperties.LOADDIALOG_CANCEL));
        this.addCancelButton(this.cancelBtn);
        this.loadBtn.setText(i18n.getString((PropertiesEnum)StringsProperties.LOADDIALOG_LOAD));
        this.addActionButton(this.loadBtn, true);
        this.setInitialFocus(this.urlField);
        this.urlField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                LoadDialog.this.validateURL();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LoadDialog.this.validateURL();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LoadDialog.this.validateURL();
            }
        });
        this.loadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadDialog.this.canceled = false;
                try {
                    LoadDialog.this.url = new URL(LoadDialog.this.urlField.getText());
                    LoadDialog.this.hide();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadDialog.this.canceled = true;
                LoadDialog.this.url = null;
                LoadDialog.this.hide();
            }
        });
    }

    public void setSelectedURL(URL url) {
        this.url = url;
    }

    public URL getSelectedURL() {
        return this.url;
    }

    public void setPushSelected(boolean selected) {
        this.push.setSelected(selected);
    }

    public boolean isPushSelected() {
        return this.push.isSelected();
    }

    private void validateURL() {
        try {
            URL u = new URL(this.urlField.getText());
            String fsep = System.getProperty("file.separator", "/");
            String host = u.getHost();
            String path = u.getPath();
            boolean hasHost = host != null && host.length() > 0;
            boolean hasPath = path != null && path.length() > 0 && !path.equals("/") && !path.equals(fsep);
            this.loadBtn.setEnabled(hasHost && hasPath);
        }
        catch (MalformedURLException ex) {
            this.loadBtn.setEnabled(false);
        }
    }

    public int showDialog() {
        this.canceled = true;
        String oldURL = this.urlField.getText();
        this.validateURL();
        this.show();
        if (this.canceled) {
            this.urlField.setText(oldURL);
        }
        return !this.canceled ? 0 : 1;
    }
}

