/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.extra;

import com.elluminate.extra.ExTRA;
import com.elluminate.extra.PreviewExTRA;
import com.elluminate.extra.QueryExTRA_abortBtn_actionAdapter;
import com.elluminate.extra.QueryExTRA_previewBtn_actionAdapter;
import com.elluminate.extra.QueryExTRA_sendBtn_actionAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class QueryExTRA
extends JFrame {
    private static final String DFT_MESSAGE = "/com/elluminate/extra/ExTRA.html";
    private static final boolean IS_MAC = System.getProperty("os.name", "").startsWith("Mac");
    public static final String EXTRA_SETTINGS = "ExTRA.properties";
    private static ResourceBundle i18n = null;
    private static Set<QueryExTRA> active = new HashSet<QueryExTRA>();
    private static Map<String, ExTRA.SendPolicy> labelToPolicy = new HashMap<String, ExTRA.SendPolicy>();
    private static Map<ExTRA.SendPolicy, String> policyToLabel = new HashMap<ExTRA.SendPolicy, String>();
    private ImageIcon icon = null;
    private ExTRA report = null;
    private JPanel actionPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JButton sendBtn = new JButton();
    private JButton abortBtn = new JButton();
    private GridLayout buttonLayout = new GridLayout();
    private BorderLayout actionLayout = new BorderLayout(6, 0);
    private JPanel contentPanel = new JPanel();
    private GridBagLayout contentLayout = new GridBagLayout();
    private JLabel emailLabel = new JLabel();
    private JLabel descLabel = new JLabel();
    private JTextField email = new JTextField();
    private JScrollPane descScroller = new JScrollPane();
    private JTextArea desc = new JTextArea();
    private JButton previewBtn = new JButton();
    private JEditorPane message = null;
    private JScrollPane messageScroller = null;
    private JLabel policyLabel = new JLabel();
    private JComboBox sendPolicy = new JComboBox();

    public QueryExTRA(ExTRA rep) {
        super(i18n.getString("ExTRA.title"));
        this.report = rep;
        boolean failed = false;
        Throwable cause = null;
        for (int retry = 0; retry < 3; ++retry) {
            try {
                this.jbInit();
                failed = false;
                break;
            }
            catch (Throwable t2) {
                failed = true;
                if (cause != null) continue;
                cause = t2;
                continue;
            }
        }
        if (failed) {
            ExTRA.reportException(this, "ExTRA", cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<QueryExTRA> getActive() {
        Set<QueryExTRA> set = active;
        synchronized (set) {
            return Collections.unmodifiableSet(active);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activate() {
        Set<QueryExTRA> set = active;
        synchronized (set) {
            active.add(this);
            this.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deactivate() {
        Set<QueryExTRA> set = active;
        synchronized (set) {
            active.remove(this);
            this.setVisible(false);
            if (active.isEmpty()) {
                ExTRA.conditionalExit();
            }
        }
    }

    private void jbInit() throws Exception {
        if (ExTRA.getMessageHtml() != null) {
            this.message = new JEditorPane("text/html", ExTRA.getMessageHtml());
        } else if (ExTRA.getMessageUrl() != null) {
            this.message = new JEditorPane(ExTRA.getMessageUrl());
        } else {
            URL rsrcUrl = this.getClass().getResource(DFT_MESSAGE);
            System.out.println("bad url: " + rsrcUrl + " from " + DFT_MESSAGE);
            this.message = new JEditorPane(rsrcUrl);
        }
        this.icon = ExTRA.getIcon();
        if (this.icon != null && !IS_MAC) {
            this.setIconImage(this.icon.getImage());
        }
        String defaultButtonAction = "default-button";
        AbstractAction sendAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryExTRA.this.sendBtn.doClick();
            }
        };
        this.message.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "default-button");
        this.message.getActionMap().put("default-button", sendAction);
        String cancelButtonAction = "cancel-button";
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryExTRA.this.abortBtn.doClick();
            }
        };
        this.message.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "cancel-button");
        this.message.getActionMap().put("cancel-button", cancelAction);
        this.desc.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "cancel-button");
        this.desc.getActionMap().put("cancel-button", cancelAction);
        this.message.setEditable(false);
        this.message.setMargin(new Insets(6, 10, 6, 10));
        this.message.setBackground(Color.WHITE);
        this.messageScroller = new JScrollPane(this.message, 20, 31);
        this.sendBtn.setText(i18n.getString("ExTRA.send"));
        this.sendBtn.addActionListener(new QueryExTRA_sendBtn_actionAdapter(this));
        this.abortBtn.setText(i18n.getString("ExTRA.dontSend"));
        this.abortBtn.addActionListener(new QueryExTRA_abortBtn_actionAdapter(this));
        this.buttonPanel.setLayout(this.buttonLayout);
        this.actionPanel.setLayout(this.actionLayout);
        this.buttonLayout.setRows(1);
        this.buttonLayout.setColumns(0);
        this.buttonLayout.setHgap(6);
        this.contentPanel.setLayout(this.contentLayout);
        this.emailLabel.setText(i18n.getString("ExTRA.eMail"));
        this.descLabel.setText(i18n.getString("ExTRA.description"));
        this.email.setText(ExTRA.getEmail());
        this.email.setToolTipText(i18n.getString("ExTRA.eMailToolTipText"));
        this.desc.setText("");
        this.desc.setToolTipText(i18n.getString("ExTRA.descriptionToolTipText"));
        this.previewBtn.setText(i18n.getString("ExTRA.preview"));
        this.previewBtn.addActionListener(new QueryExTRA_previewBtn_actionAdapter(this));
        this.actionPanel.setBorder(BorderFactory.createEmptyBorder(14, 14, 14, 14));
        this.actionPanel.add((Component)this.previewBtn, "West");
        this.actionPanel.add((Component)this.buttonPanel, "East");
        this.buttonPanel.add(this.abortBtn);
        this.buttonPanel.add(this.sendBtn);
        this.descScroller.setViewportView(this.desc);
        this.messageScroller.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
        this.messageScroller.setBackground(this.message.getBackground());
        this.policyLabel.setText(i18n.getString("ExTRA.policy"));
        this.sendPolicy.addItem(policyToLabel.get((Object)ExTRA.SendPolicy.ALWAYS));
        this.sendPolicy.addItem(policyToLabel.get((Object)ExTRA.SendPolicy.QUERY));
        this.sendPolicy.addItem(policyToLabel.get((Object)ExTRA.SendPolicy.NEVER));
        this.sendPolicy.setEditable(false);
        this.sendPolicy.setSelectedItem(policyToLabel.get((Object)ExTRA.getSendPolicy()));
        this.contentPanel.add((Component)this.messageScroller, new GridBagConstraints(0, 0, 2, 1, 1.0, 10.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.contentPanel.add((Component)this.emailLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 14, 0, 0), 0, 0));
        this.contentPanel.add((Component)this.email, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(6, 6, 0, 14), 0, 0));
        this.contentPanel.add((Component)this.descLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(6, 14, 0, 0), 0, 0));
        this.contentPanel.add((Component)this.descScroller, new GridBagConstraints(1, 2, 1, 1, 1.0, 3.5, 10, 1, new Insets(6, 6, 0, 14), 0, 0));
        this.contentPanel.add((Component)this.policyLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 12, 0, new Insets(6, 14, 0, 0), 0, 0));
        this.contentPanel.add((Component)this.sendPolicy, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(6, 6, 0, 14), 0, 0));
        JPanel c = (JPanel)this.getContentPane();
        c.add((Component)this.contentPanel, "Center");
        c.add((Component)this.actionPanel, "South");
        this.getRootPane().setDefaultButton(this.sendBtn);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.deactivate();
        }
    }

    private void updateReport() {
        this.report.addElement("eMail", this.email.getText());
        this.report.addElement("description", this.desc.getText());
    }

    void sendBtn_actionPerformed(ActionEvent e) {
        String serial = null;
        URL target = ExTRA.getTarget();
        this.updateReport();
        try {
            serial = this.report.send(target);
            ExTRA.reportMessage(this, null, "ExTRA report " + serial + " sent.");
            ExTRA.addSent(serial);
            JOptionPane.showMessageDialog(this.getParent(), MessageFormat.format(i18n.getString("ExTRA.reportSent"), serial), i18n.getString("ExTRA.sentTitle"), 1);
        }
        catch (IOException ex) {
            ExTRA.reportError(ExTRA.class, "send", "Unable to send ExTRA report to " + target + "\n     " + ex);
        }
        ExTRA.setEmail(this.email.getText());
        ExTRA.setSendPolicy(labelToPolicy.get((String)this.sendPolicy.getSelectedItem()));
        this.deactivate();
    }

    void abortBtn_actionPerformed(ActionEvent e) {
        ExTRA.setEmail(this.email.getText());
        ExTRA.setSendPolicy(labelToPolicy.get((String)this.sendPolicy.getSelectedItem()));
        this.deactivate();
    }

    void previewBtn_actionPerformed(ActionEvent e) {
        this.updateReport();
        PreviewExTRA preview = new PreviewExTRA((Frame)this, i18n.getString("ExTRA.reportTitle"), this.report);
        preview.setResizable(true);
        preview.setBounds(this.getBounds());
        preview.setVisible(true);
    }

    static {
        i18n = ResourceBundle.getBundle(ExTRA.class.getPackage().getName() + ".Strings");
        labelToPolicy.put(i18n.getString("ExTRA.policyAlways"), ExTRA.SendPolicy.ALWAYS);
        labelToPolicy.put(i18n.getString("ExTRA.policyQuery"), ExTRA.SendPolicy.QUERY);
        labelToPolicy.put(i18n.getString("ExTRA.policyNever"), ExTRA.SendPolicy.NEVER);
        for (Map.Entry<String, ExTRA.SendPolicy> entry : labelToPolicy.entrySet()) {
            policyToLabel.put(entry.getValue(), entry.getKey());
        }
        policyToLabel.put(ExTRA.SendPolicy.UNDEFINED, policyToLabel.get((Object)ExTRA.SendPolicy.ALWAYS));
    }
}

