/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.chat.module;

import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.chat.Chat;
import com.elluminate.groupware.chat.module.ErrorHandler;
import com.elluminate.groupware.chat.module.StringsProperties;
import com.elluminate.groupware.chat.module.ToSelection;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.util.Collection;

public class ToParticipants
implements ToSelection {
    private Collection<CRParticipant> toList;
    private ErrorHandler errorHandler;
    private I18n i18n;

    public ToParticipants(Collection<CRParticipant> toList) {
        this.toList = toList;
    }

    public void initErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void initI18n(I18n i18n) {
        this.i18n = i18n;
    }

    @Override
    public boolean address(Chat msg) {
        if (this.toList.isEmpty()) {
            this.errorHandler.reportError(this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_NOSELECTION), this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_CANTSENDTITLE));
            return false;
        }
        for (CRParticipant p : this.toList) {
            if (this.isChannelClosed(p) && this.toList.size() == 1) {
                this.errorHandler.reportError(this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_CANTSELECTTELECONFERENCE), this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_CANTSENDTITLE));
                return false;
            }
            if (!this.isReciepientAccessible(p)) {
                this.errorHandler.reportError(this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_INACCESSIBLERECIPIENT), this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_CANTSENDTITLE));
                return false;
            }
            msg.addTo(p);
        }
        return true;
    }

    private boolean isChannelClosed(CRParticipant p) {
        Object channelOpenForClient = p.getPropertyStore().getProperty("directMessagingChatActive");
        return channelOpenForClient == null || Boolean.FALSE.equals(channelOpenForClient);
    }

    private boolean isReciepientAccessible(CRParticipant p) {
        CRSession session = p.getSession();
        CRParticipant moi = session.getMe();
        return moi.isChair() || p.isChair() || p.getRoom() == moi.getRoom();
    }

    Collection<CRParticipant> getToList() {
        return this.toList;
    }
}

