/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper;

import com.jniwrapper.JNIWrapperException;
import com.jniwrapper.Library;
import com.jniwrapper.LibraryLoader;
import com.jniwrapper.LibraryNotFoundException;
import com.jniwrapper.LibraryVersionMismatchException;
import com.jniwrapper.PlatformContext;
import com.jniwrapper.ai;
import com.jniwrapper.bc;
import com.jniwrapper.bm;
import com.jniwrapper.util.StreamUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLibraryLoader
implements LibraryLoader {
    private static final Logger e = LoggerFactory.getLogger((Class)(h == null ? (h = DefaultLibraryLoader.b("com.jniwrapper.DefaultLibraryLoader")) : h));
    private static DefaultLibraryLoader b = null;
    private bc g;
    private static String i = null;
    private String f;
    private static int a = 0;
    public static final String JAVA_LIBRARY_PATH = "java.library.path";
    public static Class h;
    public static Class c;
    public static Class d;

    private DefaultLibraryLoader() {
        this((h == null ? (h = DefaultLibraryLoader.b("com.jniwrapper.DefaultLibraryLoader")) : h).getClassLoader(), System.getProperty(JAVA_LIBRARY_PATH), Library.NATIVE_CODE);
    }

    public DefaultLibraryLoader(ClassLoader classLoader, String string, String string2) {
        this.g = new ai(classLoader, string, string2);
        this.b();
    }

    private void b() {
        try {
            Object object;
            Serializable serializable;
            e.debug("DefaultLibraryLoader.generateTmpFolderName");
            String string = this.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
            e.debug("classContainer = " + string);
            String string2 = this.a(string);
            e.debug("bundleVersion = " + string2);
            String string3 = this.c(string);
            e.debug("jarName = " + string3);
            String string4 = this.a();
            e.debug("systemTempFolder = " + string4);
            boolean bl2 = string4.endsWith(File.separator);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string4);
            if (!bl2) {
                stringBuffer.append(File.separator);
            }
            if (string3.length() != 0) {
                stringBuffer.append(string3);
            } else {
                stringBuffer.append("JNIWrapper");
            }
            stringBuffer.append(".Build.");
            stringBuffer.append(string2);
            try {
                serializable = Class.forName("java.util.UUID");
                Method method = ((Class)serializable).getMethod("randomUUID", new Class[0]);
                object = method.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                int n2 = this.getClass().getClassLoader().hashCode();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(n2);
                stringBuffer2.append(System.currentTimeMillis());
                object = stringBuffer2.toString();
            }
            stringBuffer.append(object);
            if (bl2) {
                stringBuffer.append(File.separator);
            }
            if (!((File)(serializable = new File(stringBuffer.toString()))).exists() || !((File)serializable).isDirectory()) {
                if (!((File)serializable).mkdir()) {
                    this.f = string4;
                    throw new IllegalArgumentException("Cannot create dir: " + ((File)serializable).getAbsolutePath());
                }
                ((File)serializable).deleteOnExit();
            }
            this.f = stringBuffer.toString();
            e.debug("DefaultLibraryLoader.generateTmpFolderName: " + this.f);
        }
        catch (Exception exception) {
            e.debug("Unable to alter tmp folder. Trying to use the system one", (Throwable)exception);
            try {
                this.f = this.a();
            }
            catch (IOException iOException) {
                e.debug("Unable to alter tmp folder.", (Throwable)iOException);
            }
        }
    }

    private String c(String string) {
        e.debug("DefaultLibraryLoader.getJarName from the container: " + string);
        int n2 = string.lastIndexOf("/") + 1;
        String string2 = string.substring(n2);
        int n3 = string2.lastIndexOf(".");
        if (n3 == -1) {
            n3 = string2.length();
        }
        string2 = string2.substring(0, n3);
        return string2;
    }

    private String a(String string) {
        String string2 = "Unknown";
        if (!string.endsWith("/")) {
            try {
                URL uRL = new URL("jar:" + string + "!/META-INF/MANIFEST.MF");
                Manifest manifest = new Manifest(uRL.openStream());
                Attributes attributes = manifest.getMainAttributes();
                string2 = attributes.getValue("Bundle-Version");
                if (string2 == null) {
                    string2 = attributes.getValue("Version");
                }
            }
            catch (IOException iOException) {
                e.debug("Unable to retrieve version", (Throwable)iOException);
                string2 = "Unknown";
            }
        }
        if (string2 == null) {
            string2 = "Unknown";
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String a() throws IOException {
        String string;
        try {
            string = PlatformContext.isNewerThanTiger() ? "/private/tmp" : System.getProperty("java.io.tmpdir");
        }
        catch (Exception exception) {
            File file = File.createTempFile("~tmp", "");
            try {
                string = file.getParent();
            }
            finally {
                file.delete();
            }
        }
        return string;
    }

    public static DefaultLibraryLoader getInstance() {
        if (b == null) {
            b = new DefaultLibraryLoader();
        }
        return b;
    }

    public void addPath(File file) {
        this.g.b(file);
    }

    public void prependPath(File file) {
        this.g.a(file);
    }

    public void addPath(List list) {
        this.g.a(list);
    }

    public void addPath(String string) {
        this.g.c(string);
    }

    public File findLibrary(String string) {
        Object object;
        boolean bl2;
        String string2 = string;
        boolean bl3 = bl2 = string2.indexOf(Library.NATIVE_CODE) != -1;
        if (!new File(string).isAbsolute()) {
            string2 = DefaultLibraryLoader.mapLibraryName(string);
            if (bl2 && a >= 7 && PlatformContext.isMacOS()) {
                string2 = string2.replaceFirst(DefaultLibraryLoader.getLibraryExtension(), ".jnilib");
            }
        }
        e.debug("Finding library " + string2);
        Object object2 = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            e.debug("Class loader of '" + this.getClass() + "' class is null; trying to get context class loader...");
            classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                e.debug("Context class loader of current thread: " + Thread.currentThread() + " is null; using system class loader...");
                classLoader = ClassLoader.getSystemClassLoader();
            }
        }
        if (classLoader == null) {
            e.error("No available class loaders were found");
            throw new RuntimeException("Could not get any class loader");
        }
        try {
            object = classLoader.getResources(string2);
            while (object.hasMoreElements() && object2 == null) {
                URL uRL = object.nextElement();
                e.debug("Finding " + string2 + " library in JAR: " + uRL);
                if (uRL != null && uRL.getProtocol().startsWith("bundleresource")) {
                    uRL = this.a(uRL);
                    e.debug("Converting OSGi bundle URL to usual URL: " + uRL);
                }
                if (uRL != null && uRL.getProtocol().startsWith("jar")) {
                    e.debug("Looking for library in JAR " + uRL);
                    object2 = this.a(uRL, string2);
                }
                if (object2 != null && ((File)object2).exists() || uRL == null) continue;
                e.debug("Finding library in class path...");
                object2 = this.b(uRL);
                if (object2 == null || !bl2 || bm.a((File)object2)) continue;
                object2 = bm.a();
            }
        }
        catch (IOException iOException) {
            e.debug("Failed to scan jars for library", (Throwable)iOException);
        }
        if (object2 == null || !((File)object2).exists()) {
            e.debug("Finding library in system library path...");
            object2 = this.g.b(string2);
        }
        if ((object2 == null || !((File)object2).exists()) && PlatformContext.isMacOS()) {
            e.debug("Finding library in system library path on Mac OS X...");
            string2 = !string.endsWith(".dylib") && !string.endsWith(".jnilib") ? string + ".dylib" : string;
            object = this.g.b(string2);
            if (object != null) {
                object2 = object;
            }
            if (object2 == null || !((File)object2).exists()) {
                int n2 = string2.lastIndexOf("/");
                if (n2 > 0) {
                    String string3 = string2.substring(0, n2);
                    string2 = string3 + "/lib" + string2.substring(n2 + 1);
                } else {
                    string2 = "lib" + string2;
                }
                object = this.g.b(string2);
                if (object != null) {
                    object2 = object;
                }
            }
        }
        return object2;
    }

    private URL a(URL uRL) {
        try {
            Class<?> clazz = Class.forName("org.eclipse.core.runtime.FileLocator");
            Method method = clazz.getMethod("resolve", d == null ? (d = DefaultLibraryLoader.b("java.net.URL")) : d);
            return (URL)method.invoke(null, uRL);
        }
        catch (Exception exception) {
            e.debug("Cannot resolve OSGi Bundle URL with org.eclipse.core.runtime.FileLocator.");
            try {
                Class<?> clazz = Class.forName("org.eclipse.core.runtime.Platform");
                Method method = clazz.getMethod("resolve", d == null ? (d = DefaultLibraryLoader.b("java.net.URL")) : d);
                return (URL)method.invoke(null, uRL);
            }
            catch (Exception exception2) {
                e.debug("Cannot resolve OSGi Bundle URL with org.eclipse.core.runtime.Platform.");
                return null;
            }
        }
    }

    public static String urlToPath(URL uRL) {
        String string = uRL.getFile();
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "%", false);
        int n2 = stringTokenizer.countTokens();
        if (n2 > 0) {
            String string2 = stringTokenizer.nextToken();
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                String string4 = string3.substring(0, 2);
                int n3 = Integer.parseInt(string4, 16);
                stringBuffer.append((char)n3);
                stringBuffer.append(string3.substring(2));
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public void loadLibrary(String string) {
        File file = this.findLibrary(string);
        if (file == null) {
            throw new LibraryNotFoundException("Cannot find library: " + string);
        }
        if (!file.exists()) {
            throw new LibraryVersionMismatchException("Version of the library " + string + "found is not compatible with the current JNIWrapper version");
        }
        String string2 = file.getAbsolutePath();
        e.debug("Loading library from " + string2);
        System.load(string2);
    }

    public static String mapLibraryName(String string) {
        if (string.endsWith(DefaultLibraryLoader.getLibraryExtension())) {
            return string;
        }
        if (string.indexOf(".") != -1) {
            return string;
        }
        return System.mapLibraryName(string);
    }

    public static String getLibraryExtension() {
        if (i == null) {
            String string = "FooLibraryName";
            String string2 = System.mapLibraryName("FooLibraryName");
            int n2 = string2.indexOf("FooLibraryName");
            i = n2 == -1 ? "" : string2.substring(n2 + "FooLibraryName".length());
        }
        return i;
    }

    private File b(URL uRL) {
        String string = DefaultLibraryLoader.urlToPath(uRL);
        File file = new File(string);
        return file.exists() && file.isFile() ? file : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File a(URL uRL, String string) {
        File file = null;
        try {
            e.debug("DefaultLibraryLoader.findLibraryInJars. Loading resources to: " + this.f);
            InputStream inputStream = uRL.openStream();
            try {
                file = new File(this.f, string);
                if (file.exists() && !file.delete()) {
                    File file2 = file;
                    return file2;
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                try {
                    StreamUtils.copy(inputStream, fileOutputStream, 1024);
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            finally {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            e.error("Failed to extract JNIWrapper library to the " + this.f + " folder.", (Throwable)exception);
            JNIWrapperException.throwException(exception);
        }
        file.deleteOnExit();
        if (string.indexOf(Library.NATIVE_CODE) == -1) return file;
        if (bm.a(file)) return file;
        if (file.delete()) return bm.a();
        file.deleteOnExit();
        return bm.a();
    }

    public static Class b(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = System.getProperty("java.runtime.version");
        if (string != null) {
            try {
                a = Integer.parseInt(string.substring(2, 3));
                e.debug("JAVA_VERSION = " + a);
                if (a >= 7 && PlatformContext.isMacOS()) {
                    String string2 = System.getProperty(JAVA_LIBRARY_PATH);
                    System.setProperty(JAVA_LIBRARY_PATH, ".:" + string2);
                }
            }
            catch (Exception exception) {
                e.debug("Failed to get Java version", (Throwable)exception);
            }
        } else {
            e.debug("Could not get Java version property");
        }
    }
}

