/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.browser.proxy;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Message {
    public static final short ENC_INT = 1;
    public static final short ENC_WSTR = 2;
    public static final short ENC_BOOL = 3;
    private short msgID;
    private short slot;
    Object[] args;

    public Message(DataInputStream istr) throws IOException {
        this.msgID = istr.readShort();
        this.slot = istr.readShort();
        int nargs = istr.readShort();
        this.args = new Object[nargs];
        block5: for (int i = 0; i < nargs; ++i) {
            short type = istr.readShort();
            switch (type) {
                case 1: {
                    this.args[i] = new Integer(istr.readInt());
                    continue block5;
                }
                case 2: {
                    int len = istr.readShort();
                    char[] buf = new char[len];
                    for (int c = 0; c < len; ++c) {
                        buf[c] = istr.readChar();
                    }
                    this.args[i] = new String(buf);
                    continue block5;
                }
                case 3: {
                    byte b = istr.readByte();
                    this.args[i] = b == 0 ? Boolean.FALSE : Boolean.TRUE;
                    continue block5;
                }
                default: {
                    throw new RuntimeException("Unknown encoding type - " + type);
                }
            }
        }
    }

    public Message(short msg, short context) {
        this.msgID = msg;
        this.slot = context;
        this.args = new Object[0];
    }

    public Message(short msg, short context, Object arg0) {
        this.msgID = msg;
        this.slot = context;
        this.args = new Object[]{arg0};
    }

    public Message(short msg, short context, Object arg0, Object arg1) {
        this.msgID = msg;
        this.slot = context;
        this.args = new Object[]{arg0, arg1};
    }

    public Message(short msg, short context, Object arg0, Object arg1, Object arg2) {
        this.msgID = msg;
        this.slot = context;
        this.args = new Object[]{arg0, arg1, arg2};
    }

    public Message(short msg, short context, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.msgID = msg;
        this.slot = context;
        this.args = new Object[]{arg0, arg1, arg2, arg3};
    }

    public short getMessageID() {
        return this.msgID;
    }

    public short getContext() {
        return this.slot;
    }

    public short getArgCount() {
        return (short)this.args.length;
    }

    public Object getArg(int idx) {
        return this.args[idx];
    }

    public int getInt(int idx) {
        return (Integer)this.args[idx];
    }

    public boolean getBool(int idx) {
        return (Boolean)this.args[idx];
    }

    public String getString(int idx) {
        return (String)this.args[idx];
    }

    public static Message readMessage(DataInputStream istr) {
        try {
            return new Message(istr);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void writeMessage(DataOutputStream ostr) throws IOException {
        ostr.writeShort(this.msgID);
        ostr.writeShort(this.slot);
        ostr.writeShort(this.args.length);
        for (int i = 0; i < this.args.length; ++i) {
            Object obj = this.args[i];
            if (obj instanceof String) {
                String str = (String)obj;
                ostr.writeShort(2);
                ostr.writeShort(str.length());
                for (int c = 0; c < str.length(); ++c) {
                    ostr.writeShort(str.charAt(c));
                }
                continue;
            }
            if (obj instanceof Integer) {
                Integer in = (Integer)obj;
                ostr.writeShort(1);
                ostr.writeInt(in);
                continue;
            }
            if (obj instanceof Long) {
                int intVal;
                long longVal = (Long)obj;
                if (longVal != (long)(intVal = (int)longVal)) {
                    throw new RuntimeException("Long message arg exceeding int range not supported: 0x" + Long.toHexString(longVal));
                }
                ostr.writeShort(1);
                ostr.writeInt(intVal);
                continue;
            }
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                ostr.writeShort(3);
                ostr.writeByte(b != false ? 1 : 0);
                continue;
            }
            throw new RuntimeException("Invalid argument - " + obj.getClass().getName());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Message[");
        buf.append(this.msgID);
        buf.append(",");
        buf.append(this.slot);
        buf.append("(");
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.args[i]);
        }
        buf.append(")]");
        return buf.toString();
    }
}

