/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.resampler;

import com.elluminate.groupware.audio.resampler.ButterworthLPF;

public class Resampler {
    private static final int CHUNK_SIZE = 2000;
    private short[] chunkBuf;
    private long cumSrcCnt = 0L;
    private int delayCnt = -1;
    private ButterworthLPF lowpassFilter = null;
    private int srcRate;
    private float[] xSincOfXTbl = null;

    public Resampler(int srcRate, int delayCnt) {
        this.reset(srcRate, delayCnt);
    }

    public int resample(short[] srcBuf, int srcOff, int srcCnt, int resRate, short[] resBuf, int resOff, boolean antialias) {
        if (srcBuf == null) {
            throw new IllegalArgumentException("srcBuf = null");
        }
        if (srcOff < 0) {
            throw new IllegalArgumentException("srcOff (" + srcOff + ") < 0");
        }
        if (srcOff >= srcBuf.length) {
            throw new IllegalArgumentException("srcOff (" + srcOff + ") >= srcBuf.length (" + srcBuf.length + ")");
        }
        if (srcCnt < 1) {
            throw new IllegalArgumentException("srcCnt (" + srcCnt + ") < 1");
        }
        if (srcOff + srcCnt > srcBuf.length) {
            throw new IllegalArgumentException("srcOff (" + srcOff + ") + srcCnt (" + srcCnt + ") > srcBuf.length (" + srcBuf.length + ")");
        }
        if (resRate < 1) {
            throw new IllegalArgumentException("resRate (" + resRate + ") < 1");
        }
        if (resBuf == null) {
            throw new IllegalArgumentException("resBuf = null");
        }
        if (resOff < 0) {
            throw new IllegalArgumentException("resOff (" + resOff + ") < 0");
        }
        int resCnt = (int)((((long)srcCnt + this.cumSrcCnt) * (long)resRate + (long)this.srcRate - 1L) / (long)this.srcRate - (this.cumSrcCnt * (long)resRate + (long)this.srcRate - 1L) / (long)this.srcRate);
        if (resCnt < 1) {
            throw new IllegalArgumentException("resCnt (" + resCnt + ") < 1");
        }
        if (resOff + resCnt > resBuf.length) {
            throw new IllegalArgumentException("resOff (" + resOff + ") + resCnt (" + resCnt + ") > resBuf.length (" + resBuf.length + ")");
        }
        int chunkCnt = 2000;
        int origResOff = resOff;
        while (srcCnt > 0) {
            if (srcCnt < 2000) {
                chunkCnt = srcCnt;
            }
            if (resRate < this.srcRate && antialias) {
                if (this.lowpassFilter == null) {
                    this.lowpassFilter = new ButterworthLPF(6);
                }
                this.lowpassFilter.applyFilter(this.srcRate, 49 * resRate / 100, srcBuf, srcOff, chunkCnt, this.chunkBuf, 2 * this.delayCnt);
            } else {
                System.arraycopy(srcBuf, srcOff, this.chunkBuf, 2 * this.delayCnt, chunkCnt);
            }
            resOff += this.resampleChunk(chunkCnt, resRate, resBuf, resOff);
            System.arraycopy(this.chunkBuf, chunkCnt, this.chunkBuf, 0, 2 * this.delayCnt);
            this.cumSrcCnt += (long)chunkCnt;
            srcCnt -= chunkCnt;
            srcOff += chunkCnt;
        }
        return resOff - origResOff;
    }

    public int resample(short[] srcBuf, int srcOff, int srcCnt, int resRate, short[] resBuf, int resOff) {
        return this.resample(srcBuf, srcOff, srcCnt, resRate, resBuf, resOff, true);
    }

    public int resampleWithoutFiltering(short[] srcBuf, int srcOff, int srcCnt, int resRate, short[] resBuf, int resOff) {
        return this.resample(srcBuf, srcOff, srcCnt, resRate, resBuf, resOff, false);
    }

    private int resampleChunk(int chunkCnt, int resRate, short[] resBuf, int resOff) {
        long resLimit = ((this.cumSrcCnt + (long)chunkCnt) * (long)resRate + (long)this.srcRate - 1L) / (long)this.srcRate;
        long resFirst = (this.cumSrcCnt * (long)resRate + (long)this.srcRate - 1L) / (long)this.srcRate;
        int resChunkCnt = (int)(resLimit - resFirst);
        if (resChunkCnt == chunkCnt) {
            System.arraycopy(this.chunkBuf, this.delayCnt, resBuf, resOff, chunkCnt);
            return chunkCnt;
        }
        for (int resIdx = 0; resIdx < resChunkCnt; ++resIdx) {
            long temp = (resFirst + (long)resIdx) * (long)this.srcRate;
            long xFloor = temp / (long)resRate;
            int iFract = (int)(temp % (long)resRate);
            float xFract = (float)iFract / (float)resRate;
            int chunkIdx = (int)(xFloor - this.cumSrcCnt) + this.delayCnt;
            if (iFract == 0) {
                resBuf[resIdx + resOff] = this.chunkBuf[chunkIdx];
                continue;
            }
            float sum = 0.0f;
            for (int i = -this.delayCnt; i <= this.delayCnt; ++i) {
                sum += (float)this.chunkBuf[chunkIdx + i] / (xFract - (float)i);
                if (++i > this.delayCnt) break;
                sum -= (float)this.chunkBuf[chunkIdx + i] / (xFract - (float)i);
            }
            float y = sum * this.xSincOfX(iFract, resRate);
            if ((this.delayCnt & 1) != 0) {
                y = -y;
            }
            int yInt = (int)y;
            int clipper = Short.MIN_VALUE - yInt;
            yInt += clipper & ~(clipper >> 31);
            clipper = Short.MAX_VALUE - yInt;
            resBuf[resIdx + resOff] = (short)(yInt += clipper & clipper >> 31);
        }
        return resChunkCnt;
    }

    public void reset(int srcRate, int delayCnt) {
        if (srcRate < 1) {
            throw new IllegalArgumentException("srcRate (" + srcRate + ") < 1");
        }
        if (delayCnt < 0) {
            throw new IllegalArgumentException("delayCnt (" + delayCnt + ") < 0");
        }
        this.srcRate = srcRate;
        if (delayCnt != this.delayCnt) {
            this.delayCnt = delayCnt;
            this.chunkBuf = new short[delayCnt + 2000 + delayCnt];
        } else {
            for (int i = 0; i < this.chunkBuf.length; ++i) {
                this.chunkBuf[i] = 0;
            }
        }
        this.cumSrcCnt = 0L;
        if (this.lowpassFilter != null) {
            this.lowpassFilter.reset();
        }
    }

    private float xSincOfX(int xNumer, int xDenom) {
        int xSincOfXTblLen = (xDenom - 1 >> 2) + 2;
        if (this.xSincOfXTbl == null || this.xSincOfXTbl.length != xSincOfXTblLen) {
            this.xSincOfXTbl = new float[xSincOfXTblLen];
            for (int i = 0; i < xSincOfXTblLen; ++i) {
                this.xSincOfXTbl[i] = (float)(Math.sin(Math.PI * 4 * (double)i / (double)xDenom) / Math.PI);
            }
        }
        int xNumerDiv4 = xNumer >> 2;
        int xNumerMod4 = xNumer & 3;
        if (xNumerMod4 == 0) {
            return this.xSincOfXTbl[xNumerDiv4];
        }
        return 0.25f * ((float)(4 - xNumerMod4) * this.xSincOfXTbl[xNumerDiv4] + (float)xNumerMod4 * this.xSincOfXTbl[xNumerDiv4 + 1]);
    }
}

